------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--         S Y S T E M . T A S K I N G . I N I T I A L I Z A T I O N        --
--                                                                          --
--                                  B o d y                                 --
--                                                                          --
--                             $Revision: 1.2 $                             --
--                                                                          --
--     Copyright (C) 1992,1993,1994,1995 Free Software Foundation, Inc.     --
--                                                                          --
-- GNARL is free software; you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. GNARL is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNARL was developed by the GNARL team at Florida State University. It is --
-- now maintained by Ada Core Technologies Inc. in cooperation with Florida --
-- State University (http://www.gnat.com).                                  --
--                                                                          --
------------------------------------------------------------------------------

--  This implemetation is a version where no tasking supports provided.

package body System.Tasking.Initialization is

   procedure Put_Character (C : Integer);
   pragma Import (C, Put_Character, "putchar");

   procedure Prog_Exit (Status : Integer);
   pragma Import (C, Prog_Exit, "exit");

   procedure Write_Character (C : Character);
   procedure Write_EOL;
   procedure Write_String (S : String);
   --  Debugging procedures used for assertion output

   procedure Unimplemented (Feature : String);
   --  This procedure writes out a message to the effect that the
   --  feature specified by the Feature string is unimplemented,
   --  and halts the program.

   ---------------------
   -- Write_Character --
   ---------------------

   procedure Write_Character (C : Character) is
   begin
      Put_Character (Character'Pos (C));
   end Write_Character;

   ---------------
   -- Write_Eol --
   ---------------

   procedure Write_EOL is
   begin
      Write_Character (Ascii.LF);
   end Write_EOL;

   ------------------
   -- Write_String --
   ------------------

   procedure Write_String (S : String) is
   begin
      for J in S'Range loop
         Write_Character (S (J));
      end loop;
   end Write_String;

   -------------------
   -- Unimplemented --
   -------------------

   procedure Unimplemented (Feature : String) is
   begin
      Write_String (Feature);
      Write_String (" is unimplemented in this version of GNARL.");
      Write_EOL;
      Prog_Exit (1);
   end Unimplemented;

   -------------------
   -- Abort_Handler --
   -------------------

   procedure Abort_Handler
     (Context : Task_Primitives.Pre_Call_State)
   is
      T : Task_ID := Self;

   begin
      Unimplemented ("Tasking");
   end Abort_Handler;

   --------------------------
   -- Change_Base_Priority --
   --------------------------

   procedure Change_Base_Priority (T : Task_ID) is

   begin
      Unimplemented ("Tasking");
   end Change_Base_Priority;

   ----------------------
   -- Decrement_Master --
   ----------------------

   function Decrement_Master (M : Master_ID) return Master_ID is
   begin
      Unimplemented ("Tasking");
      return 0;
   end Decrement_Master;

   --------------------
   -- Defer_Abortion --
   --------------------

   procedure Defer_Abortion is
   begin
      Unimplemented ("Tasking");
   end Defer_Abortion;

   ---------------
   -- Free_ATCB --
   ---------------

   procedure Free_ATCB (T : in out Task_ID) is
   begin
      Unimplemented ("Tasking");
   end Free_ATCB;

   ----------------------
   -- Increment_Master --
   ----------------------

   function Increment_Master (M : Master_ID) return Master_ID is
   begin
      Unimplemented ("Tasking");
      return 0;
   end Increment_Master;

   ---------------------
   -- Initialize_ATCB --
   ---------------------

   procedure Initialize_ATCB
     (T     : Task_ID;
      Init  : ATCB_Init)
   is
   begin
      Unimplemented ("Tasking");
   end Initialize_ATCB;

   -----------------
   -- Init_Master --
   -----------------

   procedure Init_Master (M : out Master_ID) is
   begin
      Unimplemented ("Tasking");
   end Init_Master;

   --------------
   -- New_ATCB --
   --------------

   function New_ATCB
     (Init : ATCB_Init)
      return Task_ID
   is
   begin
      Unimplemented ("Tasking");
      return Null_Task;
   end New_ATCB;

   --------------------------------
   -- Remove_From_All_Tasks_List --
   --------------------------------

   procedure Remove_From_All_Tasks_List (
      Source : Task_ID;
      Result : out Boolean) is
   begin
      Unimplemented ("Tasking");
   end Remove_From_All_Tasks_List;

   -----------------------------
   -- Runtime_Assert_Shutdown --
   -----------------------------

   function Runtime_Assert_Shutdown (Msg : in String) return boolean is
   begin
      Unimplemented ("Tasking");
      return false;
   end Runtime_Assert_Shutdown;

   ----------------------
   -- Undefer_Abortion --
   ----------------------

   procedure Undefer_Abortion is
   begin
      Unimplemented ("Tasking");
   end Undefer_Abortion;

   ---------------------
   -- Unsafe_New_ATCB --
   ---------------------

   function Unsafe_New_ATCB
     (Init : ATCB_Init)
      return Task_ID
   is
   begin
      Unimplemented ("Tasking");
      return Null_Task;
   end Unsafe_New_ATCB;

   ------------------------
   -- Soft-Link Dummies  --
   ------------------------

   procedure Finalize_Attributes (T : Task_ID) is
   begin
      Unimplemented ("Tasking");
   end Finalize_Attributes;

   procedure Initialize_Attributes (T : Task_ID) is
   begin
      Unimplemented ("Tasking");
   end Initialize_Attributes;

   -----------------------------------
   -- Tasking System Initialization --
   -----------------------------------

end System.Tasking.Initialization;
