------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--                          A D A . R E A L _ T I M E                       --
--                                                                          --
--                                  B o d y                                 --
--                                                                          --
--                             $Revision: 1.2 $                             --
--                                                                          --
--     Copyright (C) 1992,1993,1994,1995 Free Software Foundation, Inc.     --
--                                                                          --
-- GNARL is free software; you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. GNARL is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNARL was developed by the GNARL team at Florida State University. It is --
-- now maintained by Ada Core Technologies Inc. in cooperation with Florida --
-- State University (http://www.gnat.com).                                  --
--                                                                          --
------------------------------------------------------------------------------

--  This implemetation is a version where no tasking supports provided.

package body Ada.Real_Time is

   procedure Put_Character (C : Integer);
   pragma Import (C, Put_Character, "putchar");

   procedure Prog_Exit (Status : Integer);
   pragma Import (C, Prog_Exit, "exit");

   procedure Write_Character (C : Character);
   procedure Write_EOL;
   procedure Write_String (S : String);
   --  Debugging procedures used for assertion output

   procedure Unimplemented (Feature : String);
   --  This procedure writes out a message to the effect that the
   --  feature specified by the Feature string is unimplemented,
   --  and halts the program.

   ---------------------
   -- Write_Character --
   ---------------------

   procedure Write_Character (C : Character) is
   begin
      Put_Character (Character'Pos (C));
   end Write_Character;

   ---------------
   -- Write_Eol --
   ---------------

   procedure Write_EOL is
   begin
      Write_Character (Ascii.LF);
   end Write_EOL;

   ------------------
   -- Write_String --
   ------------------

   procedure Write_String (S : String) is
   begin
      for J in S'Range loop
         Write_Character (S (J));
      end loop;
   end Write_String;

   -------------------
   -- Unimplemented --
   -------------------

   procedure Unimplemented (Feature : String) is
   begin
      Write_String (Feature);
      Write_String (" is unimplemented in this version of GNARL.");
      Write_EOL;
      Prog_Exit (1);
   end Unimplemented;

   -----------
   -- Clock --
   -----------

   function Clock return Time is
   begin
      Unimplemented ("Tasking");
      return Time_First;
   end Clock;

   ---------
   -- "<" --
   ---------

   function "<" (Left, Right : Time) return Boolean is
   begin
      Unimplemented ("Tasking");
      return false;
   end "<";

   function "<" (Left, Right : Time_Span) return Boolean is
   begin
      Unimplemented ("Tasking");
      return false;
   end "<";

   ---------
   -- ">" --
   ---------

   function ">" (Left, Right : Time) return Boolean is
   begin
      Unimplemented ("Tasking");
      return false;
   end ">";

   function ">" (Left, Right : Time_Span) return Boolean is
   begin
      Unimplemented ("Tasking");
      return false;
   end ">";

   ----------
   -- "<=" --
   ----------

   function "<=" (Left, Right : Time) return Boolean is
   begin
      Unimplemented ("Tasking");
      return false;
   end "<=";

   function "<=" (Left, Right : Time_Span) return Boolean is
   begin
      Unimplemented ("Tasking");
      return false;
   end "<=";

   ----------
   -- ">=" --
   ----------

   function ">=" (Left, Right : Time) return Boolean is
   begin
      Unimplemented ("Tasking");
      return false;
   end ">=";

   function ">=" (Left, Right : Time_Span) return Boolean is
   begin
      Unimplemented ("Tasking");
      return false;
   end ">=";

   ---------
   -- "+" --
   ---------

   function "+" (Left : Time; Right : Time_Span) return Time is
   begin
      Unimplemented ("Tasking");
      return Time_First;
   end "+";

   function "+"  (Left : Time_Span; Right : Time) return Time is
   begin
      Unimplemented ("Tasking");
      return Time_First;
   end "+";

   function "+"  (Left, Right : Time_Span) return Time_Span is
   begin
      Unimplemented ("Tasking");
      return Time_Span_Zero;
   end "+";

   ---------
   -- "-" --
   ---------

   function "-"  (Left : Time; Right : Time_Span) return Time is
   begin
      Unimplemented ("Tasking");
      return Time_First;
   end "-";

   function "-"  (Left, Right : Time) return Time_Span is
   begin
      Unimplemented ("Tasking");
      return Time_Span_Zero;
   end "-";

   function "-"  (Left, Right : Time_Span) return Time_Span is
   begin
      Unimplemented ("Tasking");
      return Time_Span_Zero;
   end "-";

   function "-"  (Right : Time_Span) return Time_Span is
   begin
      Unimplemented ("Tasking");
      return Time_Span_Zero;
   end "-";

   ---------
   -- "/" --
   ---------

   --  Note that Constraint_Error may be propagated

   function "/"  (Left, Right : Time_Span) return integer is
   begin
      Unimplemented ("Tasking");
      return 0;
   end "/";

   function "/"  (Left : Time_Span; Right : Integer) return Time_Span is
   begin
      Unimplemented ("Tasking");
      return Time_Span_Zero;
   end "/";

   ---------
   -- "*" --
   ---------

   function "*"  (Left : Time_Span; Right : Integer) return Time_Span is
   begin
      Unimplemented ("Tasking");
      return Time_Span_Zero;
   end "*";

   function "*"  (Left : Integer; Right : Time_Span) return Time_Span is
   begin
      Unimplemented ("Tasking");
      return Time_Span_Zero;
   end "*";

   -----------
   -- "abs" --
   -----------

   function "abs" (Right : Time_Span) return Time_Span is
   begin
      Unimplemented ("Tasking");
      return Time_Span_Zero;
   end "abs";

   -----------------
   -- To_Duration --
   -----------------

   function To_Duration (TS : Time_Span) return Duration is
   begin
      Unimplemented ("Tasking");
      return 0.0;
   end To_Duration;

   ------------------
   -- To_Time_Span --
   ------------------

   function To_Time_Span (D : Duration) return Time_Span is
   begin
      Unimplemented ("Tasking");
      return Time_Span_Zero;
   end To_Time_Span;

   -----------------
   -- Nanoseconds --
   -----------------

   function Nanoseconds (NS : integer) return Time_Span is
   begin
      Unimplemented ("Tasking");
      return Time_Span_Zero;
   end Nanoseconds;

   ------------------
   -- Microseconds --
   ------------------

   function Microseconds  (US : integer) return Time_Span is
   begin
      Unimplemented ("Tasking");
      return Time_Span_Zero;
   end Microseconds;

   -------------------
   --  Milliseconds --
   -------------------

   function Milliseconds (MS : integer) return Time_Span is
   begin
      Unimplemented ("Tasking");
      return Time_Span_Zero;
   end Milliseconds;

   -----------
   -- Split --
   -----------

   procedure Split (T : Time; SC : out Seconds_Count; TS : out Time_Span) is
   begin
      Unimplemented ("Tasking");
   end Split;

   -------------
   -- Time_Of --
   -------------

   function Time_Of (SC : Seconds_Count; TS : Time_Span) return Time is
   begin
      Unimplemented ("Tasking");
      return Time_First;
   end Time_Of;

end Ada.Real_Time;
