/*
 * play.c
 *
 * This command plays the given file.
 *
 */

#include "../include/voice.h"

char *libvoice_play_c = "$Id: play.c,v 1.3 1996/07/25 19:23:25 marc Exp $";

int voice_play_file (char *name)
     {
     int fd;
     int result;
     rmd_header header;
     int compression;

     lprintf(L_MESG, "playing voice file %s", name);

     fd = open(name, O_RDONLY);

     if (fd < 0)
          {
          lprintf(L_ERROR, "%s: Could not open voice file", program_name);
          return(FAIL);
          };

     if (!cvd.raw_data.d.i)
          {

          if (read(fd, &header, sizeof(rmd_header)) != sizeof(rmd_header))
               {
               lprintf(L_ERROR, "%s: Could not read header", program_name);
               return(FAIL);
               };

          if (strncmp(header.magic, "RMD1", 4) != 0)
               {
               lprintf(L_ERROR, "%s: No raw modem data header found",
                program_name);
               return(FAIL);
               }
          else
               lprintf(L_NOISE, "%s: raw modem data header found",
                program_name);

          if (strncmp(header.voice_modem_type, voice_modem_type,
           strlen(voice_modem_type)) != 0)
               {
               lprintf(L_ERROR, "%s: Wrong modem type found", program_name);
               return(FAIL);
               }
          else
               lprintf(L_NOISE, "%s: modem type %s found", program_name,
                header.voice_modem_type);

          compression = ntohs(header.compression);
          lprintf(L_NOISE, "%s: compression method 0x%04x", program_name,
           compression);
          }
     else
          compression = cvd.rec_compression.d.i;

     if (voice_modem_handle_event(VOICE_SET_COMPRESSION,
      (event_data) compression) != OK)
          {
          lprintf(L_ERROR, "%s: Illeagal compression type %d", program_name,
           compression);
          result = FAIL;
          }
     else
          result = voice_modem_handle_event(VOICE_PLAY_FILE,
           (event_data) fd);

     close(fd);
     return(result);
     };
