/*
 * zyxel.c
 *
 * Conversion pvf <--> ZyXEL ADPCM.
 * Based on the ZyXEL vcnvt program.
 *
 */

#include "../include/voice.h"

char *libpvf_zyxel_c = "$Id: zyxel.c,v 1.2 1996/07/25 19:22:08 marc Exp $";

typedef struct {
        int word;
        int nleft;
} state_t;

static state_t state_init = { 0x0000, 0 };

static int Mx[3][8] = {
    { 0x3800, 0x5600, 0,0,0,0,0,0 },
    { 0x399a, 0x3a9f, 0x4d14, 0x6607, 0,0,0,0 },
    { 0x3556, 0x3556, 0x399A, 0x3A9F, 0x4200, 0x4D14, 0x6607, 0x6607 },
};

static int bitmask[9] = { 0, 0x01, 0x03, 0x07, 0x0f, 0x1f, 0x3f, 0x7f, 0xff };

static int
get_bits _P3((nbits, s, in), int nbits, state_t *s, FILE *in)
{
    while( s->nleft < nbits) {
     int d=getc(in);
     if (d==EOF) return EOF;
     s->word = (s->word<<8) | d;
     s->nleft+=8;
    }
    s->nleft -= nbits;
    return (s->word >> s->nleft) & bitmask[nbits];
}

static void
put_bits _P4((data, nbits, s, out),
          int data, int nbits, state_t *s, FILE *out)
{
    s->word = (s->word<<nbits) | (data & bitmask[nbits]);
    s->nleft += nbits;
    while(s->nleft>=8) {
     int d = (s->word >> (s->nleft-8));
     putc(d&255, out);
     s->nleft-=8;
    }
}

int zyxeltopvf _P4((nbits, rom, in, out), int nbits, int rom,
 FILE *in, FILE *out)
     {
     state_t s;
     int a = 0;
     int d = 5;

     if (nbits == 30)
          nbits = 3;

     s=state_init;

     while (1)
          {
          int sign;
          int e=get_bits(nbits, &s, in);

          if (e == EOF)
               break;

          if ((nbits == 4) && (e == 0))
               d = 4;

          sign = (e >> (nbits - 1)) ? (-1) : (1);
          e = e & bitmask[nbits - 1];

          if ((rom >= 610) && (rom < 612))
               {
               /*
                * modified conversion algorithm for ROM >= 6.10
                */
               a = (a * 3973 + 2048) >> 12;
               }
          else

               if (rom >= 612)
                    {
                    /*
                     * modified conversion algorithm for ROM >= 6.12
                     */
                    a = (a * 4093 + 2048) >> 12;
                    };

          a += sign * ((e << 1) + 1) * d >> 1;

          if (d & 1)
               a++;

          zput(a << 2, out);
          d = (d * Mx[nbits - 2][e] + 0x2000) >> 14;

          if (d < 5)
               d = 5;

          };

     return(OK);
     };

int hdr_zyxeltopvf _P4((nbits, rom, in, out), int nbits, int rom,
 FILE *in, FILE *out)
{
     char * type;

     extern int read_rmd_hdr _PROTO((char**, int*, int*, FILE*));

     if (read_rmd_hdr(&type, &nbits, &rom, in) != OK)
       return(FAIL);
     if (strcmp(type, "ZyXEL 1496"))
          {
          lprintf(L_ERROR, "%s: Wrong modem type found", program_name);
           return(FAIL);
          }
     free(type);
     return(zyxeltopvf(nbits, rom, in, out));
}

int pvftozyxel _P4((nbits, rom, in, out), int nbits, int rom,
 FILE *in, FILE *out)
     {
     int a = 0;
     int d = 5;
     state_t s;
     rmd_header header;

     memset(&header, 0x00, sizeof(rmd_header));
     sprintf(header.magic, "%s", "RMD1");
     sprintf(header.voice_modem_type, "ZyXEL 1496");
     header.compression = htons(nbits);

     if (fwrite(&header, sizeof(rmd_header), 1, out) != 1)
          {
          lprintf(L_ERROR, "%s: Could not write header", program_name);
          return(FAIL);
          };

     s = state_init;

     while(1)
          {
          int e = 0;
          int nmax = 1 << (nbits - 1);
          int sign;
          int delta;

          delta = (zget(in) >> 2) - a;

          if (feof(in))
               break;

          if (delta < 0)
               {
               e = nmax;
               delta = -delta;
               };

          while((--nmax) && (delta > d))
               {
               delta -= d;
               e++;
               };

          if ((nbits == 4) && ((e & 0x0f) == 0))
               e = 0x08;

          put_bits(e, nbits, &s, out);

          if ((rom >= 610) && (rom < 612))
               {
               /*
                * modified conversion algorithm for ROM >= 6.10
                */
               a = (a * 3973 + 2048) >> 12;
               }
          else

               if (rom>=612)
                    {
                    /*
                     * modified conversion algorithm for ROM >= 6.12
                     */
                    a = (a * 4093 + 2048) >> 12;
                    };

          sign = (e >> (nbits - 1)) ? (-1) : (1);
          e = e & bitmask[nbits - 1];
          a += sign * ((e << 1) + 1) * d >> 1;

          if (d & 1)
               a++;

          d = (d * Mx[nbits - 2][e] + 0x2000) >> 14;

          if (d < 5)
               d = 5;

          };

     if (s.nleft)
          put_bits(0, 8 - s.nleft, &s, out);

     return(OK);
     };

int pvf_zyxel _P2((argc, argv), int argc, char **argv)
     {
     FILE *in = stdin;
     FILE *out = stdout;
     int result = FAIL;
     int nbits;

     voice_config("pvf", "");

     if (argc >= 2)
          {

          if (strcmp(argv[1], "-r601") == 0)
               rom_release = 601;
          else if (strcmp(argv[1], "-r610") == 0)
               rom_release = 610;
          else if (strcmp(argv[1], "-r612") == 0)
               rom_release = 612;
          else
               USAGE("[-r612|-r610|-r601]");

          };

     nbits = argv[0][strlen(argv[0]) - 1] - '0';

     if ((nbits >= 2) && (nbits <= 4))
          result = pvftozyxel(nbits, rom_release, in, out);
     else
          result = hdr_zyxeltopvf(nbits, rom_release, in, out);

     return(result);
     };
