#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "interface.h"

#include "treedata.h"

static tframe info;
static tpanel p;
static tpmsg msg;
static tpbutton okb, cancelb;
static tptext printer;

int print_ok(b, e)
tpbutton b;
tevent e;
{
	char *s;

	seteventloc(e);
	s=tptext_get_val(printer);
	do_command(Print, s, NULL, 0.0, 0.0,
		0, 0, 0, 0, 0);
	hide_printer_frame();
}

int print_cancel(b, e)
tpbutton b;
tevent e;
{
	tframe_pull_pin(info);
	tframe_hide(info);
}

int print_enter_printer(t, e)
tptext t;
tevent e;
{
    char *s;
    double d;
    int i;

    if(tevent_type(e)==te_keydown)
    {
		s=tevent_string(e);
		if(s[0]=='\n' || s[0]=='\r')
		{
			print_ok(okb, e);
			return(tptext_next);
		}
		return(tptext_insert);
    }
	return(tptext_dontknow);
}

int create_printer_frame(parent, args)
tframe parent;
targs args;
{
	char *printername;

    info=tframe_new(parent, 580,100,50,50,0,1,0, "Choose Printer", args);
    if(info==NULL)
		return(0);
    p=tframe_dialog_panel(info);
    if(p==NULL)
		return(0);
	
	printername=(char *)get_environment_value("PRINTER");

	okb=tpbutton_new(p, 10, 10, 0, 0, NULL, NULL, "Print");
	tpbutton_set_event_procedure(okb, print_ok);
	cancelb=tpbutton_new(p, 10, 10, 0, 0, okb, NULL, "Cancel");
	tpbutton_set_event_procedure(cancelb, print_cancel);
    printer=tptext_new(p, 10, 10, 100, 0, NULL, okb,
		"Printer name:");
	tptext_set_displayed_characters(printer, 15);
	if(printername!=NULL)
		if(*printername!='\0')
			tptext_set_val(printer, printername);
    tptext_set_event_procedure(printer, print_enter_printer);

    tpanel_fit(p);
    tframe_fit(info);
    tframe_hide(info);
	tframe_pull_pin(info);
    return(1);
}

int show_printer_frame()
{
	moveframetoloc(info);
    tframe_show(info);
}

int hide_printer_frame()
{
    tframe_hide(info);
}

print_busy()
{
	if(info!=NULL)
		tframe_set_busy(info);
}

print_notbusy()
{
	if(info!=NULL)
		tframe_set_notbusy(info);
}
