#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* infobranch.c:
 *
 * manages the window that allows the user to change the branch color
 * and width.
 */

#include "interface.h"

#include "treedata.h"

static tframe info;
static tpanel p;
static tpbutton colorb;
static tpslider width;
static tcolorchooser c;
static tpmsg spacer;

/* callbacks for changing line width and color.  Just call the appropriate
 * commands (see command.c) */
int branch_info_change_line_width(s, e, v)
tpslider s;
tevent e;
int v;
{
	seteventloc(e);
	do_command(EveryBranch, NULL, NULL, 0.0, 0.0,
		v, 0, 0, 0, SetThickness);
}

branch_choose_color(red, green, blue)
unsigned short red, green, blue;
{
	tcolor n;

	n=tcolor_new(globals->c, NULL, red, green, blue);
	do_command(EveryBranch, NULL, n, 0.0, 0.0,
		0, 0, 0, 0, SetBranchColor);
	tcolor_hide_chooser(c);
}

/* this callback for the "Change Color..." button just displays the color
 * chooser */
int branch_show_color_chooser(b, e)
tpbutton b;
tevent e;
{
	seteventloc(e);
	tcolor_move_chooser(c, globals->ewin, globals->ex, globals->ey);
	tcolor_show_chooser(c);
}

int branch_hide_color_chooser()
{
	if(globals->depth>1)
		tcolor_hide_chooser(c);
}

int create_branch_info_frame(parent, args)
tframe parent;
targs args;
{
	/* create frame */
    info=tframe_new(parent, 580,100,50,50,0,1,0,
		"Treetool:Branch Settings", args);
    if(info==NULL)
	return(0);
    p=tframe_dialog_panel(info);
    if(p==NULL)
	return(0);

	/* add slider for line width */
    width=tpslider_new(p, 10,10,0,0, NULL, NULL, "Line Width", 0, 15);
    if(width==NULL)
		return(0);
    tpslider_set_event_procedure(width, branch_info_change_line_width);
    /* make color picker */
	spacer=(tpmsg)tpmsg_new(p, 10, 10, 0, 0, NULL, width, "  ");
	/* add change color button */
	colorb=tpbutton_new(p, 10, 10, 0, 0, NULL, spacer, "Change Color...");
	/* only allow the color to be changed on a color monitor */
	if(globals->depth>1)
		c=(tcolorchooser)tcolor_new_chooser(parent, args, branch_choose_color,
			"Choose a Branch Color");
	else
		tpbutton_disable(colorb);
	tpbutton_set_event_procedure(colorb, branch_show_color_chooser);
    tpanel_fit(p);
    tframe_fit(info);
    tframe_hide(info);
    return(1);
}

int update_branch_info_frame(b)
	/* when a new branch is selected, this changes the slider and color
	 * chooser to reflect the attributes of the current branch */
treebranch b;
{
    tpslider_set_val(width, bdta(b)->td->thickness);
	if(globals->depth>1)
		tcolor_change_chooser_color(c, bdta(b)->td->c);
}

int show_branch_info_frame()
	/* callback for the "Branch Info..." menu item */
{
	moveframetoloc(info);
    tframe_show(info);
}

int hide_branch_info_frame()
{
    tframe_hide(info);
	if(globals->depth>1)
		tcolor_hide_chooser(c);
}

branch_busy()
{
	if(info!=NULL)
		tframe_set_busy(info);
}

branch_notbusy()
{
	if(info!=NULL)
		tframe_set_notbusy(info);
}

grey_branch_info(numtrees, clip, multi, subtrees, nodes, branches)
	/* this enables or disables the slider and color button depending on
	 * the current state of treetool.  For instance, if no branch is selected,
	 * then both buttons are disabled */
int numtrees, clip, multi, subtrees, nodes, branches;
{
    if(branches || subtrees)
    {
        if(globals->depth>1)
            tpbutton_enable(colorb);
        tpslider_enable(width);
    }
    else
    {
        if(globals->depth>1)
            tpbutton_disable(colorb);
        tpslider_disable(width);
    }
}
