#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* extras.c:
 *
 * Handles the "Extras" menu.  Functions for creating the menu, greying the
 * items depending on what kind of selection exists, and callbacks for all
 * the menu items */

#include "interface.h"

#include "treedata.h"

static tpanel menubar;
static tpmenu mextras;
static tpitem iselection, imanipulate, iresize, ihide;
static tpitem igrey;
static tpitem iglobals;
static tpitem igetrepresentatives;
static tpitem imergeablenodes;
static tpitem iconnectselections;
static tpitem iselectancestor;
static tpitem iselectall;
static tpitem ichangeoutgroup;
static tpitem ifixlabels;
static tpitem ihidesel;
static tpitem ishowsel;
static tpitem ihidelevel;
static tpitem ieven;

/* callbacks:  seteventloc stores the position of the pointer for allowing
 * popup windows to come up near the pointer */
int e_globals(m, mi, e)
tpmenu m;
tpitem mi;
tevent e;
{
	seteventloc(e);
	show_globals_setup_frame();
}

int e_hide_selected(m, mi, e)
tpmenu m;
tpitem mi;
tevent e;
{
	seteventloc(e);
	do_command(EveryNodeAndSubtree,NULL,NULL,0.0,0.0,0,0,0,0,HideNode);
}

int e_show_selected(m, mi, e)
tpmenu m;
tpitem mi;
tevent e;
{
	seteventloc(e);
	do_command(EveryNodeAndSubtree,NULL,NULL,0.0,0.0,0,0,0,0,ShowNode);
}

int e_hide_level(m, mi, e)
tpmenu m;
tpitem mi;
tevent e;
{
	seteventloc(e);
	do_command(EveryTree,NULL,NULL,0.0,0.0,0,0,0,0,HideLevel);
}

int e_even(m, mi, e)
tpmenu m;
tpitem mi;
tevent e;
{
	seteventloc(e);
	do_command(EveryTree,NULL,NULL,0.0,0.0,0,0,0,0,EvenSpacing);
}

int e_changeoutgroup(m, mi, e)
tpmenu m;
tpitem mi;
tevent e;
{
	seteventloc(e);
	do_command(ChangeOutgroup,NULL,NULL,0.0,0.0,0,0,0,0,0);
}

int e_getrepresentatives(m, mi, e)
tpmenu m;
tpitem mi;
tevent e;
{
	seteventloc(e);
	do_command(EveryTree,NULL,NULL,0.0,0.0,0,0,0,0,PruneToReps);
}

int e_connectselections(m, mi, e)
tpmenu m;
tpitem mi;
tevent e;
{
	seteventloc(e);
	do_command(EveryTree,NULL,NULL,0.0,0.0,0,0,0,0,ConnectSelections);
}

int e_selectancestor(m, mi, e)
tpmenu m;
tpitem mi;
tevent e;
{
	seteventloc(e);
	do_command(EveryTree,NULL,NULL,0.0,0.0,0,0,0,0,SelectAncestor);
}

int e_selectall(m, mi, e)
tpmenu m;
tpitem mi;
tevent e;
{
	seteventloc(e);
	do_command(SelectAll,NULL,NULL,0.0,0.0,0,0,0,0,0);
}

int e_fixlabels(m, mi, e)
tpmenu m;
tpitem mi;
tevent e;
{
	seteventloc(e);
	do_command(EveryNode,NULL,NULL,
		0.0,0.0,0,0,0,0,FixLabel);
}

int e_mergeablenodes(m, mi, e)
tpmenu m;
tpitem mi;
tevent e;
{
	seteventloc(e);
	do_command(EveryNode,NULL,NULL,
		0.0,0.0,0,0,0,0,MergeMergeableNodes);
}

create_extras_menu_items()
{
	iselection=tpitem_new("Selections", NULL);
	imanipulate=tpitem_new("Tree Manipulation", NULL);
	iresize=tpitem_new("Tree Reformatting", NULL);
	ihide=tpitem_new("Hide/Show", NULL);
	iconnectselections=tpitem_new("Connect Selections", e_connectselections);
	iselectancestor=tpitem_new("Select Common Ancestor", e_selectancestor);
	iselectall=tpitem_new("Select All", e_selectall);
	iglobals=tpitem_new("Preferences...", e_globals);
	igetrepresentatives=tpitem_new("Representative Tree", e_getrepresentatives);
	imergeablenodes=tpitem_new("Merge Mergeable Nodes", e_mergeablenodes);
	ifixlabels=tpitem_new("Justify Selected Labels", e_fixlabels);
	ichangeoutgroup=tpitem_new("Change Outgroup", e_changeoutgroup);
	ieven=tpitem_new("Even Spacing", e_even);
	igrey=tpitem_new("   ", NULL);
	ihidesel=tpitem_new("Hide Selected Nodes", e_hide_selected);
	ishowsel=tpitem_new("Show Selected Nodes", e_show_selected);
	ihidelevel=tpitem_new("Hide Level", e_hide_level);
	tpitem_disable(igrey);
}

create_extras_menu(p, after)
tpanel p;
tpmenu after;
{
	mextras=tpmenu_new(p, 10, 10, 0, 0, after, NULL, "Extras       ");

	tpmenu_add(mextras, iglobals, NULL);
	tpmenu_add(mextras, igrey, NULL);
	tpmenu_add(mextras, iconnectselections, NULL);
	tpmenu_add(mextras, iselectancestor, NULL);
	tpmenu_add(mextras, iselectall, NULL);
	tpmenu_add(mextras, igrey, NULL);
	tpmenu_add(mextras, igetrepresentatives, NULL);
	tpmenu_add(mextras, imergeablenodes, NULL);
	tpmenu_add(mextras, ichangeoutgroup, NULL);
	tpmenu_add(mextras, igrey, NULL);
	tpmenu_add(mextras, ieven, NULL);
	tpmenu_add(mextras, ifixlabels, NULL);
	tpmenu_add(mextras, igrey, NULL);
	tpmenu_add(mextras, ihidesel, NULL);
	tpmenu_add(mextras, ishowsel, NULL);
	tpmenu_add(mextras, ihidelevel, NULL);
}

grey_extras(numtrees, clip, multi, subtrees, nodes, branches)
	/* depending on what kind of selection exists, and how many trees there
	 * are, some menu items don't apply.  This routine greys them if they
	 * won't apply in the current situation */
int numtrees, clip, multi, subtrees, nodes, branches;
{
	if(branches || nodes || subtrees)
		tpitem_enable(ieven);
	else
		tpitem_disable(ieven);
	if(nodes || subtrees)
	{
		tpitem_enable(iconnectselections);
		tpitem_enable(iselectancestor);
		tpitem_enable(imergeablenodes);
		tpitem_enable(ifixlabels);
		tpitem_enable(igetrepresentatives);
		tpitem_enable(ihidesel);
		tpitem_enable(ishowsel);
		tpitem_enable(ihidelevel);
	}
	else
	{
		tpitem_disable(iconnectselections);
		tpitem_disable(iselectancestor);
		tpitem_disable(imergeablenodes);
		tpitem_disable(ifixlabels);
		tpitem_disable(igetrepresentatives);
		tpitem_disable(ihidesel);
		tpitem_disable(ishowsel);
		tpitem_disable(ihidelevel);
	}
	if(branches)
		tpitem_enable(ichangeoutgroup);
	else
		tpitem_disable(ichangeoutgroup);
}
