#include <stdio.h>

#ifdef MEMDBG
#include "memdbg.h"
#endif

#include "treestruct.h"

#define NEWICK 1		/* types of output formats */
#define PROLOG 2
#define BINARYPROLOG 3

int usewhat;	/* whether to write comments, or to use functions */
int outtype;
int (*printfun)();


writecommentlist(f, cm, i)
FILE *f;
list cm;
int i;
{
	char *s;
	int first=1;

	if(cm==NULL)
	{
		if(outtype==PROLOG)
			fprintf(f, "[]");
		return;
	}

	if(outtype==NEWICK)
	{
		startlist(cm);
		while((s=listnext(cm))!=NULL)
			fprintf(f, "[%s]", s);
	}
	else if(outtype==PROLOG)
	{
		fprintf(f, "[");
		startlist(cm);
		while((s=listnext(cm))!=NULL)
		{
			if(!first)
				fprintf(f, ",");
			else
				first=0;
			treewritename(f, s);
		}
		fprintf(f, "]");
	}
}

writeshift(f, indent)
FILE *f;
int indent;
{
	while((indent--)>0)
		fprintf(f, "%s", INDENT);
}

writetreenode(n, i, f)
treenode n;
int i;
FILE *f;
{
	int specd;
	double d;
	treebranch b;

	if(outtype==NEWICK)
		writeshift(f, i);
	else if(outtype==PROLOG)
	{
		if(i>0)
		{
			fprintf(f, "\n");
			writeshift(f, i);
		}
		fprintf(f, "newick(");
	}
	if(printfun!=NULL)
		(*printfun)(n, i, f, BEFORE_NODE);
	if(usewhat&Comments || outtype==PROLOG)
	{
		writecommentlist(f, n->bn, i);
		if(outtype==NEWICK && n->bn!=NULL)
		{
			fprintf(f, "\n");
			writeshift(f, i);
		}
		else if(outtype==PROLOG)
			fprintf(f, ",");
	}
	if(!treeleaf(n) || outtype==PROLOG)
	{
		if(outtype==NEWICK)
		{
			fprintf(f, "(\n");

			startlist(n->branches);
			b=listnext(n->branches);
			while(b!=NULL)
			{
				if(b->down!=n)
				{
					writetreenode(b->down, i+1, f);
					while(b!=NULL)
					{
						b=listnext(n->branches);
						if(b!=NULL)
							if(b->down!=n)
								break;
					}
					if(b!=NULL)
						fprintf(f, ",\n");
				}
				else
					b=listnext(n->branches);
			}
			fprintf(f, "\n");
			writeshift(f, i);
			fprintf(f, ")");
		}
		else if(outtype==PROLOG)
		{
			fprintf(f, "[");

			startlist(n->branches);
			b=listnext(n->branches);
			while(b!=NULL)
			{
				if(b->down!=n)
				{
					writetreenode(b->down, i+1, f);
					while(b!=NULL)
					{
						b=listnext(n->branches);
						if(b!=NULL)
							if(b->down!=n)
								break;
					}
					if(b!=NULL)
						fprintf(f, ",");
				}
				else
					b=listnext(n->branches);
			}
			if(!treeleaf(n))
			{
				fprintf(f, "\n");
				writeshift(f, i+1);
			}
			fprintf(f, "],");
		}
	}
	if(printfun!=NULL)
		(*printfun)(n, i, f, AFTER_LIST);
	if(usewhat&Comments || outtype==PROLOG)
	{
		writecommentlist(f, n->al, i);
		if(outtype==NEWICK && n->al!=NULL)
		{
			fprintf(f, "\n");
			writeshift(f, i);
		}
		else if(outtype==PROLOG)
			fprintf(f, ",");
	}
	if(outtype==NEWICK)
	{
		if(n->name!=NULL)
			if(strlen(n->name)!=NULL)
				treewritename(f, n->name);
	}
	else if(outtype==PROLOG)
	{
		if(n->name!=NULL)
			treewritename(f, n->name);
		else
			fprintf(f, "''");
		fprintf(f, ",");
	}
	if(printfun!=NULL)
		(*printfun)(n, i, f, AFTER_NAME);
	if(usewhat&Comments || outtype==PROLOG)
	{
		writecommentlist(f, n->an, i);
		if(outtype==NEWICK && n->an!=NULL)
		{
			fprintf(f, "\n");
			writeshift(f, i);
		}
		else if(outtype==PROLOG)
			fprintf(f, ",");
	}
	specd=parentdistance(n, &d);
	if(specd || outtype==PROLOG)
	{
		if(outtype==NEWICK)
			fprintf(f, ":");
		if(printfun!=NULL)
			(*printfun)(n, i, f, BEFORE_DISTANCE);
		if(usewhat&Comments || outtype==PROLOG)
		{
			writecommentlist(f, n->bd, i);
			if(outtype==NEWICK && n->bd!=NULL)
			{
				fprintf(f, "\n");
				writeshift(f, i);
			}
			else if(outtype==PROLOG)
				fprintf(f, ",");
		}
		if(specd)
			fprintf(f, "%.4lf", d);
		else
			fprintf(f, "''");
		if(outtype==PROLOG)
			fprintf(f, ",");
			
		if(printfun!=NULL)
			(*printfun)(n, i, f, AFTER_DISTANCE);
		if(usewhat&Comments || outtype==PROLOG)
		{
			writecommentlist(f, n->ad, i);
			if(outtype==NEWICK && n->ad!=NULL)
			{
				writeshift(f, i);
			}
		}
		if(outtype==PROLOG)
			fprintf(f, ")");
	}
}

writetree(t, f, withwhat, print_fun)
treenode t;
FILE *f;
int withwhat;
int (*print_fun)();
{
	usewhat=withwhat;
	outtype=NEWICK;
	printfun=print_fun;
	if(f==NULL)
		f=stdout;
	if(tree_get_type(t)==tr_tree)
		t=treeroot(t);
	writetreenode(t, 0, f);
	fprintf(f, ";\n");
}

writetree_prolog(t, f)
treenode t;
FILE *f;
{
	usewhat=0;
	printfun=NULL;
	outtype=PROLOG;
	if(f==NULL)
		f=stdout;
	if(tree_get_type(t)==tr_tree)
		t=treeroot(t);
	writetreenode(t, 0, f);
	fprintf(f, ".\n");
}

wtdo(t, f)
tree t;
FILE *f;
{
	treebranch branches[10000];
	treebranch b;
	treenode n;
	int i, nb;

	if(f==NULL)
		f=stdout;
	branches[0]=NULL;
	fprintf(f, "----------------------------------------\n");
	fprintf(f, "      # up          down        distance\n\n");
	startlist(t->branches);
	nb=1;
	while((b=listnext(t->branches))!=NULL)
	{
	    branches[nb]=b;
	    fprintf(f, "    %3d %-11.11s %-11.11s %8.4f (%8d)\n", nb,
		(b->up!=NULL)?b->up->name:"NULL",
		(b->down!=NULL)?b->down->name:"NULL",
		(b->specified)?b->distance:-1.0,
		tree_get_tree(b));
	    nb++;
	}
	fprintf(f, "----------------------------------------\n");
	fprintf(f, "Tree:%s (%d), root:%s\n", t->name, t,
		(t->root==NULL)?"NULL":t->root->name);
	fprintf(f, "----------------------------------------\n");
	fprintf(f, "      # up          down        distance\n\n");
	startlist(t->nodes);
	while((n=listnext(t->nodes))!=NULL)
	{
	    fprintf(f,
		"%-8.8s                                 (%8d)\n",
		n->name, tree_get_tree(n));
	    startlist(n->branches);
	    while((b=listnext(n->branches))!=NULL)
	    {
		for(i=0;i<nb;i++)
			if(b==branches[i])
				break;
		fprintf(f, "    %3d %-11.11s %-11.11s %8.4f\n", i,
		    (b->up!=NULL)?b->up->name:"NULL",
		    (b->down!=NULL)?b->down->name:"NULL",
		    (b->specified)?b->distance:-1.0);
	    }
	}
}
