#include <stdio.h>

#include <xview/xview.h>
#include <xview/panel.h>
#include "generic.h"

typedef struct {
	ltgenericd g;
	Panel_item t;	/* xview panel item */
	int (*do_events)();
	int selected;	/* 1 if checked (on) */
	} ltpcheckd, *ltpcheck;

int tpcheck_right_side(t)
ltpcheck t;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_pcheck)
		return(0);
	
	return(xv_get(t->t, XV_X)+xv_get(t->t, XV_WIDTH));
}

int tpcheck_bottom_side(t)
ltpcheck t;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_pcheck)
		return(0);
	
	return(xv_get(t->t, XV_Y)+xv_get(t->t, XV_HEIGHT));
}

int tpcheck_set(t)
ltpcheck t;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_pcheck)
		return(0);
	
	xv_set(t->t, PANEL_VALUE, 1, NULL);
	t->selected=1;
	return(1);
}

int tpcheck_unset(t)
ltpcheck t;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_pcheck)
		return(0);
	
	xv_set(t->t, PANEL_VALUE, 0, NULL);
	t->selected=0;
	return(1);
}

Panel_setting tpcheck_notify(item, val, e)
Panel_item item;
int val;
Event *e;
{
	ltpcheck t;
	int a;
	tevent te;

	t=(ltpcheck)xv_get(item, PANEL_CLIENT_DATA);

	t->selected=val;

	if(t->do_events!=NULL)
	{
		te=tevent_create_from_xviewevent(e, event_x(e), event_y(e), 0, 0);
		a=(*t->do_events)(t, te, t->selected);
		tevent_free(te);
	}
	return(XV_OK);
}

tpcheck tpcheck_new(parent, x,y,w,h,right,below, name)
tpanel parent;
int x,y,w,h;
titem right,below;
char *name;
{
	ltpcheck tmp;

	/* check types */
	if(parent==NULL)
		return(NULL);
	if(titem_type(parent)!=lt_panel)
		return(NULL);
	
	if(name==NULL)
		name="Check Item";
	
	tmp=(ltpcheck)titem_new(parent, lt_pcheck, sizeof(ltpcheckd));
	if(tmp==NULL)
		return(NULL);
	
	tmp->t=(Panel_item)xv_create(tpanel_xview(parent), PANEL_CHECK_BOX,
		PANEL_LABEL_STRING, NULL,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOOSE_ONE, FALSE,
		PANEL_CHOICE_STRINGS, name, NULL,
		PANEL_VALUE, 1,
		XV_WIDTH, w,
		XV_HEIGHT, h,
		NULL);
	
	if(right!=NULL)
		x=tp_right_side(right);
	if(below!=NULL)
		y=tp_bottom_side(below);

	xv_set(tmp->t,
		XV_X, x,
		XV_Y, y,
		PANEL_CLIENT_DATA, tmp,
		PANEL_NOTIFY_PROC, tpcheck_notify,
		NULL);

	tmp->do_events=NULL;

	return(tmp);
}

int tpcheck_free(t)
ltpcheck t;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_pcheck)
		return(0);
	
	xv_destroy_safe(t->t);
	return(titem_free(t));
}

int tpcheck_enable(t)
ltpcheck t;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_pcheck)
		return(0);
	
	xv_set(t->t, PANEL_INACTIVE, FALSE, NULL);
	return(1);
}

int tpcheck_disable(t)
ltpcheck t;
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_pcheck)
		return(0);
	
	xv_set(t->t, PANEL_INACTIVE, TRUE, NULL);
	return(1);
}

int tpcheck_set_event_procedure(t, do_events)
ltpcheck t;
int (*do_events)();
{
	/* check type */
	if(t==NULL)
		return(0);
	if(titem_type(t)!=lt_pcheck)
		return(0);
	
	t->do_events=do_events;
	return(1);
}
