#include <stdio.h>

#include <xview/xview.h>
#include <xview/panel.h>

#include "generic.h"

typedef struct {
	ltgenericd g;
	tdisplay dpy;
	Panel p;
	} ltpaneld, *ltpanel;

tdisplay tpanel_display(p)
ltpanel p;
{
	/* check if it's a panel */
	if(p==NULL)
		return(0);
	if(titem_type(p)!=lt_panel)
		return(0);

	/* return the display */
	return(p->dpy);
}

Drawable tpanel_drawable(p)
ltpanel p;
{
	/* check if it's a panel */
	if(p==NULL)
		return(0);
	if(titem_type(p)!=lt_panel)
		return(0);

	/* return the X window for the panel */
	return(xv_get(p->p, XV_XID));
}

int tpanel_right_side(p)
ltpanel p;
{
	/* check if it's a panel */
	if(p==NULL)
		return(0);
	if(titem_type(p)!=lt_panel)
		return(0);

	/* return the right side of the panel */
	return(xv_get(p->p, XV_X)+xv_get(p->p, XV_WIDTH));
}

int tpanel_bottom_side(p)
ltpanel p;
{
	/* check if it's a panel */
	if(p==NULL)
		return(0);
	if(titem_type(p)!=lt_panel)
		return(0);

	/* return the bottom side of the panel */
	return(xv_get(p->p, XV_Y)+xv_get(p->p, XV_HEIGHT));
}

Panel tpanel_xview(p)
ltpanel p;
{
	/* check if it's a panel */
	if(p==NULL)
		return(0);
	if(titem_type(p)!=lt_panel)
		return(0);

	/* return the xview Panel */
	return(p->p);
}

tpanel tpanel_new(parent, x,y,w,h,right,below, args)
titem parent;
int x,y,w,h;
titem right,below;
targs args;
{
	ltpanel p;

	/* check parent type */
	if(parent==NULL)
		return(NULL);
	else if(titem_type(parent)!=lt_frame)
		return(NULL);

	/* get memory */
	p=(ltpanel)titem_new(parent, lt_panel, sizeof(ltpaneld));
	if(p==NULL)
		return(NULL);

	/* create */
	p->p=(Panel)xv_create(tframe_xview(parent), PANEL, NULL);

	/* setup size */
	if(w!=0)
		xv_set(p->p, XV_WIDTH, w, NULL);
	if(h!=0)
		xv_set(p->p, XV_HEIGHT, h, NULL);
	
	/* setup position */
	if(right!=NULL)
		xv_set(p->p, XV_X, tright_side(right), NULL);
	else
		xv_set(p->p, XV_X, x, NULL);
	if(below!=NULL)
		xv_set(p->p, XV_Y, tbottom_side(below), NULL);
	else
		xv_set(p->p, XV_Y, y, NULL);

	p->dpy=(tdisplay)titem_display(parent);

	return((tpanel)p);
}

tpanel tpanel_new_from_dialog(f)
tframe f;
{
	ltpanel p;

	/* get memory */
	p=(ltpanel)titem_new(f, lt_panel, sizeof(ltpaneld));
	if(p==NULL)
		return(NULL);

	/* create */
	p->p=(Panel)xv_get(tframe_xview(f), FRAME_CMD_PANEL);

	return((tpanel)p);
}

int tpanel_free(p)
ltpanel p;
{
	/* check if it's a panel */
	if(p==NULL)
		return(0);
	if(titem_type(p)!=lt_panel)
		return(0);

	xv_destroy_safe(p->p);
	return(titem_free(p));
}

int tpanel_fit(p)
ltpanel p;
{
	/* check if it's a panel */
	if(p==NULL)
		return(0);
	if(titem_type(p)!=lt_panel)
		return(0);

	/* fit the panel */
	window_fit(p->p);
	return(1);
}

int tpanel_set_width_to_frame(p, f)
ltpanel p;
tframe f;
{
	/* check if it's a panel and frame */
	if(p==NULL)
		return(0);
	if(titem_type(p)!=lt_panel)
		return(0);
	if(f==NULL)
		return(0);
	if(titem_type(f)!=lt_frame)
		return(0);

	xv_set(p->p, XV_WIDTH, xv_get(tframe_xview(f), XV_WIDTH), NULL);
	return(1);
}

int tpanel_height(p)
ltpanel p;
{
	/* check if it's a panel */
	if(p==NULL)
		return(0);
	if(titem_type(p)!=lt_panel)
		return(0);

	/* return the height */
	return(xv_get(p->p, XV_HEIGHT));
}

int tpanel_width(p)
ltpanel p;
{
	/* check if it's a panel */
	if(p==NULL)
		return(0);
	if(titem_type(p)!=lt_panel)
		return(0);

	/* return the width */
	return(xv_get(p->p, XV_WIDTH));
}

int tpanel_xview_window(p)
ltpanel p;
{
	/* check if it's a panel */
	if(p==NULL)
		return(0);
	if(titem_type(p)!=lt_panel)
		return(0);

	/* return the window */
	return(xv_get(p->p, XV_XID));
}
