/*
 * @(#)$Id: ccf.c,v 1.2 1994/04/30 19:49:36 shin Exp shin $
 *
 *	Jing-Shin Chang	(shin@hermes.ee.nthu.edu.tw)
 *
 *	Natural Language Processing Laboratory
 *	Department of Electrical Engineering
 *	National Tsing-Hua University
 *	Hsinchu, Taiwan
 */
#include	<stdio.h>
#include	"ccode.h"

/*
 * @(#)main: Code conversion among several Chinese coding schemes
 *	 commonly used in Taiwan and Mainland.
 */

main(argc, argv, envp)
int	argc;
char	**argv;
char	**envp;
{
	FILE *ifile, *ofile;
	int icode, ocode;
	char istr[BUFSIZ], ostr[BUFSIZ];
	int	outlen;

	if ( !ccvt_chkargv(argc, argv, &ifile, &ofile, &icode, &ocode) ) {
		ccvt_usage(argc, argv);
		exit(1);
	}

	bzero(istr, BUFSIZ);
	while ( fgets(istr, BUFSIZ, ifile) != NULL )
	{
		cnvtcode(istr, ostr, icode, ocode, strlen(istr), &outlen);
		fputs(ostr, ofile);
		bzero(istr, BUFSIZ);
   	}
	fclose(ifile);
	fclose(ofile);
}

/*
 * @(#)ccvt_chkargv: command line parsing
 */
ccvt_chkargv(argc, argv, ifile, ofile, icode, ocode)
int	argc;
char	**argv;
FILE	**ifile;			/* input file */
FILE	**ofile;			/* output file */
int	*icode;				/* input code */
int	*ocode;				/* output code */
{
	char sourcecode, targetcode;
	char *src_file, *trg_file;
	static char codeidx[] = CODE_STRING;

	int	is_stdin,		/* source is stdin ? */
		is_stdout;		/* target is stdout ? */

/* check command syntax */

	if (argc < 2 || argv[1][0] != '-' || strlen(argv[1]) < 3 ) {
		return(FALSE);
	}

	sourcecode = argv[1][1];
	targetcode = argv[1][2];

/* determine type of source code */

	if ((*icode = Index(codeidx,sourcecode)) < 0) {
		printf("unknown input code set: %c\n", sourcecode);
		return(FALSE);
	}

/* determine type of target code */

	if ((*ocode = Index(codeidx,targetcode)) < 0) {
		printf("unknown output code set: %c\n", targetcode);
		return(FALSE);
	}

/* determine which source/target file to open (stdin/stdout or not) */

	is_stdin  = FALSE;
	is_stdout = FALSE;

	if ( argc == 2 || argv[2][0] == '-' ) {
		*ifile = stdin;
		is_stdin = TRUE;
	}
	else {
		src_file = argv[2];
	}

	if ( argc < 4 || argv[3][0] == '-' ) {
		*ofile = stdout;
		is_stdout = TRUE;
	}
	else {
		trg_file = argv[3];
	}

/* open source && target files unless they are stdin/stdout */

	if ( (!is_stdin)  &&  (*ifile=fopen(src_file,"r")) == NULL) {
		printf("\n\n fail to open input file: %s\n", src_file);
		return(FALSE);
   	}

	if ( (!is_stdout) && (*ofile=fopen(trg_file,"w")) == NULL) {
		printf("\n\n fail to open output file: %s\n", trg_file);
		return(FALSE);
	}

	return(TRUE);

} /* ccvt_chkargv */

/*
 * ccvt_usage: a brief help menu
 */
ccvt_usage(argc, argv)
int	argc;
char	**argv;
{
	printf("** Chinese Code Filters ** Rev. 1.53 ** 1994/10\n");
	printf("\nUsage: %s -ST [ {SrcFile|-} [{TrgFile|-}] ]\n\n", argv[0]);
	printf("\t- 'S'/'T': 1-char source/target code designator\n");
	printf("\t- SrcFile: source file ('-' or omitted for 'stdin')\n");
	printf("\t- TrgFile: target file ('-' or omitted for 'stdout')\n");

	printf("\nSource/Target codes: (Case Sensitive)\n\n");
	printf("\t- b: BIG5\n");
	printf("\t- i: IBM5550\n");
	printf("\t- n: NSC Internal (CNS-11643/86, Internal code)\n");
	printf("\t- e: EUC (Extended UNIX Code)\n");
	printf("\t- t: TCA (Taipei Computer Association code)\n");
	printf("\t- l: Telegram\n");
	printf("\t- H: IBM Host\n");
	printf("\t- p: NSC-P (CNS-11643/86, 7bit ISO-type protocol)\n");
	printf("\t- 7: B5E3/BIG5 7-bit ASCII exchange code (See *1 below)\n");
	printf("\t- g: GB code\n");
	printf("\t- h: HZ 7-bit ASCII exchange code for GB\n");
	printf("\t- o: optimal encoding to HZ+B5E3 (See *2 below)\n\n");
	printf("\t*1: Currently, BIG5/7-bit code includes encoding to\n");
	printf("\t    B5ENCODE/III (B5E3/.be3) format\n");
	printf("\t    and decoding from ASCII/DBCS & HZ & B5ENCODE3 mixture\n");
	printf("\t    DBCS: double byte char/code set, like Big5/CNS/5550/TCA\n");
	printf("\t    (also including EUC stuff)\n\n");

	printf("\t*2: -bo: Big5 (Taiwanese codes) => HZ if convertable\n");
	printf("\t         Big5 (Taiwanese codes) => B5E3 if otherwise\n");
	printf("\t    -go: GB => B5E3 if convertable\n");
	printf("\t         GB => HZ if otherwise\n\n");

	printf("\tExample 1: %s -be file.b5 file.euc\n", argv[0]);
	printf("\tExample 2: zcat file.b5.Z | %s -bg > file.gb\n", argv[0]);
	printf("\tExample 3: %s -b7 file.b5 > file.be3\n", argv[0]);
	printf("\tExample 4: %s -7b file.hz > file.b5\n", argv[0]);
	printf("\tExample 5: %s -7n file.asc+hz+be3 > file.cns\n", argv[0]);
	printf("\tExample 6: %s -gh file.gb file.hz\n", argv[0]);
	printf("\tExample 7: %s -g7 file.gb file.be3\n", argv[0]);
}

/*
 * History:
 *
 * $Log: ccf.c,v $
 * Revision 1.2  1994/04/30  19:49:36  shin
 * 1. change minor Usage comments on NSC
 *
 * Revision 1.1  1994/04/21  15:02:23  shin
 * Initial revision
 *
 * ORG:
 * ccvt.c: Revision 1.4  1994/03/16  18:48:00  shin
 */

