/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		RTSPSessionInterface.h

	Contains:	Presents an API for session-wide resources for modules to use.
	
	$Log: RTSPSessionInterface.h,v $
	Revision 1.2  1999/02/19 23:08:39  ds
	Created
	

*/

#ifndef __RTSPSESSIONINTERFACE_H__
#define __RTSPSESSIONINTERFACE_H__

#include "RTSPRequestStream.h"
#include "Task.h"
#include "Dictionary.h"

class RTSPSessionInterface : public Task, public Dictionary
{
public:

	RTSPSessionInterface();
	virtual ~RTSPSessionInterface() {}
	
	static UInt32 GenerateDictionaryID(FourCharCode inValueSignature);
	
	//Is this session alive? If this returns false, clean up and begone as
	//fast as possible
	bool IsLiveSession() 		{ return fSocket.IsConnected() && fLiveSession; }
	
	//Two main things are persistent through the course of a session, not
	//associated with any one request. The RequestStream (which can be used for
	//getting data from the client), and the socket.
	RTSPRequestStream*	GetInputStream() 	{ return &fStream; }
	TCPSocket*			GetSocket() 		{ return &fSocket; }
	
	UInt32				GetSessionID()		{ return fSessionID; }
	
	//Whether the timeout is active or not can be toggled on / off
	void				SetTimeoutEnabled(bool isTimeoutEnabled) { fTimeoutEnabled = isTimeoutEnabled; }

	void				SetCookieA(void* inCookieA) { fCookieA = inCookieA; }
	void				SetCookieB(void* inCookieB) { fCookieB = inCookieB; }
	void*				GetCookieA() 				{ return fCookieA; }
	void*				GetCookieB() 				{ return fCookieB; }

protected:

	//Each RTSP session has a unique number that identifies it.
	enum
	{
		kFirstRTSPSessionID = 1	//UInt32
	};

	//Requests can append cookies to the session for storing some state
	//in between requests
	void*				fCookieA;
	void*				fCookieB;
	
	RTSPRequestStream 	fStream;
	bool				fLiveSession;
	TCPSocket			fSocket;
	bool				fTimeoutEnabled;
	UInt32				fSessionID;
	
	static unsigned int	sSessionIDCounter;

};
#endif // __RTSPSESSIONINTERFACE_H__

