/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		RTSPProtocol.cpp

	Contains:	Implementation of class defined in RTSPProtocol.h

	$Log: RTSPProtocol.cpp,v $
	Revision 1.2  1999/02/19 23:08:31  ds
	Created
	

*/

#include <ctype.h>
#include "RTSPProtocol.h"

StrPtrLen RTSPProtocol::sMethods[] =
{
	StrPtrLen("DESCRIBE", 8),
	StrPtrLen("SETUP", 5),
	StrPtrLen("TEARDOWN", 8),
	StrPtrLen("PLAY", 4),
	StrPtrLen("PAUSE", 5),
	StrPtrLen("OPTIONS", 7),
	StrPtrLen("ANNOUNCE", 8),
	StrPtrLen("GET_PARAMETER", 13),
	StrPtrLen("SET_PARAMETER", 13),
	StrPtrLen("REDIRECT", 8),
	StrPtrLen("RECORD", 6),
};

RTSPProtocol::RTSPMethod
RTSPProtocol::GetMethod(const StrPtrLen &inMethodStr)
{
	//chances are this is one of our selected "VIP" methods. so check for this.
	RTSPMethod theMethod = kIllegalMethod;
	
	switch(*inMethodStr.Ptr)
	{
		case 'S': 	case 's':	theMethod = kSetupMethod;		break;
		case 'D':	case 'd':	theMethod = kDescribeMethod;	break;
		case 'T':	case 't':	theMethod = kTeardownMethod;	break;
	}

	if ((theMethod != kIllegalMethod) &&
		(inMethodStr.EqualIgnoreCase(sMethods[theMethod].Ptr, sMethods[theMethod].Len)))
		return theMethod;

	for (SInt32 x = kNumVIPMethods; x < kIllegalMethod; x++)
		if (inMethodStr.EqualIgnoreCase(sMethods[x].Ptr, sMethods[x].Len))
			return x;
	return kIllegalMethod;
}


StrPtrLen RTSPProtocol::sHeaders[] =
{
	StrPtrLen("Accept", 6),
	StrPtrLen("Cseq", 4),
	StrPtrLen("User-Agent", 10),
	StrPtrLen("Transport", 9),
	StrPtrLen("Session", 7),
	StrPtrLen("Range", 5),

	StrPtrLen("Accept-Encoding", 15),
	StrPtrLen("Accept-Language", 15),
	StrPtrLen("Authorization", 13),
	StrPtrLen("Bandwidth", 9),
	StrPtrLen("Blocksize", 9),
	StrPtrLen("Cache-Control", 13),
	StrPtrLen("Conference", 10),
	StrPtrLen("Connection", 10),
	StrPtrLen("Content-Base", 12),
	StrPtrLen("Content-Encoding", 16),
	StrPtrLen("Content-Language", 16),
	StrPtrLen("Content-length", 14),
	StrPtrLen("Content-Location", 16),
	StrPtrLen("Content-Type", 12),
	StrPtrLen("Date", 4),
	StrPtrLen("Expires", 7),
	StrPtrLen("From", 4),
	StrPtrLen("Host", 4),
	StrPtrLen("If-Match", 8),
	StrPtrLen("If-Modified-Since", 17),
	StrPtrLen("Last-Modified", 13),
	StrPtrLen("Location", 8),
	StrPtrLen("Proxy-Authenticate", 18),
	StrPtrLen("Proxy-Require", 13),
	StrPtrLen("Referer", 7),
	StrPtrLen("Retry-After", 11),
	StrPtrLen("Require", 7),
	StrPtrLen("RTP-Info", 8),
	StrPtrLen("Scale", 5),
	StrPtrLen("Speed", 5),
	StrPtrLen("Timestamp", 9),
	StrPtrLen("Vary", 4),
	StrPtrLen("Via", 3),
	
	StrPtrLen("Allow", 5),
	StrPtrLen("Public", 6),
	StrPtrLen("Server", 6),
	StrPtrLen("Unsupported", 11),
	StrPtrLen("WWW-Authenticate", 16),
	StrPtrLen(" ,", 2)
};

RTSPProtocol::RTSPHeader	RTSPProtocol::GetRequestHeader(const StrPtrLen &inHeaderStr)
{
	if (inHeaderStr.Len == 0)
		return kIllegalHeader;
	
	RTSPHeader theHeader = kIllegalHeader;
	
	//chances are this is one of our selected "VIP" headers. so check for this.
	switch(*inHeaderStr.Ptr)
	{
		case 'C': 	case 'c':	theHeader = kCSeqHeader;		break;
		case 'S':	case 's':	theHeader = kSessionHeader;		break;
		case 'U':	case 'u':	theHeader = kUserAgentHeader;	break;
		case 'A':	case 'a':	theHeader = kAcceptHeader;		break;
		case 'T':	case 't':	theHeader = kTransportHeader;	break;
		case 'R':	case 'r':	theHeader = kRangeHeader;		break;
	}
	
	if ((theHeader != kIllegalHeader) &&
		(inHeaderStr.EqualIgnoreCase(sHeaders[theHeader].Ptr, sHeaders[theHeader].Len)))
		return theHeader;

	//If this isn't one of our VIP headers, go through the remaining request headers, trying
	//to find the right one.
	for (SInt32 x = kNumVIPHeaders; x < kNumRequestHeaders; x++)
		if (inHeaderStr.EqualIgnoreCase(sHeaders[x].Ptr, sHeaders[x].Len))
			return x;
	return kIllegalHeader;
}



StrPtrLen RTSPProtocol::sStatusCodeStrings[] =
{
	StrPtrLen("Continue", ::strlen("Continue")),											//kContinue
	StrPtrLen("OK", ::strlen("OK")),														//kSuccessOK
	StrPtrLen("Created", ::strlen("Created")),												//kSuccessCreated
	StrPtrLen("Accepted", ::strlen("Accepted")),											//kSuccessAccepted
	StrPtrLen("No Content", ::strlen("No Content")),										//kSuccessNoContent
	StrPtrLen("Partial Content", ::strlen("Partial Content")),								//kSuccessPartialContent
	StrPtrLen("Low on Storage Space", ::strlen("Low on Storage Space")),					//kSuccessLowOnStorage
	StrPtrLen("Multiple Choices", ::strlen("Multiple Choices")),							//kMultipleChoices
	StrPtrLen("Moved Permanently", ::strlen("Moved Permanently")),							//kRedirectPermMoved
	StrPtrLen("Found", ::strlen("Found")),													//kRedirectTempMoved
	StrPtrLen("See Other", ::strlen("See Other")),											//kRedirectSeeOther
	StrPtrLen("Not Modified", ::strlen("Not Modified")),									//kRedirectNotModified
	StrPtrLen("Use Proxy", ::strlen("Use Proxy")),											//kUseProxy
	StrPtrLen("Bad Request", ::strlen("Bad Request")),										//kClientBadRequest
	StrPtrLen("Unauthorized", ::strlen("Unauthorized")),									//kClientUnAuthorized
	StrPtrLen("Payment Required", ::strlen("Payment Required")),							//kPaymentRequired
	StrPtrLen("Forbidden", ::strlen("Forbidden")),											//kClientForbidden
	StrPtrLen("Not Found", ::strlen("Not Found")),											//kClientNotFound
	StrPtrLen("Method Not Allowed", ::strlen("Method Not Allowed")),						//kClientMethodNotAllowed
	StrPtrLen("Not Acceptable", ::strlen("Not Acceptable")),								//kNotAcceptable
	StrPtrLen("Proxy Authentication Required", ::strlen("Proxy Authentication Required")),	//kProxyAuthenticationRequired
	StrPtrLen("Request Time-out", ::strlen("Request Time-out")),							//kRequestTimeout
	StrPtrLen("Conflict", ::strlen("Conflict")),											//kClientConflict
	StrPtrLen("Gone", ::strlen("Gone")),													//kGone
	StrPtrLen("Length Required", ::strlen("Length Required")),								//kLengthRequired
	StrPtrLen("Precondition Failed", ::strlen("Precondition Failed")),						//kPreconditionFailed
	StrPtrLen("Request Entity Too Large", ::strlen("Request Entity Too Large")),			//kRequestEntityTooLarge
	StrPtrLen("Request-URI Too Large", ::strlen("Request-URI Too Large")),					//kRequestURITooLarge
	StrPtrLen("Unsupported Media Type", ::strlen("Unsupported Media Type")),				//kUnsupportedMediaType
	StrPtrLen("Parameter Not Understood", ::strlen("Parameter Not Understood")),			//kClientParameterNotUnderstood
	StrPtrLen("Conference Not Found", ::strlen("Conference Not Found")),					//kClientConferenceNotFound
	StrPtrLen("Not Enough Bandwidth", ::strlen("Not Enough Bandwidth")),					//kClientNotEnoughBandwidth
	StrPtrLen("Session Not Found", ::strlen("Session Not Found")),							//kClientSessionNotFound
	StrPtrLen("Method Not Valid in this State", ::strlen("Method Not Valid in this State")),	//kClientMethodNotValidInState
	StrPtrLen("Header Field Not Valid For Resource", ::strlen("Header Field Not Valid For Resource")),	//kClientHeaderFieldNotValid
	StrPtrLen("Invalid Range", ::strlen("Invalid Range")),									//kClientInvalidRange
	StrPtrLen("Parameter Is Read-Only", ::strlen("Parameter Is Read-Only")),				//kClientReadOnlyParameter
	StrPtrLen("Aggregate Option Not Allowed", ::strlen("Aggregate Option Not Allowed")),	//kClientAggregateOptionNotAllowed
	StrPtrLen("Only Aggregate Option Allowed", ::strlen("Only Aggregate Option Allowed")),	//kClientAggregateOptionAllowed
	StrPtrLen("Unsupported Transport", ::strlen("Unsupported Transport")),					//kClientUnsupportedTransport
	StrPtrLen("Destination Unreachable", ::strlen("Destination Unreachable")),				//kClientDestinationUnreachable
	StrPtrLen("Internal Server Error", ::strlen("Internal Server Error")),					//kServerInternal
	StrPtrLen("Not Implemented", ::strlen("Not Implemented")),								//kServerNotImplemented
	StrPtrLen("Bad Gateway", ::strlen("Bad Gateway")),										//kServerBadGateway
	StrPtrLen("Service Unavailable", ::strlen("Service Unavailable")),						//kServerUnavailable
	StrPtrLen("Gateway Timeout", ::strlen("Gateway Timeout")),								//kServerGatewayTimeout
	StrPtrLen("RTSP Version not supported", ::strlen("RTSP Version not supported")),		//kRTSPVersionNotSupported
	StrPtrLen("Option Not Supported", ::strlen("Option Not Supported"))						//kServerOptionNotSupported
};

SInt32 RTSPProtocol::sStatusCodes[] =
{
 	100,		//kContinue
 	200,		//kSuccessOK
 	201,		//kSuccessCreated
 	202,		//kSuccessAccepted
 	204,		//kSuccessNoContent
 	206,		//kSuccessPartialContent
 	250,		//kSuccessLowOnStorage
 	300,		//kMultipleChoices
	301,		//kRedirectPermMoved
 	302,		//kRedirectTempMoved
 	303,		//kRedirectSeeOther
 	304,		//kRedirectNotModified
 	305,		//kUseProxy
 	400,		//kClientBadRequest
 	401,		//kClientUnAuthorized
 	402,		//kPaymentRequired
 	403,		//kClientForbidden
 	404,		//kClientNotFound
 	405,		//kClientMethodNotAllowed
 	406,		//kNotAcceptable
 	407,		//kProxyAuthenticationRequired
 	408,		//kRequestTimeout
 	409,		//kClientConflict
 	410,		//kGone
 	411,		//kLengthRequired
 	412,		//kPreconditionFailed
 	413,		//kRequestEntityTooLarge
 	414,		//kRequestURITooLarge
 	415,		//kUnsupportedMediaType
 	451,		//kClientParameterNotUnderstood
 	452,		//kClientConferenceNotFound
 	453,		//kClientNotEnoughBandwidth
 	454,		//kClientSessionNotFound
 	455,		//kClientMethodNotValidInState
 	456,		//kClientHeaderFieldNotValid
 	457,		//kClientInvalidRange
 	458,		//kClientReadOnlyParameter
 	459,		//kClientAggregateOptionNotAllowed
 	460,		//kClientAggregateOptionAllowed
 	461,		//kClientUnsupportedTransport
 	462,		//kClientDestinationUnreachable
 	500,		//kServerInternal
 	501,		//kServerNotImplemented
 	502,		//kServerBadGateway
 	503,		//kServerUnavailable
 	504,		//kServerGatewayTimeout
 	505,		//kRTSPVersionNotSupported
 	551			//kServerOptionNotSupported
};

StrPtrLen RTSPProtocol::sStatusCodeAsStrings[] =
{
 	StrPtrLen("100", 3),		//kContinue
 	StrPtrLen("200", 3),		//kSuccessOK
 	StrPtrLen("201", 3),		//kSuccessCreated
 	StrPtrLen("202", 3),		//kSuccessAccepted
 	StrPtrLen("204", 3),		//kSuccessNoContent
 	StrPtrLen("206", 3),		//kSuccessPartialContent
 	StrPtrLen("250", 3),		//kSuccessLowOnStorage
 	StrPtrLen("300", 3),		//kMultipleChoices
	StrPtrLen("301", 3),		//kRedirectPermMoved
 	StrPtrLen("302", 3),		//kRedirectTempMoved
 	StrPtrLen("303", 3),		//kRedirectSeeOther
 	StrPtrLen("304", 3),		//kRedirectNotModified
 	StrPtrLen("305", 3),		//kUseProxy
 	StrPtrLen("400", 3),		//kClientBadRequest
 	StrPtrLen("401", 3),		//kClientUnAuthorized
 	StrPtrLen("402", 3),		//kPaymentRequired
 	StrPtrLen("403", 3),		//kClientForbidden
 	StrPtrLen("404", 3),		//kClientNotFound
 	StrPtrLen("405", 3),		//kClientMethodNotAllowed
 	StrPtrLen("406", 3),		//kNotAcceptable
 	StrPtrLen("407", 3),		//kProxyAuthenticationRequired
 	StrPtrLen("408", 3),		//kRequestTimeout
 	StrPtrLen("409", 3),		//kClientConflict
 	StrPtrLen("410", 3),		//kGone
 	StrPtrLen("411", 3),		//kLengthRequired
 	StrPtrLen("412", 3),		//kPreconditionFailed
 	StrPtrLen("413", 3),		//kRequestEntityTooLarge
 	StrPtrLen("414", 3),		//kRequestURITooLarge
 	StrPtrLen("415", 3),		//kUnsupportedMediaType
 	StrPtrLen("451", 3),		//kClientParameterNotUnderstood
 	StrPtrLen("452", 3),		//kClientConferenceNotFound
 	StrPtrLen("453", 3),		//kClientNotEnoughBandwidth
 	StrPtrLen("454", 3),		//kClientSessionNotFound
 	StrPtrLen("455", 3),		//kClientMethodNotValidInState
 	StrPtrLen("456", 3),		//kClientHeaderFieldNotValid
 	StrPtrLen("457", 3),		//kClientInvalidRange
 	StrPtrLen("458", 3),		//kClientReadOnlyParameter
 	StrPtrLen("459", 3),		//kClientAggregateOptionNotAllowed
 	StrPtrLen("460", 3),		//kClientAggregateOptionAllowed
 	StrPtrLen("461", 3),		//kClientUnsupportedTransport
 	StrPtrLen("462", 3),		//kClientDestinationUnreachable
 	StrPtrLen("500", 3),		//kServerInternal
 	StrPtrLen("501", 3),		//kServerNotImplemented
 	StrPtrLen("502", 3),		//kServerBadGateway
 	StrPtrLen("503", 3),		//kServerUnavailable
 	StrPtrLen("504", 3),		//kServerGatewayTimeout
 	StrPtrLen("505", 3),		//kRTSPVersionNotSupported
 	StrPtrLen("551", 3)			//kServerOptionNotSupported
};

StrPtrLen RTSPProtocol::sVersionString[] = 
{
	StrPtrLen("RTSP/1.0", 8)
};

RTSPProtocol::RTSPVersion
RTSPProtocol::GetVersion(StrPtrLen &versionStr)
{
	if (versionStr.Len != 8)
		return kIllegalVersion;
	else
		return k10Version;
}
