/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		RTPFileModule.h

	Contains:	RTP module that serves RTP packets stored in files. 
					
	$Log: RTPCacheModule.h,v $
	Revision 1.2  1999/02/19 23:07:22  ds
	Created
	

*/

#ifndef _RTPFILEMODULE_H_
#define _RTPFILEMODULE_H_

#include "QTRTPFile.h"
#include "RTPModule.h"
#include "RTPSession.h"
#include "OSFileSource.h"
#include "OSRef.h"
#include "QTRTPFile.h"
#include "SDPParser.h"


class RTPFileModule : public RTPModule
{
	public:
	
		RTPFileModule();
		virtual ~RTPFileModule() {}

		virtual RTSPProtocol::RTSPStatusCode Describe(RTSPRequestInterface* inRequest, void** outCookie);

		//returns non-null error handler in the event of an error
		virtual RTSPProtocol::RTSPStatusCode NewSession(RTSPRequestInterface* ,
										RTPSession* inSessionP, void* inCookie);
											
		virtual void 		DestroySession(RTPSession* inSessionP);
		virtual void		DestroyCookie(void* inCookie);

		virtual RTSPProtocol::RTSPStatusCode ProcessRTSPRequest(RTSPRequestInterface* inRequest,
													RTPSession* inSession);
		
		virtual QTSS_ErrorCode	GetParameter(QTSS_ParamKeywords inParam,
												RTPSession*,
												RTPStream*,
												void* outResult,
												UInt32* ioLen);
		
		SInt64 	SendPackets(RTPSession* inSession);
		
	private:
	
		struct FileSession
		{
			FileSession() : fNextPacket(NULL), fNextPacketLen(0), 
							fPacketPlayTime(0), fStream(NULL) {}
			~FileSession() {}
			
			QTRTPFile fFile;
			char*	fNextPacket;
			int		fNextPacketLen;
			SInt64	fPacketPlayTime;
			RTPStream* fStream;
			SDPParser fSDPParser;
		};
		
		void SetTrackQuality(RTPSession* inSession, QTRTPFile* inFile, UInt32 inQuality);
		
		RTSPProtocol::RTSPStatusCode DoPlay(RTSPRequestInterface* inRequest, RTPSession* inSession);
		RTSPProtocol::RTSPStatusCode DoSetup(RTSPRequestInterface* inRequest, RTPSession* inSession);
		RTSPProtocol::RTSPStatusCode CreateQTRTPFile(RTSPRequestInterface* inRTSPRequest, char* inPath, FileSession** outFile);
		
		//beginning of each packet
		//send out packets at most this many milliseconds ahead of time.
		static StrPtrLen sSDPSuffix;
		static StrPtrLen sSDPHeader1;
		static StrPtrLen sSDPHeader2;
		static StrPtrLen sSDPHeader3;
		static StrPtrLen sSDPHeader4;

};

#endif //_RTPFILEMODULE_H_