/*
 * util.c
 * Written by Michael Kellner
 * Copyright 1999 by Apple Computer, Inc., all rights reserved.
 *
 * $Log: /StreamingServers/proxy3/util.c $
		
		2     4/2/99 2:52 PM Mike Kellner
		better copyright
		
		1     2/26/99 10:36 AM Mike Kellner
		Adding subproject 'proxy3' to '$/StreamingServers'
		
		3     2/15/99 2:22 PM Mike Kellner
		use DOS LF/CR 'cause mac can deal and win can't.
		
		2     2/12/99 11:48 AM Mike Kellner
		split out platform specific code
		
		1     2/11/99 9:44 AM Mike Kellner
		Adding 'util.c' to '$/StreamingServers/proxy/'
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <fcntl.h>

#include "util.h"

/**********************************************/
static char ip_string_buffer[20];
char *ip_to_string(int ip) {
	sprintf(ip_string_buffer, "%d.%d.%d.%d",
		(ip & 0xff000000) >> 24, (ip & 0x00ff0000) >> 16,
		(ip & 0x0000ff00) >> 8, (ip & 0x000000ff));
	return ip_string_buffer;
}

/**********************************************/
static char to_lower(char c)
{
	if (c >= 'A' && c <= 'Z')
		return ((c - 'A') + 'a');
	return c;
}

/**********************************************/
char *str_dup(char *str)
{
	char *ret;
	
	ret = (char*)malloc(strlen(str)+1);
	strcpy(ret, str);
	return ret;
}

/**********************************************/
int str_casecmp(char *str1, char *str2)
{
	int	ret;
	
	ret = *str1 - *str2;
	while (*str1 && *str2 && ((ret = *str1++ - *str2++) == 0))
		;
	return ret;
}

/**********************************************/
int strn_casecmp(char *str1, char *str2, int l)
{
	int	ret;
	
	ret = to_lower(*str1) - to_lower(*str2);
	while (l-- && to_lower(*str1) && to_lower(*str2) && ((ret = to_lower(*str1++) - to_lower(*str2++)) == 0))
		;
	return ret;
}

/**********************************************/
char *str_sep(char **stringp, char *delim)
{
	int j, dl, i, sl;
	char *newstring, *ret;

	if (*stringp == NULL)
		return NULL;

	dl = strlen(delim);
	sl = strlen(*stringp);
	newstring = NULL;
	ret = *stringp;

	for (i=0; i<sl; i++) {
		for (j=0; j<dl; j++) {
			if ((*stringp)[i] == delim[j]) {
				(*stringp)[i] = '\0';
				newstring = &((*stringp)[i+1]);
				i = sl; j = dl;
			}
		}
	}

	*stringp = newstring;
	return ret;
}

/**********************************************/
typedef struct t_ip_cache {
	struct t_ip_cache *next;
	char 	*name;
	int		ip;
} t_ip_cache;
static t_ip_cache *gIPcache = NULL;
int check_IP_cache(char *name, int *ip)
{
	t_ip_cache *cur = gIPcache;
	
	while (cur) {
		if (str_casecmp(name, cur->name) == 0) {
			*ip = cur->ip;
			return 0;
		}
		cur = cur->next;
	}
	return -1;
}

/**********************************************/
int add_to_IP_cache(char *name, int ip)
{
	t_ip_cache *cur;
	
	cur = (t_ip_cache*)malloc(sizeof(t_ip_cache));
	if (cur == NULL)
		return -1;
	cur->ip = ip;
	cur->name = malloc(strlen(name) + 1);
	strcpy(cur->name, name);
	cur->next = gIPcache;
	gIPcache = cur;
	return 0;
}

/**********************************************/
int inet_aton_(char *s, int *retval)
{
	int i, l, x, el[4], ret, good = 1;

	x = 0, ret = 0;
	l = strlen(s);
	el[0] = 0;
	for (i=0; i<l; i++) {
		if (s[i] == '.') {
			x++;
			if (x > 3) {
				good = 0;
				break;
			}
			el[x] = 0;
		}
		else if (s[i] >= '0' && s[i] <= '9') {
			el[x] *= 10;
			el[x] += s[i] - '0';
		}
		else
			good = 0;
	}
	switch (x) {
		case 3:
			ret = ( ((el[0] << 24) & 0xff000000) |
					((el[1] << 16) & 0x00ff0000) |
					((el[2] << 8 ) & 0x0000ff00) |
					 (el[3] & 0x000000ff) );
			break;
		case 2:
			ret = ( ((el[0] << 24) & 0xff000000) |
					((el[1] << 16) & 0x00ff0000) |
					 (el[2] & 0x0000ffff) );
			break;
		case 1:
			ret = (((el[0] << 24) & 0xff000000) |
					(el[1] & 0x00ffffff) );
			break;
		case 0:
			ret = el[0];
			break;
	}
	*retval = ret;
	return good;
}

