/*
	File:		shared_udp.h

	Contains:	udp sockets implementation with shared ports
	
	Written by:	Michael Kellner

	Copyright:	 1999 by Apple Computer, Inc., all rights reserved.

	$Log: /StreamingServers/proxy3/shared_udp.h $
		
		3     4/2/99 6:11 PM Mike Kellner
		fixed header
		
		2     4/2/99 2:53 PM Mike Kellner
		better copyright

	$NoKeywords: $

*/


#ifndef __SHARED_UDP_H__
#define __SHARED_UDP_H__

/**********************************************/
typedef int (*do_routine)(void * refCon, char *buf, int bufSize);

typedef struct ipList {
	struct ipList	*next;
	int				ip;
	do_routine		what_to_do;
	void			*what_to_do_it_with;
} ipList;

typedef struct shok {
	struct shok	*next;
	int		socket;
	int		port;
	ipList	*ips;
	struct shok	*sib;		// sibling - rtcp or rtp
} shok;

typedef struct trans_pb {
	int		*status;		// set to 1 when needs to die
	shok	*send_from;
	int		send_to_ip;
	int		send_to_port;
} trans_pb;

/**********************************************/
ipList *find_ip_in_list(ipList *list, int ip);
int add_ip_to_list(ipList **list, int ip);
int remove_ip_from_list(ipList **list, int ip);
shok *find_available_shok(int fromIP, int toIP, int withSib);
int add_ips_to_shok(shok *theShok, int fromIP, int toIP, int withSib);
void set_udp_port_min_and_max(int min, int max);
int remove_shok(shok *theShok, int withSib);
void remove_shok_ref(shok *theShok, int fromIP, int toIP, int withSib);
shok *make_new_shok(int fromIP, int toIP, int withSib);
int make_udp_port_pair(int fromIP, int toIP, shok **rtpSocket, shok **rtcpSocket);
int upon_receipt_from(shok *theShok, int fromIP, do_routine doThis, void *withThis);
int service_shoks();
int transfer_data(void *refCon, char *buf, int bufSize);

#endif // __SHARED_UDP_H__

