/*
 * proxy_plat.h
 * Written by Michael Kellner
 * Copyright 1999 by Apple Computer, Inc., all rights reserved.
 *
 * $Log: /StreamingServers/proxy3/proxy_plat.h $
		
		6     4/2/99 2:53 PM Mike Kellner
		better copyright
		
		5     3/05/99 3:26p Mike Kellner
		make win32 ErrorString and DebugString be same as Mac
		
		4     3/5/99 12:46 PM Mike Kellner
		make DebugString just printf on unix and win
		
		3     3/4/99 3:08 PM Mike Kellner
		add ASYNC connect for Mac
		
		2     3/3/99 4:22 PM Mike Kellner
		make Mac ErrorString just print it into a global variable for display
		later.
		
		1     2/26/99 10:36 AM Mike Kellner
		Adding subproject 'proxy3' to '$/StreamingServers'
		
		7     2/19/99 4:11 PM Mike Kellner
		moved some stuff from util.h
		
		6     2/17/99 1:47 PM Mike Kellner
		add ui prototypes
		
		5     2/17/99 10:47 AM Mike Kellner
		add status structure
		
		4     2/15/99 2:18 PM Mike Kellner
		use global for getopt string (so we can have different ones for
		Mac/Unix and Win) use more plat independent stuff for error checking
		use DOS LF/CR 'cause mac can deal and win can't.
		
		3     2/12/99 2:51 PM Mike Kellner
		add lf at end
		
		2     2/12/99 11:48 AM Mike Kellner
		split out platform specific code
		
		1     2/12/99 9:23 AM Mike Kellner
		Adding 'proxy_plat.h' to '$/StreamingServers/proxy/'
 */

#ifndef _PLAT_H_
#define _PLAT_H_

/**********************************************/
#define bool    char
#if !defined(mac)
#define true    1
#define false   0
#endif
#if !defined(WIN32)
#define INVALID_SOCKET -1
#define SOCKET_ERROR -1
#endif

/**********************************************/
#if defined(WIN32)
#define EACCES		WSAEACCES
#define EINTR		WSAEINTR
#define EAGAIN		WSAEWOULDBLOCK		/* good enough? */
#define EPIPE		WSAESHUTDOWN		/* good enough? */
#define ENOTCONN	WSAENOTCONN
#define ECONNRESET	WSAECONNRESET
#define EISCONN		WSAEISCONN
#define EINPROGRESS	WSAEINPROGRESS
#define EALREADY	WSAEALREADY
#include "WINSOCK.H"
#elif defined(mac)
#define EACCES		kEACCESErr
#define EPIPE		kEPIPEErr
#define EINTR		kEINTRErr
#define EAGAIN		kEAGAINErr
#define ENOTCONN	kENOTCONNErr
#define ECONNRESET	kECONNRESETErr
#define EISCONN		kEISCONNErr
#define EINPROGRESS	kEINPROGRESSErr
#define EALREADY	kEALREADYErr
#endif

/**********************************************/
#define MSEC_PER_SEC	1000
#define USEC_PER_SEC	1000000
#define USEC_PER_MSEC	1000
#define timer_sub(ntime,subtime,eqtime)         \
	if ((subtime).tv_usec > (ntime).tv_usec) {							\
		(eqtime).tv_sec = ((ntime).tv_sec - 1) - (subtime).tv_sec;		\
		(eqtime).tv_usec = ((int)(((uint)((ntime).tv_usec) + USEC_PER_SEC) -  \
		(uint)((subtime).tv_usec)));            \
	}                                           \
	else {                                      \
		(eqtime).tv_sec = (ntime).tv_sec - (subtime).tv_sec;            \
		(eqtime).tv_usec = (ntime).tv_usec - (subtime).tv_usec;         \
	}


extern char *gConfigFilePath;
extern char *gOptionsString;
extern char gOptionsChar;

typedef struct stats_chunk {
	unsigned long	elapsedSeconds;
	unsigned long	bpsReceived;
	unsigned long	bpsSent;
	unsigned long	ppsReceived;
	unsigned long	ppsSent;
	unsigned long	totalPacketsReceived;
	unsigned long	totalPacketsSent;
	unsigned long	numClients;
	unsigned long	numPorts;
} stats_chunk;


int init_network(void);
int term_network(void);
int init_ui(void);
int service_ui(int sleep_ticks);

void sleep_milliseconds(int ms);
unsigned long microseconds();
#define kPENDING_ADDRESS -2
int name_to_ip_num(char *name, int *ip_num, int async);
int get_remote_address(int skt, int *port);
int get_local_address(int skt, int *port);
int get_local_ip_address(void);
bool isReadable(int fd);
bool isWritable(int fd);

int new_socket_udp(void);
int new_socket_tcp(int is_listener);
void close_socket(int skt);
void set_socket_reuse_address(int skt);
void set_socket_max_buf(int skt);
void make_socket_nonblocking(int skt);
int bind_socket_to_address(int skt, int address, int port, int is_listener);
int listen_to_socket(int skt);
int	call_is_waiting(int skt, int *incoming_skt);
int accept_connection(int from, int *to);
#if DO_ASYNC
pascal void conn_finished_proc(void* contextPtr, OTEventCode code, OTResult /*result*/, void* /*cookie*/);
int connect_to_address(void *context, OTNotifyProcPtr proc, int skt, int address, int port);
#else
int connect_to_address(int skt, int address, int port);
#endif

int tcp_data_ready(int skt);

int recv_udp(int skt, char *buf, int amt, int *fromAddress, int *fromPort);
int send_udp(int skt, char *buf, int amt, int address, int port);
int recv_tcp(int skt, char *buf, int amt);
int send_tcp(int skt, char *buf, int amt);

// int make_udp_port_pair(int *socket1, int *socket2);

int GetLastSocketError(int skt);
void DoStats(stats_chunk *stats);

#if defined(mac) || defined(WIN32)
extern char gLastErrorString[256];
#define ErrorString(a)		sprintf(gLastErrorString, a)
#define ErrorString1(a,b)	sprintf(gLastErrorString, a, b)
#define ErrorStringS(a,b)	sprintf(gLastErrorString, a, b)
#define DebugString(a)		printf(a "\n")
#define DebugString1(a,b)	printf(a "\n", b)
#define DebugStringS(a,b)	printf(a "\n", b)
#else
void ErrorString(char *string);
void ErrorString1(char *string, int d);
void ErrorStringS(char *string, char *arg);
#define DebugString(a)		printf(a "\n")
#define DebugString1(a,b)	printf(a "\n", b)
#define DebugStringS(a,b)	printf(a "\n", b)
#endif
#endif // _PLAT_H_

