#include<stdio.h>
#include<stdlib.h>
#include<X11/Intrinsic.h>
#include<X11/StringDefs.h>
#include<X11/Shell.h>
#include<X11/Xmu/Atoms.h>
#include<X11/Xaw/Command.h>
#include<X11/Xaw/Box.h>
#include<X11/Xaw/Form.h>
#include<X11/Xaw/Label.h>
#include<X11/Xaw/Command.h>
#include<X11/Xaw/AsciiText.h>
#include<X11/Xaw/Scrollbar.h>
#include<X11/Xutil.h>

#define Version_str "XShodo Ver 2.0"
char *xbmfile = "xshodo.xbm";

XtAppContext app;
Widget top[3];
Widget fname;

Display *dpy;
int screen;
Window root,win;
Dimension Ww,Wh;
Pixmap pix;
GC gc,gc2;
Atom wm_protocols[2];
Cursor cursor_brush;
Pixmap icon_pix;
Pixmap icon_pix2;

#include "cclub.xbm"
#include "brush.xbm"
#include "brush_mask.xbm"
#include "suzuri.xbm"

int Px,Py;
int Pw,Pl;

char *brush_name[6] = {
  "TL","AR","DR","SL","SR","RR"
};
int Pd[6];
int brush_max[6] = {
  1000,1000,1000,1000,1000,1000
};
Widget brush_lbl[6],brush_txt[6],brush_bar[6];

#define BRUSH_NUMS (5)
int Pn = 0;
int Pset[BRUSH_NUMS][6];
Widget brush_num;

static void disp_brush_data(int n)
{
  char str[20];
  sprintf(str,"%5.1f",Pd[n]/10.0);
  XtVaSetValues(brush_txt[n],XtNlabel,XtNewString(str),XtNwidth,50,NULL);
  XawScrollbarSetThumb(brush_bar[n],((float)Pd[n])/brush_max[n],0);
}

static void set_brush_data(int n)
{
  char str[20];
  int i;
  for(i=0;i<6;i++) {
    Pset[Pn][i] = Pd[i];
    Pd[i] = Pset[n][i];
    disp_brush_data(i);
  }
  Pn = n;
  sprintf(str,"BRUSH%d",Pn+1);
  XtVaSetValues(brush_num,XtNlabel,XtNewString(str),NULL);
}

static void bar_jump(Widget w,XtPointer dat,XtPointer a) {
  Pd[(long)dat] = *((float *)a)*brush_max[(long)dat];
  disp_brush_data((long)dat);
}

static void bar_scroll(Widget w,XtPointer dat,XtPointer a){
  if((int)a>0){
    Pd[(long)dat] -= 1;
    if(Pd[(long)dat]<0) Pd[(long)dat] = 0;
  }else if((int)a<0){
    Pd[(long)dat] += 1;
    if(Pd[(long)dat]>brush_max[(long)dat]) Pd[(long)dat] = brush_max[(long)dat];
  }
  disp_brush_data((long)dat);
}

void quit(Widget w,XtPointer dat,XtPointer call) {
  exit(0);
}

void Wabout(Widget w,XtPointer dat,XtPointer call) {
  XtPopup(top[2],XtGrabNonexclusive);
}

void Wclear(Widget w,XtPointer dat,XtPointer call) {
  XSetForeground(dpy,gc2,0);
  XFillRectangle(dpy,pix,gc2,0,0,Ww,Wh);
  XSetForeground(dpy,gc2,1);
  XClearWindow(dpy,win);
}

void Wsave(Widget w,XtPointer dat,XtPointer call) {
  String str;
  XtVaGetValues(fname,XtNstring,&str,NULL);
  XWriteBitmapFile(dpy,str,pix,Ww,Wh,-1,-1);
}

void Wload(Widget w,XtPointer dat,XtPointer call) {
  int a,b;
  Pixmap pp;
  unsigned int dw,dh;
  String str;
  XtVaGetValues(fname,XtNstring,&str,NULL);
  if(BitmapSuccess == XReadBitmapFile(dpy,win,str,&dw,&dh,&pp,&a,&b)) {
    Ww = dw;
    Wh = dh;
    XFreePixmap(dpy,pix);
    pix = pp;
    XCopyPlane(dpy,pix,win,gc,0,0,dw,dh,0,0,1);
    XtResizeWidget(top[0],Ww,Wh,(Dimension)0);
  }
}

void WinExpose(Widget w,XEvent *ev,String *p,Cardinal *n) {
  XCopyPlane(dpy,pix,win,gc,ev->xexpose.x,ev->xexpose.y,ev->xexpose.width,ev->xexpose.height,ev->xexpose.x,ev->xexpose.y,1);
}

void WinResize(Widget w,XEvent *ev,String *p,Cardinal *n) {
  Pixmap pp;
  Dimension dw,dh;

  XtVaGetValues(top[0],XtNwidth,&dw,XtNheight,&dh,NULL);
  pp = XCreatePixmap(dpy,win,dw,dh,1);
  XSetForeground(dpy,gc2,0);
  XFillRectangle(dpy,pp,gc2,0,0,dw,dh);
  XSetForeground(dpy,gc2,1);
  XCopyArea(dpy,pix,pp,gc2,0,0,Ww,Wh,0,0);
  XFreePixmap(dpy,pix);
  pix = pp;
  Ww = dw;
  Wh = dh;
}

void brush_sel(Widget w,XtPointer dat,XtPointer call) {
  set_brush_data((int)dat);
}

void B2push(Widget w,XEvent *ev,String *p,Cardinal *n) {
  Px = ev->xbutton.x;
  Py = ev->xbutton.y;
  Pw = Pd[0];
  Pl = 2;
}

void B1push(Widget w,XEvent *ev,String *p,Cardinal *n) {
  Px = ev->xbutton.x;
  Py = ev->xbutton.y;
  Pw = 0;
  Pl = 1;
}

void B1up(Widget w,XEvent *ev,String *p,Cardinal *n) {
  Pl = 0;
}

void B3push(Widget w,XEvent *ev,String *p,Cardinal *n) {
  Pw = 0;
  Pl = 0;
}

void B1move(Widget w,XEvent *ev,String *p,Cardinal *n) {
  int ww;
  if(Pl == 0 && Pw > 0) {
    Pw-=Pd[5];
    if(Pw <= 0) {
      Pw = 0;
    }
  } else if(Pl == 1) {
    Pw+=Pd[1];
    if(Pw >= Pd[0]) {
      Pw = Pd[0];
      Pl = 2;
    }
  } else if(Pl == 2) {
    Pw-=Pd[2];
    if(Pw <= Pd[3]) {
      Pw = (Pd[0]<Pd[3]) ? Pd[0] : Pd[3];
      Pl = 3;
    }
  } else if(Pl == 3) {
    Pw-=Pd[4];
    if(Pw <= 0) {
      Pw = 0;
      Pl = 0;
    }
  }
  ww = Pw/10;
  if(ww > 0) {
    XSetLineAttributes(dpy,gc,ww,LineSolid,CapRound,JoinRound);
    XDrawLine(dpy, win, gc, Px,Py,ev->xbutton.x, ev->xbutton.y);
    XSetLineAttributes(dpy,gc2,ww,LineSolid,CapRound,JoinRound);
    XDrawLine(dpy, pix, gc2, Px,Py,ev->xbutton.x, ev->xbutton.y);
  }
  Px = ev->xbutton.x;
  Py = ev->xbutton.y;
}

void WMEvent(Widget w,XEvent *e,String *p,Cardinal *n)
{
  if(e->xclient.data.l[0] == wm_protocols[0] ||
    e->xclient.data.l[0] == wm_protocols[1] ){
    exit(0);
  }
}

/* MAIN */

static XtActionsRec actions[]={
  {"wmevent", WMEvent},
  {"b1push",B1push},
  {"b1release",B1up},
  {"b2push",B2push},
  {"b3push",B3push},
  {"b1move",B1move},
  {"resize",WinResize},
  {"expose",WinExpose},
};

String trans_win = 
"<Message>WM_PROTOCOLS: wmevent()\n"
"<Btn1Down>: b1push()\n"
"<Btn2Down>: b2push()\n"
"<Btn3Down>: b3push()\n"
"<Btn1Up>: b1release()\n"
"<Btn2Up>: b1release()\n"
"<Motion>: b1move()\n"
"<Expose>: expose()\n"
"<Configure>: resize()";

static void popdown(Widget w,XtPointer dat, XtPointer a)
{
        XtPopdown(dat);
}

Widget init_about_dlg( Widget top ){
  Widget base,form,cmd,up;
  Pixmap icon;
  icon = XCreateBitmapFromData(XtDisplay(top),XtWindow(top),(char*)cclub_bits,cclub_width,cclub_height);
  base = XtVaCreatePopupShell("aboutBase",transientShellWidgetClass,top,XtNtitle,"About XShodo",NULL);
  form = XtVaCreateManagedWidget("about",formWidgetClass,base,NULL);
  up = XtVaCreateManagedWidget("label1",labelWidgetClass,form,XtNleftBitmap,icon,XtNheight,(Dimension)50,XtNlabel,Version_str,XtNborderWidth,0,NULL);
  up = XtVaCreateManagedWidget("label2",labelWidgetClass,form,XtNfromVert,up,XtNborderWidth,0,
    XtNlabel,"Programed by Tsuyoshi Iida\n  (TUT Computer Club)\n    Copyright 1995,1997",
    NULL);
  cmd  = XtVaCreateManagedWidget("ok",commandWidgetClass,form,XtNfromVert,up,NULL);
  XtAddCallback(cmd,XtNcallback,popdown,base);
  return base;
}

Widget init_brush_dlg( Widget top ){
  int i;
  char name[20];
  Widget up,lt,base,form;

  base = XtVaAppCreateShell("xshodo","XShodo",topLevelShellWidgetClass,XtDisplay(top),XtNtranslations,XtParseTranslationTable("#override <Message>WM_PROTOCOLS: wmevent()"),NULL);
  form = XtVaCreateManagedWidget("box1",formWidgetClass,base,NULL);
  up = lt = XtVaCreateManagedWidget("Babout",commandWidgetClass,form,XtNlabel,"about",NULL);
  XtAddCallback(lt,XtNcallback,Wabout,0);
  lt = XtVaCreateManagedWidget("Bsave",commandWidgetClass,form,XtNlabel,"save",XtNfromHoriz,lt,NULL);
  XtAddCallback(lt,XtNcallback,Wsave,0);
  lt = XtVaCreateManagedWidget("Bload",commandWidgetClass,form,XtNlabel,"load",XtNfromHoriz,lt,NULL);
  XtAddCallback(lt,XtNcallback,Wload,0);
  lt = XtVaCreateManagedWidget("Bclear",commandWidgetClass,form,XtNlabel,"clear",XtNfromHoriz,lt,NULL);
  XtAddCallback(lt,XtNcallback,Wclear,0);
  lt = XtVaCreateManagedWidget("Bquit",commandWidgetClass,form,XtNlabel,"quit",XtNfromHoriz,lt,NULL);
  XtAddCallback(lt,XtNcallback,quit,0);

  up = XtVaCreateManagedWidget("file_title",labelWidgetClass,form,XtNfromVert,up,XtNborderWidth,0,XtNlabel,"filename",NULL);
  up = fname = XtVaCreateManagedWidget("fname",asciiTextWidgetClass,form,
    XtNfromVert,up,XtNwidth,200,XtNeditType,XawtextEdit,
    XtNscrollHorizontal,XawtextScrollAlways,
    XtNtranslations,XtParseTranslationTable("#override <Key>Return: end-of-line()"),
    NULL);

  lt = XtVaCreateManagedWidget("brush_title",labelWidgetClass,form,XtNfromVert,up,XtNborderWidth,0,XtNlabel,"brush select",NULL);
  up = brush_num = XtVaCreateManagedWidget("brush_num",labelWidgetClass,form,XtNfromVert,up,XtNfromHoriz,lt,XtNborderWidth,0,NULL);
  sprintf(name,"BRUSH%d",Pn+1);
  XtVaSetValues(brush_num,XtNlabel,XtNewString(name),NULL);

  sprintf(name,"BRUSH%d",1);
  lt = XtVaCreateManagedWidget(name,commandWidgetClass,form,XtNlabel,name,XtNfromVert,up,NULL);
  XtAddCallback(lt,XtNcallback,brush_sel,0);
  for(i=1;i<BRUSH_NUMS;i++) {
    sprintf(name,"BRUSH%d",i+1);
    lt = XtVaCreateManagedWidget(name,commandWidgetClass,form,XtNlabel,name,XtNfromHoriz,lt,XtNfromVert,up,NULL);
    XtAddCallback(lt,XtNcallback,brush_sel,(XtPointer)i);
  }
  up = lt;

  up = XtVaCreateManagedWidget("param_title",labelWidgetClass,form,XtNfromVert,up,XtNborderWidth,0,XtNlabel,"brush parameter",NULL);
  for(i=0;i<6;i++) {
    sprintf(name,"%s%d","L",i);
    brush_lbl[i] = XtVaCreateManagedWidget(name,labelWidgetClass,form,XtNfromVert,up,XtNborderWidth,0,XtNwidth,30,XtNlabel,brush_name[i],NULL);
    sprintf(name,"%s%d","T",i);
    brush_txt[i] = XtVaCreateManagedWidget(name,labelWidgetClass,form,XtNborderWidth,0,XtNfromHoriz,brush_lbl[i],XtNfromVert,up,XtNwidth,50,NULL);
    sprintf(name,"%s%d","B",i);
    brush_bar[i] = XtVaCreateManagedWidget(name,scrollbarWidgetClass,form,XtNfromHoriz,brush_txt[i],XtNfromVert,up,XtNorientation,XtorientHorizontal,XtNwidth,100,NULL);
    XtAddCallback(brush_bar[i],XtNjumpProc,bar_jump,(XtPointer)i);
    XtAddCallback(brush_bar[i],XtNscrollProc,bar_scroll,(XtPointer)i);
    disp_brush_data(i);
    up = brush_lbl[i];
  }
  return base;
}

Cursor set_cursor(char *pat,char *mask,unsigned w, unsigned h, int x, int y)
{
  XColor black,white;
  Pixmap cur_pat,cur_mask;
  Cursor ret;

  black.red = black.green = black.blue = 0;
  white.red = white.green = white.blue = 0xffff;

  cur_pat  = XCreateBitmapFromData(dpy,root,pat,w,h);
  cur_mask = XCreateBitmapFromData(dpy,root,mask,w,h);
  ret = XCreatePixmapCursor(dpy,cur_pat,cur_mask,&black,&white,x,y);

  XFreePixmap(dpy,cur_pat);
  XFreePixmap(dpy,cur_mask);
  return ret;
}


void main(int ac,char **av) {
  Dimension bb,dd;
  unsigned int dw,dh;
  int i;

  i = 0;
  Pset[i][0] = 400;
  Pset[i][1] = 40;
  Pset[i][2] = 10;
  Pset[i][3] = 400;
  Pset[i][4] = 10;
  Pset[i][5] = 400;

  if(BRUSH_NUMS > 0) {
    i++;
    Pset[i][0] = 800;
    Pset[i][1] = 80;
    Pset[i][2] = 20;
    Pset[i][3] = 800;
    Pset[i][4] = 20;
    Pset[i][5] = 800;
  }
  if(BRUSH_NUMS > 1) {
    i++;
    Pset[i][0] = 100;
    Pset[i][1] = 10;
    Pset[i][2] = 3;
    Pset[i][3] = 100;
    Pset[i][4] = 3;
    Pset[i][5] = 100;
  }
  if(BRUSH_NUMS >2) {
    i++;
    Pset[i][0] = 400;
    Pset[i][1] = 10;
    Pset[i][2] = 0;
    Pset[i][3] = 400;
    Pset[i][4] = 0;
    Pset[i][5] = 40;
  }
  if(BRUSH_NUMS > 3)
    for(i++;i<BRUSH_NUMS;i++) {
      Pset[i][0] = 400;
      Pset[i][1] = 40;
      Pset[i][2] = 10;
      Pset[i][3] = 300;
      Pset[i][4] = 0;
      Pset[i][5] = 40;
    }
  Pn = 0;
  for(i = 0;i<6;i++)
    Pd[i] = Pset[Pn][i];

  top[0] = XtVaAppInitialize(&app,"XShodo",NULL,0,&ac,av,NULL,XtNgeometry,"640x480",XtNtitle,"xshodo",NULL);

  dpy = XtDisplay(top[0]);
  screen = XScreenNumberOfScreen(XtScreen(top[0]));
  root = RootWindow(dpy,screen);

  XtAppAddActions(app, actions, XtNumber(actions));
  XtOverrideTranslations(top[0],XtParseTranslationTable(trans_win));

  XtSetMappedWhenManaged(top[0],False);
  XtRealizeWidget(top[0]);

  win = XtWindow(top[0]);
  XtVaGetValues(top[0],XtNwidth,&Ww,XtNheight,&Wh,NULL);
  pix = XCreatePixmap(dpy,win,(int)Ww,(int)Wh,1);
  XtVaSetValues(top[0],XtNforeground,BlackPixel(dpy,screen),NULL);
  XtVaSetValues(top[0],XtNbackground,WhitePixel(dpy,screen),NULL);
  gc = XCreateGC(dpy,win,0,NULL);
  gc2 = XCreateGC(dpy,pix,0,NULL);
  XSetForeground(dpy,gc2,0);
  XFillRectangle(dpy,pix,gc2,0,0,Ww,Wh);
  XSetForeground(dpy,gc2,1);
  XSetForeground(dpy,gc,BlackPixel(dpy,screen));
  XSetBackground(dpy,gc,WhitePixel(dpy,screen));
  cursor_brush = set_cursor((char*)brush_bits,(char*)brush_mask_bits,brush_width,brush_height,brush_x_hot,brush_y_hot);
  XDefineCursor(dpy,XtWindow(top[0]),cursor_brush);
  XtVaSetValues(top[0],XtNcursor,cursor_brush,NULL);
  icon_pix  = XCreateBitmapFromData(dpy,root,(char*)brush_bits,brush_width,brush_height);
  XtVaSetValues(top[0],XtNiconPixmap,icon_pix,NULL);

  top[1] = init_brush_dlg(top[0]);
  top[2] = init_about_dlg(top[0]);

  XtSetMappedWhenManaged(top[1],True);
  XtRealizeWidget(top[1]);

  icon_pix2  = XCreateBitmapFromData(dpy,root,(char*)suzuri_bits,suzuri_width,suzuri_height);
  XtVaSetValues(top[1],XtNiconPixmap,icon_pix2,NULL);

  wm_protocols[0] = XInternAtom(dpy,"WM_DELETE_WINDOW",False);
  wm_protocols[1] = XInternAtom(dpy,"WM_SAVEYOURSELF",False);
  XSetWMProtocols(dpy,XtWindow(top[0]),wm_protocols,2);
  XSetWMProtocols(dpy,XtWindow(top[1]),wm_protocols,2);


  if(ac > 1) {
    int a,b;
    Pixmap pp;
    xbmfile = av[1];
    if(BitmapSuccess == XReadBitmapFile(dpy,win,xbmfile,&dw,&dh,&pp,&a,&b)) {
      Ww = dw;
      Wh = dh;
      XFreePixmap(dpy,pix);
      pix = pp;
      XCopyPlane(dpy,pix,win,gc,0,0,dw,dh,0,0,1);
      XtResizeWidget(top[0],Ww,Wh,(Dimension)0);
    }
  }
  XtVaGetValues(top[1],XtNwidth,&dd,XtNheight,&bb,NULL);
  XtVaSetValues(top[1],XtNminWidth,dd,XtNmaxWidth,dd,XtNminHeight,bb,XtNmaxHeight,bb,NULL);
  XtVaSetValues(fname,XtNstring,XtNewString(xbmfile),NULL);

  XtMapWidget(top[0]);
  XtAppMainLoop(app);
}
