# SPIM S20 MIPS simulator.
# A torture test for the SPIM simulator.
# Version for big-endian systems.
# Copyright (C) 1990-1994 James Larus, larus@cs.wisc.edu.
# ALL RIGHTS RESERVED.
#
# SPIM is distributed under the following conditions:
#
# You may make copies of SPIM for your own use and modify those copies.
#
# All copies of SPIM must retain my name and copyright notice.
#
# You may not sell SPIM or distributed SPIM in conjunction with a commerical
# product or service without the expressed written consent of James Larus.
#
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE.
#

# $Header: /u/l/a/larus/Software/SPIM/src/Tests/RCS/tt.be.s,v 1.40 1999/01/12 05:52:28 larus Exp $

	.data
saved_ret_pc:	.word 0		# Holds PC to return from main
m3:	.asciiz "The next few lines should contain exception error messages\n"
m4:	.asciiz "Done with exceptions\n\n"
	.text
	.globl main
main:
	sw $31 saved_ret_pc

#
# The first thing to do is to test the exceptions:
#
	li $v0 4	# syscall 4 (print_str)
	la $a0 m3
	syscall

# Exception 1 (INT) -- Not implemented yet
# Exception 4 (ADEL)
	li $t0 0x400000
	lw $3 1($t0)
# Exception 5 (ADES)
	sw $3 1($t0)
# Exception 6 (IBUS) -- Can't test and continue
# Exception 7 (DBUS)
	lw $3 10000000($t0)
# Exception 8 (SYSCALL) -- Not implemented
# Exception 9 (BKPT)
	break 0
# Exception 10 (RI) -- Not implemented (can't enter bad instructions)
# Exception 12 (overflow)
	lui $t0 0x7fffffff
	add $t0 $t0 $t0
	li $v0 4	# syscall 4 (print_str)
	la $a0 m4
	syscall

#
# Try modifying R0
#
	add $0, $0, 1
	bnez $0 fail

#
# Now, test each instruction
#

	.data
add_:	.asciiz "Testing ADD\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 add_
	syscall

	li $2 1
	li $3 -1

	add $4, $0, $0
	bnez $4 fail
	add $4, $0, $2
	bne $4 1 fail
	add $4, $4, $3
	bnez $4 fail


	.data
addi_:	.asciiz "Testing ADDI\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 addi_
	syscall

	addi $4, $0, 0
	bnez $4 fail
	addi $4, $0, 1
	bne $4 1 fail
	addi $4, $4, -1
	bnez $4 fail


	.data
addiu_:	.asciiz "Testing ADDIU\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 addiu_
	syscall

	addiu $4, $0, 0
	bnez $4 fail
	addiu $4, $0, 1
	bne $4 1 fail
	addiu $4, $4, -1
	bnez $4 fail

	lui $2 0x7fffffff
	addiu $2 $2 0x7fffffff	# should not trap
	bne $2 -2 fail


	.data
addu_:	.asciiz "Testing ADDU\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 addu_
	syscall

	li $2 1
	li $3 -1

	addu $4, $0, $0
	bnez $4 fail
	addu $4, $0, $2
	bne $4 1 fail
	addu $4, $4, $3
	bnez $4 fail

	lui $2 0x7fffffff
	addu $2 $2 $2		# should not trap
	bne $2 -2 fail


	.data
and_:	.asciiz "Testing AND\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 and_
	syscall

	li $2 1
	li $3 -1

	and $4 $0 $0
	bnez $4 fail
	and $4 $2 $2
	beqz $4 fail
	and $4 $2 $3
	bne $4 1 fail


	.data
andi_:	.asciiz "Testing ANDI\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 andi_
	syscall

	li $2 1
	li $3 -1

	andi $4 $0 0
	bnez $4 fail
	and $4 $2 1
	beqz $4 fail
	and $4 $2 -1
	bne $4 1 fail
	and $4 $3 -1
	bne $4 $3 fail


	.data
beq_:	.asciiz "Testing BEQ\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 beq_
	syscall

	li $2 -1
	li $3 1

	beq $0 $0 l1
	j fail
l1:	beq $2 $2 l2
	j fail
l2:	beq $3 $2 fail

	beq $2 $2 far_away	# Check long branch
	j fail
come_back:

	li $2 3
l2_1:	sub $2 $2 1
	bnez $2, l2_1


	.data
bgez_:	.asciiz "Testing BGEZ\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 bgez_
	syscall

	li $2 -1
	li $3 1

	bgez $0 l3
	j fail
l3:	bgez $3 l4
	j fail
l4:	bgez $2 fail


	.data
bgezal_:.asciiz "Testing BGEZAL\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 bgezal_
	syscall

	li $2 -1
	li $3 1

	bgezal $0 l5
	j fail
	bgezal $2 fail
l5:	bgezal $3 l6
l55:	j fail
l6:	la $4 l55
	bne $31 $4 fail


	.data
bgtz_:	.asciiz "Testing BGTZ\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 bgtz_
	syscall

	li $2 -1
	li $3 1

	bgtz $0 fail
l7:	bgtz $3 l8
	j fail
l8:	bgtz $2 fail


	.data
blez_:	.asciiz "Testing BLEZ\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 blez_
	syscall

	li $2 -1
	li $3 1

	blez $0 l9
	j fail
l9:	blez $2 l10
	j fail
l10:	blez $3 fail


	.data
bltz_:	.asciiz "Testing BLTZ\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 bltz_
	syscall

	li $2 -1
	li $3 1

	bltz $0 fail
l11:	bltz $2 l12
	j fail
l12:	bltz $3 fail


	.data
bltzal_:.asciiz "Testing BLTZAL\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 bltzal_
	syscall

	li $2 -1
	li $3 1

	bltzal $0 fail
	bltzal $3 fail
l13:	bltzal $2 l15
l14:	j fail
l15:	la $4 l14
	bne $31 $4 fail


	.data
bne_:	.asciiz "Testing BNE\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 bne_
	syscall

	li $2 -1
	li $3 1

	bne $0 $0 fail
	bne $2 $2 fail
	bne $3 $2 l16
l16:


	.data
break_:	.asciiz "Testing BREAK\nExpect a exception message:\n  "
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 break_
	syscall

	break 3


# COPz is not implemented or checked


	.data
ccp_:	.asciiz "Testing move to/from coprocessor control z\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 ccp_
	syscall

	li $2 0x7f7f
	ctc0 $2 $3
	cfc0 $4 $3
	bne $2 $4 fail
	li $2 0x7f7f
	ctc1 $2 $3
	cfc1 $4 $3
	bne $2 $4 fail
	li $2 0x7f7f
	ctc2 $2 $3
	cfc2 $4 $3
	bne $2 $4 fail
	li $2 0x7f7f
	ctc3 $2 $3
	cfc3 $4 $3
	bne $2 $4 fail


	.data
div_:	.asciiz "Testing DIV\n"
div2_:	.asciiz "Expect exception caused by divide by 0:\n  "
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 div_
	syscall

	li $2 4
	li $3 2
	li $4 -2

	div $5 $2 $3
	bne $5 2 fail
	mfhi $5
	bne $5 0 fail

	div $5 $2 $4
	bne $5 -2 fail
	mfhi $5
	bne $5 0 fail

	li $v0 4	# syscall 4 (print_str)
	la $a0 div2_
	syscall
	div $5 $2 $0


	.data
divu_:	.asciiz "Testing DIVU\n"
divu2_:	.asciiz "Expect exception caused by divide by 0:\n  "
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 divu_
	syscall

	li $2 4
	li $3 2
	li $4 -2

	divu $5 $2 $3
	bne $5 2 fail
	mfhi $5
	bne $5 0 fail

	divu $0 $2 $3
	mflo $5
	bne $5 2 fail
	mfhi $5
	bne $5 0 fail

	divu $5 $2 $4
	bne $5 0 fail
	mfhi $5
	bne $5 4 fail

	li $v0 4	# syscall 4 (print_str)
	la $a0 divu2_
	syscall
	divu $5 $2 $0


	.data
j_:	.asciiz "Testing J\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 j_
	syscall

	j l17
	j fail
l17:


	.data
jal_:	.asciiz "Testing JAL\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 jal_
	syscall

	jal l18
l19:	j l20
l18:	la $4 l19
	bne $31 $4 fail
	jr $31
l20:


	.data
jalr_:	.asciiz "Testing JALR\n"
jalr2_:	.asciiz "Expect an non-word boundary exception:\n  "
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 jalr_
	syscall

	la $2 l21
	jalr $3, $2
l23:	j l22
l21:	la $4 l23
	bne $3 $4 fail
	jr $3
l22:	li $v0 4	# syscall 4 (print_str)
	la $a0 jalr2_
	syscall
	la $2 l24
	add $2 $2 2
l24:	jalr $3 $2


	.data
jr_:	.asciiz "Testing JR\n"
jr2_:	.asciiz "Expect an non-word boundary exception:\n  "
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 jr_
	syscall

	la $2 l25
	jr $2
	j fail
l25:	li $v0 4	# syscall 4 (print_str)
	la $a0 jr2_
	syscall
	la $2 l27
	add $2 $2 2
l27:	jr $2


	.data
la_:	.asciiz "Testing LA\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 la_
	syscall

	# Simple cases already tested
	li $4 101
	la $5 10($4)
	bne $5 111 fail


	.data
lb_:	.asciiz "Testing LB\n"
lb2_:	.asciiz "Expect an address error exceptions:\n	"
lbd_:	.byte 1, -1, 0, 128
lbd1_:	.word 0x76543210, 0xfedcba98
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 lb_
	syscall

	la $2 lbd_
	lb $3 0($2)
	bne $3 1 fail
	lb $3 1($2)
	bne $3 -1 fail
	lb $3 2($2)
	bne $3 0 fail
	lb $3 3($2)
	bne $3 0xffffff80 fail

	la $t0 lbd1_
	lb $t1 0($t0)
	bne $t1 0x76 fail
	lb $t1 1($t0)
	bne $t1 0x54 fail
	lb $t1 2($t0)
	bne $t1 0x32 fail
	lb $t1 3($t0)
	bne $t1 0x10 fail
	lb $t1 4($t0)
	bne $t1 0xfffffffe fail
	lb $t1 5($t0)
	bne $t1 0xffffffdc fail
	lb $t1 6($t0)
	bne $t1 0xffffffba fail
	lb $t1 7($t0)
	bne $t1 0xffffff98 fail

	li $v0 4	# syscall 4 (print_str)
	la $a0 lb2_
	syscall

	li $t5 0x7fffffff
	lb $3 1000($t5)

	.data
lbu_:	.asciiz "Testing LBU\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 lbu_
	syscall

	la $2 lbd_
	lbu $3 0($2)
	bne $3 1 fail
	lbu $3 1($2)
	bne $3 0xff fail
	lbu $3 2($2)
	bne $3 0 fail
	lbu $3 3($2)
	bne $3 128 fail

	la $t0 lbd1_
	lbu $t1 0($t0)
	bne $t1 0x76 fail
	lbu $t1 1($t0)
	bne $t1 0x54 fail
	lbu $t1 2($t0)
	bne $t1 0x32 fail
	lbu $t1 3($t0)
	bne $t1 0x10 fail
	lbu $t1 4($t0)
	bne $t1 0xfe fail
	lbu $t1 5($t0)
	bne $t1 0xdc fail
	lbu $t1 6($t0)
	bne $t1 0xba fail
	lbu $t1 7($t0)
	bne $t1 0x98 fail

	li $v0 4	# syscall 4 (print_str)
	la $a0 lb2_
	syscall

	li $t5 0x7fffffff
	lbu $3 1000($t5)


	.data
ld_:	.asciiz "Testing LD\n"
ld2_:	.asciiz "Expect four address error exceptions:\n"
ldd_:	.word 1, -1, 0, 0x8000000
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 ld_
	syscall

	la $2 ldd_
	ld $3 0($2)
	bne $3 1 fail
	bne $4 -1 fail
	ld $3 8($2)
	bne $3 0 fail
	bne $4 0x8000000 fail

	li $v0 4	# syscall 4 (print_str)
	la $a0 ld2_
	syscall

	li $t5 0x7fffffff
	ld $3 1000($t5)
	ld $3 1001($t5)


	.data
lh_:	.asciiz "Testing LH\n"
lh2_:	.asciiz "Expect two address error exceptions:\n"
lhd_:	.half 1, -1, 0, 0x8000
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 lh_
	syscall

	la $2 lhd_
	lh $3 0($2)
	bne $3 1 fail
	lh $3 2($2)
	bne $3 -1 fail
	lh $3 4($2)
	bne $3 0 fail
	lh $3 6($2)
	bne $3 0xffff8000 fail

	li $v0 4	# syscall 4 (print_str)
	la $a0 lh2_
	syscall

	li $t5 0x7fffffff
	lh $3 1000($t5)
	lh $3 1001($t5)

	.data
lhu_:	.asciiz "Testing LHU\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 lhu_
	syscall

	la $2 lhd_
	lhu $3 0($2)
	bne $3 1 fail
	lhu $3 2($2)
	bne $3 0xffff fail
	lhu $3 4($2)
	bne $3 0 fail
	lhu $3 6($2)
	bne $3 0x8000 fail

	li $v0 4	# syscall 4 (print_str)
	la $a0 lh2_
	syscall

	li $t5 0x7fffffff
	lhu $3 1000($t5)
	lhu $3 1001($t5)


	.data
lui_:	.asciiz "Testing LUI\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 lui_
	syscall

	lui $2 0
	bne $2 $0 fail
	lui $2 1
	srl $2 $2 16
	addiu $2 $2 -1	# Don't do compare directly since it uses LUI
	bne $2 $0 fail
	lui $2 1
	andi $2 $2 0xffff
	bne $2 $0 fail
	lui $2 -1
	srl $2 $2 16
	addiu $2 $2 1
	andi $2 $2 0xffff
	bne $2 $0 fail


	.data
lw_:	.asciiz "Testing LW\n"
lwd_:	.word 1, -1, 0, 0x8000000
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 lw_
	syscall

	la $2 lwd_
	lw $3 0($2)
	bne $3 1 fail
	lw $3 4($2)
	bne $3 -1 fail
	lw $3 8($2)
	bne $3 0 fail
	lw $3 12($2)
	bne $3 0x8000000 fail

	add $2 $2 12
	lw $3 -12($2)
	bne $3 1 fail
	lw $3 -8($2)
	bne $3 -1 fail
	lw $3 -4($2)
	bne $3 0 fail
	lw $3 0($2)
	bne $3 0x8000000 fail

	li $v0 4	# syscall 4 (print_str)
	la $a0 lh2_
	syscall

	li $t5 0x7fffffff
	lw $3 1000($t5)
	lw $3 1001($t5)


	.data
lwl_:	.asciiz "Testing LWL\n"
	.align 2
lwld_:	.byte 0 1 2 3 4 5 6 7
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 lwl_
	syscall

	la $2 lwld_
	move $3 $0
	lwl $3 0($2)
	bne $3 0x10203 fail
	move $3 $0
	lwl $3 1($2)
	bne $3 0x1020300 fail
	li $3 5
	lwl $3 1($2)
	bne $3 0x1020305 fail
	move $3 $0
	lwl $3 2($2)
	bne $3 0x2030000 fail
	li $3 5
	lwl $3 2($2)
	bne $3 0x2030005 fail
	move $3 $0
	lwl $3 3($2)
	bne $3 0x3000000 fail
	li $3 5
	lwl $3 3($2)
	bne $3 0x3000005 fail

	li $v0 4	# syscall 4 (print_str)
	la $a0 lh2_
	syscall

	li $t5 0x7fffffff
	lwl $3 1000($t5)
	lwl $3 1001($t5)


	.data
lwr_:	.asciiz "Testing LWR\n"
	.align 2
lwrd_:	.byte 0 1 2 3 4 5 6 7
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 lwr_
	syscall

	la $2 lwrd_
	li $3 0x0505
	lwr $3 0($2)
	bne $3 0x0500 fail
	move $3 $0
	lwr $3 1($2)
	bne $3 0x01 fail
	li $3 0x505
	lwr $3 1($2)
	bne $3 0x01 fail
	move $3 $0
	lwr $3 2($2)
	bne $3 0x0102 fail
	li $3 0x050505
	lwr $3 2($2)
	bne $3 0x0102 fail
	move $3 $0
	lwr $3 3($2)
	bne $3 0x010203 fail
	li $3 0x05050505
	lwr $3 3($2)
	bne $3 0x010203 fail

	li $v0 4	# syscall 4 (print_str)
	la $a0 lh2_
	syscall

	li $t5 0x7fffffff
	lwr $3 1000($t5)
	lwr $3 1001($t5)

	.data
mcp_:	.asciiz "Testing move to/from coprocessor z\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 mcp_
	syscall

	li $2 0x7f7f
	mtc0 $2 $3
	mfc0 $4 $3
	bne $2 $4 fail
	li $2 0x7f7f
	mtc1 $2 $3
	mfc1 $4 $f3
	bne $2 $4 fail
	li $2 0x7f7f
	li $3 0xf7f7
	mtc1.d $2 $4
	mfc1.d $6 $4
	bne $2 $6 fail
	bne $3 $7 fail
	li $2 0x7f7f
	mtc2 $2 $3
	mfc2 $4 $3
	bne $2 $4 fail
	li $2 0x7f7f
	mtc3 $2 $3
	mfc3 $4 $3
	bne $2 $4 fail


	.data
hilo_:	.asciiz "Testing move to/from HI/LO\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 hilo_
	syscall

	mthi $0
	mfhi $2
	bnez $2 fail
	mtlo $0
	mflo $2
	bnez $2 fail
	li $2 1
	mthi $2
	mfhi $3
	bne $3 $2 fail
	li $2 1
	mtlo $2
	mflo $3
	bne $3 $2 fail
	li $2 -1
	mthi $2
	mfhi $3
	bne $3 $2 fail
	li $2 -1
	mtlo $2
	mflo $3
	bne $3 $2 fail


	.data
mul_:	.asciiz "Testing MUL\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 mul_
	syscall

	li $2, 1
	mul $3, $2, 0
	bnez $3 fail
	mul $3, $2, 1
	bne $3 1 fail
	mul $3, $2, 10
	bne $3 10 fail

	mul $2 $0 $0
	bnez $2 fail
	mfhi $3
	bnez $3 fail
	mflo $3
	bnez $3 fail

	li $4, 1
	mul $2 $4 $4
	bne $2 1 fail
	mfhi $3
	bnez $3 fail
	mflo $3
	bne $3 1 fail

	li $4, -1
	mul $2 $4 $4
	bne $2 1 fail
	mfhi $3
	bnez $3 fail
	mflo $3
	bne $3 1 fail

	li $4, -1
	li $5, 1
	mul $2 $4 $5
	bne $2 -1 fail
	mfhi $3
	bne $3 -1 fail
	mflo $3
	bne $3 -1 fail

	li $4, 0x10000
	mul $2 $4 $4
	bne $2 0 fail
	mfhi $3
	bne $3 1 fail
	mflo $3
	bne $3 0 fail

	li $4, 0x80000000
	mul $2 $4 $4
	bne $2 0 fail
	mfhi $3
	bne $3 0x40000000 fail
	mflo $3
	bne $3 0 fail


	.data
multu_:	.asciiz "Testing MULTU\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 multu_
	syscall

	multu $0 $0
	mfhi $3
	bnez $3 fail
	mflo $3
	bnez $3 fail

	li $4, 1
	multu $4 $4
	mfhi $3
	bnez $3 fail
	mflo $3
	bne $3 1 fail

	li $4, -1
	multu $4 $4
	mfhi $3
	bne $3 0xfffffffe fail
	mflo $3
	bne $3 1 fail

	li $4, -1
	li $5, 0
	multu $4 $5
	mfhi $3
	bne $3 0 fail
	mflo $3
	bne $3 0 fail

	li $4, -1
	li $5, 1
	multu $4 $5
	mfhi $3
	bne $3 0 fail
	mflo $3
	bne $3 -1 fail

	li $4, 0x10000
	multu $4 $4
	mfhi $3
	bne $3 1 fail
	mflo $3
	bne $3 0 fail

	li $4, 0x80000000
	multu $4 $4
	mfhi $3
	bne $3 0x40000000 fail
	mflo $3
	bne $3 0 fail

	li $3, 0xcecb8f27
	li $4, 0xfd87b5f2
	multu $3 $4
	mfhi $3
	bne $3 0xcccccccb fail
	mflo $3
	bne $3 0x7134e5de fail


	.data
mulo_:	.asciiz "Testing MULO\n"
mulo1_:	.asciiz "Expect an exception:\n	 "
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 mulo_
	syscall

	mulo $2 $0 $0
	bne $2 0 fail

	li $4, 1
	mulo $2 $4 $4
	bne $2 1 fail

	li $4, -1
	mulo $2 $4 $4
	bne $2 1 fail

	li $4, -1
	li $5, 1
	mulo $2 $4 $5
	bne $2 -1 fail

	li $v0 4	# syscall 4 (print_str)
	la $a0 mulo1_
	syscall

	li $4, 0x10000
	mulo $2 $4 $4
	bne $2 0 fail


	.data
nor_:	.asciiz "Testing NOR\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 nor_
	syscall

	li $2 1
	li $3 -1

	nor $4 $0 $0
	bne $4 -1 fail
	nor $4 $2 $2
	bne $4 0xfffffffe fail
	nor $4 $2 $3
	bne $4 0 fail


	.data
or_:	.asciiz "Testing OR\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 or_
	syscall

	li $2 1
	li $3 -1

	or $4 $0 $0
	bne $4 0 fail
	or $4 $2 $2
	bne $4 1 fail
	or $4 $2 $3
	bne $4 -1 fail


	.data
ori_:	.asciiz "Testing ORI\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 ori_
	syscall

	li $2 1
	li $3 -1

	ori $4 $0 0
	bne $4 0 fail
	ori $4 $2 1
	bne $4 1 fail
	ori $4 $2 -1
	bne $4 0xffffffff fail


# RFE tested previously


	.data
sb_:	.asciiz "Testing SB\n"
sb2_:	.asciiz "Expect an address error exceptions:\n	"
	.align 2
sbd_:	.byte 0, 0, 0, 0
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 sb_
	syscall

	li $3, 1
	la $2 sbd_
	sb $3 0($2)
	lw $4 0($2)
	bne $4 0x1000000 fail
	li $3 2
	sb $3 1($2)
	lw $4 0($2)
	bne $4 0x1020000 fail
	li $3 3
	sb $3 2($2)
	lw $4 0($2)
	bne $4 0x1020300 fail
	li $3 4
	sb $3 3($2)
	lw $4 0($2)
	bne $4 0x1020304 fail


	li $v0 4	# syscall 4 (print_str)
	la $a0 sb2_
	syscall

	li $t5 0x7fffffff
	sb $3 1000($t5)


	.data
sd_:	.asciiz "Testing SD\n"
sd2_:	.asciiz "Expect two address error exceptions:\n"
	.align 2
sdd_:	.word 0, 0, 0, 0
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 sd_
	syscall

	li $3, 0x7f7f7f7f
	li $4, 0xf7f7f7f7
	la $2 sdd_
	sd $3 0($2)
	ld $5 0($2)
	bne $3 $5 fail
	bne $4 $4 fail

	li $v0 4	# syscall 4 (print_str)
	la $a0 sd2_
	syscall

	li $t5 0x7fffffff
	sd $3 1000($t5)
	sd $3 1001($t5)


	.data
sh_:	.asciiz "Testing SH\n"
sh2_:	.asciiz "Expect two address error exceptions:\n"
	.align 2
shd_:	.byte 0, 0, 0, 0
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 sh_
	syscall

	li $3, 1
	la $2 shd_
	sh $3 0($2)
	lw $4 0($2)
	bne $4 0x10000 fail
	li $3 2
	sh $3 2($2)
	lw $4 0($2)
	bne $4 0x10002 fail

	li $v0 4	# syscall 4 (print_str)
	la $a0 sh2_
	syscall

	li $t5 0x7fffffff
	sh $3 1000($t5)
	sh $3 1001($t5)


	.data
sll_:	.asciiz "Testing SLL\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 sll_
	syscall

	li $2 1

	sll $3 $2 0
	bne $3 1 fail
	sll $3 $2 1
	bne $3 2 fail
	sll $3 $2 16
	bne $3 0x10000 fail
	sll $3 $2 32
	bne $3 1 fail


	.data
sllv_:	.asciiz "Testing SLLV\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 sllv_
	syscall

	li $2 1
	li $4 0
	sllv $3 $2 $4
	bne $3 1 fail
	li $4 1
	sllv $3 $2 $4
	bne $3 2 fail
	li $4 16
	sllv $3 $2 $4
	bne $3 0x10000 fail
	li $4 32
	sllv $3 $2 $4
	bne $3 1 fail


	.data
slt_:	.asciiz "Testing SLT\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 slt_
	syscall

	slt $3 $0 $0
	bne $3 0 fail
	li $2 1
	slt $3 $2 $0
	bne $3 0 fail
	slt $3 $0 $2
	bne $3 1 fail
	li $2 -1
	slt $3 $2 $0
	bne $3 1 fail
	slt $3 $0 $2
	bne $3 0 fail
	li $2 -1
	li $4 1
	slt $3 $2 $4
	bne $3 1 fail


	.data
slti_:	.asciiz "Testing SLTI\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 slti_
	syscall

	slti $3 $0 0
	bne $3 0 fail
	li $2 1
	slti $3 $2 0
	bne $3 0 fail
	slti $3 $0 1
	bne $3 1 fail
	li $2 -1
	slti $3 $2 0
	bne $3 1 fail
	slti $3 $0 -1
	bne $3 0 fail
	li $2 -1
	li $4 1
	slti $3 $2 1
	bne $3 1 fail
	slti $3 $4 -1
	bne $3 0 fail


	.data
sltiu_:	.asciiz "Testing SLTIU\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 sltiu_
	syscall

	sltiu $3 $0 0
	bne $3 0 fail
	li $2 1
	sltiu $3 $2 0
	bne $3 0 fail
	sltiu $3 $0 1
	bne $3 1 fail
	li $2 -1
	sltiu $3 $2 0
	bne $3 0 fail
	sltiu $3 $0 -1
	bne $3 1 fail
	li $2 -1
	li $4 1
	sltiu $3 $2 1
	bne $3 0 fail
	sltiu $3 $4 -1
	bne $3 1 fail


	.data
sltu_:	.asciiz "Testing SLTU\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 sltu_
	syscall

	sltu $3 $0 $0
	bne $3 0 fail
	li $2 1
	sltu $3 $2 $0
	bne $3 0 fail
	sltu $3 $0 $2
	bne $3 1 fail
	li $2 -1
	sltu $3 $2 $0
	bne $3 0 fail
	sltu $3 $0 $2
	bne $3 1 fail
	li $2 -1
	li $4 1
	sltu $3 $2 $4
	bne $3 0 fail


	.data
sra_:	.asciiz "Testing SRA\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 sra_
	syscall

	li $2 1
	sra $3 $2 0
	bne $3 1 fail
	sra $3 $2 1
	bne $3 0 fail
	li $2 0x1000
	sra $3 $2 4
	bne $3 0x100 fail
	li $2 0x80000000
	sra $3 $2 4
	bne $3 0xf8000000 fail


	.data
srav_:	.asciiz "Testing SRAV\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 srav_
	syscall

	li $2 1
	li $4 0
	srav $3 $2 $4
	bne $3 1 fail
	li $4 1
	srav $3 $2 $4
	bne $3 0 fail
	li $2 0x1000
	li $4 4
	srav $3 $2 $4
	bne $3 0x100 fail
	li $2 0x80000000
	li $4 4
	srav $3 $2 $4
	bne $3 0xf8000000 fail


	.data
srl_:	.asciiz "Testing SRL\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 srl_
	syscall

	li $2 1
	srl $3 $2 0
	bne $3 1 fail
	srl $3 $2 1
	bne $3 0 fail
	li $2 0x1000
	srl $3 $2 4
	bne $3 0x100 fail
	li $2 0x80000000
	srl $3 $2 4
	bne $3 0x08000000 fail


	.data
srlv_:	.asciiz "Testing SRLV\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 srlv_
	syscall

	li $2 1
	li $4 0
	srlv $3 $2 $4
	bne $3 1 fail
	li $4 1
	srlv $3 $2 $4
	bne $3 0 fail
	li $2 0x1000
	li $4 4
	srlv $3 $2 $4
	bne $3 0x100 fail
	li $2 0x80000000
	li $4 4
	srlv $3 $2 $4
	bne $3 0x08000000 fail


	.data
sub_:	.asciiz "Testing SUB\n"
sub1_:	.asciiz "Expect an overflow exceptions:\n  "
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 sub_
	syscall

	li $2 1
	li $3 -1

	sub $4, $0, $0
	bnez $4 fail
	sub $4, $0, $2
	bne $4 -1 fail
	sub $4, $2, $0
	bne $4, 1 fail
	sub $4, $2, $3
	bne $4, 2 fail
	sub $4, $3, $2
	bne $4, -2 fail

	li $v0 4	# syscall 4 (print_str)
	la $a0 sub1_
	syscall
	li $2 0x80000000
	li $3 1
	sub $4, $3, $2


	.data
subu_:	.asciiz "Testing SUBU\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 subu_
	syscall

	li $2 1
	li $3 -1

	subu $4, $0, $0
	bnez $4 fail
	subu $4, $0, $2
	bne $4 -1 fail
	subu $4, $2, $0
	bne $4, 1 fail
	subu $4, $2, $3
	bne $4, 2 fail
	subu $4, $3, $2
	bne $4, -2 fail

	li $2 0x80000000
	li $3 1
	subu $4, $3, $2


	.data
sw_:	.asciiz "Testing SW\n"
sw2_:	.asciiz "Expect two address error exceptions:\n"
	.align 2
swd_:	.byte 0, 0, 0, 0
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 sw_
	syscall

	li $3, 0x7f7f7f7f
	la $2 swd_
	sw $3 0($2)
	lw $4 0($2)
	bne $4 0x7f7f7f7f fail

	li $v0 4	# syscall 4 (print_str)
	la $a0 sw2_
	syscall

	li $t5 0x7fffffff
	sw $3 1000($t5)
	sw $3 1001($t5)

	lw $t0 far_away
	sw $0 far_away
	lw $t1 far_away
	bne $t1 $0 fail
	b far_away
come_back2:
	sw $0 far_away

	.data
lswc_:	.asciiz "Testing load/store word coprocessor z\n"
	.align 2
lswcd_:	.byte 0, 0, 0, 0
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 lswc_
	syscall

	li $3, 0x7f7f7f7f
	la $2 lswcd_
	mtc0 $3, $0
	swc0 $0 0($2)
	lw $4 0($2)
	bne $4 $3 fail
	lwc0 $1 0($2)
	mfc0 $5, $1
	bne $5 $3 fail

	li $3, 0x7f7f7f7f
	la $2 lswcd_
	mtc1 $3, $0
	swc1 $f0 0($2)
	lw $4 0($2)
	bne $4 $3 fail
	lwc1 $f1 0($2)
	mfc1 $5, $f1
	bne $5 $3 fail

	li $3, 0x7f7f7f7f
	la $2 lswcd_
	mtc2 $3, $0
	swc2 $0 0($2)
	lw $4 0($2)
	bne $4 $3 fail
	lwc2 $1 0($2)
	mfc2 $5, $1
	bne $5 $3 fail

	li $3, 0x7f7f7f7f
	la $2 lswcd_
	mtc3 $3, $0
	swc3 $0 0($2)
	lw $4 0($2)
	bne $4 $3 fail
	lwc3 $1 0($2)
	mfc3 $5, $1
	bne $5 $3 fail


	.data
swl_:	.asciiz "Testing SWL\n"
	.align 2
swld_:	.word 0 0
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 swl_
	syscall

	la $2 swld_

	li $3 0x01020304
	swl $3 0($2)
	lw $4 0($2)
	bne $4 0x01020304 fail

	li $3 0x01020300
	swl $3 1($2)
	lw $4 0($2)
	bne $4 0x1010203 fail

	li $3 0x01020000
	swl $3 2($2)
	lw $4 0($2)
	bne $4 0x1010102 fail

	li $3 0x01000000
	swl $3 3($2)
	lw $4 0($2)
	bne $4 0x1010101 fail


	.data
swr_:	.asciiz "Testing SWR\n"
	.align 2
swrd_:	.word 0 0
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 swr_
	syscall

	la $2 swrd_

	li $3 0x01020304
	swr $3 0($2)
	lw $4 0($2)
	bne $4 0x4000000 fail

	li $3 0x01020304
	swr $3 1($2)
	lw $4 0($2)
	bne $4 0x3040000 fail

	li $3 0x01020304
	swr $3 2($2)
	lw $4 0($2)
	bne $4 0x2030400 fail

	li $3 0x01020304
	swr $3 3($2)
	lw $4 0($2)
	bne $4 0x1020304 fail


	.data
syscall_:.asciiz "Testing SYSCALL\n"
syscall1_:.asciiz "The next line should contain: -1, -1.000000, -2.000000\n"
syscall2_:.asciiz ", "
fp_sm1:	.float -1.0
fp_dm2:	.double -2.0
fp_c1:	.float 17.18
fp_c2:	.float 1700.18
fp_c3:	.double 17.18e10
fp_c4:	.double 1700.18e10
syscall5_:.asciiz "\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 syscall_
	syscall

	li $v0 4	# syscall 4 (print_str)
	la $a0 syscall1_
	syscall

	li $v0 1
	li $a0 -1
	syscall

	li $v0 4	# syscall 4 (print_str)
	la $a0 syscall2_
	syscall

	lwc1 $f12 fp_sm1
	li $v0 2
	syscall

	li $v0 4	# syscall 4 (print_str)
	la $a0 syscall2_
	syscall

	lwc1 $f12 fp_dm2
	lwc1 $f13 fp_dm2+4
	li $v0 3
	syscall

	li $v0 4	# syscall 4 (print_str)
	la $a0 syscall5_
	syscall


	li $v0 5	# syscall 5 (read_int)
	syscall
	bne $v0 17 fail

	li $v0 5	# syscall 5 (read_int)
	syscall
	bne $v0 1717 fail


	li $v0 6	# syscall 6 (read_float)
	syscall
	lwc1 $f2 fp_c1
	c.eq.s $f0, $f2
	bc1f fail

	li $v0 6	# syscall 6 (read_float)
	syscall
	lwc1 $f2 fp_c2
	c.eq.s $f0, $f2
	bc1f fail


	li $v0 7	# syscall 7 (read_double)
	syscall
	lwc1 $f2 fp_c3
	lwc1 $f3 fp_c3+4
	c.eq.d $f0, $f2
	bc1f fail

	li $v0 7	# syscall 7 (read_double)
	syscall
	lwc1 $f2 fp_c4
	lwc1 $f3 fp_c4+4
	c.eq.d $f0, $f2
	bc1f fail


	.data
xor_:	.asciiz "Testing XOR\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 xor_
	syscall

	li $2 1
	li $3 -1

	xor $4 $0 $0
	bne $4 0 fail
	xor $4 $3 $3
	bne $4 0 fail
	xor $4 $2 $3
	bne $4 0xfffffffe fail


	.data
xori_:	.asciiz "Testing XORI\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 xori_
	syscall

	li $2 1
	li $3 -1

	xori $4 $0 0
	bne $4 0 fail
	xori $4 $3 -1
	bne $4 0 fail
	xori $4 $2 -1
	bne $4 0xfffffffe fail


#
# Testing Floating Point Ops
#

	.data
abs.s_:.asciiz "Testing ABS.S\n"
fp_s100:.float 100.0
fp_sm100:.float -100.0
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 abs.s_
	syscall

	lw $4 fp_s100
	lwc1 $f0 fp_s100
	abs.s $f2 $f0
	mfc1 $5 $f2
	bne $4 $5 fail

	lwc1 $f0 fp_sm100
	abs.s $f2 $f0
	mfc1 $5 $f2
	bne $4 $5 fail


	.data
abs.d_:.asciiz "Testing ABS.D\n"
fp_d100:.double 100.0
fp_dm100:.double -100.0
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 abs.d_
	syscall

	lw $4 fp_d100
	lw $5 fp_d100+4
	lwc1 $f0 fp_d100
	lwc1 $f1 fp_d100+4
	abs.d $f2 $f0
	mfc1 $6 $f2
	mfc1 $7 $f3
	bne $4 $6 fail
	bne $5 $7 fail

	lwc1 $f0 fp_dm100
	lwc1 $f1 fp_dm100+4
	abs.d $f2 $f0
	mfc1 $6 $f2
	mfc1 $7 $f3
	bne $4 $6 fail
	bne $5 $7 fail


	.data
add.s_:	.asciiz "Testing ADD.S\n"
fp_s0:	.float 0.0
fp_s1:	.float 1.0
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 add.s_
	syscall

	lw $4 fp_s0
	lwc1 $f0 fp_s0
	add.s $f2 $f0 $f0
	mfc1 $6 $f2
	bne $4 $6 fail

	lw $4 fp_s1
	lwc1 $f0 fp_s0
	lwc1 $f2 fp_s1
	add.s $f4 $f0 $f2
	mfc1 $6 $f4
	bne $4 $6 fail

	lw $4 fp_s0
	lwc1 $f0 fp_s1
	lwc1 $f2 fp_sm1
	add.s $f4 $f0 $f2
	mfc1 $6 $f4
	bne $4 $6 fail


	.data
add.d_:	.asciiz "Testing ADD.D\n"
fp_d0:	.double 0.0
fp_d1:	.double 1.0
fp_dm1:	.double -1.0
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 add.d_
	syscall

	lw $4 fp_d0
	lw $5 fp_d0+4
	lwc1 $f0 fp_d0
	lwc1 $f1 fp_d0+4
	add.d $f2 $f0 $f0
	mfc1 $6 $f2
	mfc1 $7 $f3
	bne $4 $6 fail
	bne $5 $7 fail

	lw $4 fp_d1
	lw $5 fp_d1+4
	lwc1 $f0 fp_d0
	lwc1 $f1 fp_d0+4
	lwc1 $f2 fp_d1
	lwc1 $f3 fp_d1+4
	add.d $f4 $f0 $f2
	mfc1 $6 $f4
	mfc1 $7 $f5
	bne $4 $6 fail
	bne $5 $7 fail

	lw $4 fp_d0
	lw $5 fp_d0+4
	lwc1 $f0 fp_d1
	lwc1 $f1 fp_d1+4
	lwc1 $f2 fp_dm1
	lwc1 $f3 fp_dm1+4
	add.d $f4 $f0 $f2
	mfc1 $6 $f4
	mfc1 $7 $f5
	bne $4 $6 fail
	bne $5 $7 fail


# BC1F and BC1T tested below.


# ToDo: Check order/unordered exception in floating point comparison.

	.data
c.eq.d_:	.asciiz "Testing C.EQ.D\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 c.eq.d_
	syscall

	lwc1 $f0 fp_d1
	lwc1 $f1 fp_d1+4
	lwc1 $f2 fp_d1
	lwc1 $f3 fp_d1+4
	lwc1 $f4 fp_d1p5
	lwc1 $f5 fp_d1p5+4
	c.eq.d $f0 $f2
	bc1f fail
	bc1t l200
	j fail
l200:	c.eq.d $f0 $f4
	bc1t fail
	bc1f l201
	j fail
l201:


	.data
c.eq.s_:	.asciiz "Testing C.EQ.S\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 c.eq.s_
	syscall

	lwc1 $f0 fp_s1
	lwc1 $f2 fp_s1
	lwc1 $f4 fp_s1p5
	c.eq.s $f0 $f2
	bc1f fail
	bc1t l210
	j fail
l210:	c.eq.s $f0 $f4
	bc1t fail
	bc1f l211
	j fail
l211:


	.data
c.f.d_:	.asciiz "Testing C.F.D\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 c.f.d_
	syscall

	lwc1 $f0 fp_d1
	lwc1 $f1 fp_d1+4
	lwc1 $f2 fp_d1
	lwc1 $f3 fp_d1+4
	lwc1 $f4 fp_d1p5
	lwc1 $f5 fp_d1p5+4
	c.f.d $f0 $f2
	bc1t fail
	bc1f l220
	j fail
l220:	c.f.d $f0 $f4
	bc1t fail
	bc1f l221
	j fail
l221:


	.data
c.f.s_:	.asciiz "Testing C.F.S\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 c.f.s_
	syscall

	lwc1 $f0 fp_s1
	lwc1 $f2 fp_s1
	lwc1 $f4 fp_s1p5
	c.f.s $f0 $f2
	bc1t fail
	bc1f l230
	j fail
l230:	c.f.s $f0 $f4
	bc1t fail
	bc1f l231
	j fail
l231:


	.data
c.le.d_:	.asciiz "Testing C.LE.D\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 c.le.d_
	syscall

	lwc1 $f0 fp_d1
	lwc1 $f1 fp_d1+4
	lwc1 $f2 fp_d1p5
	lwc1 $f3 fp_d1p5+4
	lwc1 $f4 fp_dm2
	lwc1 $f5 fp_dm2+4
	c.le.d $f0 $f2
	bc1f fail
	bc1t l240
	j fail
l240:	c.le.d $f2 $f0
	bc1t fail
	bc1f l241
	j fail
l241:	c.le.d $f0 $f0
	bc1f fail
	bc1t l242
	j fail
l242:	c.le.d $f4 $f0
	bc1f fail
	bc1t l243
	j fail
l243:


	.data
c.le.s_:	.asciiz "Testing C.LE.S\n"
fp_sm2:	.float -2.0
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 c.le.s_
	syscall

	lwc1 $f0 fp_s1
	lwc1 $f2 fp_s1p5
	lwc1 $f4 fp_sm2
	c.le.s $f0 $f2
	bc1f fail
	bc1t l250
	j fail
l250:	c.le.s $f2 $f0
	bc1t fail
	bc1f l251
	j fail
l251:	c.le.s $f0 $f0
	bc1f fail
	bc1t l252
	j fail
l252:	c.le.s $f4 $f0
	bc1f fail
	bc1t l253
	j fail
l253:


	.data
c.lt.d_:	.asciiz "Testing C.LT.D\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 c.lt.d_
	syscall

	lwc1 $f0 fp_d1
	lwc1 $f1 fp_d1+4
	lwc1 $f2 fp_d1p5
	lwc1 $f3 fp_d1p5+4
	lwc1 $f4 fp_dm2
	lwc1 $f5 fp_dm2+4
	c.lt.d $f0 $f2
	bc1f fail
	bc1t l260
	j fail
l260:	c.lt.d $f2 $f0
	bc1t fail
	bc1f l261
	j fail
l261:	c.lt.d $f0 $f0
	bc1t fail
	bc1f l262
	j fail
l262:	c.lt.d $f4 $f0
	bc1f fail
	bc1t l263
	j fail
l263:


	.data
c.lt.s_:	.asciiz "Testing C.LT.S\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 c.lt.s_
	syscall

	lwc1 $f0 fp_s1
	lwc1 $f2 fp_s1p5
	lwc1 $f4 fp_sm2
	c.lt.s $f0 $f2
	bc1f fail
	bc1t l270
	j fail
l270:	c.lt.s $f2 $f0
	bc1t fail
	bc1f l271
	j fail
l271:	c.lt.s $f0 $f0
	bc1t fail
	bc1f l272
	j fail
l272:	c.lt.s $f4 $f0
	bc1f fail
	bc1t l273
	j fail
l273:


	.data
c.nge.d_:	.asciiz "Testing C.NGE.D\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 c.nge.d_
	syscall

	lwc1 $f0 fp_d1
	lwc1 $f1 fp_d1+4
	lwc1 $f2 fp_d1p5
	lwc1 $f3 fp_d1p5+4
	lwc1 $f4 fp_dm2
	lwc1 $f5 fp_dm2+4
	c.nge.d $f0 $f2
	bc1f fail
	bc1t l280
	j fail
l280:	c.nge.d $f2 $f0
	bc1t fail
	bc1f l281
	j fail
l281:	c.nge.d $f0 $f0
	bc1t fail
	bc1f l282
	j fail
l282:	c.nge.d $f4 $f0
	bc1f fail
	bc1t l283
	j fail
l283:


	.data
c.nge.s_:	.asciiz "Testing C.NGE.S\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 c.nge.s_
	syscall

	lwc1 $f0 fp_s1
	lwc1 $f2 fp_s1p5
	lwc1 $f4 fp_sm2
	c.nge.s $f0 $f2
	bc1f fail
	bc1t l290
	j fail
l290:	c.nge.s $f2 $f0
	bc1t fail
	bc1f l291
	j fail
l291:	c.nge.s $f0 $f0
	bc1t fail
	bc1f l292
	j fail
l292:	c.nge.s $f4 $f0
	bc1f fail
	bc1t l293
	j fail
l293:


	.data
c.ngle.d_:	.asciiz "Testing C.NGLE.D\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 c.ngle.d_
	syscall

	lwc1 $f0 fp_d1
	lwc1 $f1 fp_d1+4
	lwc1 $f2 fp_d1
	lwc1 $f3 fp_d1+4
	lwc1 $f4 fp_d1p5
	lwc1 $f5 fp_d1p5+4
	c.ngle.d $f0 $f2
	bc1t fail
l300:	c.ngle.d $f0 $f4
	bc1t fail
l301:


	.data
c.ngle.s_:	.asciiz "Testing C.NGLE.S\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 c.ngle.s_
	syscall

	lwc1 $f0 fp_s1
	lwc1 $f2 fp_s1
	lwc1 $f4 fp_s1p5
	c.ngle.s $f0 $f2
	bc1t fail
l310:	c.ngle.s $f0 $f4
	bc1t fail
l311:


	.data
c.ngl.d_:	.asciiz "Testing C.NGL.D\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 c.ngl.d_
	syscall

	lwc1 $f0 fp_d1
	lwc1 $f1 fp_d1+4
	lwc1 $f2 fp_d1
	lwc1 $f3 fp_d1+4
	lwc1 $f4 fp_d1p5
	lwc1 $f5 fp_d1p5+4
	c.ngl.d $f0 $f2
	bc1f fail
	bc1t l320
	j fail
l320:	c.ngl.d $f0 $f4
	bc1t fail
	bc1f l321
	j fail
l321:


	.data
c.ngl.s_:	.asciiz "Testing C.NGL.S\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 c.ngl.s_
	syscall

	lwc1 $f0 fp_s1
	lwc1 $f2 fp_s1
	lwc1 $f4 fp_s1p5
	c.ngl.s $f0 $f2
	bc1f fail
	bc1t l330
	j fail
l330:	c.ngl.s $f0 $f4
	bc1t fail
	bc1f l331
	j fail
l331:


	.data
c.ngt.d_:	.asciiz "Testing C.NGT.D\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 c.ngt.d_
	syscall

	lwc1 $f0 fp_d1
	lwc1 $f1 fp_d1+4
	lwc1 $f2 fp_d1p5
	lwc1 $f3 fp_d1p5+4
	lwc1 $f4 fp_dm2
	lwc1 $f5 fp_dm2+4
	c.ngt.d $f0 $f2
	bc1f fail
	bc1t l340
	j fail
l340:	c.ngt.d $f2 $f0
	bc1t fail
	bc1f l341
	j fail
l341:	c.ngt.d $f0 $f0
	bc1f fail
	bc1t l342
	j fail
l342:	c.ngt.d $f4 $f0
	bc1f fail
	bc1t l343
	j fail
l343:


	.data
c.ngt.s_:	.asciiz "Testing C.NGT.S\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 c.ngt.s_
	syscall

	lwc1 $f0 fp_s1
	lwc1 $f2 fp_s1p5
	lwc1 $f4 fp_sm2
	c.ngt.s $f0 $f2
	bc1f fail
	bc1t l350
	j fail
l350:	c.ngt.s $f2 $f0
	bc1t fail
	bc1f l351
	j fail
l351:	c.ngt.s $f0 $f0
	bc1f fail
	bc1t l352
	j fail
l352:	c.ngt.s $f4 $f0
	bc1f fail
	bc1t l353
	j fail
l353:


	.data
c.ole.d_:	.asciiz "Testing C.OLE.D\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 c.ole.d_
	syscall

	lwc1 $f0 fp_d1
	lwc1 $f1 fp_d1+4
	lwc1 $f2 fp_d1p5
	lwc1 $f3 fp_d1p5+4
	lwc1 $f4 fp_dm2
	lwc1 $f5 fp_dm2+4
	c.ole.d $f0 $f2
	bc1f fail
	bc1t l360
	j fail
l360:	c.ole.d $f2 $f0
	bc1t fail
	bc1f l361
	j fail
l361:	c.ole.d $f0 $f0
	bc1f fail
	bc1t l362
	j fail
l362:	c.ole.d $f4 $f0
	bc1f fail
	bc1t l363
	j fail
l363:


	.data
c.ole.s_:	.asciiz "Testing C.OLE.S\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 c.ole.s_
	syscall

	lwc1 $f0 fp_s1
	lwc1 $f2 fp_s1p5
	lwc1 $f4 fp_sm2
	c.ole.s $f0 $f2
	bc1f fail
	bc1t l370
	j fail
l370:	c.ole.s $f2 $f0
	bc1t fail
	bc1f l371
	j fail
l371:	c.ole.s $f0 $f0
	bc1f fail
	bc1t l372
	j fail
l372:	c.ole.s $f4 $f0
	bc1f fail
	bc1t l373
	j fail
l373:


	.data
c.seq.d_:	.asciiz "Testing C.SEQ.D\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 c.seq.d_
	syscall

	lwc1 $f0 fp_d1
	lwc1 $f1 fp_d1+4
	lwc1 $f2 fp_d1
	lwc1 $f3 fp_d1+4
	lwc1 $f4 fp_d1p5
	lwc1 $f5 fp_d1p5+4
	c.seq.d $f0 $f2
	bc1f fail
	bc1t l380
	j fail
l380:	c.seq.d $f0 $f4
	bc1t fail
	bc1f l381
	j fail
l381:


	.data
c.seq.s_:	.asciiz "Testing C.SEQ.S\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 c.seq.s_
	syscall

	lwc1 $f0 fp_s1
	lwc1 $f2 fp_s1
	lwc1 $f4 fp_s1p5
	c.seq.s $f0 $f2
	bc1f fail
	bc1t l390
	j fail
l390:	c.seq.s $f0 $f4
	bc1t fail
	bc1f l391
	j fail
l391:


	.data
c.sf.d_:	.asciiz "Testing C.SF.D\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 c.sf.d_
	syscall

	lwc1 $f0 fp_d1
	lwc1 $f1 fp_d1+4
	lwc1 $f2 fp_d1
	lwc1 $f3 fp_d1+4
	lwc1 $f4 fp_d1p5
	lwc1 $f5 fp_d1p5+4
	c.sf.d $f0 $f2
	bc1t fail
l400:	c.sf.d $f0 $f4
	bc1t fail
l401:


	.data
c.sf.s_:	.asciiz "Testing C.SF.S\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 c.sf.s_
	syscall

	lwc1 $f0 fp_s1
	lwc1 $f2 fp_s1
	lwc1 $f4 fp_s1p5
	c.sf.s $f0 $f2
	bc1t fail
l410:	c.sf.s $f0 $f4
	bc1t fail
l411:


	.data
c.ueq.d_:	.asciiz "Testing C.UEQ.D\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 c.ueq.d_
	syscall

	lwc1 $f0 fp_d1
	lwc1 $f1 fp_d1+4
	lwc1 $f2 fp_d1
	lwc1 $f3 fp_d1+4
	lwc1 $f4 fp_d1p5
	lwc1 $f5 fp_d1p5+4
	c.ueq.d $f0 $f2
	bc1f fail
	bc1t l420
	j fail
l420:	c.ueq.d $f0 $f4
	bc1t fail
	bc1f l421
	j fail
l421:


	.data
c.ueq.s_:	.asciiz "Testing C.UEQ.S\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 c.ueq.s_
	syscall

	lwc1 $f0 fp_s1
	lwc1 $f2 fp_s1
	lwc1 $f4 fp_s1p5
	c.ueq.s $f0 $f2
	bc1f fail
	bc1t l430
	j fail
l430:	c.ueq.s $f0 $f4
	bc1t fail
	bc1f l431
	j fail
l431:


	.data
c.ule.d_:	.asciiz "Testing C.ULE.D\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 c.ule.d_
	syscall

	lwc1 $f0 fp_d1
	lwc1 $f1 fp_d1+4
	lwc1 $f2 fp_d1p5
	lwc1 $f3 fp_d1p5+4
	lwc1 $f4 fp_dm2
	lwc1 $f5 fp_dm2+4
	c.ule.d $f0 $f2
	bc1f fail
	bc1t l440
	j fail
l440:	c.ule.d $f2 $f0
	bc1t fail
	bc1f l441
	j fail
l441:	c.ule.d $f0 $f0
	bc1f fail
	bc1t l442
	j fail
l442:	c.ule.d $f4 $f0
	bc1f fail
	bc1t l443
	j fail
l443:


	.data
c.ule.s_:	.asciiz "Testing C.ULE.S\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 c.ule.s_
	syscall

	lwc1 $f0 fp_s1
	lwc1 $f2 fp_s1p5
	lwc1 $f4 fp_sm2
	c.ule.s $f0 $f2
	bc1f fail
	bc1t l450
	j fail
l450:	c.ule.s $f2 $f0
	bc1t fail
	bc1f l451
	j fail
l451:	c.ule.s $f0 $f0
	bc1f fail
	bc1t l452
	j fail
l452:	c.ule.s $f4 $f0
	bc1f fail
	bc1t l453
	j fail
l453:


	.data
c.un.d_:	.asciiz "Testing C.UN.D\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 c.un.d_
	syscall

	lwc1 $f0 fp_d1
	lwc1 $f1 fp_d1+4
	lwc1 $f2 fp_d1
	lwc1 $f3 fp_d1+4
	lwc1 $f4 fp_d1p5
	lwc1 $f5 fp_d1p5+4
	c.un.d $f0 $f2
	bc1t fail
	bc1f l460
	j fail
l460:	c.un.d $f0 $f4
	bc1t fail
	bc1f l461
	j fail
l461:


	.data
c.un.s_:	.asciiz "Testing C.UN.S\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 c.un.s_
	syscall

	lwc1 $f0 fp_s1
	lwc1 $f2 fp_s1
	lwc1 $f4 fp_s1p5
	c.un.s $f0 $f2
	bc1t fail
	bc1f l470
	j fail
l470:	c.un.s $f0 $f4
	bc1t fail
	bc1f l471
	j fail
l471:


# CFC1 and CTC1 tested previously


	.data
cvt.d.s_:	.asciiz "Testing CVT.D.S\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 cvt.d.s_
	syscall

	lw $4 fp_d0
	lw $5 fp_d0+4
	lwc1 $f0 fp_s0
	cvt.d.s $f2 $f0
	mfc1 $6 $f2
	mfc1 $7 $f3
	bne $4 $6 fail
	bne $5 $7 fail

	lw $4 fp_d1
	lw $5 fp_d1+4
	lwc1 $f0 fp_s1
	cvt.d.s $f2 $f0
	mfc1 $6 $f2
	mfc1 $7 $f3
	bne $4 $6 fail
	bne $5 $7 fail

	lw $4 fp_dm1
	lw $5 fp_dm1+4
	lwc1 $f0 fp_sm1
	cvt.d.s $f2 $f0
	mfc1 $6 $f2
	mfc1 $7 $f3
	bne $4 $6 fail
	bne $5 $7 fail


	.data
cvt.d.w_:	.asciiz "Testing CVT.D.W\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 cvt.d.w_
	syscall

	lw $4 fp_d0
	lw $5 fp_d0+4
	mtc1 $0 $0
	cvt.d.w $f2 $f0
	mfc1 $6 $f2
	mfc1 $7 $f3
	bne $4 $6 fail
	bne $5 $7 fail

	lw $4 fp_d1
	lw $5 fp_d1+4
	li $t1 1
	mtc1 $t1 $0
	cvt.d.w $f2 $f0
	mfc1 $6 $f2
	mfc1 $7 $f3
	bne $4 $6 fail
	bne $5 $7 fail

	lw $4 fp_dm1
	lw $5 fp_dm1+4
	li $t1 -1
	mtc1 $t1 $0
	cvt.d.w $f2 $f0
	mfc1 $6 $f2
	mfc1 $7 $f3
	bne $4 $6 fail
	bne $5 $7 fail


	.data
cvt.s.d_:	.asciiz "Testing CVT.S.D\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 cvt.s.d_
	syscall

	lw $4 fp_s0
	lwc1 $f0 fp_d0
	lwc1 $f1 fp_d0+4
	cvt.s.d $f2 $f0
	mfc1 $6 $f2
	bne $4 $6 fail

	lw $4 fp_s1
	lwc1 $f0 fp_d1
	lwc1 $f1 fp_d1+4
	cvt.s.d $f2 $f0
	mfc1 $6 $f2
	bne $4 $6 fail

	lw $4 fp_sm1
	lwc1 $f0 fp_dm1
	lwc1 $f1 fp_dm1+4
	cvt.s.d $f2 $f0
	mfc1 $6 $f2
	bne $4 $6 fail


	.data
cvt.s.w_:	.asciiz "Testing CVT.S.W\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 cvt.s.w_
	syscall

	lw $4 fp_s0
	mtc1 $0 $0
	cvt.s.w $f2 $f0
	mfc1 $6 $f2
	bne $4 $6 fail

	lw $4 fp_s1
	li $t1 1
	mtc1 $t1 $0
	cvt.s.w $f2 $f0
	mfc1 $6 $f2
	bne $4 $6 fail

	lw $4 fp_sm1
	li $t1 -1
	mtc1 $t1 $0
	cvt.s.w $f2 $f0
	mfc1 $6 $f2
	bne $4 $6 fail


	.data
cvt.w.d_:	.asciiz "Testing CVT.W.D\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 cvt.w.d_
	syscall

	lwc1 $f0 fp_d0
	lwc1 $f1 fp_d0+4
	cvt.w.d $f2 $f0
	mfc1 $6 $f2
	bne $0 $6 fail

	lwc1 $f0 fp_d1
	lwc1 $f1 fp_d1+4
	cvt.w.d $f2 $f0
	mfc1 $6 $f2
	li $4 1
	bne $4 $6 fail

	lwc1 $f0 fp_dm1
	lwc1 $f1 fp_dm1+4
	cvt.w.d $f2 $f0
	mfc1 $6 $f2
	li $4 -1
	bne $4 $6 fail


	.data
cvt.w.s_:	.asciiz "Testing CVT.W.S\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 cvt.w.s_
	syscall

	lwc1 $f0 fp_s0
	cvt.w.s $f2 $f0
	mfc1 $6 $f2
	bne $0 $6 fail

	lwc1 $f0 fp_s1
	cvt.w.s $f2 $f0
	mfc1 $6 $f2
	li $4 1
	bne $4 $6 fail

	lwc1 $f0 fp_sm1
	cvt.w.s $f2 $f0
	mfc1 $6 $f2
	li $4 -1
	bne $4 $6 fail


	.data
div.s_:	.asciiz "Testing DIV.S\n"
fp_s2:	.float 2.0
fp_s3:	.float 3.0
fp_s1p5:.float 1.5
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 div.s_
	syscall

	lw $4 fp_s1
	lwc1 $f0 fp_s1
	div.s $f2 $f0 $f0
	mfc1 $6 $f2
	bne $4 $6 fail

	lw $4 fp_s1p5
	lwc1 $f0 fp_s3
	lwc1 $f2 fp_s2
	div.s $f4 $f0 $f2
	mfc1 $6 $f4
	bne $4 $6 fail


	.data
div.d_:	.asciiz "Testing DIV.D\n"
fp_d2:	.double 2.0
fp_d3:	.double 3.0
fp_d1p5:.double 1.5
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 div.d_
	syscall

	lw $4 fp_d1
	lw $5 fp_d1+4
	lwc1 $f0 fp_d1
	lwc1 $f1 fp_d1+4
	div.d $f2 $f0 $f0
	mfc1 $6 $f2
	mfc1 $7 $f3
	bne $4 $6 fail
	bne $5 $7 fail

	lw $4 fp_d1p5
	lw $5 fp_d1p5+4
	lwc1 $f0 fp_d3
	lwc1 $f1 fp_d3+4
	lwc1 $f2 fp_d2
	lwc1 $f3 fp_d2+4
	div.d $f4 $f0 $f2
	mfc1 $6 $f4
	mfc1 $7 $f5
	bne $4 $6 fail
	bne $5 $7 fail


# LWC1, MFC1 tested pfreviously

	.data
mov.s_:	.asciiz "Testing MOV.S\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 mov.s_
	syscall

	lw $4 fp_s1
	lwc1 $f2 fp_s1
	mov.s $f4 $f2
	mov.s $f6 $f4
	mfc1 $6 $f6
	bne $4 $6 fail


	.data
mov.d_:	.asciiz "Testing MOV.D\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 mov.d_
	syscall

	lw $4 fp_d1
	lw $5 fp_d1+4
	lwc1 $f2 fp_d1
	lwc1 $f3 fp_d1+4
	mov.d $f4 $f2
	mov.d $f6 $f4
	mfc1 $6 $f6
	mfc1 $7 $f7
	bne $4 $6 fail
	bne $5 $7 fail


# MTC1 tested previously

	.data
mul.s_:	.asciiz "Testing MUL.S\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 mul.s_
	syscall

	lw $4 fp_s1
	lwc1 $f0 fp_s1
	mul.s $f2 $f0 $f0
	mfc1 $6 $f2
	bne $4 $6 fail

	lw $4 fp_s3
	lwc1 $f0 fp_s1p5
	lwc1 $f2 fp_s2
	mul.s $f4 $f0 $f2
	mfc1 $6 $f4
	bne $4 $6 fail


	.data
mul.d_:	.asciiz "Testing MUL.D\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 mul.d_
	syscall

	lw $4 fp_d1
	lw $5 fp_d1+4
	lwc1 $f0 fp_d1
	lwc1 $f1 fp_d1+4
	mul.d $f2 $f0 $f0
	mfc1 $6 $f2
	mfc1 $7 $f3
	bne $4 $6 fail
	bne $5 $7 fail

	lw $4 fp_d3
	lw $5 fp_d3+4
	lwc1 $f0 fp_d1p5
	lwc1 $f1 fp_d1p5+4
	lwc1 $f2 fp_d2
	lwc1 $f3 fp_d2+4
	mul.d $f4 $f0 $f2
	mfc1 $6 $f4
	mfc1 $7 $f5
	bne $4 $6 fail
	bne $5 $7 fail


	.data
neg.s_:	.asciiz "Testing NEG.S\n"
fp_sm3:	.float -3.0
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 neg.s_
	syscall

	lw $4 fp_sm1
	lwc1 $f0 fp_s1
	neg.s $f2 $f0
	mfc1 $6 $f2
	bne $4 $6 fail

	lw $4 fp_s3
	lwc1 $f0 fp_sm3
	neg.s $f2 $f0
	mfc1 $6 $f2
	bne $4 $6 fail


	.data
neg.d_:	.asciiz "Testing NEG.D\n"
fp_dm3:	.double -3.0
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 neg.d_
	syscall

	lw $4 fp_dm1
	lw $5 fp_dm1+4
	lwc1 $f0 fp_d1
	lwc1 $f1 fp_d1+4
	neg.d $f2 $f0
	mfc1 $6 $f2
	mfc1 $7 $f3
	bne $4 $6 fail
	bne $5 $7 fail

	lw $4 fp_d3
	lw $5 fp_d3+4
	lwc1 $f0 fp_dm3
	lwc1 $f1 fp_dm3+4
	neg.d $f4 $f0
	mfc1 $6 $f4
	mfc1 $7 $f5
	bne $4 $6 fail
	bne $5 $7 fail


	.data
sub.s_:	.asciiz "Testing SUB.S\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 sub.s_
	syscall

	lw $4 fp_s0
	lwc1 $f0 fp_s0
	sub.s $f2 $f0 $f0
	mfc1 $6 $f2
	bne $4 $6 fail

	lw $4 fp_sm1
	lw $5 fp_s1
	lwc1 $f0 fp_s0
	lwc1 $f2 fp_s1
	sub.s $f4 $f0 $f2
	mfc1 $6 $f4
	bne $4 $6 fail
	sub.s $f4 $f2 $f0
	mfc1 $6 $f4
	bne $5 $6 fail

	lw $4 fp_s1p5
	lwc1 $f0 fp_s1p5
	lwc1 $f2 fp_s3
	sub.s $f4 $f2 $f0
	mfc1 $6 $f4
	bne $4 $6 fail


	.data
sub.d_:	.asciiz "Testing SUB.D\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 sub.d_
	syscall

	lw $4 fp_d0
	lw $5 fp_d0+4
	lwc1 $f0 fp_d0
	lwc1 $f1 fp_d0+4
	sub.d $f2 $f0 $f0
	mfc1 $6 $f2
	mfc1 $7 $f3
	bne $4 $6 fail
	bne $5 $7 fail

	lw $4 fp_dm1
	lw $5 fp_dm1+4
	lwc1 $f0 fp_d0
	lwc1 $f1 fp_d0+4
	lwc1 $f2 fp_d1
	lwc1 $f3 fp_d1+4
	sub.d $f4 $f0 $f2
	mfc1 $6 $f4
	mfc1 $7 $f5
	bne $4 $6 fail
	bne $5 $7 fail
	lw $4 fp_d1
	lw $5 fp_d1+4
	sub.d $f4 $f2 $f0
	mfc1 $6 $f4
	mfc1 $7 $f5
	bne $4 $6 fail
	bne $5 $7 fail

	lw $4 fp_d1p5
	lw $5 fp_d1p5+4
	lwc1 $f0 fp_d1p5
	lwc1 $f1 fp_d1p5+4
	lwc1 $f2 fp_d3
	lwc1 $f3 fp_d3+4
	sub.d $f4 $f2 $f0
	mfc1 $6 $f4
	mfc1 $7 $f5
	bne $4 $6 fail
	bne $5 $7 fail


# SWC1 tested previously


#
# Testing Pseudo Ops
#

	.data
abs_:	.asciiz "Testing ABS\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 abs_
	syscall

	li $2 1
	abs $3 $2
	bne $3 1 fail

	li $2 -1
	abs $2 $2
	bne $2 1 fail

	li $2 0
	abs $2 $2
	bne $2 0 fail


	.data
b_:	.asciiz "Testing B\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 b_
	syscall


	b l101
	b fail
l101:


	.data
bal_:	.asciiz "Testing BAL\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 bal_
	syscall

	bal l102
l103:	j l104
l102:	la $4 l103
	bne $31 $4 fail
	jr $31
l104:


	.data
beqz_:	.asciiz "Testing BEQZ\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 beqz_
	syscall

	beqz $0 l105
	j fail
l105:	li $2 1
	beqz $2 fail


	.data
bge_:	.asciiz "Testing BGE\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 bge_
	syscall

	bge $0 $0 l106
	j fail
l106:	li $2 1
	bge $0 $2 fail
	bge $2 $0 l107
	j fail
l107:	li $3 -1
	bge $3 $2 fail
	bge $2 $3 l108
	j fail
l108:

	bge $0 0 l109
	j fail
l109:	li $2 1
	bge $0 1 fail
	bge $2 0 l110
	j fail
l110:	li $3 -1
	bge $3 1 fail
	bge $2 -1 l111
	j fail
l111:


	.data
bgeu_:	.asciiz "Testing BGEU\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 bgeu_
	syscall

	bgeu $0 $0 l112
	j fail
l112:	li $2 1
	bgeu $0 $2 fail
	bgeu $2 $0 l113
	j fail
l113:	li $3 -1
	bgeu $2 $3 fail
	bgeu $3 $2 l114
	j fail
l114:

	bgeu $0 0 l115
	j fail
l115:	li $2 1
	bgeu $0 1 fail
	bgeu $2 0 l116
	j fail
l116:	li $3 -1
	bgeu $2 -1 fail
	bgeu $3 1 l117
	j fail
l117:


	.data
bgt_:	.asciiz "Testing BGT\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 bgt_
	syscall

	bgt $0 $0 fail
l120:	li $2 1
	bgt $0 $2 fail
	bgt $2 $0 l121
	j fail
l121:	li $3 -1
	bgt $3 $2 fail
	bgt $2 $3 l122
	j fail
l122:

	bgt $0 0 fail
l123:	li $2 1
	bgt $0 1 fail
	bgt $2 0 l124
	j fail
l124:	li $3 -1
	bgt $3 1 fail
	bgt $2 -1 l125
	j fail
l125:


	.data
bgtu_:	.asciiz "Testing BGTU\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 bgtu_
	syscall

	bgtu $0 $0 fail
l132:	li $2 1
	bgtu $0 $2 fail
	bgtu $2 $0 l133
	j fail
l133:	li $3 -1
	bgtu $2 $3 fail
	bgtu $3 $2 l134
	j fail
l134:

	bgtu $0 0 fail
l135:	li $2 1
	bgtu $0 1 fail
	bgtu $2 0 l136
	j fail
l136:	li $3 -1
	bgtu $2 -1 fail
	bgtu $3 1 l137
	j fail
l137:


	.data
ble_:	.asciiz "Testing BLE\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 ble_
	syscall

	ble $0 $0 l140
	j fail
l140:	li $2 1
	ble $2 $0 fail
	ble $0 $2 l141
	j fail
l141:	li $3 -1
	ble $2 $3 fail
	ble $3 $2 l142
	j fail
l142:

	ble $0 0 l143
	j fail
l143:	li $2 1
	ble $2 0 fail
	ble $0 1 l144
	j fail
l144:	li $3 -1
	ble $2 -1 fail
	ble $3 1 l145
	j fail
l145:


	.data
bleu_:	.asciiz "Testing BLEU\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 bleu_
	syscall

	bleu $0 $0 l152
	j fail
l152:	li $2 1
	bleu $2 $0 fail
	bleu $0 $2 l153
	j fail
l153:	li $3 -1
	bleu $3 $2 fail
	bleu $2 $3 l154
	j fail
l154:

	bleu $0 0 l155
	j fail
l155:	li $2 1
	bleu $2 0 fail
	bleu $0 1 l156
	j fail
l156:	li $3 -1
	bleu $3 1 fail
	bleu $2 -1 l157
	j fail
l157:


	.data
blt_:	.asciiz "Testing BLT\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 blt_
	syscall

	blt $0 $0 fail
l160:	li $2 1
	blt $2 $0 fail
	blt $0 $2 l161
	j fail
l161:	li $3 -1
	blt $2 $3 fail
	blt $3 $2 l162
	j fail
l162:

	blt $0 0 fail
l163:	li $2 1
	blt $2 0 fail
	blt $0 1 l164
	j fail
l164:	li $3 -1
	blt $2 -1 fail
	blt $3 1 l165
	j fail
l165:


	.data
bltu_:	.asciiz "Testing BLTU\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 bltu_
	syscall

	bltu $0 $0 fail
l172:	li $2 1
	bltu $2 $0 fail
	bltu $0 $2 l173
	j fail
l173:	li $3 -1
	bltu $3 $2 fail
	bltu $2 $3 l174
	j fail
l174:

	bltu $0 0 fail
l175:	li $2 1
	bltu $2 0 fail
	bltu $0 1 l176
	j fail
l176:	li $3 -1
	bltu $3 1 fail
	bltu $2 -1 l177
	j fail
l177:


	.data
bnez_:	.asciiz "Testing BNEZ\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 bnez_
	syscall

	bnez $0 fail
	li $2 1
	bnez $2 l180
	j fail
l180:


# DIV and DIVU checked previously


	.data
l_s_:	.asciiz "Testing L_S\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 l_s_
	syscall

	lw $2 fp_s1p5
	l.s $f0 fp_s1p5
	mfc1 $4 $f0
	bne $2 $4 fail

	.data
l_d_:	.asciiz "Testing L_D\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 l_d_
	syscall

	lw $2 fp_d1p5
	lw $3 fp_d1p5+4
	l.d $f0 fp_d1p5
	mfc1 $4 $f0
	mfc1 $5 $f1
	bne $2 $4 fail
	bne $3 $5 fail


# LA better work or nothing above will work


	.data
li_:	.asciiz "Testing LI\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 li_
	syscall

	li $2 0xfffffff
	bne $2 0xfffffff fail
	li $2 0xffffffe
	bne $2 0xffffffe fail
	li $2 0
	bnez $2 fail
	li $2 0x7fffffff
	bne $2 0x7fffffff fail
	li $2 32767
	bne $2 32767 fail
	li $2 32768
	bne $2 32768 fail
	li $2 65535
	bne $2 65535 fail
	li $2 65536
	bne $2 65536 fail


	.data
li.d_:	.asciiz "Testing LI.d\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 li.d_
	syscall

	li.d $f0 1.0
	mfc1 $2, $f0
	mfc1 $3, $f1
	lw $4, fp_d1
	lw $5, fp_d1+4
	bne $2 $4 fail
	bne $3 $5 fail

	li.d $f0 -1.0
	mfc1 $2, $f0
	mfc1 $3, $f1
	lw $4, fp_dm1
	lw $5, fp_dm1+4
	bne $2 $4 fail
	bne $3 $5 fail


	.data
li.s_:	.asciiz "Testing LI.s\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 li.s_
	syscall

	li.s $f0 1.0
	mfc1 $2, $f0
	lw $3, fp_s1
	bne $2 $3 fail

	li.s $f0 -1.0
	mfc1 $2, $f0
	lw $3, fp_sm1
	bne $2 $3 fail


	.data
move_:	.asciiz "Testing MOVE\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 move_
	syscall

	li $2 0xfffffff
	move $3 $2
	bne $2 $3 fail


# MUL and MULO and MULOU were tested previously


	.data
neg_:	.asciiz "Testing NEG\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 neg_
	syscall

	li $2 -101
	neg $3 $2
	bne $3 101 fail
	li $2 101
	neg $2 $2
	bne $2 -101 fail
	neg $2 $0
	bne $2 0 fail


	.data
negu_:	.asciiz "Testing NEGU\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 negu_
	syscall

	li $2 -101
	negu $3 $2
	bne $3 101 fail
	li $2 101
	negu $2 $2
	bne $2 -101 fail
	negu $2 $0
	bne $2 0 fail

	.data
nop_:	.asciiz "Testing NOP\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 nop_
	syscall

	nop		# How do we test it??


	.data
not_:	.asciiz "Testing NOT\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 not_
	syscall

	not $2 $0
	bne $2 0xffffffff fail
	li $2 0
	not $3 $2
	bne $3 0xffffffff fail
	li $2 0xffffffff
	not $3 $2
	bne $3 0 fail


	.data
rem_:	.asciiz "Testing REM\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 rem_
	syscall

	li $2 5
	li $3 2
	li $4 -2

	rem $5 $2 $3
	bne $5 1 fail

	rem $5 $2 $4
	bne $5 1 fail

	.data
remu_:	.asciiz "Testing REMU\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 remu_
	syscall

	li $2 5
	li $3 2
	li $4 -2

	remu $5 $2 $3
	bne $5 1 fail

	remu $5 $2 $4
	bne $5 5 fail


	.data
rol_:	.asciiz "Testing ROL\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 rol_
	syscall
	li $2 5
	li $3 5
	rol $4 $2 $3
	bne $4 0xa0 fail
	li $2 5
	li $3 -5
	rol $4 $2 $3
	bne $4 0x28000000 fail
	li $2 5
	rol $4 $2 5
	bne $4 0xa0 fail
	li $2 5
	rol $4 $2 -5
	bne $4 0x28000000 fail


	.data
ror_:	.asciiz "Testing ROR\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 ror_
	syscall
	li $2 5
	li $3 5
	ror $4 $2 $3
	bne $4 0x28000000 fail
	li $2 5
	li $3 -5
	ror $4 $2 $3
	bne $4 0xa0 fail
	li $2 5
	ror $4 $2 5
	bne $4 0x28000000 fail
	li $2 5
	ror $4 $2 -5
	bne $4 0xa0 fail


	.data
s_s_:	.asciiz "Testing S_S\n"
foo:	.word 0
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 s_s_
	syscall

	lw $2 fp_s1p5
	mtc1 $2 $0
	s.s $f0 foo
	lw $4 foo
	bne $2 $4 fail

	.data
s_d_:	.asciiz "Testing S_D\n"
bar:	.word 0 0
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 s_d_
	syscall

	lw $2 fp_d1p5
	lw $3 fp_d1p5+4
	mtc1 $2 $0
	mtc1 $3 $1
	s.d $f0 bar
	lw $4 bar
	lw $5 bar+4

	bne $2 $4 fail
	bne $3 $5 fail


	.data
seq_:	.asciiz "Testing SEQ\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 seq_
	syscall

	li $2 -1
	li $3 1

	seq $4 $0 $0
	beqz $4 fail
	seq $4 $2 $3
	bnez $4 fail

	seq $4 $0 0
	beqz $4 fail
	seq $4 $3 2
	bnez $4 fail


	.data
sge_:	.asciiz "Testing SGE\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 sge_
	syscall

	sge $4 $0 $0
	beqz $4 fail
	li $2 1
	sge $4 $0 $2
	bnez $4 fail
	sge $4 $2 $0
	beqz $4 fail
	li $2 -1
	sge $4 $0 $2
	beqz $4 fail
	sge $4 $2 $0
	bnez $4 fail

	li $2 1
	sge $2 $0 $2
	bnez $2 fail
	li $2 1
	sge $2 $2 $0
	beqz $2 fail
	li $2 -1
	sge $2 $0 $2
	beqz $2 fail
	li $2 -1
	sge $2 $2 $0
	bnez $2 fail

	sge $4 $0 0
	beqz $4 fail
	li $2 1
	sge $4 $0 1
	bnez $4 fail
	sge $4 $2 0
	beqz $4 fail
	li $2 -1
	sge $4 $0 -1
	beqz $4 fail
	sge $4 $2 0
	bnez $4 fail


	.data
sgeu_:	.asciiz "Testing SGEU\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 sgeu_
	syscall

	sgeu $4 $0 $0
	beqz $4 fail
	li $2 1
	sgeu $4 $0 $2
	bnez $4 fail
	sgeu $4 $2 $0
	beqz $4 fail
	li $2 -1
	sgeu $4 $0 $2
	bnez $4 fail
	sgeu $4 $2 $0
	beqz $4 fail

	sgeu $4 $0 0
	beqz $4 fail
	li $2 1
	sgeu $4 $0 1
	bnez $4 fail
	sgeu $4 $2 0
	beqz $4 fail
	li $2 -1
	sgeu $4 $0 -1
	bnez $4 fail
	sgeu $4 $2 0
	beqz $4 fail


	.data
sgt_:	.asciiz "Testing SGT\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 sgt_
	syscall

	sgt $4 $0 $0
	bnez $4 fail
	li $2 1
	sgt $4 $0 $2
	bnez $4 fail
	sgt $4 $2 $0
	beqz $4 fail
	li $2 -1
	sgt $4 $0 $2
	beqz $4 fail
	sgt $4 $2 $0
	bnez $4 fail

	sgt $4 $0 0
	bnez $4 fail
	sgt $4 $0 1
	bnez $4 fail
	li $2 1
	sgt $4 $2 0
	beqz $4 fail
	sgt $4 $0 -1
	beqz $4 fail
	li $2 -1
	sgt $4 $2 0
	bnez $4 fail


	.data
sgtu_:	.asciiz "Testing SGTU\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 sgtu_
	syscall

	sgtu $4 $0 $0
	bnez $4 fail
	li $2 1
	sgtu $4 $0 $2
	bnez $4 fail
	sgtu $4 $2 $0
	beqz $4 fail
	li $2 -1
	sgtu $4 $0 $2
	bnez $4 fail
	sgtu $4 $2 $0
	beqz $4 fail

	sgtu $4 $0 0
	bnez $4 fail
	sgtu $4 $0 1
	bnez $4 fail
	li $2 1
	sgtu $4 $2 0
	beqz $4 fail
	sgtu $4 $0 -1
	bnez $4 fail
	li $2 -1
	sgtu $4 $2 0
	beqz $4 fail


	.data
sle_:	.asciiz "Testing SLE\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 sle_
	syscall

	sle $4 $0 $0
	beqz $4 fail
	li $2 1
	sle $4 $0 $2
	beqz $4 fail
	sle $4 $2 $0
	bnez $4 fail
	li $2 -1
	sle $4 $0 $2
	bnez $4 fail
	sle $4 $2 $0
	beqz $4 fail

	li $2 1
	sle $2 $0 $2
	beqz $2 fail
	li $2 1
	sle $2 $2 $0
	bnez $2 fail
	li $2 -1
	sle $2 $0 $2
	bnez $2 fail
	li $2 -1
	sle $2 $2 $0
	beqz $2 fail

	sle $4 $0 0
	beqz $4 fail
	li $2 1
	sle $4 $0 1
	beqz $4 fail
	sle $4 $2 0
	bnez $4 fail
	li $2 -1
	sle $4 $0 -1
	bnez $4 fail
	sle $4 $2 0
	beqz $4 fail


	.data
sleu_:	.asciiz "Testing SLEU\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 sleu_
	syscall

	sleu $4 $0 $0
	beqz $4 fail
	li $2 1
	sleu $4 $0 $2
	beqz $4 fail
	sleu $4 $2 $0
	bnez $4 fail
	li $2 -1
	sleu $4 $0 $2
	beqz $4 fail
	sleu $4 $2 $0
	bnez $4 fail

	sleu $4 $0 0
	beqz $4 fail
	li $2 1
	sleu $4 $0 1
	beqz $4 fail
	sleu $4 $2 0
	bnez $4 fail
	li $2 -1
	sleu $4 $0 -1
	beqz $4 fail
	sleu $4 $2 0
	bnez $4 fail


	.data
sne_:	.asciiz "Testing SNE\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 sne_
	syscall

	li $2 -1
	li $3 1

	sne $4 $0 $0
	bnez $4 fail
	sne $4 $2 $3
	beqz $4 fail

	sne $4 $0 0
	bnez $4 fail
	sne $4 $3 2
	beqz $4 fail


	.data
ulh_:	.asciiz "Testing ULH\n"
ulh1_:	.byte 1 2 3 4 5 6 7 8
ulh2_:	.byte 0xff 0xff
	.text

	li $v0 4	# syscall 4 (print_str)
	la $a0 ulh_
	syscall
	la $2 ulh1_
	ulh $3 0($2)
	bne $3 0x0102 fail
	ulh $3 1($2)
	bne $3 0x0203 fail
	ulh $3 2($2)
	bne $3 0x0304 fail
	ulh $3 3($2)
	bne $3 0x0405 fail
	ulh $3 4($2)
	bne $3 0x0506 fail
	la $2 ulh2_
	ulh $3 0($2)
	bne $3 -1 fail


	.data
ulhu_:	.asciiz "Testing ULHU\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 ulhu_
	syscall

	li $v0 4	# syscall 4 (print_str)
	la $a0 ulhu_
	syscall
	la $2 ulh1_
	ulhu $3 0($2)
	bne $3 0x0102 fail
	ulhu $3 1($2)
	bne $3 0x0203 fail
	ulhu $3 2($2)
	bne $3 0x0304 fail
	ulhu $3 3($2)
	bne $3 0x0405 fail
	ulhu $3 4($2)
	bne $3 0x0506 fail
	la $2 ulh2_
	ulhu $3 0($2)
	bne $3 0xffff fail


	.data
ulw_:	.asciiz "Testing ULW\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 ulw_
	syscall

	la $2 ulh1_
	ulw $3 0($2)
	bne $3 0x1020304 fail
	ulw $3 1($2)
	bne $3 0x2030405 fail
	ulw $3 2($2)
	bne $3 0x3040506 fail
	ulw $3 3($2)
	bne $3 0x4050607 fail


	.data
ush_:	.asciiz "Testing USH\n"
ushd:	.word 0 0
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 ush_
	syscall

	la $2 ushd
	sw $0 0($2)
	sw $0 4($2)
	li $3 -1
	ush $3 0($2)
	lw $4 0($2)
	bne $4 0xffff0000 fail
	lw $4 4($2)
	bne $4 0 fail

	sw $0 0($2)
	sw $0 4($2)
	li $3 -1
	ush $3 1($2)
	lw $4 0($2)
	bne $4 0xffff00 fail
	lw $4 4($2)
	bne $4 0 fail

	sw $0 0($2)
	sw $0 4($2)
	li $3 -1
	ush $3 2($2)
	lw $4 0($2)
	bne $4 0xffff fail
	lw $4 4($2)
	bne $4 0 fail

	sw $0 0($2)
	sw $0 4($2)
	li $3 -1
	ush $3 3($2)
	lw $4 0($2)
	bne $4 0xff fail
	lw $4 4($2)
	bne $4 0xff000000 fail


	.data
usw_:	.asciiz "Testing USW\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 usw_
	syscall

	la $2 ushd
	sw $0 0($2)
	sw $0 4($2)
	li $3 -1
	usw $3 0($2)
	lw $4 0($2)
	bne $4 -1 fail
	lw $4 4($2)
	bne $4 0 fail

	sw $0 0($2)
	sw $0 4($2)
	li $3 -1
	usw $3 1($2)
	lw $4 0($2)
	bne $4 0xffffff fail
	lw $4 4($2)
	bne $4 0xff000000 fail

	sw $0 0($2)
	sw $0 4($2)
	li $3 -1
	usw $3 2($2)
	lw $4 0($2)
	bne $4 0xffff fail
	lw $4 4($2)
	bne $4 0xffff0000 fail

	sw $0 0($2)
	sw $0 4($2)
	li $3 -1
	usw $3 3($2)
	lw $4 0($2)
	bne $4 0xff fail
	lw $4 4($2)
	bne $4 0xffffff00 fail

	.data
word_:	.asciiz "Testing .WORD\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 word_
	syscall

	.data
	.align 0
wordd:	.byte 0x1
	.word 0x87654320
	.word 0xfedcba90
	.text
	la $2 wordd
	lwr $3 1($2)
	lwl $3 0($2)
	bne $3 0x01876543 fail
	lwr $3 5($2)
	lwl $3 4($2)
	bne $3 0x20fedcba fail

	.data
	.byte 0
x:	.word OK	# Forward reference in unaligned data!
	.text
	lw $8 x
	beq $8 $0 fail
OK:


# Done !!!
	.data
sm:	.asciiz "\nPassed all tests\n"
	.text
	li $v0 4	# syscall 4 (print_str)
	la $a0 sm
	syscall
	lw $31 saved_ret_pc
	jr $31		# Return from main


	.data
fm:	.asciiz "Failed test\n"
	.text
fail:	li $v0 4	# syscall 4 (print_str)
	la $a0 fm
	syscall
	li $v0, 10	# syscall 10 (exit)
	syscall


	.text 0x408000
far_away:
	beq $0, $0, come_back
	beq $0, $0, come_back2

