// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: x11dev.h,v 1.3 1998/08/27 04:10:34 jgg Exp $
/* ######################################################################
   
   X11Dev - X Windows Device Interface
   
   This implements a Graphic Context and Input Method for the X11 GUI.
   It is based on raw XLib calls and does not use any part of Xt.
   
   The region manager's RegionData void* is really a Window type, and
   represents the window (region in our terms) attached to the widget.
   
   The graphic context caches X Fonts and X Color Cells to speed of
   processing of widget redraws. 

   XAttachDisplay will attempt to attach to the X server. If it fails
   0 will be returned and the client can attempt to initialize other 
   GUI types. Otherwise it will return an unrealized widget that 
   represents the X Root window. Upon realization this widget will aquire
   the Window(Region) of the Root window. It will also attach to the passed 
   select loop anything needed to accept input. It also initializes 
   GenGC::GC, GraphicGC::GC and XWindowsGC::GC with an instance of XWindowsGC.

   The correct use for the attach function is to call it, add any new
   widgets/callbacks/etc you need as children of it and then call Loop()
   on the select loop. With X Windows you MUST instantiate all top level 
   widgets with regions, Flag(Wf_Region).
   
   ###################################################################### */
									/*}}}*/
// Header section: deity
#ifndef DEITY_X11DEV_H
#define DEITY_X11DEV_H

#ifdef __GNUG__
#pragma interface "deity/x11dev.h"
#endif  

#include <deity/graphics.h>
#include <deity/selectloop.h>
#include <X11/Xlib.h>

class Widget;

class XWindowsGC : public GraphicGC
{
   // Cursed g++, this should read
   // ::GC *CurGC;
   _XGC *CurGC;
   
   Window CurWin;
   Rect Clip;
   unsigned long ForeColor;
   unsigned long BackColor;
   XFontStruct *XFont;
   SimpleFont CurFont;

   // Colormap stuff
   bool Paletted;
   Colormap PrivColors;
   XColor CMapValues[256];
   bool CMapUsed[256];
   
   // Cache structures
   struct FontData
   {
      XFontStruct *XFont;
      SimpleFont Font;
   };
   FontData FontCache[10];
   struct ColorData
   {
      Color Clr;
      unsigned long Pix;
   };
   ColorData ColorCache[20];
   int LastColorInsert;
   
   // Private XPM cache class
   class XPMData;
   class XPMPreload;
   friend XPMData;
   
   protected:
   
   // Clipping
   virtual void ClipRect(Rect Win);

   // Misc utils
   unsigned long MatchColor(Color C);
   Rect TextTranslate(Point &P,const char *Start,unsigned int Len,
		      unsigned long Flags);
   XPMData *GetXPMData(XPMImage &Image);
   
   public:
   
   static XWindowsGC *GC;
   
   // X Info
   void *ResizeBlock;
   Display *XDisplay;
   inline operator Display *() {return XDisplay;};
   
   // Region things
   virtual void *CreateRegion(Widget *For,void *Parent);
   virtual void AttachRegion(void *Region);
   virtual void DeleteRegion(void *Region);
   virtual void ResizeRegion(Widget *For,void *Region,Rect Size);
   virtual void SetTitle(void *Region,const char *Title,const char *Icon = 0);
   virtual void GrabMouse(void *Region);
      
   // Colors
   virtual void SetColor(Color C);
   virtual void Background(Color C);
   
   // Fonts
   virtual bool SetFont(SimpleFont Font);
   virtual Rect ExtentText(const char *Start,unsigned int Len);
   virtual void DrawText(Point Pos,const char *Start,unsigned int Len,unsigned long Flags = 0);
   virtual void DrawText(Rect Pos,Point Pos,const char *Start,unsigned int Len,unsigned long Flags = 0);
   virtual void DrawTextT(Point Pos,const char *Start,unsigned int Len,unsigned long Flags = 0);
   virtual unsigned int WrapText(const char *Start,unsigned int Len,long Max);

   // General
   virtual void Flush();
   virtual void Fill(Rect Area);
   virtual void BFill(Rect Area);

   // Bitmaps
   virtual void DrawBitmap(Point Pos,XPMImage &Image,unsigned long Flags = 0);
   virtual void DrawBitmap(Rect Pos,Point Pos,XPMImage &Image,unsigned long Flags = 0);
   virtual void DrawBitmapT(Point Pos,XPMImage &Image,unsigned long Flags = 0);
   virtual bool ImagePreload(XPMImage &Image);
   
   // Highlevel drawing
   virtual void Box3d(Rect Box,Color Ul,Color Lr,Color Fill,unsigned long Width);
   virtual void Line(Point Start,Point Stop);

   XWindowsGC();
   virtual ~XWindowsGC();
};

class XWindowsFd : public SelectLoop::Fd
{
   protected:
   
   // Widget to use as the top of the widget tree
   Widget *Root;
   Point LastPos;
   bool Click;
   
   virtual bool Read(SelectLoop &Owner);
   void Setup(SelectLoop &Owner);
   Widget *LocateWidget(void *Region);
   void TranslateKey(const XEvent &ev);
   void TranslateMouse(const XEvent &ev);
   
   // Atoms
   Atom WMDeleteWindow;
   
   public:

   XWindowsFd(Widget *Root);
   virtual ~XWindowsFd();
};

// Attempt to initialize X windows mode
Widget *XAttachDisplay(SelectLoop &Loop);

#endif
