/*
 * Copyright (c) 1991-1994 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the Computer Systems
 *	Engineering Group at Lawrence Berkeley Laboratory.
 * 4. Neither the name of the University nor of the Laboratory may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * @(#) $Header: vu.h,v 1.8 96/03/16 13:12:55 van Exp $ (LBL)
 */

#ifndef vat_vu_h
#define vat_vu_h

#include "tkwidget.h"

class VUMeter : public TkWidget {
    public:
	VUMeter(const char* path,
		double scale, double lpfgain = .75, int width = 10);
	void set(double);
	virtual int command(int argc, const char*const* argv);
    protected:
	virtual void draw();
	virtual void update();
	virtual void resize();
	virtual double warp(double value) const = 0;

	double value_;		/* current (mean) level */
	double alpha_;		/* low-pass filter time constant */
    private:
	inline void rect(Display* dpy, Drawable win, GC gc,
			 int x0, int y0, int w, int h) const;

	double scale_;

	int barht_;
	int gap_;

	int nlevel_;		/* number of discrete levels (i.e., blocks) */
	int hot_level_;		/* blk number we display in VatVU.hot color */
	int topblk_;		/* index of topmost block displayed */
	int ntop_;
	int peak_;		/* top block for peak indicator */
	int peakcnt_;		/* hysteresis for peak indicator */
	int setpeak_;

	static GC bg_;
	static GC fg_;
	static GC gray_;
	static GC hot_;
};

class DBMeter : public VUMeter {
    public:
	DBMeter(const char* path,
		double scale, double lpfgain = .75, int width = 10);
    protected:
	virtual double warp(double value) const;
};

class LinearMeter : public VUMeter {
    public:
	LinearMeter(const char* path,
		    double scale, double lpfgain = .75, int width = 10);
    protected:
	virtual double warp(double value) const;
};

#endif
