# Construct IDE interface

proc utilmenu {name} {
  global params

# Add dummy for correct deleting
  $name add separator
  $name delete 1 last
  if {$params(Util) != {}} {
    $name add separator
    set i 1
    foreach l $params(Util) {
      $name add command -label "$i [lindex $l 0]" -underline 0 \
        -command "Util [expr $i -1]"
      incr i
    }
  }
}

proc SetPos {} {
  global params

  set x [expr [winfo rootx .]+10]
  set y [winfo rooty .]
  set params(dlg_geom) +$x+$y
  set params(x0) $x
  set params(y0) $y
  set params(default_geom) +$params(x0)+0
  debug $params(dlg_geom)
}

proc ButtonHint {w id} {
  global gparams params TXT

  if {$params(hint_active) == 0} return
  if {![winfo exists $w]} return
  set x [winfo rootx $w]
  set y [expr [winfo rooty $w]+[winfo height $w]]
  catch {destroy .hint}
  toplevel .hint -bg black -bd 2 -relief flat
  wm overrideredirect .hint 1
  wm geometry .hint +$x+$y
  label .hint.l -bg yellow
  if [info exists TXT($gparams(hlplan),$id)] {
    .hint.l configure -textvariable TXT($gparams(hlplan),$id)
  }
  pack .hint.l
}

proc DelButtonHint {} {
  global params

  set params(hint_active) 0
  catch {
    after cancel $params(af_post)
    after cancel $params(af_unpost)
    destroy .hint
  }
}

proc BindButtonHint {w s} {
  global params

  set params(hint_$w) $s
  bind $w <Enter> {
    set params(hint_active) 1
    set params(af_post) [after 1500 ButtonHint %W \"$params(hint_%W)\"]
    set params(af_unpost) [after 4500 DelButtonHint]
  }
  bind $w <Leave> {
    DelButtonHint
  }
}

proc HintButton {w bitmapfile args} {
  global params

  set cmd ""
  set hint ""
  set selectparam ""
  set paramname ""
  set configcmd "#none"
  foreach {opt val} $args {
    switch -- $opt {
      -command {set cmd $val}
      -hint { set hint $val}
      -selectparam {set selectparam $val}
      -configcmd {set configcmd $val}
      -paramname {set paramname $val}
      default { error "Wrong parameter $opt}
    }
  }
  frame $w -bd 1 -relief groove 
  button $w.b -bitmap @$params(icon_dir)/$bitmapfile -command $cmd -bd 0 \
    -pady 1 -relief flat -fg black -anchor w
  grid $w.b -row 0 -column 0 -sticky nsew
  grid columnconfigure $w 0 -weight 1
  bind $w.b <Button-3> $configcmd
  if {$selectparam != {}} {
    button $w.s -bitmap @$params(icon_dir)/down2.ico -bd 0 \
      -command [list SelectAction $w $selectparam] -relief flat -fg gray
    bind $w.s <Enter> {%W configure -fg black}
    bind $w.s <Leave> {%W configure -fg gray}
    bind $w.s <Button-3> $configcmd
    grid $w.s -row 0 -column 1 -sticky e -ipady 0
    bind $w.s <Enter> {
      %W config -relief raised
    }
    bind $w.s <Leave> {
      %W config -relief flat
    }
  }
  if {$paramname != {}} {
    button $w.l -textvariable params($paramname) -anchor w \
    -width 10 -command $cmd -bd 0 -pady 0 -padx 0 -relief flat
    grid $w.l -row 1 -column 0 -columnspan 2 -sticky ew -ipady 0
    bind $w.l <Button-3> $configcmd
  }
  set params(hint_$w) $hint
  BindButtonHint $w $hint
  BindButtonHint $w $hint
}

proc WaitHint {w id} {
  global gparams TXT

  set x [expr round([winfo rootx $w]+[winfo width $w]*0.4)]
  set y [expr round([winfo rooty $w]+[winfo height $w]*0.4)]
  toplevel .wait -bg red -bd 2 -relief raised
  wm overrideredirect .wait 1
  wm geometry .wait +$x+$y
  label .wait.l -font {Helvetica 20 bold} -bg red -fg white
  if [info exists TXT($gparams(hlplan),$id)] {
    .wait.l configure -textvariable TXT($gparams(hlplan),$id)
  }
  pack .wait.l
}

proc DelWaitHint {} {
  catch {destroy .wait}
}

proc showbuttons {} {
  global gparams

  if {$gparams(showicons)} {
    catch {
      grid .h -row 0 -column 0 -sticky ew
    }
  } else {
    catch {
      grid forget .h
    }
  }
}

proc showprimary {} {
  global gparams

  if {$gparams(showprimary)} {
    catch {
      grid .p -row 1 -column 0 -sticky ew
    }
  } else {
    catch {
      grid forget .p
    }
  }
}

proc showterm {} {
  global gparams

  if {$gparams(showout)} {
    catch {
      grid .term -row 2 -column 0 -sticky ew
    }
  } else {
    catch {
      grid forget .term
    }
  }
}
# Toplevel window
# +----------------------------------------+
# | Menubar .m                             |
# +----------------------------------------+
# | |Hotkey|Select| .h                     |
# | |   Info      |                        |
# +----------------------------------------+
# | Primary File .p                        |
# +----------------------------------------+
# | Terminal .t (80x25)                    |
# |                                        |
# |                                        |
# |                                        |
# +----------------------------------------+
#

proc ide {} {
  global params gparams SK

  wm title . TeXShell
  wm iconbitmap . @$params(icon_dir)/tex.ico
  wm protocol . WM_DELETE_WINDOW Exit
  option add *font {Helvetica 12 normal}
  # Regions
  frame .p -bd 1 -relief groove
  frame .h -bd 1 -relief groove
  text .term -width $gparams(termwidth) -height $gparams(termheight) \
    -font [list $gparams(font) $gparams(fontsize) $gparams(fontstyle)]
  grid .term -row 2 -column 0 -sticky nsew

  # Menubar
  menu .menubar -bd 1
  . config -menu .menubar
  foreach m {File Action Util Options} {
    set $m [menu .menubar.m$m -tearoff 0]
    .menubar add cascade -label $m -underline 0 -menu .menubar.m$m
  }
  set Help [menu .menubar.help -tearoff 0]
  .menubar add cascade -label Help -underline 0 -menu .menubar.help

  $File add command -label "Primary File..." -underline 0 \
    -accelerator $SK(primary) -command Primary
  $File add command -label "Edit Primary" -underline 1 \
    -accelerator $SK(editprim) -command EditPrim
  $File add command -label "Edit..." -underline 0 \
    -accelerator $SK(edit) \
    -command Edit
  $File add command -label "Structure..." -underline 0 -accelerator \
    $SK(project) -command Project
  $File add separator
  $File add command -label Quit -underline 1 -accelerator $SK(exit) \
    -command {Exit}

  $Action add command -label "Graphics" -accelerator $SK(graphic) \
    -command Graphic -underline 0
  $Action add command -label "Compose" -accelerator $SK(compose) \
    -command Compose -underline 0
  $Action add command -label "References" -accelerator $SK(ref) \
    -command Reference -underline 0
  $Action add command -label "View" -accelerator $SK(view) \
    -command View -underline 0
  $Action add command -label "Print" -accelerator $SK(print) \
    -command Print -underline 0
  $Action add command -label "Util" -accelerator $SK(util) \
    -command Util -underline 0
  $Action add command -label "Filter" -accelerator $SK(filter) \
    -command Filter -underline 0

  $Util add command -label "Kill Process" -underline 0 -command Kill  
  utilmenu $Util
  
  $Options add checkbutton -label "Show Toolbar" \
    -variable gparams(showicons) -command showbuttons -underline 5
  $Options add checkbutton -label "Show Primary" \
    -variable gparams(showprimary) -command showprimary -underline 5
  $Options add checkbutton -label "Show Output" -underline 0 \
    -variable gparams(showout) -command showterm
  $Options add separator
  $Options add command -label "Editor..." -accelerator {Esc+F3} \
    -underline 0 -command {selectparams Edit}
  $Options add command -label "Graphics..." -accelerator {Esc+F5} \
    -underline 0 -command {selectparams Graphic}
  $Options add command -label "Compose..." -accelerator {Esc+F6} \
    -underline 0 -command {selectparams Compose}
  $Options add command -label "References..." -accelerator {Esc+F7} \
    -underline 0 -command {selectparams Reference}
  $Options add command -label "View..." -accelerator {Esc+F8} \
    -underline 0 -command {selectparams View}
  $Options add command -label "Print..." -accelerator {Esc+F9} \
    -underline 2 -command {selectparams Print}
  $Options add command -label "Utils..." -accelerator {Esc+F11} \
    -underline 0 -command {selectparams Util}
  $Options add command -label "Filter..." -accelerator {Esc+F12} \
    -underline 0 -command {selectfilter}
  $Options add separator
  $Options add command -label "Global Settings..." \
    -underline 6 -command GlobalOptions
  $Options add command -label "Editor Settings..." \
    -underline 6 -command EditOptions
  $Options add command -label "Save as default" -underline 1 \
    -command {writeparams default}
  $Help add command -label "TeXShell..." -accelerator F1 -command {Help .}

  # Command Buttons
  #  proc HintButton {w bitmapfile cmd Edit selectparam paramname} 
  HintButton .h.fedit edit2.ico -command Edit -hint hintedit \
    -selectparam "Edit" -configcmd "selectparams Edit" -paramname Edit_name
  HintButton .h.fgraph graphic2.ico -command Graphic -hint hintgraphic \
    -selectparam "Graphic" -configcmd "selectparams Graphic" \
    -paramname Graphic_name
  HintButton .h.fcompose tex2.ico -command Compose -hint hintcompose \
    -selectparam "Compose" -configcmd "selectparams Compose" \
    -paramname Compose_name
  HintButton .h.fref ref2.ico -command Reference -hint hintreference \
    -selectparam "Reference" -configcmd "selectparams Reference" \
    -paramname Reference_name 
  HintButton .h.fview xdvi2.ico -command View -hint hintview \
    -selectparam "View" -configcmd "selectparams View" -paramname View_name
  HintButton .h.fprint printer2.ico -command Print -hint hintprint \
    -selectparam "Print" -configcmd "selectparams Print" -paramname Print_name
  HintButton .h.futil cat2.ico -command Util -hint hintutil \
    -selectparam "Util" -configcmd "selectparams Util" -paramname Util_name
  HintButton .h.ffilter filter.ico -command Filter -hint hintfilter \
    -selectparam Filter -configcmd "selectfilter" -paramname Filter_name
  HintButton .p.fhelp help2.ico -command {Help .} -hint hinthelp
  HintButton .p.fexit door2.ico -command Exit -hint hintquit
  pack .h.fedit .h.fgraph .h.fcompose .h.fref .h.fview .h.fprint \
    .h.futil .h.ffilter -fill both -side left -expand 1
  showbuttons
  showprimary

 # Primary file
  HintButton .p.bprimary primary.ico -command Primary -hint hintprimary
  label .p.d -textvariable params(Short_dir) -font fixed -bd 1 -relief sunken
  label .p.ls -text " / "
  label .p.f -textvariable params(Primary_file) -font fixed -bd 1 \
    -relief sunken
  HintButton .p.bstruct struct.ico -command Project -hint hintproject
  pack .p.bprimary .p.bstruct -side left -anchor n -fill y
  pack .p.d .p.ls .p.f -side left -padx 2 -pady 2 -fill y -anchor n
  pack .p.fexit -side right -anchor n -fill y
  pack .p.fhelp -side right -anchor n -fill y

  # Bindings
  GlobalBind
  bind .term <Button-1> "xfocus ."
  update

# Output window
  CreateTerm

  # Save dialog geometry
##  update
  # Save default window geometry

  update
  SetPos
  debug $params(dlg_geom)
  showterm
  focus -force .
}

proc GlobalBind {} {
  global B

  bind all $B(help) {Help %W}
  bind . $B(edit) {Edit}
  bind . $B(primary) {Primary}
  bind . $B(editprim) { EditPrim }
  bind . $B(project) {Project}
  bind . $B(graphic) {Graphic}
  bind . $B(compose) {Compose}
  bind . $B(ref) {Reference}
  bind . $B(view) {View}
  bind . $B(print) {Print}
  bind . $B(util) {Util}
  bind . $B(filter) {Filter}
  bind . $B(paredit) "selectparams Edit"
  bind . $B(pargraphic) "selectparams Graphic"
  bind . $B(parcompose) "selectparams Compose"
  bind . $B(parref) "selectparams Reference"
  bind . $B(parview) "selectparams View"
  bind . $B(parprint) "selectparams Print"
  bind . $B(parutil) "selectparams Util"
  bind . $B(parfilter) "selectfilter"
  bind . $B(selterm)  "xfocus ."
  bind . $B(exit) "Exit"
  bind . $B(editprim) "EditPrim"
  bind . <Alt-Key> {
    switch %A {
      x -
      X { Exit }
      0 {
        EditPrim
      }
      1 - 2 - 3 - 4 - 5 - 6 - 7 - 8 -
      9 {
        Edit %A
      }
    }
  }
  for {set i 1} {$i < 10} {incr i} {
    bind . $B(seled$i) "Edit $i"
  }
}
