proc EditOptReconfig {} {
  global gparams
  
  .term config -font \
    [list $gparams(font) $gparams(fontsize) $gparams(fontstyle)]
  for {set i 0} {$i < 10} {incr i} {
    if [winfo exists .t$i] {
      .t$i.text config -bg $gparams(bgnormal) -fg $gparams(fgnormal) \
        -insertbackground $gparams(fgnormal) \
        -font [list $gparams(font) $gparams(fontsize) $gparams(fontstyle)]
      .t$i.text tag configure comment -foreground $gparams(fgcomment)
      .t$i.text tag configure env -foreground $gparams(fgenv)
      .t$i.text tag configure repl -background $gparams(bgsearch) \
        -foreground $gparams(fgsearch)
    }
  }
}

proc EditOptSelFont {} {
  global editopt
  
  foreach l {normal comment search env} {
    .editopt.ls$l configure -font \
      [list $editopt(font) $editopt(fontsize) $editopt(fontstyle)]
  }
}

proc EditOptSelColor {par value} {
  global editopt
  
  set editopt($par$editopt(seltxt)) $value
  switch $editopt(seltxt) {
    comment -
    err -
    env {
      if {$par == "fg"} {
        .editopt.ls$editopt(seltxt) configure -$par $value
      }
    }
    search {
      .editopt.ls$editopt(seltxt) configure -$par $value
    }
    normal {
      .editopt.ls$editopt(seltxt) configure -$par $value
      if {$par == "bg"} {
        foreach l {comment env} {
          .editopt.ls$l configure -bg $value
	}
      }
    }
  }
}

proc EditOpt {} {
  global editopt gparams params

  set editopt(seltxt) normal
  set editopt(font) fixed
  set editopt(fontsize) 12
  set editopt(fontstyle) normal
  set editopt(wrap) 1
  set editopt(interval) 30
  set editopt(bak) 0
  set editopt(save) 1
  set editopt(fgnormal) #000000
  set editopt(bgnormal) #ffffff
  set editopt(fgcomment) #000000
  set editopt(bgcomment) #ffffff
  set editopt(fgerr) #ff0000
  set editopt(bgerr) #ffffff
  set editopt(fgenv) #000000
  set editopt(bgenv) #ffffff
  set editopt(fgsearch) #ffffff
  set editopt(bgsearch) #000000
  foreach p [array names gparams] {
    set editopt($p) $gparams($p)
  }

  toplevel .editopt
  wm title .editopt {Editor settings}
  wm geometry .editopt $params(dlg_geom)

  frame .editopt.fmisc -bd 1 -relief raised
  frame .editopt.ffont -bd 1 -relief raised
  frame .editopt.fcolor -bd 1 -relief raised
  frame .editopt.fsample -bd 1 -relief raised
  frame .editopt.fbuttons -bd 1 -relief raised
  pack .editopt.fmisc .editopt.ffont .editopt.fcolor .editopt.fsample \
    .editopt.fbuttons -side top -fill x -ipady 5
  
  # Misc
  
  checkbutton .editopt.bwrap -text "Auto Wrap" -anchor w \
    -variable editopt(wrap)
  checkbutton .editopt.bext  -text "Auto \\end{..}" -anchor w \
    -variable editopt(autoext)
  checkbutton .editopt.bbak  -text "BAK File" -anchor w \
    -variable editopt(bak)
  checkbutton .editopt.bsave -text "Autosave" -anchor w \
    -variable editopt(save)
  label .editopt.linterval -text "Autosave Interval \[s\]:"
  entry .editopt.einterval -width 4 -textvariable editopt(interval)
  grid configure .editopt.bwrap -in .editopt.fmisc -row 0 -column 0 -sticky w
  grid configure .editopt.bext -in .editopt.fmisc -row 0 -column 1 -sticky w
  grid configure .editopt.bbak -in .editopt.fmisc -row 1 -column 0 -sticky w
  grid configure .editopt.bsave -in .editopt.fmisc -row 2 -column 0 -sticky w
  grid configure .editopt.linterval -in .editopt.fmisc -row 1 -column 1 \
    -sticky w
  grid configure .editopt.einterval -in .editopt.fmisc -row 2 -column 1 \
    -sticky w

  # Font
  label .editopt.lfont -text "Font:"
  ts_optionMenu .editopt.bfont editopt(font) EditOptSelFont fixed courier
  grid .editopt.lfont -in .editopt.ffont -row 0 -column 0
  grid .editopt.bfont -in .editopt.ffont -row 1 -column 0
  label .editopt.lfsize -text "Size:"
  ts_optionMenu .editopt.bfsize editopt(fontsize) EditOptSelFont 10 12 14 16 18
  grid .editopt.lfsize -in .editopt.ffont -row 0 -column 1
  grid .editopt.bfsize -in .editopt.ffont -row 1 -column 1
  label .editopt.lfstyle -text "Style:"
  ts_optionMenu .editopt.bfstyle editopt(fontstyle) EditOptSelFont normal italic bold
  grid .editopt.lfstyle -in .editopt.ffont -row 0 -column 2
  grid .editopt.bfstyle -in .editopt.ffont -row 1 -column 2
 
  # Colors
  set i 0
  for {set row 0} {$row < 8} {incr row} {
    for {set col 0} {$col < 8} {incr col} {
      set b [expr ($row/2)*85]
      set g [expr ($col%4)*85]
      set r [expr (($row%2)*2+$col/4)*85]
      frame .editopt.ffg$i -width 10 -height 10 \
        -background [format {#%02x%02x%02x} \
        $r $g $b] -bd 1 -relief raised
      bind .editopt.ffg$i <1> {EditOptSelColor fg [%W cget -bg]}
      grid configure .editopt.ffg$i -column $col -row $row \
        -in .editopt.fcolor
      frame .editopt.fbg$i -width 10 -height 10 \
        -background [format {#%02x%02x%02x} \
        $r $g $b] -bd 1 -relief raised
      bind .editopt.fbg$i <1> {EditOptSelColor bg [%W cget -bg]}
      grid configure .editopt.fbg$i -column [expr $col+9] -row $row \
        -in .editopt.fcolor
      incr i
    }
  }
  label .editopt.lfg -text "Foreground"
  label .editopt.lbg -text "Background"
  grid configure .editopt.lfg -in .editopt.fcolor -row 8 -col 0 -columnspan 8 \
    -sticky w
  grid configure .editopt.lbg -in .editopt.fcolor -row 8 -col 9 -columnspan 8 \
    -sticky w
  frame .editopt.fcdummy -width 20
  grid configure .editopt.fcdummy -row 0 -col 8 -in .editopt.fcolor -sticky we
  grid columnconfigure .editopt.fcolor 8 -weight 1
   
  # Sample
  radiobutton .editopt.bsnormal -text Normal -variable editopt(seltxt) \
    -value normal
  label .editopt.lsnormal -text "Normal text line" -anchor w \
    -bg $editopt(bgnormal) -fg $editopt(fgnormal)
  radiobutton .editopt.bscomment -text Comment -variable editopt(seltxt) \
    -value comment
  label .editopt.lscomment -text "% A Comment line" -anchor w \
    -bg $editopt(bgnormal) -fg $editopt(fgcomment)
  radiobutton .editopt.bserr -text Mistake -variable editopt(seltxt) \
    -value err
  label .editopt.lserr -text "A misteke" -anchor w \
    -bg $editopt(bgnormal) -fg $editopt(fgerr)
  radiobutton .editopt.bsenv -text "\\begin/end" -variable editopt(seltxt) \
    -value env
  label .editopt.lsenv -text "\\begin\{...\}" -anchor w \
    -bg $editopt(bgnormal) -fg $editopt(fgenv)
  radiobutton .editopt.bssearch -text Search -variable editopt(seltxt) \
    -value search
  label .editopt.lssearch -text "Search text" -anchor w \
    -bg $editopt(bgsearch) -fg $editopt(fgsearch)
  grid configure .editopt.bsnormal -in .editopt.fsample -row 0 -column 0 \
    -sticky w
  grid configure .editopt.lsnormal -in .editopt.fsample -row 0 -column 1 \
    -sticky we
  grid configure .editopt.bscomment -in .editopt.fsample -row 1 -column 0 \
    -sticky w
  grid configure .editopt.lscomment -in .editopt.fsample -row 1 -column 1 \
    -sticky we
  grid configure .editopt.bserr -in .editopt.fsample -row 2 -column 0 \
    -sticky w
  grid configure .editopt.lserr -in .editopt.fsample -row 2 -column 1 \
    -sticky we
  grid configure .editopt.bsenv -in .editopt.fsample -row 3 -column 0 \
    -sticky w
  grid configure .editopt.lsenv -in .editopt.fsample -row 3 -column 1 \
    -sticky we
  grid configure .editopt.bssearch -in .editopt.fsample -row 4 -column 0 \
    -sticky w
  grid configure .editopt.lssearch -in .editopt.fsample -row 4 -column 1 \
    -sticky we
  grid columnconfigure .editopt.fsample 1 -weight 1

  # Buttons
  button .editopt.bok -text OK -command {set editopt(ok) 1}
  pack .editopt.bok -in .editopt.fbuttons -side left -padx 10 -pady 5
  button .editopt.bcancel -text Cancel -command {set editopt(ok) 0}
  pack .editopt.bcancel -in .editopt.fbuttons -side left -padx 10 -pady 5

  EditOptSelFont
  set editopt(oldfocus) [focus]
  focus .editopt
  grab .editopt
  tkwait variable editopt(ok)
  if {$editopt(ok)} {
    foreach p {wrap autoext bak save interval font fontsize fontstyle
      fgnormal bgnormal fgcomment bgcomment fgsearch bgsearch fgenv bgenv 
      fgerr} {
      set gparams($p) $editopt($p)
    }
    EditOptReconfig
  }
  grab release .editopt
  focus $editopt(oldfocus)
  destroy .editopt
}
