/* # skkinput (Simple Kana-Kanji Input)
 * draw.c --- Draw cursor, draw fonts, ... 
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#include "config.h"
#include "commondef.h"
#include "buffers.h"
#include "draw.h"

/*
 * ץȥ
 */
int myCharTextWidth
( struct skkinputManagedFont **fontset, struct myChar *wstring, int num ) ;

/*
 * Хѿ
 */
static char *skkinput_ModelineStrings
[ NUMBER_OF_MODELINE ] = {
  "SKK:", "", "", "",
} ;
/* νˤäư㤦⡼ɥ饤*/
static char *skkinput_ModelineStringsJisyo
[ NUMBER_OF_MODELINE_JISYO ] = {
  "-", "*", 
} ;

static char *skkinput_ModelineStringsOverTheSpot
[ NUMBER_OF_MODELINE_OVERTHESPOT ] = {
  "*",	/* !OverSpot */
  "-",	/*  OverSpot */
} ;

/*
 * skkinput λꤵ줿˥饯ɽؿ
 *----
 * flag ϽŤ͹碌Ԥɤɽ˴ط롣
 * ȿžɽ򤹤뤫ɤϡgc ǻꤹ뤳ȤˤʤäƤ롣
 */
int skkwin_jputchar
( Display *disp, Window win, struct skkinputManagedFont **fontset,
  GC gc, int x, int y, int chara, int flag )
{
  XFontStruct *font ;
  XChar2b wchara ;
  char schara ;

  if( chara > 0x100 && fontset[ CHARSET_JISX0208_1983 ] != NULL ){
    /* ʸɽ*/
    wchara.byte1 = ( chara & 0x07F00 ) >> 8 ;
    wchara.byte2 = ( chara & 0x0007F ) ;
    font = ( fontset[ CHARSET_JISX0208_1983 ] )->font ;
    XSetFont( disp, gc, font->fid ) ;
    if( flag ){
      XDrawString16( disp, win, gc, x, y, &wchara, 1 ) ;
    } else {
      XDrawImageString16( disp, win, gc, x, y, &wchara, 1 ) ;
    }
    x += XTextWidth16( font, &wchara, 1 ) ;
  } else if( fontset[ CHARSET_ASCII ] != NULL ){
    font = ( fontset[ CHARSET_ASCII ] )->font ;
    XSetFont( disp, gc, font->fid ) ;
    schara = chara ;
    if( flag ){
      XDrawString( disp, win, gc, x, y, &schara, 1 ) ;
    } else {
      XDrawImageString( disp, win, gc, x, y, &schara, 1 ) ;
    }
    x += XTextWidth( font, &schara, 1 ) ;
  } else {
    x += DEFAULT_TOFU_WIDTH ;
  }
  return x ;
}

/*
 * skk window ʸõؿ
 *----
 * x, y Ϻɸ
 */
void skkwin_jerase
( Display *disp, Window win, GC gc, int x, int y,
  int font_ascent, int width, int height )
{
  XFillRectangle
    ( disp, win, gc, x, y - font_ascent, width, height ) ;
  return ;
}

/*
 * skkinput λꤵ줿˥饯ɽؿ
 *----
 * flag ϽŤ͹碌ɽ뤫ɤĤɤ̤ѤƤ
 * ΤפФʤɡĥ֤Ǥʸɽ
 */
int skkwin_jputMyChar
( Display *disp, Window win, struct skkinputManagedFont **fontset,
  GC gc, GC rgc, int x, int y, struct myChar chara, 
  int font_height, int font_ascent, int flag )
{
  XFontStruct *font ;
  char schara ;
  XChar2b wchara ;
  int width ;

  if( fontset[ ( int )chara.charset ] == NULL )
    return ( x + DEFAULT_TOFU_WIDTH ) ;
  font = fontset[ ( int )chara.charset ]->font ;
  XSetFont( disp, gc, font->fid ) ;
  switch( chara.charset ){
  case CHARSET_ISO8859_1 :
  case CHARSET_ISO8859_2 :
  case CHARSET_ISO8859_3 :
  case CHARSET_ISO8859_4 :
  case CHARSET_ISO8859_5 :
  case CHARSET_ISO8859_6 :
  case CHARSET_ISO8859_7 :
  case CHARSET_ISO8859_8 :
  case CHARSET_ISO8859_9 :
  case CHARSET_JISX0201_1976 :
    schara = chara.chara ;
    width = XTextWidth( font, &schara, 1 ) ;
    if( flag ){
      XDrawString( disp, win, gc, x, y, &schara, 1 ) ;
    } else {
      skkwin_jerase
	( disp, win, rgc, x, y, font_ascent, width, font_height ) ;
      XDrawImageString( disp, win, gc, x, y, &schara, 1 ) ;
    }
    break ;
  case CHARSET_JISX0208_1978 :
  case CHARSET_JISX0208_1983 :
  case CHARSET_JISX0212_1990 :
  case CHARSET_GB2312_1980 :
  case CHARSET_KSC5601_1987 :
    wchara.byte1 = chara.chara >> 8 ;
    wchara.byte2 = chara.chara & 0x00FF ;
    width = XTextWidth16( font, &wchara, 1 ) ;
    if( flag ){
      XDrawString16( disp, win, gc, x, y, &wchara, 1 ) ;
    } else {
      skkwin_jerase
	( disp, win, rgc, x, y, font_ascent, width, font_height ) ;
      XDrawImageString16
	( disp, win, gc, x, y, &wchara, 1 ) ;
    }
    break ;
  default :
    return x ;
  }
  return ( x + width ) ;
}

/*
 * ꤵ줿ɥλꤵ줿֤ʸɽؿ
 *----
 * ưԤϤʤΤǡեȤξ󤷤Ϥʤ
 */
int skkwin_jputstring
( Display *disp, Window win, struct skkinputManagedFont **fontset,
  GC gc, int x, int y, struct myChar *text )
{
  XFontStruct *font = NULL ;
  char schara ;
  XChar2b wchara ;
  int width ;

  for( ; !IS_END_OF_STRING( *text ) ; text ++ ){
    if( fontset[ ( int )text->charset ] == NULL )
      continue ;
    if( font != fontset[ ( int )text->charset ]->font ){
      /* ˤ XSetFont ʤΤǡƱʤȤʤ*/
      font = fontset[ ( int )text->charset ]->font ;
      XSetFont( disp, gc, font->fid ) ;
    }
    width = myCharTextWidth( fontset, text, 1 ) ;
    switch( text->charset ){
    case CHARSET_ISO8859_1 :
    case CHARSET_ISO8859_2 :
    case CHARSET_ISO8859_3 :
    case CHARSET_ISO8859_4 :
    case CHARSET_ISO8859_5 :
    case CHARSET_ISO8859_6 :
    case CHARSET_ISO8859_7 :
    case CHARSET_ISO8859_8 :
    case CHARSET_ISO8859_9 :
    case CHARSET_JISX0201_1976 :
      schara = text->chara ;
      XDrawString( disp, win, gc, x, y, &schara, 1 ) ;
      break ;
    case CHARSET_JISX0208_1978 :
    case CHARSET_JISX0208_1983 :
    case CHARSET_JISX0212_1990 :
    case CHARSET_GB2312_1980 :
    case CHARSET_KSC5601_1987 :
      wchara.byte1 = text->chara >> 8 ;
      wchara.byte2 = text->chara & 0x00FF ;
      XDrawString16( disp, win, gc, x, y, &wchara, 1 ) ;
      break ;
    default :
      continue ;
    }
    x += width ;
  }
  return x ;
}

/*
 * ʬؿɽطνʤԵǽ̵
 *-----
 * Ϥ minibuffer ѤȤäޤ
 */
void skkwin_jdiffputstring
( Display *disp, Window win, struct skkinputManagedFont **fontset,
  GC gc, GC rgc, int x, int y, int width,
  struct myChar *text, struct myChar *ptext,
  int font_height, int font_ascent )
{
  int x1, x2 ;

  /* x1 ϸߤ x2 ʸɽ֤ˤʤäƤ롣*/
  x1 = x2 = x ;

  /* ĤʸӤ롣*/
  while( !IS_END_OF_STRING( *text ) && x1 < width ){
    if( x1 == x2 ){
      /* ξԤƱ֤ˤΤǡƱ charset Ʊ chara ʤ鸽
       * ߤξɽɬפϤʤ*/
      if( text->chara == ptext->chara ){
	/* chara Ʊäˤϡcharset ƱɤȽ̤
	 * 롣chara 㤨Сcharset ɤ졢ƱʸǤ뤳
	 * Ϥʤ(ȡ롪) */
	if( text->charset == ptext->charset ){
	  x1 += myCharTextWidth( fontset, text,  1 ) ;
	  x2 += myCharTextWidth( fontset, ptext, 1 ) ;
	  text ++ ;
	  ptext ++ ;
	  continue ;
	}
	/* ޤ continue Ƥʤä顢ۤʤʸä
	 * Ȥˤʤ롣*/
      }
    } else if( x1 > x2 ){
      /* ʸκǸޤƤˤϡ̵Ѥ text ɽ
       * ߤɤĤޤԤäƤޤΤǡ㲽*/
      if( IS_END_OF_STRING( *ptext ) ){
	x2 = width ;
	continue ;
      }
      x2 += myCharTextWidth( fontset, ptext, 1 ) ;
      ptext ++ ;
      continue ;
    }
    /* ɽʸԤƤޤäˤ̵ѤǺ
     * 褷ɤޤcharset  chara ۤʤäƤˤ⤳
     * ä뤳Ȥˤʤ롣*/
    skkwin_jputMyChar
      ( disp, win, fontset, gc, rgc, 
	x1, y, *text, font_height, font_ascent, False ) ;
    x1 += myCharTextWidth( fontset, text, 1 ) ;
    text ++ ;
  }
  /* ̰դޤɽƤΤǾõȤɬ̵*/
  /* ⤷ɽ˻ȤäʬĶɽƤΤǡ*/
  if( x1 >= width || IS_END_OF_STRING( *ptext ) )
    return ;
  /* 񤭤Ƥʤ褷ʬõ롣*/
  XFillRectangle
    ( disp, win, rgc, x1, y - font_ascent, width - x1, font_height ) ;
  return ;
}

/*
 * ɽؿ
 *----
 * int kf : ե饰EUC ɤʤ True ˤʤ롣
 */
void skkinputDrawCursor
( Display *disp, Window win, GC roman_ngc, GC roman_rgc, 
  int x, int y, int font_ascent, int width, int height, int is_focus )
{
  /* ɽ롣*/
  if( is_focus ){
    XFillRectangle
      ( disp, win, roman_ngc,
	x, y - font_ascent + 1, width - 1, height - 1 ) ;
  } else {
    XFillRectangle
      ( disp, win, roman_rgc,
	x, y - font_ascent + 1, width - 1, height - 1 ) ;
    XDrawRectangle
      ( disp, win, roman_ngc,
	x, y - font_ascent + 1, width - 1, height - 2 ) ;
  }
  return ;
}

/*
 *
 */
void OTSW_CalcTopPositionOfBuffer
( struct skkinputManagedFont **fontset,
  struct myChar *linetop, int linetop_pos, int cur_pos,
  int client_width, struct myChar **ret_toptext, int *ret_toppos )
{
  struct myChar *text, *toptext ;
  int toppos, pos, x, xdiff ;
  
  text    = linetop ;
  pos     = linetop_pos ;
  toppos  = linetop_pos ;
  toptext = linetop ;
  x       = 0 ;

  while( !IS_END_OF_STRING( *text ) ){
    /* ԥɤʤ鼡ΰ֤˽롣*/
    if( IS_ASCII_EQUAL( *text, '\n' ) ){
      /* ֤դȽȴ롣*/
      if( pos == cur_pos )
	break ;
      toppos  = pos  + 1 ;
      toptext = text + 1 ;
      x       = 0 ;
    } else {
      /* charset Ƚ̤Ȥˤեη׻*/
      xdiff = myCharTextWidth( fontset, text, 1 ) ;
      x += xdiff ;
      /* Ԥ뤫ݤȽǡ*/
      if( x >= client_width ){
	toppos  = pos ;
	toptext = text ;
	x       = xdiff ;
      }
      /* ֤դȽȴ롣*/
      if( pos == cur_pos )
	break ;
    }
    pos ++ ;
    text ++ ;
  }
  *ret_toptext = toptext ;
  *ret_toppos  = toppos ;
  return ;
}

/*
 * ȥåץХåեΰ־ιԤɽؿ
 *----
 * դǵ㤭Ȥ()
 */
void OTSW_FullDrawTopBufferTopLine
( Display *disp, Window win, struct skkinputManagedFont **fontset,
  GC gc, GC rgc, struct myChar *text, int text_pos,
  int font_ascent, int font_height, int width, int bsflag, 
  int cursor_width, int cur_pos, int cur_exist, int is_focus )
{
  int x = 0, xdiff = 0 ;
  int cursor_flag = False ;
  
  /* ʤäν*/
  for( ; !IS_END_OF_STRING( *text ) && x < width ; text ++, text_pos ++ ){
    /* charset Ƚ̤Ȥˤեη׻*/
    xdiff = myCharTextWidth( fontset, text, 1 ) ;
    /* ɽʤΤɤȽꤹ롣*/
    if( text_pos == cur_pos && cur_exist ){
      if( !bsflag || ( x + xdiff ) < width ){
	skkinputDrawCursor
	  ( disp, win, gc, rgc,
	    x, font_ascent, font_ascent, xdiff,
	    font_height, is_focus ) ;
	cursor_flag = True ;
      }
    }
    /* ̤αüޤ褷ΤɤȽǤ롣*/
    if( ( x + xdiff ) >= width && bsflag ){
      XDrawLine( disp, win, gc, x, 0, width, font_height ) ;
      /* ɽʤΤǡԡϤʤλ*/
      return ;
    }
    /* ԥɤɤˤϡǽ롣*/
    if( IS_ASCII_EQUAL( *text, '\n' ) )
      return ;
    if( cursor_flag ){
      if( is_focus ){
	skkwin_jputMyChar
	  ( disp, win, fontset, rgc, gc,
	    x, font_ascent, *text, font_height, font_ascent, True ) ;
      } else {
	skkwin_jputMyChar
	  ( disp, win, fontset, gc, rgc, 
	    x, font_ascent, *text, font_height, font_ascent, True ) ;
      }
      cursor_flag = False ;
    } else {
      skkwin_jputMyChar
	( disp, win, fontset, gc, rgc,
	  x, font_ascent, *text, font_height, font_ascent, False ) ;
    }
    x += xdiff ;
  }
  /* 뤬ƥȤθ¸ߤ硣*/
  if( cur_exist && text_pos == cur_pos ){
    if( ( !bsflag || ( x + xdiff ) < width ) ){
      skkinputDrawCursor
	( disp, win, gc, rgc,
	  x, font_ascent, font_ascent,
	  cursor_width, font_height, is_focus ) ;
    } else {
      XDrawLine( disp, win, gc, x, 0, width, font_height ) ;
    }
  }
  return ;
}


/*
 * cur_line != NULL ʤСΤä꤬ܤǤ뤫֤
 */
int skkinput_GetLineNum
( struct skkinputManagedFont **fontset, struct myChar *text,
  unsigned int width,  int cursor_width, int cur_pos, int *cur_line )
{
  int num, cur_num, x, y, pos, xdiff ;
  struct myChar *ptr ;

  /* ɽѿν*/
  x = y = pos = cur_num = num = 0 ;
  /* 롼ס*/
  for( ptr = text ; !IS_END_OF_STRING( *ptr ) ; ptr ++, pos ++ ){
    if( IS_ASCII_EQUAL( *ptr, '\n' ) ){
      /* ֤򵭲롣*/
      if( pos == cur_pos )
	cur_num = num ;
      x = 0 ;
      num ++ ;
    } else {
      xdiff = myCharTextWidth( fontset, ptr, 1 ) ;
      x += xdiff ;
      if( x >= width ){
	x = xdiff ;
	num ++ ;
      }
      /* ֤򵭲롣*/
      if( pos == cur_pos )
	cur_num = num ;
    }
  }
  /* ̤˥ȯƤʤ硣*/
  if( pos <= cur_pos ){
    if( ( x + cursor_width ) > width )
      num ++ ;
    cur_num = num ;
  }
  /* ΰ֤֤Τʡ */
  if( cur_line != NULL )
    *cur_line = cur_num ;
  return num ;
}

/*
 * ɽ٤ΰ礭ʬäƤʸβΰ֤ɽ
 * 뤫ؿ
 */
int skkinput_FindStartLine
( struct skkinputManagedFont **fontset, struct myChar *text, 
  int startline, unsigned int width )
{
  int x, pos, xdiff ;
  struct myChar *ptr ;

  /* ɽѿν*/
  x = pos = 0 ;
  ptr = text ;
  /* 롼ס*/
  while( startline > 0 && !IS_END_OF_STRING( *ptr ) ){
    if( IS_ASCII_EQUAL( *ptr, '\n' ) ){
      x = 0 ;
      startline -- ;
    } else {
      xdiff = myCharTextWidth( fontset, ptr, 1 ) ;
      x += xdiff ;
      if( x >= width ){
	x = xdiff ;
	startline -- ;
	if( startline <= 0 )
	  break ;
      }
    }
    ptr ++ ; pos ++ ;
  }
  return pos ;
}

/*
 * Window manager ξ񴹤ؿ
 */
void XChangeWMNormalHints
( Display *disp, Window win, XSizeHints *hints )
{
  XSizeHints sizehints ;
  long supplied ;

  /* Window Manager ˥ҥȤäƤ롣XSetWMNormalHints * 
   * ʬ񴹤ʤ褦ʤΤǡ hints ɤߤȤäƤ麹*
   * ؤȤˡȤʤФʤʤ*/
  XGetWMNormalHints
    ( disp, win, &sizehints, &supplied ) ;
  /*
   * 顢ե饰򸫤ƽȤȤԤ
   */

  /* ɥɽ֤θ򲿽ˤȤ뤫*/
  if( hints->flags & PWinGravity ){
    sizehints.flags |= PWinGravity ;
    sizehints.win_gravity = hints->win_gravity ;
  }
  /* ɥΥ١ꡣ*/
  if( hints->flags & PBaseSize ){
    sizehints.flags |= PBaseSize ;
    sizehints.base_width  = hints->base_width ;
    sizehints.base_height = hints->base_height ;
  }
  /* ɥκǾ礭ꡣ*/
  if( hints->flags & PMinSize ){
    sizehints.flags |= PMinSize ;
    sizehints.min_width  = hints->min_width ;
    sizehints.min_height = hints->min_height ;
  }
  /* ɥκ礭ꡣ*/
  if( hints->flags & PMaxSize ){
    sizehints.flags |= PMaxSize ;
    sizehints.max_width  = hints->max_width ;
    sizehints.max_height = hints->max_height ;
  }
  /* ɥʬ(Ѳ)ꡣ*/
  if( hints->flags & PResizeInc ){
    sizehints.flags |= PResizeInc ;
    sizehints.width_inc  = hints->width_inc ;
    sizehints.height_inc = hints->height_inc ;
  }
  /* ꤹ롣*/
  XSetWMNormalHints( disp, win, &sizehints ) ;
  return ;
}

/*
 * ꤵ줿礭֤ξ XRectangle ¤Τ֤ؿ
 */
void XGetRectangleOfWindow( Display *disp, Window win, XRectangle *area )
{
  Window rootwin ;
  int x, y ;
  unsigned int border_width, depth_size, height, width ;
  
  XGetGeometry
    ( disp, win,
      &rootwin, &x, &y, &width, &height,
      &border_width, &depth_size ) ;
  area->x = ( short )x ;
  area->y = ( short )y ;
  area->width  = ( unsigned short )width ;
  area->height = ( unsigned short )height ;
  return ;
}

/*
 * Ϥ줿 skkinput Υ⡼ɥ饤󤬲ǤΤĴ٤ؿ
 */
int skkinput_GetModelineNumber( struct SKKInputNode *node )
{
  int modeline ;
  /* ̾ϥ⡼ɤʤΡ ǤϤʤΡ */
  if( !node->j_mode ){
    /* ϥ⡼ɤʤΡ Ⱦϥ⡼ɤʤΡ */
    if( node->j_zenkaku ){
      modeline = MODELINE_ZENKAKU ;
    } else {
      modeline = MODELINE_HANKAKU ;
    }
  } else {
    /* Ҳ̾ϥ⡼ɤʤΡ ʿ̾ϥ⡼ɤʤΡ */
    if( node->j_katakana_mode ){
      modeline = MODELINE_KATAKANA ;
    } else {
      modeline = MODELINE_KANA ;
    }
  }
  return modeline ;
}

/*
 * ܸ Extended Unix Code ʤʸɽؿ
 *---
 */
int skkwin_jputCharString
( Display *disp, Window win, struct skkinputManagedFont **fontset,
  GC gc, int x, int y, unsigned char *text )
{
  XFontStruct *font = NULL ;
  XChar2b wchara ;

  for( ; *text != '\0' ; ){
    if( ( *text ) & 0x80 ){
      switch( *text ){
      case 0x8E :
	text ++ ;
	if( fontset[ CHARSET_JISX0201_1976 ] != NULL ){
	  if( font != fontset[ CHARSET_JISX0201_1976 ]->font ){
	    font = fontset[ CHARSET_JISX0201_1976 ]->font ;
	    XSetFont( disp, gc, font->fid ) ;
	  }
	  XDrawString( disp, win, gc, x, y, text, 1 ) ;
	  x += XTextWidth( font, text, 1 ) ;
	} else {
	  x += DEFAULT_TOFU_WIDTH ;
	} 
	text ++ ;
	break ;
      case 0x8F :
	text ++ ;
	if( fontset[ CHARSET_JISX0212_1990 ] != NULL ){
	  if( font != fontset[ CHARSET_JISX0212_1990 ]->font ){
	    font = fontset[ CHARSET_JISX0212_1990 ]->font ;
	    XSetFont( disp, gc, font->fid ) ;
	  }
	  wchara.byte1 = ( text[ 0 ] ) & 0x7F ;
	  wchara.byte2 = ( text[ 1 ] ) & 0x7F ;
	  XDrawString16
	    ( disp, win, gc, x, y, &wchara, 1 ) ;
	  x += XTextWidth16( font, &wchara, 1 ) ;
	} else {
	  x += DEFAULT_TOFU_WIDTH ;
	}
	text ++ ;
	text ++ ;
	break ;
      default :
	if( fontset[ CHARSET_JISX0208_1983 ] != NULL ){
	  if( font != fontset[ CHARSET_JISX0208_1983 ]->font ){
	    font = fontset[ CHARSET_JISX0208_1983 ]->font ;
	    XSetFont( disp, gc, font->fid ) ;
	  }
	  wchara.byte1 = ( text[ 0 ] ) & 0x7F ;
	  wchara.byte2 = ( text[ 1 ] ) & 0x7F ;
	  XDrawString16( disp, win, gc, x, y, &wchara, 1 ) ;
	  x += XTextWidth16( font, &wchara, 1 ) ;
	} else {
	  x += DEFAULT_TOFU_WIDTH ;
	}
	text ++ ;
	text ++ ;
	break ;
      }
    } else {
      if( fontset[ CHARSET_ASCII ] != NULL ){
	if( font != fontset[ CHARSET_ASCII ]->font ){
	  font = fontset[ CHARSET_ASCII ]->font ;
	  XSetFont( disp, gc, font->fid ) ;
	}
	XDrawString( disp, win, gc, x, y, text, 1 ) ;
	x += XTextWidth( font, text, 1 ) ;
      } else {
	x += DEFAULT_TOFU_WIDTH ;
      }
      text ++ ;
    }
  }
  return x ;
}

/*
 * ƥȤɽΤɬפ(width)ؿ
 */
int skkwin_charTextWidth
( struct skkinputManagedFont **fontset, unsigned char *string, int num )
{
  XChar2b wchara ;
  int width ;

  width = 0 ;
  while( *string != '\0' && num > 0 ){
    if( ( *string ) & 0x80 ){
      wchara.byte1 = ( *string ++ ) & 0x7F ;
      num -- ;
      wchara.byte2 = ( *string ++ ) & 0x7F ;
      num -- ;
      if( fontset[ CHARSET_JISX0208_1983 ] != NULL ){
	width += XTextWidth16
	  ( fontset[ CHARSET_JISX0208_1983 ]->font, &wchara, 1 ) ;
      } else {
	width += DEFAULT_TOFU_WIDTH ;
      }
    } else {
      if( fontset[ CHARSET_ASCII ] != NULL ){
	width += XTextWidth
	  ( fontset[ CHARSET_ASCII ]->font, string, 1 ) ;
      } else {
	width += DEFAULT_TOFU_WIDTH ;
      }
      string ++ ;
      num -- ;
    }
  }
  return width ;
}

/*
 * ƥȤɽΤɬפ(width)ؿ
 */
int myCharTextWidth
( struct skkinputManagedFont **fontset, struct myChar *wstring, int num )
{
  char    schara ;
  XChar2b wchara ;
  int width ;

  width = 0 ;
  while( num > 0 && !IS_END_OF_STRING( *wstring ) ){
    if( fontset[ ( int )wstring->charset ] != NULL ){
      switch( wstring->charset ){
      case CHARSET_ISO8859_1 :
      case CHARSET_ISO8859_2 :
      case CHARSET_ISO8859_3 :
      case CHARSET_ISO8859_4 :
      case CHARSET_ISO8859_5 :
      case CHARSET_ISO8859_6 :
      case CHARSET_ISO8859_7 :
      case CHARSET_ISO8859_8 :
      case CHARSET_ISO8859_9 :
      case CHARSET_JISX0201_1976 :
	schara = wstring->chara ;
	width += XTextWidth
	  ( fontset[ ( int )wstring->charset ]->font, &schara, 1 ) ;
	break ;
      case CHARSET_JISX0208_1978 :
      case CHARSET_JISX0208_1983 :
      case CHARSET_JISX0212_1990 :
      case CHARSET_GB2312_1980 :
      case CHARSET_KSC5601_1987 :
	wchara.byte1 = ( wstring->chara ) >> 8 ;
	wchara.byte2 = ( wstring->chara ) & 0x00FF ;
	width += XTextWidth16
	  ( fontset[ ( int )wstring->charset ]->font, &wchara, 1 ) ;
	break ;
      default :
	width += DEFAULT_TOFU_WIDTH ;
	break ;
      }
    } else {
      width += DEFAULT_TOFU_WIDTH ;
    }
    wstring ++ ;
    num -- ;
  }
  return width ;
}

/*
 * ⡼ɥ饤褹ؿ
 */
int getWidthOfModeLine
( struct skkinputManagedFont **fontset, struct SKKInputNode *node,
  int jisyo_dirty, int overthespot_like_input )
{
  int modeline = skkinput_GetModelineNumber( node ) ;
  int width ;

  width  = skkwin_charTextWidth
    ( fontset, skkinput_ModelineStrings[ modeline - 1 ], 32 ) ;
  width += skkwin_charTextWidth
    ( fontset, skkinput_ModelineStringsJisyo[ jisyo_dirty ], 1 ) ;
  width += skkwin_charTextWidth
    ( fontset, skkinput_ModelineStringsOverTheSpot
      [ ( overthespot_like_input & 1 ) ], 1 ) ;
  return width ;
}

/*
 * ⡼ɥ饤褹ؿ
 */
void fullDrawModeLine
( Display *disp, Window win, struct skkinputManagedFont **fontset,
  GC gc, struct SKKInputNode *node, int x, int y,
  int jisyo_dirty, int overthespot_like_input )
{
  int modeline = skkinput_GetModelineNumber( node ) ;

  /* ⡼ɥ饤ɽ( SKKΥ⡼ɽ )*/
  x = skkwin_jputCharString
    ( disp, win, fontset, gc,
      x, y, skkinput_ModelineStrings[ modeline - 1 ] ) ;
  /* ⡼ɥ饤ɽ( ξɽ )*/
  x = skkwin_jputCharString
    ( disp, win, fontset, gc,
      x, y, skkinput_ModelineStringsJisyo[ jisyo_dirty ] ) ;
  skkwin_jputCharString
    ( disp, win, fontset, gc,
      x, y, skkinput_ModelineStringsOverTheSpot
      [ ( overthespot_like_input & 1 ) ] ) ;
  return ;
}

/*
 * ⡼ɥ饤ɽΤˤɤ٤ʸɬפʤΤؿ
 */
int getMaxLengthOfModeline( struct skkinputManagedFont **fontset )
{
  int width, max_width, ret, i ;

  max_width = 0 ;
  for( i = 0 ; i < NUMBER_OF_MODELINE ; i ++ ){
    width = skkwin_charTextWidth
      ( fontset, skkinput_ModelineStrings[ i ], 4 ) ;
    if( max_width < width )
      max_width = width ;
  }
  ret = max_width ;
  max_width = 0 ;
  for( i = 0 ; i < NUMBER_OF_MODELINE_OVERTHESPOT ; i ++ ){
    width = skkwin_charTextWidth
      ( fontset, skkinput_ModelineStringsOverTheSpot[ i ], 1 ) ;
    if( max_width < width )
      max_width = width ;
  }
  return ( ret + ( max_width << 1 ) ) ;
}
