/***************************************************************************
                          qbrewview.h  -  client view class for QBrew
                             -------------------
    begin                : September 20th, 1999
    copyright            : (C) 1999 by David Johnson
    email                : arandir@meer.net

    This software licensed under the Berkeley Software Distribution License
 ***************************************************************************/

#ifndef QBREWVIEW_H
#define QBREWVIEW_H

// include files for QT
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qspinbox.h>
#include <qtabwidget.h>
#include <qwidget.h>

// application specific includes
#include "qbrewdoc.h"
#include "qbrewcalc.h"
#include "fixedspinbox.h"
#include "grainpage.h"
#include "hopspage.h"
#include "miscpage.h"

/**
 * the client view for the application
 */

class QBrewView : public QWidget {
	Q_OBJECT
public:
	/** cosntructor */
	QBrewView(QWidget *parent=0, const char* name = NULL, QBrewDoc* doc=0, QBrewCalc* calc=0);
	/** destructor */
	~QBrewView();
	
	/** initialize layouts */
	void initLayouts();
	/** initialize widgets */
	void initWidgets();

protected slots:
	/** receives if document has changed */
	void slotDocumentChanged();
	/** receives if style has changed */
	void slotStyleChanged();
	
private:
	/** set a combo box to the text */
	void setComboItem(QComboBox *combo, const QString &txt);
	
private:
	/** view's pointer to document */
	QBrewDoc *document;
	/** view's pointer to calc data */
	QBrewCalc *calcdata;
	
	// layouts
	QBoxLayout *mainLayout;
	QGridLayout *recipeLayout;
	QGridLayout *styleLayout;
	
	// recipe layout widgets
	QLabel *titleLabel;
	QLineEdit *titleEdit;
	QLabel *styleLabel;
	QComboBox *styleCombo;
	QLabel *brewerLabel;
	QLineEdit *brewerEdit;
	QCheckBox *mashCheck;
	QLabel *sizeLabel;
	FixedSpinBox *sizeSpin;
	
	// style layout widgets
	QGroupBox *styleBox;
	QLabel *ogMinimum;
	QLabel *ogMaximum;
	QLabel *ogYours;
	QLabel *ibuMinimum;
	QLabel *ibuMaximum;
	QLabel *ibuYours;
	QLabel *srmMinimum;
	QLabel *srmMaximum;
	QLabel *srmYours;
	QFrame *vSeparator;
	QLabel *fgLabel;
	QLabel *alcoholByVol;
	QLabel *alcoholByWgt;
	
	// ingredients layout widgets
	QTabWidget *ingredientsTab;
	GrainPage *grainPage;
	HopsPage *hopsPage;
	MiscPage *miscPage;
};

#endif // QBREWVIEW_H





























