/*
 * Copyright (c) 1996 University College London
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Computer Science
 *      Department at University College London
 * 4. Neither the name of the University nor of the Department may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "prototypes.h"
#include <sys/types.h>
#include <memory.h>
/*Rate in *bytes* per second we are allowed to send */
extern int data_rate;
extern void debug(const char *fmt,...);
extern int Null_Key();

int xsocksend(fd, header, buf, len)
int fd;
unsigned char *buf;
ntheader *header;
int len;
{
    struct iovec iv[2];
    static u_char gatherbuf[2048];
    int glen;
    if (Null_Key() == TRUE) {
	iv[0].iov_base = (caddr_t) header;
	iv[0].iov_len = sizeof(ntheader);
	iv[1].iov_base = (caddr_t) buf;
	iv[1].iov_len = len;
	if (len + sizeof(ntheader) > MAX_PACKET_SIZE) {
	    debug("Attempt made to send too large a packet\n");
	    return -1;
	}
	debug("Sending packet.  Header len=%d, Bodylen=%d t=%d\n", sizeof(ntheader),
	      len, header->msgtype);
#ifdef WIN32
	memcpy(gatherbuf, (char *) header, sizeof(ntheader));
	memcpy(gatherbuf + sizeof(ntheader), buf, len);
	glen = sizeof(ntheader) + len;
	send(fd, gatherbuf, glen, 0);
#else
	writev(fd, iv, 2);
#endif
    } else {

	u_char *encrypted;


	glen = sizeof(ntheader) + len;
	/*these copies are insignificant compared to DES... */
	memcpy(gatherbuf, (char *) header, sizeof(ntheader));
	memcpy(gatherbuf + sizeof(ntheader), buf, len);
	encrypted = (u_char *) Encrypt(gatherbuf, &glen);
	debug("encryption sending %s\n", encrypted);
	send(fd, encrypted, glen, 0);
    }

    return 0;
}
