/*
 * Copyright (c) 1996 University College London
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Computer Science
 *      Department at University College London
 * 4. Neither the name of the University nor of the Department may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <sys/types.h>

#include "prototypes.h"


/*#define MULTICAST */

int joinipgroup(sock, group, interf)
int sock;
char *group, *interf;
{
    unsigned i1, i2, i3, i4, g1, g2, g3, g4;
    struct ip_mreq imr;

    if (sscanf(group, "%u.%u.%u.%u", &g1, &g2, &g3, &g4) != 4) {
	fprintf(stderr, "bad args\n");
	return (-1);
    }
    imr.imr_multiaddr.s_addr = (g1 << 24) | (g2 << 16) | (g3 << 8) | g4;

    if (interf == NULL) {
#ifdef NOTDEF
	char hn[128];
	struct hostent *hp;
	gethostname(hn, 128);
	if ((hp = gethostbyname(hn)) == NULL) {
	    fprintf(stderr, "hostname internal snafu\n");
	    return (-1);
	}
	memcpy((char *) &imr.imr_interface.s_addr, hp->h_addr, hp->h_length);
#endif
	imr.imr_interface.s_addr = INADDR_ANY;
    } else {
	if (sscanf(interf, "%u.%u.%u.%u", &i1, &i2, &i3, &i4) != 4) {
	    fprintf(stderr, "bad args\n");
	    return (-1);
	}
	imr.imr_interface.s_addr = (i1 << 24) | (i2 << 16) | (i3 << 8) | i4;
    }

    imr.imr_multiaddr.s_addr = htonl(imr.imr_multiaddr.s_addr);
    imr.imr_interface.s_addr = htonl(imr.imr_interface.s_addr);
    if (setsockopt(sock, IPPROTO_IP, IP_ADD_MEMBERSHIP,
		   (char *) &imr, sizeof(struct ip_mreq)) == -1) {
	perror("can't join group");
	return (-1);
    } else {
	if (interf != NULL) {
	    debug("group joined (group=%s, i/f=%s)\n", group, interf);
	} else {
	    debug("group joined (group=%s, i/f=NULL)\n", group);
	}
    }
    return (0);
}
