/*
 * Copyright (c) 1996 University College London
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Computer Science
 *      Department at University College London
 * 4. Neither the name of the University nor of the Department may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include <stdlib.h>
#include "prototypes.h"
#include <string.h>
static int idctr = 0;
extern unsigned long ipaddr;
extern unsigned short processid;
#define UNKNOWN_ID 65535

void generate_id(char *id)
{
    sprintf(id, "t%lx%4.4x%4.4x", ipaddr, processid, idctr++);
}

void generate_pointer_id(char *id, char *type)
{
    /*like lines and blocks, but with idnum dependant on pointer type */
    if (strcmp(type, "arrow") == 0)
	sprintf(id, "t%lx%4.4xffff", ipaddr, processid);
    else if (strcmp(type, "hand") == 0)
	sprintf(id, "t%lx%4.4xfffe", ipaddr, processid);
    else if (strcmp(type, "eraser") == 0)
	sprintf(id, "t%lx%4.4xfffd", ipaddr, processid);

}

void htonid(char *idstr, netid * nid)
{
    int i;
    char addrstr[9];
    char pidstr[5];
    char idnumstr[5];
    if (strcmp(idstr, "NULL") == 0) {
	nid->pid = htons(UNKNOWN_ID);
	nid->idnum = htons(UNKNOWN_ID);
	return;
    }
    for (i = 0; i < 4; i++) {
	pidstr[i] = idstr[i + 9];
	idnumstr[i] = idstr[i + 13];
	addrstr[i] = idstr[i + 1];
	addrstr[i + 4] = idstr[i + 5];
    }
    addrstr[8] = '\0';
    pidstr[4] = '\0';
    idnumstr[4] = '\0';
    nid->ipaddr.s_addr = htonl(strtoul(addrstr, (char **) NULL, 16));
    nid->pid = htons((unsigned short) strtol(pidstr, (char **) NULL, 16));
    nid->idnum = htons((unsigned short) strtol(idnumstr, (char **) NULL, 16));
}

void ntohid(netid * nid, char *idstr)
{
    if ((ntohs(nid->pid) == UNKNOWN_ID) && (ntohs(nid->idnum) == UNKNOWN_ID))
	sprintf(idstr, "NULL");
    else
	sprintf(idstr, "t%8.8lx%4.4x%4.4x",
		(unsigned long) ntohl(nid->ipaddr.s_addr),
		ntohs(nid->pid),
		ntohs(nid->idnum));
}
