/**************************************************************
  (C) 1997 by Achim Kaiser

  You may distribute under the terms of the GNU General Public
  License as specified in the COPYING file.
**************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/cursorfont.h>

#include <sys/signal.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <locale.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "detailtitle.h"
#include "positiontext.h"
#include "icontopipe.h"
#include "windowposition.h"
#include "pixmap.h"
#include "shell.h"
#include "iwc.h"
#include "handler.h"
#include "gui.h"
#include "timer.h"
#include "iconmanager.h"
#include "objstart.h"
#include "global.h"
#include "testinstall.h"
#include "stringfunctions.h"
#include "options.h"
#include "rubwindow.h"
#include "wmicon.h"
#include "color.h"

int main(int argc,char *argv[])  
{
  Display *dis;
  Window win,movewin;
  Window oldwin;
  XEvent event;
  XSizeHints hint;
  int scr;
  int done;
  int mapagain;
  int maindesktop;
  XWindowAttributes rootatr;
  XSetWindowAttributes xswa;
  unsigned long valuemask;
  char *text;
  char *windowname=NULL;
  char *iconname=NULL;
  char *pathname=NULL;
  char *backgroundname=NULL;
  char *positiona=NULL;
  char *positions=NULL;
  static Atom           proto_atom= None, delete_atom= None;
  XClassHint *classhint;

  if (argc==2 && (strcmp(argv[1],"-h")==0 ||
                  strcmp(argv[1],"-v")==0 ||
                  strcmp(argv[1],"-help")==0 ||
		  strcmp(argv[1],"--help")==0)) {
    printf("DFM - Desktop File Manager - %s\n",VERSION);
    printf("\n");
    printf("dfm                              - starts main program (desktop)\n");
    printf("dfm <folder>                     - opens folder in normal view\n");
    printf("dfm <folder> -detail             - opens folder in detail view\n");
    printf("dfm <folder> -structure          - opens folder in structure view\n");
    printf("dfm -setfile <file> [file] [...] - opens option window for files\n");
    printf("dfm -setdir <folder>             - opens option window for a folder\n");
    printf("dfm -setdir ~/.dfmdesk/          - opens the desktop options window\n");
    printf("dfm -start <file>                - opens the file with the dfm parameters\n");
    printf("dfm -save                        - saves the current positions/info of dfm\n");
    printf("dfm <-h|-v|-help|--help>         - this help text\n");
    _exit(0);
  }

  chdir((char*)getenv("HOME"));
  setenv("PWD",getenv("HOME"),True);
  dis=XOpenDisplay((char*)getenv("DISPLAY"));
  SetDisplay(dis);
  if (dis==NULL) {
     printf("DFM: Can't open display! Check DISPLAY variable!\n");
     _exit(-1);
  }
  initgui(&argc, &argv);
  if (argc==3 && strcmp(argv[1],"-geticon")==0) {
    if (IsDesktopActive()==True) {
      IconToPipe(argv[2]);
      _exit(0);
    } else {
      printf("DFM: The desktop isn't running!\n");
      _exit(-1);
    }
  }
  
  /*debugging*/
  if (fork()!=0)
    _exit(0);
  /***********/
  /*XSynchronize(GetDisplay(),1);*/
  setlocale(LC_ALL,"");
  IgnoreErrorOn();
  SetTimer(0);
  if (IsDesktopActive()==True) {
    if (argc>=3 && strcmp(argv[1],"-setdir")==0) {
      text=CutHomeDir(argv[2]);
      if (text[0]=='.' && text[1]=='/')
        text[0]='~';
      if (strcmp("~/.dfmdesk/",text)==0 || strcmp("~/.dfmdesk",text)==0)
	MainWindowOptions(argc,argv);
      else
	WindowOptions(argc,argv);
    }
    if (argc==2 && strcmp(argv[1],"-save")==0) {
      SetShowHidden(True);
      SaveFileInfoFromDesktop();
      _exit(0);
    }
    if (argc==3 && strcmp(argv[1],"-setfile")==0)
      FileOptions(argc,argv);
    if (argc>3 && strcmp(argv[1],"-setfile")==0)
      MultipleFileOptions(argc,argv);
    if (argc>=3 && strcmp(argv[1],"-start")==0) 
      ObjectStart(argv[2]);
  } else {
    if ((argc==2 && strcmp(argv[1],"-save")==0) ||
        (argc>=3 && ((strcmp(argv[1],"-setdir")==0) ||
                     (strcmp(argv[1],"-start")==0) ||
                     (strcmp(argv[1],"-setfile")==0)))) {
       printf("DFM: The desktop isn't running!\n");
       _exit(-1);
    }
  }
  if (argc==3 && strcmp(argv[2],"-detail")==0)
    SetKindOfWindow(DETAIL);
  else if (argc==3 && strcmp(argv[2],"-structure")==0)
    SetKindOfWindow(STRUCTURE);
  else
    SetKindOfWindow(NORMAL);
  SetCursors(XCreateFontCursor(dis,XC_middlebutton),XCreateFontCursor(dis,XC_watch));
  scr=DefaultScreen(dis);
  if (argc==1) {
    hint.x=0; hint.y=0;
    hint.width=2;hint.height=2;
    hint.flags=PPosition|PSize;
    if (IsDesktopActive()==False) {
      maindesktop=True;
      
      windowname=".dfmdesk --- dfm:~/.dfmdesk/";
      iconname=".dfmdesk";
      pathname="~/.dfmdesk/";
      InitColors();
    } else { 
      printf("DFM is already running.\n");
      XCloseDisplay(dis);
      _exit(-1);
    }
  } else {
    if (IsDesktopActive()==False) {
      printf("wait for mainprogram\n");
      SetDestroy(30);
      do {
        XSync(GetDisplay(),0);
      } while(IsDesktopActive()==False);
      StopDestroy();
    }
    text=CutHomeDir(argv[1]);
    pathname=malloc(strlen(text)+2);
    strcpy(pathname,text);
    free(text);
    if (pathname[strlen(pathname)-1]!='/')
      strcat(pathname,"/");
    if (pathname[0]=='.' && pathname[1]=='/')
      pathname[0]='~';
    if (strcmp(pathname,"~/.dfmdesk/")==0 && GetKindOfWindow()==NORMAL) {
      XCloseDisplay(dis);
      _exit(0);
    }
    XGrabServer(GetDisplay());
     
    windowname=GenerateWindowName(pathname,GetKindOfWindow());

    iconname=GenerateLastNameWithoutSlash(pathname);

    oldwin=GetWindowNamed(windowname);

    if (oldwin!=None) {
      XUngrabServer(GetDisplay());
      SendWindow(oldwin,RAISE);
      XFlush(dis);
      XCloseDisplay(dis);
      _exit(0);
    }
    maindesktop=False;
    GetFileInfoFromDesktop(windowname,&positiona,&backgroundname,
			   &positions);
    GetPositionFromText(positiona,&hint.x,&hint.y,NULL);
    GetPositionFromText(positions,&hint.width,&hint.height,NULL);
    hint.flags=PPosition|PSize|USPosition|USSize;
    if (positiona==NULL) {
      hint.x=80; hint.y=80;
      hint.width=502;hint.height=300;
      hint.flags=PSize|USSize;
    }
  }
  if (testandinstall(pathname)==False) {
    printf("DFM: Can`t open \"%s\" ?!\n",pathname);
    XCloseDisplay(dis);
    _exit(0);
  }
  SetIsDesktop(maindesktop);
  SetPath(pathname);
  SetWindowName(windowname);

  SetValidHints(&hint);
  if (maindesktop==True) {
    xswa.override_redirect=True;
    valuemask=CWOverrideRedirect;  
    win=XCreateWindow(dis,DefaultRootWindow(dis),
		      hint.x,hint.y,hint.width,hint.height,
		      0,0,InputOnly,CopyFromParent,valuemask,&xswa);
    movewin=XCreateWindow(dis,win,
		      0,0,hint.width,hint.height,
		      0,0,InputOnly,CopyFromParent,valuemask,&xswa);
  } else {
    win=XCreateSimpleWindow(dis,DefaultRootWindow(dis),
			    hint.x,hint.y,hint.width,hint.height,
			    0,0,0);
    movewin=XCreateSimpleWindow(dis,win,
				0,0,hint.width,hint.height,
				0,GetBestColor(0xffff,0xffff,0xffff),
                                  GetBestColor(0xffff,0xffff,0xffff));
  }
  XDefineCursor(dis,win,GetWaitCursor());
  SetGC(XCreateGC(GetDisplay(),XDefaultRootWindow(GetDisplay()),0,0));
  SetWindow(win);
  SetMoveWindow(movewin);
  if (maindesktop==True)
    LoadFileInfoToDesktop();
  XSetStandardProperties(dis,win,windowname,iconname,None,argv,argc,&hint);
  if (maindesktop==False)
    SetWMIcon();
  classhint=XAllocClassHint();
  classhint->res_name="dfm";
  classhint->res_class="dfm";
  XSetClassHint(dis,win,classhint);
  XUngrabServer(GetDisplay());
  XLowerWindow(dis,win);
  XMapWindow(dis,movewin);
  UpdateWindow();
  UpdateFontName();
  UpdateTimer();
  UpdateColors();
  if (maindesktop==False) {
    XSelectInput(dis,movewin,VisibilityChangeMask|
		             ButtonReleaseMask|ButtonPressMask|PointerMotionMask);
    XSelectInput(dis,win,KeyPressMask|StructureNotifyMask);
  } else {
    XSelectInput(dis,movewin,ButtonReleaseMask|ButtonPressMask|
		 PointerMotionMask);
    XSelectInput(dis,win,EnterWindowMask|KeyPressMask);
    XSelectInput(dis,XDefaultRootWindow(GetDisplay()),KeyPressMask);
    if (GetMainBackground()==False)
      XUnmapWindow(dis,win);
    else
      XMapWindow(dis,win);
  }
  if (GetKindOfWindow()==DETAIL)
    CreateDetailTitle();
  if (maindesktop==False) {
    XMapRaised(dis,win);
    proto_atom = XInternAtom(dis, "WM_PROTOCOLS", False);
    delete_atom = XInternAtom(dis, "WM_DELETE_WINDOW", False);
    if ((proto_atom != None) && (delete_atom != None))
      XChangeProperty(dis, win, proto_atom, XA_ATOM, 32,
		      PropModePrepend, (unsigned char *) &delete_atom, 1);
  }
  /*******Create icons**********/
  if (GetKindOfWindow()==STRUCTURE)
    MakeWindowTree();
  else
    MakeWindowIcons();
  /*****************************/
  if (IsSubDesktop()==True) {
    SetWindowSaveStatus(GetPath(),True);
    SetIconSaveStatus(GetPath(),True);
  }
  done=0;
  mapagain=0;
  XUndefineCursor(dis,win);
  signal(SIGALRM,updatetimer);
  alarm(GetTimer());
  while (True||done==0) {
    if (mapagain==0) {
      signal(SIGALRM,updatetimer);
      XNextEvent(dis,&event);
      signal(SIGALRM,repeat);
    } else
      XNextEvent(dis,&event);  
    switch(event.type) {
    case SelectionRequest:
      SelectionReq(event);
      break;
    case ClientMessage:
      if ((maindesktop==False) && 
	    (event.xclient.message_type == proto_atom) &&
	    (event.xclient.window == win) && 
	    (event.xclient.data.l[0] == delete_atom)) {
        XGetWindowAttributes(dis,win,&rootatr);
        if (rootatr.map_state==IsUnmapped || GetWindowCache()==0) {
            XCloseDisplay(GetDisplay());
            _exit(0);
        }
        /*XWithdrawWindow(dis,win,0); * what's better? */
    	XUnmapWindow(dis,win);
	mapagain=1;
        signal(SIGALRM,destroy);
	alarm(GetWindowCache());
      } else {
        if (event.xclient.message_type==XInternAtom(GetDisplay(),
					     "_DFMMESSAGE",False)) {
          if (event.xclient.data.s[0]==RAISE) {
	     GetFileInfoFromDesktop(windowname,&positiona,&backgroundname,
	     		            &positions);
	     GetPositionFromText(positiona,&hint.x,&hint.y,NULL);
	     GetPositionFromText(positions,&hint.width,&hint.height,NULL);

             hint.flags=PPosition|PSize|USPosition|USSize;
             hint.x=hint.x;
             hint.y=hint.y;
             hint.width=hint.width;
             hint.height=hint.height;
	     SetValidHints(&hint);
             XSetNormalHints(dis,win,&hint);

             XMapRaised(dis,win);
             signal(SIGALRM,updatetimer);
             alarm(GetTimer());
             mapagain=0;
          } else
	    if (mapagain==0) {
	      WorkIncomingCall(event);
	    }
	}
      }
      break;
    case MapNotify:
      break;
    case EnterNotify:
      if (maindesktop==True) {
	XLowerWindow(dis,win);
	LowerIcons();
	ManageAutofocus(&event);
      }
      break;
    case Expose:
      if (maindesktop==True) {
	XLowerWindow(dis,win);
	LowerIcons();
      } else
	UpdateDetailView(event.xexpose.window);
      break;
    case LeaveNotify:
      XUndefineCursor(dis,win);
      XSelectInput(dis,XDefaultRootWindow(GetDisplay()),PropertyChangeMask);
      XMapWindow(dis,win);
      XLowerWindow(dis,win);
      break;
    case ButtonPress:
      if (maindesktop==True && event.xbutton.button==2 && GetMainBackground()==True) {	
	XDefineCursor(dis,win,GetMidCursor());
	XSelectInput(dis,XDefaultRootWindow(GetDisplay()),PropertyChangeMask|LeaveWindowMask);
	XUnmapWindow(dis,win);
	/*XLowerWindow(dis,win); */
	break;
      }
    case MotionNotify:
      if (maindesktop==True)
        XLowerWindow(dis,win);
    default:
      if (mapagain==0) {
	done=HandleTheEvent(event);
      }
      break;
    }
  }
  if (maindesktop==True) {
    /*SaveFileInfoFromDesktop();*/
  }
  XCloseDisplay(dis);
  _exit(0);
}
