 /*
  * Extended version of struct dirent
  */

#include <sys/types.h>
#include <dirent.h>
struct direntry
  {
    mode_t d_mode;		/* S_IFDIR if a directory */
    time_t d_mtime;
    char d_name[1];
  };

#include <X11/Xlib.h>
#ifdef I18N
#include <X11/Xlocale.h>
#endif
#include <stdio.h>

#include "general.h" /* because misc.h is already taken */
#include "font.h"

typedef int (*my_sort_f) (struct direntry ** d1, struct direntry ** d2);
extern my_sort_f my_sort_list[5];

unsigned long GetColor(char *);

#include "timer.h"
#include "balloon.h"

int mystrcasecmp (char *, char *);
int mystrncasecmp (char *, char *, int);
char* mystrdup (const char*);
char* mystrndup (const char*, int);
char *CatString3 (const char *, const char *, const char *);
int mygethostname (char *, int);
void SendText (int *, char *, unsigned long);
void SendInfo (int *, char *, unsigned long);
char *safemalloc (int);
char *findIconFile (char *, char *, int);
void replaceEnvVar (char **);
int ReadASPacket (int, unsigned long *, unsigned long **);
void CopyString (char **, char *);
void sleep_a_little (int);
int GetFdWidth (void);
int CheckFile (const char *);
int CheckDir (const char *);
char *CheckOrShare (const char *, const char *, const char *, const int);
char *PutHome (const char *);
int HomeCreate (const char *);
int CheckOrCreate (const char *);
int CheckOrCreateFile (const char *);
int my_scandir (char *, struct direntry *(*[]), int (*select) (struct dirent *),
		int (*dcomp) (struct direntry **, struct direntry **));
int my_sort (struct direntry **, struct direntry **);
int my_dirsort (struct direntry **, struct direntry **);
int my_numbersort (const char *name1, const char *name2);
int my_alphasort (struct direntry **, struct direntry **);
int my_datesort (struct direntry **, struct direntry **);
int ignore_dots (struct dirent *);

/* #define DEBUG_ALLOCS */
#ifdef DEBUG_ALLOCS
#define safemalloc(a) countmalloc(__FUNCTION__, __LINE__, a)
#define calloc(a, b) countcalloc(__FUNCTION__, __LINE__, a, b)
#define realloc(a, b) countrealloc(__FUNCTION__, __LINE__, a, b)
#define free(a) countfree(__FUNCTION__, __LINE__, a)
void *countmalloc (char *fname, int line, int length);
void *countcalloc (char *fname, int line, int nrecords, int length);
void *countrealloc (char *fname, int line, void *ptr, int length);
void countfree (char *fname, int line, void *ptr);
void print_unfreed_mem (void);
#endif /*DEBUG_ALLOCS */
