/* This file contains code for unified image loading from XPM file  */
/********************************************************************/
/* Copyright (c) 1998 Sasha Vasko <sashav@sprintmail.com>            */
/********************************************************************/
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "../configure.h"
#include "../include/aftersteplib.h"

#include <stdio.h>
#include <signal.h>
#include <string.h>
#include <unistd.h>
#include <time.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xproto.h>
#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/xpm.h>

#include "../include/afterstep.h"

/* our input-output data structures definitions */
#include "../include/loadimg.h"

/*
   #define LOG1(a)       fprintf( stderr, a );
   #define LOG2(a,b)    fprintf( stderr, a, b );
   #define LOG3(a,b,c)    fprintf( stderr, a, b, c );
   #define LOG4(a,b,c,d)    fprintf( stderr, a, b, c, d );
 */

#define LOG1(a)
#define LOG2(a,b)
#define LOG3(a,b,c)
#define LOG4(a,b,c,d)

int
ShowPixmapError (int Err)
{
#ifdef XPM
  if (Err == XpmSuccess)
    return 0;
  if (Err == XpmOpenFailed)
    fprintf (stderr, "libXPM error reading XPM file: %s\n", XpmGetErrorString (Err));
  else if (Err == XpmColorFailed)
    fprintf (stderr, "Couldn't allocate required colors\n");
  /* else if (Err == XpmFileInvalid)
     fprintf (stderr, "Invalid Xpm File\n"); */
  else if (Err == XpmColorError)
    fprintf (stderr, "Invalid Color specified in Xpm file\n");
  else if (Err == XpmNoMemory)
    fprintf (stderr, "Insufficient Memory\n");
#endif /* XPM */

  return 1;

}
/* loads pixmap from the XPM file .
   Returns :
   0 - if failed to load pixmap ;
   1 - if pixmap loaded successfully.
 */
int
LoadXPMFile (LImageParams * pParams)
{
#ifdef XPM
  XpmAttributes xpm_attributes;

  xpm_attributes.colormap = pParams->m_colormap;
  xpm_attributes.width = pParams->m_max_x;
  xpm_attributes.height = pParams->m_max_y;
  xpm_attributes.closeness = 40000;
  xpm_attributes.valuemask = XpmSize | XpmReturnPixels | XpmColormap | XpmCloseness;

  if (ShowPixmapError (XpmReadFileToPixmap (pParams->m_dpy, pParams->m_w, (char *) (pParams->m_realfilename), &(pParams->m_Target), &(pParams->m_Mask), &xpm_attributes)) != 0)
    pParams->m_Target = 0;	/*Just in case */
#endif /* XPM */

  LOG3 ("\nLoading XPM at:{%lu}:%s. ", time (NULL), ((pParams->m_Target == 0) ? "Failed" : "Success"));
  return (pParams->m_Target != 0) ? 1 : 0;
}
