/* 
   String splitter function
   Copyright (C) 1999, Joe Orton <joe@orton.demon.co.uk>
                                                                     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/* Splits str into component parts using given seperator,
 * skipping given whitespace around separators and at the 
 * beginning and end of str. Separators are ignored within
 * any pair of characters specified as being quotes.
 * Returns array of components followed by a NULL pointer. The
 * components are taken from dynamically allocated memory, and
 * the entire array can be easily freed using strsplit_free.
 *
 * aka: What strtok should have been.
 */
char **strsplit( const char *str, const char seperator,
		 const char *quotes, const char *whitespace );

/* A bit like strsplit, except each component is split into a pair.
 * Each pair is returned consecutively in the return array.
 *  e.g.:
 *     strpairs( "aa=bb,cc=dd", ',', '=', NULL, NULL )
 *  =>   "aa", "bb", "cc", "dd", NULL, NULL
 * Note, that if a component is *missing* it's key/value separator,
 * then the 'value' in the array will be a NULL pointer. But, if the
 * value is zero-length (i.e., the component separator follows directly
 * after the key/value separator, or with only whitespace inbetween),
 * then the value in the array will be a zero-length string.
 *  e.g.:
 *     strpairs( "aaaa,bb=cc,dd=,ee=ff", ',', '=', NULL, NULL )
 *  =>   "aaaa", NULL, "bb", "cc", "dd", "", "ee", "ff"
 * A NULL key indicates the end of the array (the value will also 
 * be NULL, for convenience).
 */
char **strpairs( const char *str, const char compsep, const char kvsep, 
		 const char *quotes, const char *whitespace );

/* Frees the array returned by strsplit */
void strsplit_free( char **components );

/* Frees the array returned by strpairs */
void strpairs_free( char **pairs );

/* Returns a string which is str with ch stripped from
 * beggining and end, if present in either. The string returned
 * is dynamically allocated using malloc.
 *
 * e.g.  strstrip( "abbba", 'a' )  => "bbb". */
char *strstrip( const char *str, const char ch );
