static gchar *Apache_funcs[] = {
	"Apache",
	"apache_lookup_uri", N_( "Perform a partial request for the specified URI and return all info about it" ),
	"apache_note", N_( "Get and set apache request notes" ),
	"getallheaders", N_( "Fetch all HTTP request headers" ),
	"virtual", N_( "Perform an Apache sub-request" ),
	NULL
};

static gchar *Array_funcs_a2c[] = {
	"Array a-c",
	"array", N_( "Create an array" ),
	"array_push", N_( "Push one or more elements onto the end of array" ),
	"array_pop", N_( "Pop the element off the end of array" ),
	"array_unshift", N_( "Push one or more elements onto the beginning of array" ),
	"array_shift", N_( "Pop an element of the beginning of array" ),
	"array_slice", N_( "Extract a slice of the array" ),
	"array_splice", N_( "Remove a portion of the array and replace it with something else" ),
	"array_merge", N_( "Merge two or more arrays" ),
	"array_keys", N_( "Return all the keys of an array" ),
	"array_values", N_( "Return all the values of an array" ),
	"array_walk", N_( "Apply a user function to every member of an array." ),
	"arsort", N_( "Sort an array in reverse order and maintain index association" ),
	"asort", N_( "Sort an array and maintain index association" ),
	"compact", N_( "Create array containing variables and their values" ),
	"count", N_( "count elements in a variable" ),
	"current", N_( "Return the current element in an array" ),
	NULL
};

static gchar *Array_funcs_e2u[] = {
	"Array e-u",
	"each", N_( "Return the next key and value pair from an array" ),
	"end", N_( "Set the internal pointer of an array to its last element" ),
	"extract", N_( "Import variables into the symbol table from an array" ),
	"in_array", N_( "Return true if a value exists in an array" ),
	"key", N_( "Fetch a key from an associative array" ),
	"ksort", N_( "Sort an array by key" ),
	"list", N_( "Assign variables as if they were an array " ),
	"next", N_( "Advance the internal array pointer of an array" ),
	"pos", N_( "Get the current element from an array" ),
	"prev", N_( "Rewind the internal array pointer" ),
	"range", N_( "Create an array containing a range of integers" ),
	"reset", N_( "Set the internal pointer of an array to its first element" ),
	"rsort", N_( "Sort an array in reverse order" ),
	"shuffle", N_( "Shuffle an array" ),
	"sizeof", N_( "Get the number of elements in an array" ),
	"sort", N_( "Sort an array" ),
	"uasort", N_( "Sort an array with a user-defined comparison function and maintain index association" ),
	"uksort", N_( "Sort an array by keys using a user-defined comparison function" ),
	"usort", N_( "Sort an array by values using a user-defined comparison function" ),
	NULL
};

static gchar *Aspell_funcs[] = {
	"Aspell",
	"aspell_new", N_( "load a new dictionary" ),
	"aspell_check", N_( "check a word" ),
	"aspell_check-raw", N_( "check a word without changing its case or trying to trim it" ),
	"aspell_suggest", N_( "suggest spellings of a word" ),
	NULL
};

static gchar *bcmath_funcs[] = {
	"bcmath",
	"bcadd", N_( "Add two arbitrary precision numbers." ),
	"bccomp", N_( "Compare two arbitrary precision numbers." ),
	"bcdiv", N_( "Divide two arbitrary precision numbers." ),
	"bcmod", N_( "Get modulus of an arbitrary precision number." ),
	"bcmul", N_( "Multiply two arbitrary precision number." ),
	"bcpow", N_( "Raise an arbitrary precision number to another." ),
	"bcscale", N_( "Set default scale parameter for all bc math functions." ),
	"bcsqrt", N_( "Get the square root of an arbitray precision number." ),
	"bcsub", N_( "Subtract one arbitrary precision number from another." ),
	NULL
};

static gchar *calander_funcs[] = {
	"Calander",
	"JDToGregorian", N_( "Converts Julian Day Count to Gregorian date" ),
	"GregorianToJD", N_( "Converts a Gregorian date to Julian Day Count" ),
	"JDToJulian", N_( "Converts a Julian Calendar date to Julian Day Count" ),
	"JulianToJD", N_( "Converts a Julian Calendar date to Julian Day Count" ),
	"JDToJewish", N_( "Converts a Julian Day Count to the Jewish Calendar" ),
	"JewishToJD", N_( "Converts a date in the Jewish Calendar to Julian Day Count" ),
	"JDToFrench", N_( "Converts a Julian Day Count to the French Republican Calendar" ),
	"FrenchToJD", N_( "Converts a date from the French Republican Calendar to a Julian Day Count" ),
	"JDMonthName", N_( "Returns a month name" ),
	"JDDayOfWeek", N_( "Returns the day of the week" ),
	"easter_date", N_( "get UNIX timestamp for midnight on Easter of a given year" ),
	"easter_days", N_( "get number of days after March 21 on which Easter falls for a given year" ),
	NULL
};

static gchar *cpdf_funcs[] = {
	"ClibPDF",
	NULL
};

static gchar *time_funcs[] = {
	"Date and Time",
	"checkdate", N_( "validate a date/time" ),
	"date", N_( "format a local time/date" ),
	"strftime", N_( "format a local time/date according to locale settings " ),
	"gmstrftime", N_( "format a GMT/CUT time/date according to locale settings" ),
	"getdate", N_( "get date/time information" ),
	"gettimeofday", N_( "get current time" ),
	"gmdate", N_( "format a GMT/CUT date/time" ),
	"mktime", N_( "get UNIX timestamp for a date" ),
	"gmmktime", N_( "get UNIX timestamp for a GMT date" ),
	"time", N_( "return current UNIX timestamp" ),
	"microtime", N_( "return current UNIX timestamp with microseconds" ),
	NULL
};

static gchar *dba_funcs[] = {
	"Database (dbm-style)",
	"dba_close", N_( "Close database" ),
	"dba_delete", N_( "Delete entry specified by key" ),
	"dba_exists", N_( "Check whether key exists" ),
	"dba_fetch", N_( "Fetch data specified by key" ),
	"dba_firstkey", N_( "Fetch first key" ),
	"dba_insert", N_( "Insert entry" ),
	"dba_nextkey", N_( "Fetch next key" ),
	"dba_popen", N_( "Open database persistently" ),
	"dba_open", N_( "Open database" ),
	"dba_optimize", N_( "Optimize database" ),
	"dba_replace", N_( "Replace or insert entry" ),
	"dba_sync", N_( "Synchronize database" ),
	NULL
};

static gchar *dbase_funcs[] = {
	"dBase",
	"dbase_create", N_( "creates a dBase database" ),
	"dbase_open", N_( "opens a dBase database" ),
	"dbase_close", N_( "close a dBase database" ),
	"dbase_pack", N_( "packs a dBase database" ),
	"dbase_add_record", N_( "add a record to a dBase database" ),
	"dbase_replace_record", N_( "replace a record in a dBase database" ),
	"dbase_delete_record", N_( "deletes a record from a dBase database" ),
	"dbase_get_record", N_( "gets a record from a dBase database" ),
	"dbase_get_record_with_names", N_( "gets a record from a dBase database as an associative array" ),
	"dbase_numfields", N_( "find out how many fields are in a dBase database" ),
	"dbase_numrecords", N_( "find out how many records are in a dBase database" ),
	NULL
};

static gchar *dbm_funcs[] = {
	"dbm",
	"dbmopen", N_( "opens a dbm database" ),
	"dbmclose", N_( "closes a dbm database"),
	"dbmexists", N_( "tells if a value exists for a key in a dbm database" ),
	"dbmfetch", N_( "fetches a value for a key from a dbm database" ),
	"dbminsert", N_( "inserts a value for a key in a dbm database" ),
	"dbmreplace", N_( "replaces the value for a key in a dbm database" ),
	"dbmdelete", N_( "deletes the value for a key from a dbm database" ),
	"dbmfirstkey", N_( "retrieves the first key from a dbm database" ),
	"dbmnextkey", N_( "retrieves the next key from a dbm database" ),
	"dblist", N_( "describes the dbm-compatible library being used" ),
	NULL
};

static gchar *directory_funcs[] = {
	"Directory",
	"chdir", N_( "change directory" ),
	"dir", N_( "directory class" ),
	"closedir", N_( "close directory handle" ),
	"opendir", N_( "open directory handle" ),
	"readdir", N_( "read entry from directory handle" ),
	"rewinddir", N_( "rewind directory handle" ),
	NULL
};

static gchar *dynamic_funcs[] = {
	"Dynamic loading",
	"dl", N_( "load a PHP extension at runtime" ),
	NULL
};

static gchar *execute_funcs[] = {
	"Execution (Program)",
	"escapeshellcmd", N_( "escape shell metacharacters" ),
	"exec", N_( "Execute an external program" ),
	"system", N_( "Execute an external program and display output" ),
	"passthru", N_( "Execute an external program and display raw output" ),
	NULL
};

static gchar *fdf_funcs[] = {
	"Forms Data Format",
	"fdf_open", N_( "Open a FDF document" ),
	"fdf_close", N_( "Close an FDF document" ),
	"fdf_create", N_( "Create a new FDF document" ),
	"fdf_save", N_( "Save a FDF document" ),
	"fdf_get_value", N_( "Get the value of a field" ),
	"fdf_set_value", N_( "Set the value of a field" ),
	"fdf_next_field_name", N_( "Get the next field name" ),
	"fdf_set_ap", N_( "Set the appearance of a field" ),
	"fdf_set_status", N_( "Set the value of the /STATUS key" ),
	"fdf_get_status", N_( "Get the value of the /STATUS key" ),
	"fdf_set_file", N_( "Set the value of the /F key" ),
	"fdf_get_file", N_( "Get the value of the /F key" ),
	NULL
};

static gchar *filepro_funcs[] = {
	"filePro",
	"filepro", N_( "read and verify the map file" ),
	"filepro_fieldname", N_( "gets the name of a field" ),
	"filepro_fieldtype", N_( "gets the type of a field" ),
	"filepro_fieldwidth", N_( "gets the width of a field" ),
	"filepro_retrieve", N_( "retrieves data from a filePro database" ),
	"filepro_fieldcount", N_( "find out how many fields are in a filePro database" ),
	"filepro_rowcount", N_( "find out how many rows are in a filePro database" ),
	NULL
};

static gchar *filesystem_b2fpa_funcs[] = {
	"Filesystem b-fpa",
	"basename", N_( "return filename component of path" ),
	"chgrp", N_( "change file group" ),
	"chmod", N_( "change file mode" ),
	"chown", N_( "change file owner" ),
	"clearstatcache", N_( "clear file stat cache" ),
	"copy", N_( "copy file" ),
	"delete", N_( "a dummy manual entry" ),
	"dirname", N_( "return directory name component of path" ),
	"diskfreespace", N_( "return available space in directory" ),
	"fclose", N_( "close an open file pointer" ),
	"feof", N_( "test for end-of-file on a file pointer" ),
	"fgetc", N_( "get character from file pointer" ),
	"fgetcsv", N_( "get line from file pointer and parse for CSV fields" ),
	"fgets", N_( "get line from file pointer" ),
	"fgetss", N_( "get line from file pointer and strip HTML tags" ),
	"file", N_( "read entire file into an array" ),
	"file_exists", N_( "Check whether a file exists." ),
	"fileatime", N_( "get last access time of file" ),
	"filectime", N_( "get inode change time of file" ),
	"filegroup", N_( "get file group" ),
	"fileinode", N_( "get file inode" ),
	"filemtime", N_( "get file modification time" ),
	"fileowner", N_( "get file owner" ),
	"fileperms", N_( "get file permissions" ),
	"filesize", N_( "get file size" ),
	"filetype", N_( "get file type" ),
	"flock", N_( "portable advisory file locking" ),
	"fopen", N_( "open file or URL" ),
	"fpassthru", N_( "output all remaining data on a file pointer" ),
	NULL
};

static gchar *filesystem_fpu2u_funcs[] = {
	"FileSystem fpu-u",
	"fputs", N_( "write to a file pointer" ),
	"fread", N_( "Binary-safe file read" ),
	"fseek", N_( "seek on a file pointer" ),
	"ftell", N_( "tell file pointer read/write position" ),
	"fwrite", N_( "Binary-safe file write" ),
	"set_file_buffer", N_("Sets file buffering on the given file pointer"),
	"is_dir", N_( "tells whether the filename is a directory" ),
	"is_executable", N_( "tells whether the filename is executable" ),
	"is_file", N_( "tells whether the filename is a regular file" ),
	"is_link", N_( "tells whether the filename is a symbolic link" ),
	"is_readable", N_( "tells whether the filename is readable" ),
	"is_writeable", N_( "tells whether the filename is writeable" ),
	"link", N_( "Create a hard link" ),
	"linkinfo", N_( "Get information about a link" ),
	"mkdir", N_( "make directory" ),
	"pclose", N_( "close process file pointer" ),
	"popen", N_( "open process file pointer" ),
	"readfile", N_( "output a file" ),
	"readlink", N_( "Return the target of a symbolic link" ),
	"rename", N_( "rename a file" ),
	"rewind", N_( "rewind the position of a file pointer" ),
	"rmdir", N_( "remove directory" ),
	"stat", N_( "give information about a file" ),
	"lstat", N_( "give information about a file or symbolic link" ),
	"symlink", N_( "Create a symbolic link" ),
	"tempnam", N_( "create unique file name" ),
	"touch", N_( "set modification time of file" ),
	"umask", N_( "changes the current umask" ),
	"unlink", N_( "Delete a file" ),
	NULL
};

static gchar *http_funcs[] = {
	"http",
	"header", N_( "Send a raw HTTP header" ),
	"setcookie", N_( "Send a cookie" ),
	NULL
};

static gchar *hyperwave_funcs[] = {
	"Hyperwave",
	"hw_Children", N_( "object ids of children" ),
	"hw_ChildrenObj", N_( "object records of children" ),
	"hw_Close", N_( "closes the Hyperwave connection" ),
	"hw_Connect", N_( "opens a connection" ),
	"hw_Cp", N_( "copies objects" ),
	"hw_Deleteobject", N_( "deletes object" ),
	"hw_DocByAnchor", N_( "object id object belonging to anchor" ),
	"hw_DocByAnchorObj", N_( "object record object belonging to anchor" ),
	"hw_DocumentAttributes", N_( "object record of hw_document" ),
	"hw_DocumentBodyTag", N_( "body tag of hw_document" ),
	"hw_DocumentContent", N_( "returns content of hw_document" ),
	"hw_DocumentSetContent", N_( "sets/replaces content of hw_document" ),
	"hw_DocumentSize", N_( "size of hw_document" ),
	"hw_ErrorMsg", N_( "returns error message" ),
	"hw_EditText", N_( "retrieve text document" ),
	"hw_Error", N_( "error number" ),
	"hw_Free_Document", N_( "frees hw_document" ),
	"hw_GetParents", N_( "object ids of parents" ),
	"hw_GetParentsObj", N_( "object records of parents" ),
	"hw_GetChildColl", N_( "object ids of child collections" ),
	"hw_GetChildCollObj", N_( "object records of child collections" ),
	"hw_GetRemote", N_( "Gets a remote document" ),
	"hw_GetRemoteChildren", N_( "Gets children of remote document" ),
	"hw_GetSrcByDestObj", N_( "Returns anchors pointing at object" ),
	"hw_GetObject", N_( "object record" ),
	"hw_GetAndLock", N_( "return bject record and lock object" ),
	"hw_GetText", N_( "retrieve text document" ),
	"hw_GetObjectByQuery", N_( "search object" ),
	"hw_GetObjectByQueryObj", N_( "search object" ),
	"hw_GetObjectByQueryColl", N_( "search object in collection" ),
	"hw_GetObjectByQueryCollObj", N_( "search object in collection" ),
	"hw_GetChildDocColl", N_( "object ids of child documents of collection" ),
	"hw_GetChildDocCollObj", N_( "object records of child documents of collection" ),
	"hw_GetAnchors", N_( "object ids of anchors of document" ),
	"hw_GetAnchorsObj", N_( "object records of anchors of document" ),
	"hw_Mv", N_( "moves objects" ),
	"hw_Identify", N_( "identifies as user" ),
	"hw_InCollections", N_( "check if object ids in collections" ),
	"hw_Info", N_( "info about connection" ),
	"hw_InsColl", N_( "insert collection" ),
	"hw_InsDoc", N_( "insert document" ),
	"hw_InsertDocument", N_( "upload any document" ),
	"hw_InsertObject", N_( "inserts an object record" ),
	"hw_Modifyobject", N_( "modifies object record" ),
	"hw_New_Document", N_( "create new document" ),
	"hw_Objrec2Array", N_( "convert attributes from object record to object array" ),
	"hw_OutputDocument", N_( "prints hw_document" ),
	"hw_pConnect", N_( "make a persistent database connection" ),
	"hw_PipeDocument", N_( "retrieve any document" ),
	"hw_Root", N_( "root object id" ),
	"hw_Unlock", N_( "unlock object" ),
	"hw_Who", N_( "List of currently logged in users" ),
	"hw_Username", N_( "name of currently logged in user" ),
	NULL
};

static gchar *image_funcs[] = {
	"Image",
	"GetImageSize", N_( "get the size of a GIF, JPG or PNG image" ),
	"ImageArc", N_( "draw a partial ellipse" ),
	"ImageChar", N_( "draw a character horizontally" ),
	"ImageCharUp", N_( "draw a character vertically" ),
	"ImageColorAllocate", N_( "allocate a color for an image" ),
	"ImageColorTransparent", N_( "define a color as transparent" ),
	"ImageCopyResized", N_( "copy and resize part of an image" ),
	"ImageCreate", N_( "create a new image" ),
	"ImageCreateFromGif", N_( "create a new image from file or URL" ),
	"ImageDashedLine", N_( "draw a dashed line" ),
	"ImageDestroy", N_( "destroy an image" ),
	"ImageFill", N_( "flood fill" ),
	"ImageFilledPolygon", N_( "draw a filled polygon" ),
	"ImageFilledRectangle", N_( "draw a filled rectangle" ),
	"ImageFillToBorder", N_( "flood fill to specific color" ),
	"ImageFontHeight", N_( "get font height" ),
	"ImageFontWidth", N_( "get font width" ),
	"ImageGif", N_( "output image to browser or file" ),
	"ImageInterlace", N_( "enable or disable interlace" ),
	"ImageLine", N_( "draw a line" ),
	"ImageLoadFont", N_( "load a new font" ),
	"ImagePolygon", N_( "draw a polygon" ),
	"ImageRectangle", N_( "draw a rectangle" ),
	"ImageSetPixel", N_( "set a single pixel" ),
	"ImageString", N_( "draw a string horizontally" ),
	"ImageStringUp", N_( "draw a string vertically" ),
	"ImageSX", N_( "get image width" ),
	"ImageSY", N_( "get image height" ),
	"ImageTTFBBox", N_( "give the bounding box of a text using TypeType fonts" ),
	"ImageTTFText", N_( "write text to the image using a TrueType fonts" ),
	"ImageColorAt", N_( "get the index of the color of a pixel" ),
	"ImageColorClosest", N_( "get the index of the closest color to the specified color" ),
	"ImageColorExact", N_( "get the index of the specified color" ),
	"ImageColorResolve", N_( "get the index of the specified color or its closest possible alternative" ),
	"ImageColorSet", N_( "set the color for the specified palette index" ),
	"ImageColorsForIndex", N_( "get the colors for an index" ),
	"ImageColorsTotal", N_( "find out the number of colors in an image's palette" ),
	"ImagePSLoadFont", N_( "load a PostScript Type 1 from file" ),
	"ImagePSFreeFont", N_( "free memory used by a PostScript Type 1 font" ),
	"ImagePSEncodeFont", N_( "change the character encoding vector of a font" ),
	"ImagePSText", N_( "to draw a text string over an image using PostScript Type1 fonts" ),
	"ImagePSBBox", N_( "give the bounding box of a text rectangle using PostScript Type1 fonts" ),
	NULL
};

static gchar *imap_funcs[] = {
	"IMAP",
	"imap_append", N_( "Append a string message to a specified mailbox" ),
	"imap_base64", N_( "Decode BASE64 encoded text" ),
	"imap_body", N_( "Read the message body" ),
	"imap_check", N_( "Check current mailbox" ),
	"imap_close", N_( "Close an IMAP stream" ),
	"imap_createmailbox", N_( "Create a new mailbox" ),
	"imap_delete", N_( "Mark a messge for deletion from current mailbox" ),
	"imap_deletemailbox", N_( "Delete a mailbox" ),
	"imap_expunge", N_( "Delete all messages marked for deletion" ),
	"imap_fetchbody", N_( "Fetch a particular section of the body of the message" ),
	"imap_fetchstructure", N_( "Read the structure of a particular message" ),
	"imap_header", N_( "Read the header of the message" ),
	"imap_headers", N_( "Returns headers for all messages in a mailbox" ),
	"imap_listmailbox", N_( "Read the list of mailboxes" ),
	"imap_getmailboxes", N_( "Read the list of mailboxes, returning detailed information on each one" ),
	"imap_listsubscribed", N_( "List all the subscribed mailboxes" ),
	"imap_getsubscribed", N_( "List all the subscribed mailboxes" ),
	"imap_mail_copy", N_( "Copy specified messages to a mailbox" ),
	"imap_mail_move", N_( "Move specified messages to a mailbox" ),
	"imap_num_msg", N_( "Gives the number of messages in the current mailbox" ),
	"imap_num_recent", N_( "Gives the number of recent messages in current mailbox" ),
	"imap_open", N_( "Open an IMAP stream to a mailbox" ),
	"imap_ping", N_( "Check if the IMAP stream is still active" ),
	"imap_renamemailbox", N_( "Rename an old mailbox to new mailbox" ),
	"imap_reopen", N_( "Reopen IMAP stream to new mailbox" ),
	"imap_subscribe", N_( "Subscribe to a mailbox" ),
	"imap_undelete", N_( "Unmark the message which is marked deleted" ),
	"imap_unsubscribe", N_( "Unsubscribe from a mailbox" ),
	"imap_qprint", N_( "Convert a quoted-printable string to an 8 bit string" ),
	"imap_8bit", N_( "Convert an 8bit string to a quoted-printable string." ),
	"imap_binary", N_( "Convert an 8bit string to a base64 string." ),
	"imap_scanmailbox", N_( "Read the list of mailboxes, takes a string to search for in the text of the mailbox" ),
	"imap_mailboxmsginfo", N_( "Get information about the current mailbox" ),
	"imap_rfc822_write_address", N_( "Returns a properly formatted email address given the mailbox, host, and personal info." ),
	"imap_rfc822_parse_adrlist", N_( "Parses an address string" ),
	"imap_setflag_full", N_( "Sets flags on messages" ),
	"imap_clearflag_full", N_( "Clears flags on messages"),
	"imap_sort", N_( "" ),
	"imap_fetchheader", N_( "Returns header for a message" ),
	"imap_uid", N_( "This function returns the UID for the given message sequence number." ),
	"imap_msgno", N_( "This function returns the message sequence number for the given UID." ),
	"imap_search", N_( "This function returns an array of messages matching the given search criteria." ),
	"imap_last_error", N_( "This function returns the last IMAP error (if any) that occurred during this page request." ),
	"imap_errors", N_( "This function returns all of the IMAP errors (if any) that have occurred during this page request or since the error stack was reset." ),
	"imap_alerts", N_( "This function returns all IMAP alert messages (if any) that have occurred during this page request orsince the alert stack was reset." ),
	"imap_status", N_( "This function returns status information on a mailbox other than the current one." ),
	NULL
};

static gchar **php_a2f_submenus[] = {
	Apache_funcs,
	Array_funcs_a2c,
	Array_funcs_e2u,
	Aspell_funcs,
	bcmath_funcs,
	calander_funcs,
	cpdf_funcs,
	time_funcs,
	dba_funcs,
	dbase_funcs,
	dbm_funcs,
	directory_funcs,
	dynamic_funcs,
	execute_funcs,
	fdf_funcs,
	filepro_funcs,
	filesystem_b2fpa_funcs,
	filesystem_fpu2u_funcs,
	NULL
};

static gchar **php_submenus[] = {
	http_funcs,
	hyperwave_funcs,
	image_funcs,
	imap_funcs,
	NULL
};
