#ifndef EDITOR_H
#define EDITOR_H

GtkWidget *screem_editor_new( void );
void screem_editor_close( void );
gboolean screem_editor_popup( GtkWidget *widget, GdkEventButton *event );
void screem_editor_insert( gint pos, gchar *text );
void screem_editor_clear( void );
GtkStyle *screem_editor_get_style( void );
gint screem_editor_get_width( void );
gint screem_editor_get_height( void );
gint screem_editor_get_length( void );
gchar *screem_editor_get_text( gint from, gint len );
gboolean screem_editor_has_selection( void );
void screem_editor_select_region( gint start, gint len );
void screem_editor_cut( void );
void screem_editor_copy( void );
void screem_editor_paste( void );
void screem_editor_clear_selection( void );
void screem_editor_set_pos( gint pos );
gint screem_editor_get_pos( void );
void screem_editor_delete_forward( gint pos, gint len );
void screem_editor_enable( void );
void screem_editor_disable( void );
void screem_editor_buffer_text( void );
void screem_editor_insert_markup( gchar *open_element, gchar *close_element );
void screem_editor_insert_attribute( gchar *attribute );
void screem_editor_insert_file( gchar *filename );
void screem_editor_changed( void );
gint hi_trigger( void );

#endif
