"""

 Linbot Configuration file
 Edit this file to your choosing.  This is just a regular Python module, so
 if you want to do something fancy with it, go right ahead. Just make sure
 that all variables are defined and have an appropriate value .

"""


# if this is true, linbot will consider external all links that do not start in 
# the same directory level as the base url.  For example, given
# linbot http://www.myhost.com/~me/
# 'http://www.myhost.com/~me/stuff/index.html' would be considered internal while
# 'http://www.myhost.com/index.html' would be considered external.
# The default is false (0). note this can be overriden with the -b command-line
# flag
BASE_URLS_ONLY=0

# This is a (Python) list of URLs that should not be explored.  This can also
# be passed to linbot via the -x command line switch.  Note this should be a
# VALID REGULAR EXPRESSION.  See also YANKED_URLS below.
#EXCLUDED_URLS = [r'http://home1.gte.net/marduk/linbot/']
EXCLUDED_URLS = []

# This is like EXLUDED_URLS, but YANKED_URLS are not checked at all.  Also
# you can use the -y command line switch.
# When using the below parameter, make sure that the regular expressions are
# raw Python strings (beginning quote preceded with an "r").  Regular expressions
# are case insensitive.
#YANKED_URLS = [r'*\.jpg",r'.*\.tar\.gz']
YANKED_URLS = []

# Normally linbot will check links to "external" sites at the top level to
# ensure that your pages don't refer to broken links that are not at your
# site. However, you may not want this.  Setting this option to 1 will cause
# linbot to not check external links.  Note a link that is part of the. This
# can also be set with the command-line -a switch
#
# EXCLUDED_URLS list is considered external
AVOID_EXTERNAL_LINKS = 0

# Currently, Linbot can checks http:, ftp:, and file:, schemes.  However, you may
# want to avoid certain schemes (such as file: or ftp:).  Remove the scheme
# from this list and Linbot will avoid it.  Avoided URLs are treated as external
# Default is to not avoid any.
# Examples:
#SCHEMES = ['http']
#SCHEMES = ['http','ftp']
SCHEMES = ['http','ftp','file']


# You can define proxies for the individual schemes above.  The PROXIES config
# variable is a python dictionary or 'None', for example:
# PROXIES = {'http':'http://localhost:3128'}
#PROXIES = {'http':'http://localhost:3128','ftp':'http://localhost:3128'}
PROXIES = None
# Note: according to the urllib documentation, you should also be able to set
# proxies according to your system's environment variables, for example:
# $ HTTP_PROXY='http://localhost:3128' ; export HTTP_PROXY # using Bourne Shell
# $ FTP_PROXY='http://localhost:3128' ; export FTP_PROXY
# proxies in the configuration take precedence over environment settings


# hostnames (for example, www.myhost.com) which are to be considered local to
# your site.  Note that by default, the base URL of your site is considered
# local.  This can also be passed via command-line (see documentation for details
#
# HOSTS = ['home1.gte.net','manson.ddns.org']
HOSTS = [] 

# Directory where files generated by linbot will be placed.  This can also be
# specified via the -o command-line flag.
OUTPUT_DIR = '.'

# When listing a broken link in it's published report, Linbot can either make the
# broken link 'active' or simply list the URL.  Most users will probably not
# want the broken link to be active.
ANCHOR_BAD_LINKS = 0

# Usually, Linbot will processs a URL and immediately move on to the next one.
# However, on some loaded systems, it may be more desirable to have Linbot wait
# a while between requests.  This option should be set to any non-negative number
# (in seconds).  This can also be set using the command-line -w <secs> flag.
WAIT_BETWEEN_REQUESTS = 0


################ The section below is for report plugins  ################

# This is the list of report plugins to display. The elements are strings and
# there should be a corresponding .py file in the LINBOTHOME/reports directory
# else bad things will occur ;-).  Place in the order for which you would like to
# see them in the navigation bar.
# Note: Do not include the 'problems' report as it will appear (last) on all
# reports automatically
PLUGINS = ['sitemap',
	   'badlinks',
	   'images',
	   'whatsold',
	   'whatsnew',
	   'slow',
	   'notitles',
	   'external',
	   'notchkd']
	   
# This is a URL (absolute or relative) of a level 1 Cascading Stylesheet to be
# used in all reports.  See the default linbot.css as well as the HTML source
# for ideas on making your own .css for Linbot.
STYLESHEET = 'http://starship.skyport.net/crew/marduk/linbot/linbot.css'

##### The Navigation (menu) frame/page ############
NAVBAR_FILENAME    = 'navbar.html'
NAVBAR_WIDTH = '150'
NAVBAR_PADDING = 4
NAVBAR_SPACING = 0

MAIN_FILENAME      = 'index.html'

# url to logo (image) shown on all pages.  If you change this you will also
# want to change the LOGO_ALT option below
LOGO_HREF="http://starship.skyport.net/crew/marduk/linbot/linbot.gif"

##### Configuratin for specific plugins #####
REPORT_SITEMAP_LEVEL = 5 # How many levels deep to display the site map

# number of columns in thumbnail image page
REPORT_IMAGES_COLS=5
# width of thumbnail images
REPORT_IMAGES_WIDTH=100
# height of thumbnail images
REPORT_IMAGES_HEIGHT=100

REPORT_WHATSOLD_URL_AGE = 30
REPORT_WHATSNEW_URL_AGE = 7

REPORT_SLOW_URL_SIZE = 76



################## you shouldn't need to change anything below #################

__version__='0.9'
__author__='marduk (marduk@python.net)'  
LINBOT_HOME='http://starship.skyport.net/crew/marduk/linbot/'
