-- $Horde: horde/scripts/database/pgsql_create.sql,v 1.1.2.5 2000/08/31 21:48:24 jon Exp $
--
-- Run using:  psql template1 < pgsql_create.sql

CREATE DATABASE horde;

\connect horde

CREATE TABLE active_sessions (
    sid         varchar(32),
    name        varchar(32),
    val         text,
    changed     varchar(14) not null,
    constraint "pk_active_sessions" primary key ("name","sid")
);

CREATE INDEX "changed_idx" on "active_sessions" ("changed");


CREATE TABLE imp_pref (
    username    varchar(255) not null primary key,
    sig	        text,
    fullname    varchar(70),
    replyto     varchar(70),
    lang        varchar(30)
);

CREATE TABLE imp_addr (
    username    varchar(255) not null,
    address     varchar(255) not null,
    nickname    varchar(255),
    fullname    varchar(255),
    constraint "pk_imp_addr" primary key ("username","address")
);


GRANT SELECT, INSERT, UPDATE ON active_sessions TO hordemgr;
GRANT SELECT, INSERT, UPDATE ON imp_pref, imp_addr TO hordemgr;
