package HNS::Collection;
################################################################
# HNS::Collection   :  diary collection class
#
# usage:
#  my $col = new HNS::Collection;
#  $col->Read($y);
#  $col->Print($y, $m, $d);
#  #$col->PrintRecent;   # recent
#
# $Id: Collection.pm,v 1.6.2.1 2000/01/03 01:23:41 kenji Exp $
################################################################
use strict;
use ObjectTemplate;
@HNS::Collection::ISA = qw(ObjectTemplate);

use HNS;
use HNS::Diary;
use DateTime::Date;

attributes qw(diarys last_modified mode start_time end_time year month day);
use vars qw(%FootMessages);

%FootMessages = 
    ('HasContent'=>"Diary for %num day(s)\n",
     'NoContent' =>"No Match\n");

################################################################
sub initialize($)
{
    my $self = shift;
    $self->diarys({});
}
################################################################
# read specific year, month
sub Read($$$$)
{
    my ($self, $year, $month, $day) = @_;

    # set date
    $self->year($year), $self->month($month), $self->day($day);
    # start time
    $self->start_time(time);

    $day = '(0\d|10)' if $day eq "a";
    $day = '(11|12|13|14|15|16|17|18|19|20)' if $day eq "b";
    $day = '(21|22|23|24|25|26|27|28|29|30|31)' if $day eq "c";

    $self->collect_yearly($year);
    for my $ymd (sort keys %{$self->diarys}){
	my $diary = $self->diarys->{$ymd};
	$diary->filename =~ /d(\d+)\.hnf/;
	next unless ($1 =~ /$year$month$day/);
	$diary->Read;
    }
}
# read recent few days
sub ReadRecent($;$)
{
    my ($self, $max) = @_;
#    $max ||= 5;
    
    $self->start_time(time);
    $self->mode('RECENT');
    my $year = $HNS::Status->start_time->year;

    my $cnt = 0;
    my $y_cnt;
    # read this year and last year, for acrossing year
    # for exapmle: 1999/01/02, 1999/01/01, 1998/12/31, 1998/12/30...
#print "content-type: text/html\n\n";
    while ($cnt<$max){
	# read file info : first this year, second last year
	$self->collect_yearly($year);
	for my $ymd (reverse sort keys %{$self->diarys}){
#print "$cnt $ymd ";
	    my $diary = $self->diarys->{$ymd};
#print "$diary->year $year ";
	    next unless $diary->year == $year;
	    last if (++$cnt>$max);	# read done
#print "read<br>";
	    $diary->Read;
	    # set date
	    unless ($self->year){
		$self->year($diary->year);
		$self->month($diary->month);
		$self->day($diary->day);
	    }
	    # last modified
	    if ($diary->last_modified > $self->last_modified){
		$self->last_modified($diary->last_modified);
	    }
	}
	last if ++$y_cnt>1;  # read done of this year and last year
	$year--;
    }
    # set now date if no diary
    unless ($self->year){
	$self->year(sprintf("%04d", $HNS::Status->start_time->year));
	$self->month(sprintf("%02d", $HNS::Status->start_time->month));
	$self->day(sprintf("%02d", $HNS::Status->start_time->day));
    }
}
# return year-matched file list (directory containted)
# private:
sub collect_yearly ($$)
{
    my ($self, $year) = @_;
    
    for my $dir ($HNS::System::DiaryDir, "$HNS::System::DiaryDir/$year"){
	opendir(DIR, $dir) || next;
#	for my $file (sort readdir(DIR)){
	my $file;
	while ($file = readdir(DIR)){
	    next unless (-f "$dir/$file" &&          # normal file
			 $file =~ /^d($year\d{4})\.hnf$/ &&
			 !$self->diarys->{$1});
	    my $diary = new HNS::Diary(filename=>"$dir/$file");
	    $self->diarys->{$1} = $diary;
	}
    }
    return;
}
################################################################
sub Print($)
{
    my $self = shift;

    my @ymds = sort keys %{$self->diarys};
    @ymds = reverse @ymds if $self->mode eq 'RECENT';

    my $num;
    for (@ymds){
	my ($md, $diary) = ($_, $self->diarys->{$_});
#	print "md:$md, ";
	next unless $diary->read_done;
	$diary->Print;
	$num++;
    }
    # Footer
    my $msg = ($num) ? $FootMessages{'HasContent'} :
	$FootMessages{'NoContent'};
    $msg =~ s/%num/$num/g;
    print $msg;
    $self->end_time(time);
}
################################################################
1;
