<?php 
# ---------------------------------------------------------------
# bookmarker
# A WWW based bookmark management, retrieval, and search tool.
# Copyright (C) 1998  Padraic Renaghan
# Licensed under terms of GNU General Public License
# (see http://www.renaghan.com/bookmarker/source/LICENSE)
# ---------------------------------------------------------------
# $Id: tree.php3,v 1.14 1999/07/08 13:07:44 prenagha Exp $
# ---------------------------------------------------------------
include("bkprepend.php3");
page_open(array( "sess" => "bk_sess_cache"
      ,"auth" => "bk_cr_auth"
		  ,"perm" => "bk_perm"
		  ,"user" => "bk_user"));

$tpl->define(array(
 body       => "tree.body.tpl",
 msg        => "common.message.tpl",
 error_msg  => "common.error_message.tpl"
));

# get the session variable that stores the username
# most of the time it is equal to the username in the
# auth class, but if the guest user logs in, there
# username session variable is set to prenagha
set_bkusername(); 

# we keep a user variable that holds the last selection
# the user made for the groupby option
$user->register("last_groupby");
  
# if no action, then show the same list as last time
# this page was viewed. the session start variables 
# should be set by the register function
$bk_c = new bk_db;

## Check if there was a submission
while ( is_array($HTTP_POST_VARS) 
     && list($key, $val) = each($HTTP_POST_VARS)) {
  switch ($key) {

  ## Load a Saved Search
  case "bks_load":
    ## if form submitted, then if groupby has no value it
		## means the user deselected it, set it to FALSE
		if (!isset($groupby)) {
		  $groupby = FALSE;
		}

    ## Do we have all necessary data?
		## if search isn't greater than zero, then it is "NONE"
		## or not defined, in this case reset the where clause vars
		## and exit the loop. this will cause no where clause to
		## be applied - in effect resetting the query to ALL.
    if ($search > 0 ) {
		} else {
		  unset ($saved_search);
			unset ($where);
      break;
    }

    ## get the saved search
    $query = sprintf("select query from search where id=%s and username='%s'", $search, $bkusername);
    $bk_c->query($query);
    if ($bk_c->next_record()){
      $saved_search = $bk_c->f("query");
    } else {
      $error_msg .= "Saved Search not found in database!";
      break;
    }
    
	break;

  default:
  break;
 }
}

# if the groupby var is still not set by now, that means that
# this was not a form submission. in that case we default the
# groupby var to whatever the user last selected (stored in a 
# user variable). if the user variable is not set yet, default
# to groupby ON.
if (!isset($groupby)) {
  if (isset($last_groupby)) {
	  $groupby = $last_groupby;
	} else {
    $groupby = TRUE;
	}
}
$last_groupby = $groupby;

$query = sprintf("select category.name as category_name, subcategory.name as subcategory_name, bookmark.id, bookmark.url, bookmark.name as bookmark_name, bookmark.ldesc from bookmark, category, subcategory where( bookmark.category_id = category.id and category.username='%s' and bookmark.subcategory_id = subcategory.id and subcategory.username='%s' and bookmark.username = '%s')", $bkusername, $bkusername, $bkusername);

# if saved search loaded then use it first
if (isset($saved_search)) {
  $query .= " and (" . $saved_search . ")";
	$filter_msg = "Filter " . htmlspecialchars($saved_search);
} elseif (isset($where)) {
# else if a WHERE clause was specified in the URL, then use it
  $query .= " and (" . base64_decode($where) . ")";
	$filter_msg = "Filter " . htmlspecialchars(base64_decode($where));
}

if ($groupby) {
  $query .= " order by category.name, subcategory.name, bookmark.name";
	$groupby_default = "checked";
} else {
  $query .= " order by bookmark.name, bookmark.url";
	$groupby_default = "";
}

if ($bookmarker->show_bk_in_tree && ($groupby || !(isset($groupby)))) {
  $output .= sprintf("dbAdd( true , \"bookmarker\" , \"\" , 0 , \"bk_app\" , 0, 0)\n");
  $output .= sprintf("dbAdd( false , \"start\" , \"index.php3\" , 1 , \"bk_app\" , 0, 0)\n");
  $output .= sprintf("dbAdd( false , \"plain list\" , \"list.php3\" , 1 , \"bk_app\" , 0, 0)\n");
  $output .= sprintf("dbAdd( false , \"create\" , \"create.php3\" , 1 , \"bk_app\" , 0, 0)\n");
  $output .= sprintf("dbAdd( false , \"search\" , \"search.php3\" , 1 , \"bk_app\" , 0, 0)\n");
}

$bk_c->query($query);

$prev_category = " ";
$prev_subcategory = " ";
$first_time = 1;

while ($bk_c->next_record()) {

# only do the category subcategory breaks if the user wants them
  if ($groupby) {
   	$category_break = 0;
	  $subcategory_break = 0;
	
	  if ($bk_c->f("category_name") != $prev_category) {
		  $prev_category = $bk_c->f("category_name");
		  $category_break = 1;
	  }
 	  if ($bk_c->f("subcategory_name") != $prev_subcategory) {
		  $prev_subcategory = $bk_c->f("subcategory_name");
		  $subcategory_break = 1;
	  }
	
	  if ($category_break or $subcategory_break and !$first_time) {
		  $first_time = 0;
	  }

	  if ($category_break) {
      $output .= sprintf("dbAdd( true , \"%s\" , \"\" , 0 , \"bk_target\", 0,%s)\n",htmlspecialchars(stripslashes($prev_category)), $bk_c->f("id"));
      $output .= sprintf("dbAdd( true , \"%s\" , \"\" , 1 , \"bk_target\", 0,%s)\n",htmlspecialchars(stripslashes($prev_subcategory)), $bk_c->f("id"));
	  } elseif ($subcategory_break) {
      $output .= sprintf("dbAdd( true , \"%s\" , \"\" , 1 , \"bk_target\", 0,%s)\n",htmlspecialchars(stripslashes($prev_subcategory)), $bk_c->f("id"));
	  }		

    $output .= sprintf("dbAdd( false , \"%s\" , \"%s\" , 2 , \"bk_target\", 0,%s)\n",htmlspecialchars(stripslashes($bk_c->f("bookmark_name"))), $bk_c->f("url"), $bk_c->f("id"));
	} else {
# the user doesn't want category/subcategory breaks, so just print the
# urls on the first level
    $output .= sprintf("dbAdd( false , \"%s\" , \"%s\" , 0 , \"bk_target\", 0,%s)\n",htmlspecialchars(stripslashes($bk_c->f("bookmark_name"))), $bk_c->f("url"), $bk_c->f("id"));
  }
}

if (isset ($error_msg)) {
  $tpl->assign(ERROR_MSG_TEXT, $error_msg);
  $tpl->parse(ERROR_MSG, "error_msg");
}

if (isset ($msg)) {
  $tpl->assign(MSG_TEXT, $msg);
  $tpl->parse(MSG, "msg");
}

# load the list of previously saved searches
# and prepare the save search form

if ($search > 0) {
  $default_search = $search;
} else {
  $default_search = "NONE";
}

load_ddlb("search", $default_search, $bkusername, &$search_select, TRUE);
$tpl->assign(array(
  SEARCH_SELECT => $search_select,
  FORM_ACTION   => $sess->self_url()
));

$tpl->assign(array(
  FILTER_MSG       => $filter_msg,
  GROUPBY_DEFAULT  => $groupby_default,
  BOOKMARK_JS      => $output,
  IMAGE_URL_PREFIX => $bookmarker->image_url_prefix
));
$tpl->parse(BODY, "body");
$tpl->FastPrint();

page_close();
?>
