#ifndef ___ARENA_DEBUG_H___
#  define ___ARENA_DEBUG_H___

/*
 * Debugging tools.	QingLong.14-12-96
 */


#  include "defs.h"
#  include "types.h"

#  include "HTAnchor.h"

#  include "menu.h"


extern unsigned long debug;

#  define AUTHENTICATION_TRACE_BITMASK   0x00000001
#  define        BADFLAG_TRACE_BITMASK   0x00000002
#  define      BOOKMARKS_TRACE_BITMASK   0x00000004
#  define         BRIDGE_TRACE_BITMASK   0x00000008
#  define         COLOUR_TRACE_BITMASK   0x00000010
#  define        CONNECT_TRACE_BITMASK   0x00000020
#  define        DISPLAY_TRACE_BITMASK   0x00000040
#  define           FONT_TRACE_BITMASK   0x00000080
#  define           FORM_TRACE_BITMASK   0x00000100
#  define        HISTORY_TRACE_BITMASK   0x00000200
#  define          IMAGE_TRACE_BITMASK   0x00000400
#  define        MAILCAP_TRACE_BITMASK   0x00000800
#  define         MAILTO_TRACE_BITMASK   0x00001000
#  define           MENU_TRACE_BITMASK   0x00002000
#  define         OPTION_TRACE_BITMASK   0x00004000
#  define    PAINTSTREAM_TRACE_BITMASK   0x00008000
#  define      PARSEHTML_TRACE_BITMASK   0x00010000
#  define       REGISTER_TRACE_BITMASK   0x00020000
#  define         SCROLL_TRACE_BITMASK   0x00040000
#  define          SPAWN_TRACE_BITMASK   0x00080000
#  define         STATUS_TRACE_BITMASK   0x00100000
#  define          STYLE_TRACE_BITMASK   0x00200000
#  define          TABLE_TRACE_BITMASK   0x00400000
#  define            TAG_TRACE_BITMASK   0x00800000
#  define              X_TRACE_BITMASK   0x01000000

#  define        VERBOSE_TRACE_BITMASK   0x80000000

#  define AUTHENTICATION_TRACE (debug & AUTHENTICATION_TRACE_BITMASK)
#  define        BADFLAG_TRACE (debug &        BADFLAG_TRACE_BITMASK)
#  define      BOOKMARKS_TRACE (debug &      BOOKMARKS_TRACE_BITMASK)
#  define         BRIDGE_TRACE (debug &         BRIDGE_TRACE_BITMASK)
#  define         COLOUR_TRACE (debug &         COLOUR_TRACE_BITMASK)
#  define        CONNECT_TRACE (debug &        CONNECT_TRACE_BITMASK)
#  define        DISPLAY_TRACE (debug &        DISPLAY_TRACE_BITMASK)
#  define           FONT_TRACE (debug &           FONT_TRACE_BITMASK)
#  define           FORM_TRACE (debug &           FORM_TRACE_BITMASK)
#  define        HISTORY_TRACE (debug &        HISTORY_TRACE_BITMASK)
#  define          IMAGE_TRACE (debug &          IMAGE_TRACE_BITMASK)
#  define        MAILCAP_TRACE (debug &        MAILCAP_TRACE_BITMASK)
#  define         MAILTO_TRACE (debug &         MAILTO_TRACE_BITMASK)
#  define           MENU_TRACE (debug &           MENU_TRACE_BITMASK)
#  define         OPTION_TRACE (debug &         OPTION_TRACE_BITMASK)
#  define    PAINTSTREAM_TRACE (debug &    PAINTSTREAM_TRACE_BITMASK)
#  define      PARSEHTML_TRACE (debug &      PARSEHTML_TRACE_BITMASK)
#  define       REGISTER_TRACE (debug &       REGISTER_TRACE_BITMASK)
#  define         SCROLL_TRACE (debug &         SCROLL_TRACE_BITMASK)
#  define          SPAWN_TRACE (debug &          SPAWN_TRACE_BITMASK)
#  define         STATUS_TRACE (debug &         STATUS_TRACE_BITMASK)
#  define          STYLE_TRACE (debug &          STYLE_TRACE_BITMASK)
#  define          TABLE_TRACE (debug &          TABLE_TRACE_BITMASK)
#  define            TAG_TRACE (debug &            TAG_TRACE_BITMASK)
#  define              X_TRACE (debug &              X_TRACE_BITMASK)

#  define        VERBOSE_TRACE (debug &        VERBOSE_TRACE_BITMASK)

#  define            ANY_TRACE  debug

#  define VERBOSE  VERBOSE_TRACE


/*
 * Just to ease and centralize control. QingLong.14-12-96.
 */
#  ifdef __STDC__
int Arena_DebugPrint(char* output_format, ...);
#   else
int Arena_DebugPrint(output_format, va_alist)
     char* output_format;
     va_dcl;
#  endif


/*
 * Stylization of trace printing. QingLong.14-12-96.
 */
#  ifdef __STDC__
extern int Arena_TracePrint(char* CallerFunction, char* output_format, ...);
#   else
extern int Arena_TracePrint(CallerFunction, output_format, va_alist)
     char* theCallerFunction;
     char* output_format;
     va_dcl;
#  endif


/*
 * Print some info about document. QingLong.14-12-96.
 */
extern void debug_PrintDoc(char* CallerFunction, Doc* doc);

/*
 * Print some info about anchor. QingLong.14-12-96.
 */
extern void debug_PrintAnchor(char* CallerFunction, HTAnchor* anchor);

/*
 * libsane is a debuging routine that checks the state of document pointers.
 */
extern void libSane(void);

/*
 * debugging routine which prints out the current history stack.
 */
extern void HistoryList(Context* context);

/*
 * Arena_printMenuItems prints the list of the items of the given menu.
 */
void Arena_printMenuItems(MenuItem* FirstMenuItem);

/* StyleSane is a debugging functions which tries to
 * print out the content of a style sheet
 */
extern void StyleSane(StyleSheet* sheet);

#endif
