/***************************************************************************
 *
 * $Header: /home/werner/ytree/RCS/util.c,v 1.16 1998/11/11 19:02:48 werner Rel $
 *
 * Diverse Hilfsfunktionen
 *
 ***************************************************************************/


#include "ytree.h"



typedef struct
{
  char *extension;
  int  method;
} Extension2Method;



static Extension2Method file_extensions[] = FILE_EXTENSIONS;


char *GetPath(DirEntry *dir_entry, char *buffer)
{
  DirEntry *de_ptr;
  char     help_buffer[PATH_LENGTH + 1];

  *buffer = '\0';

  for( de_ptr = dir_entry; de_ptr; de_ptr = de_ptr->up_tree )
  {
    *help_buffer = '\0';
    if( de_ptr->up_tree ) (void) strcat( help_buffer, FILE_SEPARATOR_STRING );
    if( strcmp( de_ptr->name, FILE_SEPARATOR_STRING ) )
      (void) strcat( help_buffer, de_ptr->name );
    (void) strcat( help_buffer, buffer );
    (void) strcpy( buffer, help_buffer );
  }

  /* if( *buffer == '\0' ) (void) strcpy( buffer, FILE_SEPARATOR_STRING ); */

  return( buffer );
}





char *GetFileNamePath(FileEntry *file_entry, char *buffer)
{
  (void) GetPath( file_entry->dir_entry, buffer );
  if( *buffer && strcmp( buffer, FILE_SEPARATOR_STRING ) ) 
    (void) strcat( buffer, FILE_SEPARATOR_STRING );
  return( strcat( buffer, file_entry->name ) );
}



char *GetRealFileNamePath(FileEntry *file_entry, char *buffer)
{
  char *sym_name;

  if( mode == DISK_MODE )
    return( GetFileNamePath( file_entry, buffer ) );

  if( S_ISLNK( file_entry->stat_struct.st_mode ) )
  {
    sym_name = &file_entry->name[ strlen( file_entry->name ) + 1 ];
    if( *sym_name == FILE_SEPARATOR_CHAR )
      return( strcpy( buffer, sym_name ) );
  }
  
  (void) GetPath( file_entry->dir_entry, buffer );
  if( *buffer && strcmp( buffer, FILE_SEPARATOR_STRING ) ) 
    (void) strcat( buffer, FILE_SEPARATOR_STRING );
  if( S_ISLNK( file_entry->stat_struct.st_mode ) )
    return( strcat( buffer, &file_entry->name[ strlen( file_entry->name ) + 1 ] ) );
  else
    return( strcat( buffer, file_entry->name ) );
}






int GetDirEntry(DirEntry *tree, 
                DirEntry *current_dir_entry, 
                char *dir_path, 
                DirEntry **dir_entry, 
                char *to_path
	       )
{
  char dest_path[PATH_LENGTH+1];
  char current_path[PATH_LENGTH+1];
  char help_path[PATH_LENGTH+1];
  char *token, *old;
  DirEntry *de_ptr, *sde_ptr;
  int n;

  *dir_entry = NULL;
  *to_path   = '\0';

   strcpy(to_path, dir_path);
  if( getcwd( current_path, sizeof( current_path ) - 2 ) == NULL )
  {
    (void) sprintf( message, "getcwd failed*%s", sys_errlist[errno] );
    ERROR_MSG( message );
    return( -1 );
  }

  if( *dir_path != FILE_SEPARATOR_CHAR ) 
  {
    if( chdir( GetPath( current_dir_entry, help_path ) ) )
    {
      ERROR_MSG( "Chdir Failed" );
      return( -1 );
    }
  }

  if( chdir( dir_path ) )
  {
#ifdef DEBUG
    (void) sprintf( message, "Invalid Path!*\"%s\"", dir_path );
    MESSAGE( message );
#endif
    return( -3 );
  }

#if 0
  (void) getcwd( dest_path, sizeof( dest_path ) - 2 );
  (void) strcpy( to_path, dest_path );
#endif

  strcpy(dest_path, dir_path);
  if( chdir( current_path ) )
  {
    ERROR_MSG( "Chdir failed; Can't resume" );
    return( -1 );
  }

  n = strlen( tree->name );
  if( !strncmp( tree->name, dest_path, n ) &&
      ( dest_path[n] == FILE_SEPARATOR_CHAR || dest_path[n] == '\0' ) )
  {
    /* Pfad befindet sich im (Sub)-Tree */
    /*----------------------------------*/

    de_ptr = tree;
    token = Strtok_r( &dest_path[n], FILE_SEPARATOR_STRING, &old );
    while( token )
    {
      for( sde_ptr = de_ptr->sub_tree; sde_ptr; sde_ptr = sde_ptr->next )
      {
        if( !strcmp( sde_ptr->name, token ) )
	{
	  /* Subtree gefunden */
	  /*------------------*/

	  de_ptr = sde_ptr;
	  break;
	}
      }
      if( sde_ptr == NULL )
      {
#ifdef DEBUG
	(void) sprintf( message, "Can't find directory; token=%s", token );
	ERROR_MSG( message );
#endif
	return( -3 );
      }
      token = Strtok_r( NULL, FILE_SEPARATOR_STRING, &old );
    }
    *dir_entry = de_ptr;
  }
  return( 0 );
}




int GetFileEntry(DirEntry *de_ptr, char *file_name, FileEntry **file_entry)
{
  FileEntry *fe_ptr;

  *file_entry = NULL;

  for( fe_ptr = de_ptr->file; fe_ptr; fe_ptr = fe_ptr->next )
  {
    if( !strcmp( fe_ptr->name, file_name ) )
    {
      /* Eintrag gefunden */
      /*------------------*/

      *file_entry = fe_ptr;
      break;
    }
  }
  return( 0 );
}





char *GetAttributes(unsigned short modus, char *buffer)
{
  char *save_buffer = buffer;

       if( S_ISREG( modus ) )  *buffer++ = '-';
  else if( S_ISDIR( modus ) )  *buffer++ = 'd';
  else if( S_ISCHR( modus ) )  *buffer++ = 'c';
  else if( S_ISBLK( modus ) )  *buffer++ = 'b';
  else if( S_ISFIFO( modus ) ) *buffer++ = 'p';
  else if( S_ISLNK( modus ) )  *buffer++ = 'l';
  else if( S_ISSOCK( modus ) ) *buffer++ = 's';  /* ??? */
  else                         *buffer++ = '?';  /* unknown */

  if( modus & S_IRUSR ) *buffer++ = 'r';
  else *buffer++ = '-';

  if( modus & S_IWUSR ) *buffer++ = 'w';
  else *buffer++ = '-';
    
  if( modus & S_IXUSR ) *buffer++ = 'x';
  else *buffer++ = '-';
    
  if( modus & S_ISUID ) *(buffer - 1) = 's';
    

  if( modus & S_IRGRP ) *buffer++ = 'r';
  else *buffer++ = '-';

  if( modus & S_IWGRP ) *buffer++ = 'w';
  else *buffer++ = '-';
    
  if( modus & S_IXGRP ) *buffer++ = 'x';
  else *buffer++ = '-';
    
  if( modus & S_ISGID ) *(buffer - 1) = 's';


  if( modus & S_IROTH ) *buffer++ = 'r';
  else *buffer++ = '-';

  if( modus & S_IWOTH ) *buffer++ = 'w';
  else *buffer++ = '-';
    
  if( modus & S_IXOTH ) *buffer++ = 'x';
  else *buffer++ = '-';
    
  *buffer = '\0';

  return( save_buffer );
}





/***************************************************************************
 * InputStr                                                                *
 * Liest eine Zeichenkette an Position (y,x) mit der max. Laenge length    *
 * Vorschlagswert fuer die Eingabe ist s selbst                            *
 * Zurueckgegeben wird das Zeichen, mit dem die Eingabe beendet wurde      *
 ***************************************************************************/


int InputString(char *s, int y, int x, int length, char *term)
                               /* Ein- und Ausgabestring              */
                               /* Position auf Bildschirm             */
                               /* max. Laenge                         */
                               /* Menge von Terminierungszeichen      */
{
  int p;                       /* Aktuelle Position                   */
  int c1;                      /* Gelesenes Zeichen                   */
  int i;                       /* Laufvariable                        */
  char *pp;
  BOOL key_pressed = FALSE;
  char path[PATH_LENGTH + 1];

  static BOOL insert_flag = TRUE;

  /* Feld gefuellt ausgeben */
  /*------------------------*/
  print_time = FALSE;
  MvAddStr( y, x, s );
  leaveok(stdscr, FALSE);
  
  for(i=strlen(s); i < length; i++)
    addch( '_' );


  p = 0;

  do  /* until termkey pressed */
  {
    wmove( stdscr, y, x+p );

    wnoutrefresh( stdscr );
    doupdate();

    c1 = getch();

    if( c1 >= ' ' && c1 < 0xff && c1 != 127) 
    {
      /* Darstellbares Zeichen */
      /*-----------------------*/

      if( key_pressed == FALSE )
      {
	s[0] = '\0';
        
	move( y, x );
        for(i=0; i < length; i++)
          addch( '_' );
	move( y, x );
      }

      if( p < length )
      {
        /* Platz zum einfuegen vorhanden */
        /*-------------------------------*/

        if( insert_flag )
        {
          /* Restliche Zeichen eine Position vorruecken */
          /*--------------------------------------------*/

          if( strlen( s ) == length ) s[length-1] = '\0';
          for(i=strlen(s); i >= p; i-- )
            s[i+1] = s[i];
        }
        else
        {
          /* Simples ueberschreiben */
          /*------------------------*/

          if( s[p] == '\0' )
            s[p+1] = '\0';
        }

        s[p] = (char) c1;

        addstr( &s[p] );
        p++;
      }
      else
      {
        /* Zeile voll */
        /*------------*/

        beep();
      }
    }
    else
    {
      /* Steuerzeichen */
      /*---------------*/

      switch( c1 )
      {
        case KEY_LEFT       : if( p > 0 )
                                p--;
                              else
                                beep();
                              break;
        case KEY_RIGHT      : if( p < (int) strlen( s ) )
                                p++;
                              else
                                beep();
                              break;
	case KEY_UP         : 
                             if(( pp = GetHistory()) == NULL) {
			       break;
			     }
                             if(*pp)
                             {
                               strncpy(s, pp, length);
			       s[length] = '\0';
			       p = strlen(s);
                               MvAddStr( y, x, s );
                               for(i=p; i < length; i++)
                                 addch( '_' );
                               wnoutrefresh( stdscr );
                               doupdate();
                             }
                             break;

        case KEY_HOME       : p = 0;
                              break;
        case KEY_END        : p = strlen( s );
                              break;
        case KEY_DC         : if( p < (int) strlen( s ) )
                              {
                                (void) strcpy( s+p, s+p+1 );
                                printw( "%s_", s+p );
                              }
                              break;
	case 0x08           :
        case 0x7F           :
        case KEY_BACKSPACE  : if( p > 0 )
                              {
                                (void) strcpy( s+p-1, s+p );
                                printw( "\b%s_", s+p-1 );
                                p--;
                              }
                              else
                                beep();
                              break;
        case KEY_DL         : for(i=0; i < (int) strlen(s) - p; i++)
			        addch( '_' );
                              s[p] = '\0';
                              break;
	case KEY_EIC        :
        case KEY_IC         : insert_flag ^= TRUE; 
                              break;

#ifdef KEY_F
        case KEY_F(2)       : 
#endif
        case 'F' & 0x1f     : if(KeyF2Get( statistic.tree,
                                           statistic.disp_begin_pos,
                                           statistic.cursor_pos, path)) 
                              {
			        /* beep(); */
				break;
			      }
                              if(*path)
                              {
                                strncpy(s, path, length);
			        s[length] = '\0';
			        p = strlen(s);
                                MvAddStr( y, x, s );
                                for(i=p; i < length; i++)
                                  addch( '_' );
                                wnoutrefresh( stdscr );
                                doupdate();
                              }
                              break;

        default             : if( c1 == LF ) c1 = CR;
                              if( !strrchr( term, c1 ) )
                                beep();
                              break;
      }
    }
    key_pressed = TRUE;
  } while( !strrchr( term, c1 ) );

  p = strlen( s );

  move( y, x + p );

  for(i=0; i < length - p; i++ )
   addch( ' ' );

  move( y, x );
  leaveok( stdscr, TRUE);
  print_time = TRUE;
  InsHistory( s );
  return( c1 );
}





int InputChoise(char *msg, char *term)
{
  int  c;

  ClearHelp();

  leaveok(stdscr, FALSE);
  mvprintw( LINES - 2, 1, msg );
  wnoutrefresh( stdscr );
  doupdate();
  do
  {
    c = getch();
    if( islower( c ) ) c = toupper( c );
  } while( !strchr( term, c ) );
  
  echochar( c );

  move( LINES - 2, 1 ); clrtoeol();
  leaveok(stdscr, TRUE);

  return( c );
}





int GetTapeDeviceName( void )
{
  int  result;
  char path[PATH_LENGTH+1];

  result = -1;

  ClearHelp();

  (void) strcpy( path, statistic.tape_name );

  MvAddStr( LINES - 2, 1, "Tape-Device:" );
  if( InputString( path, LINES - 2, 14, COLS - 15, "\r\033" ) == CR )
  {
    result = 0;
    (void) strcpy( statistic.tape_name, path );
  }

  move( LINES - 2, 1 ); clrtoeol();

  return( result );
}



char *CTime(time_t f_time, char *buffer)
{
  char   *cptr;
  time_t now;

  if( (now = time( NULL )) == -1 )
  {
    ERROR_MSG( "time() failed" );
    exit( 1 );
  }

  cptr = ctime( &f_time );
  (void) strncpy( buffer, cptr+4, 12 );
  buffer[12] = '\0';

  if( (now - f_time) > 31536000L )
  {
    /* Differenz groesser als 1 Jahr */
    /*-------------------------------*/

    (void) strncpy( &buffer[7], cptr + 19, 5 );
    
  }

  return( buffer );
}

  


void PrintSpecialString(WINDOW *win, int y, int x, char *str, int color)
{
  int ch;

  for( ; *str; str++ )
  {
    switch( *str )
    {
      case '1': ch = ACS_ULCORNER; break;
      case '2': ch = ACS_URCORNER; break;
      case '3': ch = ACS_LLCORNER; break;
      case '4': ch = ACS_LRCORNER; break;
      case '5': ch = ACS_TTEE;     break;
      case '6': ch = ACS_LTEE;     break;
      case '7': ch = ACS_RTEE;     break;
      case '8': ch = ACS_BTEE;     break;
      case '9': ch = ACS_LARROW;   break;
      case '|': ch = ACS_VLINE;    break;
      case '-': ch = ACS_HLINE;    break;
      default:  ch = PRINT(*str);
    }
#ifdef COLOR_SUPPORT
    ch |= COLOR_PAIR(color) | A_BOLD;
#endif /* COLOR_SUPPORT */
    mvwaddch( win, y, x++, ch );
  }
}

void PrintOptions(WINDOW *win, int y, int x, char *str)
{
  int ch;
  int color, hi_color, lo_color;

#ifdef COLOR_SUPPORT
     lo_color = MENU_COLOR;
     hi_color = HIMENUS_COLOR;
#else
     lo_color = A_NORMAL;
     hi_color = A_BOLD;
#endif
   
  color = lo_color;

  for( ; *str; str++ )
  {
    ch = (int) *str;
   
    switch( *str ) {
        case '(': color = hi_color;  continue;
	case ')': color = lo_color;  continue;

#ifdef COLOR_SUPPORT
	case ']': color = lo_color;  continue;
	case '[': color = hi_color;  continue;
#else
	case ']':
	case '[': /* ignore */ continue;
#endif

        case '1': ch = ACS_ULCORNER; break;
        case '2': ch = ACS_URCORNER; break;
        case '3': ch = ACS_LLCORNER; break;
        case '4': ch = ACS_LRCORNER; break;
        case '5': ch = ACS_TTEE;     break;
        case '6': ch = ACS_LTEE;     break;
        case '7': ch = ACS_RTEE;     break;
        case '8': ch = ACS_BTEE;     break;
        case '9': ch = ACS_LARROW;   break;
        case '|': ch = ACS_VLINE;    break;
        case '-': ch = ACS_HLINE;    break;
        default:  ch = PRINT(*str);
     }

#ifdef COLOR_SUPPORT
     ch |= (COLOR_PAIR(color) | A_BOLD);
#else
     ch |= color;
#endif
     mvwaddch( win, y, x++, ch );
   }
}


void PrintMenuOptions(WINDOW *win,int y, int x, char *str, int ncolor, int hcolor)
{
  int ch;
  int color, hi_color, lo_color;

#ifdef COLOR_SUPPORT
     lo_color = MENU_COLOR;
     hi_color = HIMENUS_COLOR;
#else
     lo_color = A_NORMAL;
     hi_color = A_REVERSE;
#endif
   
  color = lo_color;

  for( ; *str; str++ )
  {
    ch = (int) *str;
   
    switch( ch ) {
        case '(': color = hi_color;  continue;
	case ')': color = lo_color;  continue;

#ifdef COLOR_SUPPORT
	case ']': color = lo_color;  continue;
	case '[': color = hi_color;  continue;
#else
	case ']':
	case '[': /* ignore */ continue;
#endif
        default : ch = PRINT(*str);
    }

#ifdef COLOR_SUPPORT
    ch |= (COLOR_PAIR(color) | A_BOLD);
#else
    ch |= color;
#endif
    mvwaddch(win, y, x++, ch );
  }
}



/*****************************************************************************
 *                              FormFilename                                 *
 *****************************************************************************/

char *FormFilename(char *dest, char *src, unsigned int max_len)
{
  int i;
  int begin;
  unsigned int l;

  l = strlen(src);
  begin = 0;

  if( l <= max_len )
    return( strcpy( dest, src ) );
  else
  {
    for(i=0; i < (int) max_len - 4; i++)
      if( src[l - i] == FILE_SEPARATOR_CHAR || src[l - i] == '\\' )
        begin = l - i;
    (void) strcpy( dest, "/..." );
    return( strcat(dest, &src[begin] ) );
  }
}


/*****************************************************************************
 *                              CutFilename                                  *
 *****************************************************************************/

char *CutFilename(char *dest, char *src, unsigned int max_len)
{
  unsigned int l;

  l = strlen(src);

  if( l <= max_len )
    return( strcpy( dest, src ) );
  else
  {
    (void) strncpy( dest, src, max_len - 3 );
    (void) strcpy( &dest[max_len - 3], "..." );
    return( dest );
  }
}



/*****************************************************************************
 *                                  Fnsplit                                  *
 *****************************************************************************/

/* Aufsplitten des Dateinamens in die einzelnen Komponenten */

void Fnsplit(char *path, char *dir, char *name)
{
  int  i;
  char *name_begin;
  char *trunc_name;

  while( *path == ' ' || *path == '\t' ) path++;

  while( strchr(path, FILE_SEPARATOR_CHAR ) || strchr(path, '\\') )
    *(dir++) = *(path++);

  *dir = '\0';
  
  name_begin = path;
  trunc_name = name;

  for(i=0; i < PATH_LENGTH && *path; i++ ) 
    *(name++) = *(path++);

  *name = '\0';

  if( i == PATH_LENGTH && *path )
  {
    (void) sprintf( message, "filename too long:*%s*truncating to*%s", 
		    name_begin, trunc_name
		  );
    WARNING( message );
  }
}



void HitReturnToContinue(void)
{
  vidattr( A_REVERSE );
  putp( "[Hit return to continue]" );
  vidattr( 0 );
  (void) fflush( stdout );
  (void) getch();
  doupdate();
}




int BuildFilename( char *in_filename,
		   char *pattern,
		   char *out_filename
		 )
{
  char *cptr;
  int  result = 0;


  for( ; *pattern; pattern++ )
  {
    if( *pattern == '*' )
    {
      cptr = in_filename;
      for( ; (*out_filename = *cptr); out_filename++, cptr++ );
    }
    else
    {
      *out_filename++ = *pattern;
    }
  }

  *out_filename = '\0';

  return( result );
}



int GetFileMethod( char *filename )
{
  int i, k, l;

  l = strlen( filename );

  for( i=0; 
       i < sizeof( file_extensions ) / sizeof( file_extensions[0] ); 
       i++ 
     )
  {
    k = strlen( file_extensions[i].extension );
    if( l >= k && !strcmp( &filename[l-k], file_extensions[i].extension ) )
      return( file_extensions[i].method );
  }

  return( NO_COMPRESS );
}




BOOL KeyPressed()
{
  BOOL pressed = FALSE;

#if !defined( linux ) || !defined( TERMCAP )
  nodelay( stdscr, TRUE );
  if( wgetch( stdscr ) != ERR ) pressed = TRUE;
  nodelay( stdscr, FALSE );
#endif /* linux/TERMCAP */

  return( pressed );
}


BOOL EscapeKeyPressed()
{
  BOOL pressed = FALSE;
  int  c;

#if !defined( linux ) || !defined( TERMCAP )
  nodelay( stdscr, TRUE );
  if( ( c = wgetch( stdscr ) ) != ERR ) pressed = TRUE;
  nodelay( stdscr, FALSE );
#endif /* linux/TERMCAP */

  return( ( pressed && c == ESC ) ? TRUE : FALSE );
}




#ifdef __NeXT__

char *getcwd(char *dest, int len)
{
  static char  buffer[MAXNAMLEN];
  DIR    *dirp;
  struct direct  *dp;
  long   inode;
  char   *cp = buffer + MAXNAMLEN - 1;

  *cp = 0;

  do {
    dirp = opendir(".");
    for (dp=readdir(dirp); dp; dp=readdir(dirp)) {
      if(dp->d_namlen && !strcmp(dp->d_name,".")) {
        break;
      }
    }
    if (inode == dp->d_ino) break;
    inode = dp->d_ino;
    (void) closedir(dirp);
    dirp = opendir("..");
    for (dp=readdir(dirp); dp && (dp->d_ino != inode); dp=readdir(dirp));
    cp -= dp->d_namlen;
    (void) strncpy(cp,dp->d_name,dp->d_namlen);
    *--cp = FILE_SEPARATOR_CHAR;
    (void) closedir(dirp);
  } while(!chdir(".."));
  
  (void) chdir(cp+2);
  (void) strncpy(dest,cp+2,len);
}


#endif


#ifdef VI_KEYS

int ViKey( int ch )
{
  switch( ch )
  {
    case VI_KEY_UP:    ch = KEY_UP;    break;
    case VI_KEY_DOWN:  ch = KEY_DOWN;  break;
    case VI_KEY_RIGHT: ch = KEY_RIGHT; break;
    case VI_KEY_LEFT:  ch = KEY_LEFT;  break;
    case VI_KEY_PPAGE: ch = KEY_PPAGE; break;
    case VI_KEY_NPAGE: ch = KEY_NPAGE; break;
  }
  return(ch);
}

#endif /* VI_KEYS */

  
#ifdef _IBMR2
#undef wgetch

int AixWgetch( WINDOW *w )
{
  int c;
  
  if( ( c = wgetch( w ) ) == KEY_ENTER ) c = LF;

  return( c );
}

#endif



void NormPath( char *in_path, char *out_path )
{
  char *s, *d;
  char *old, *opath;
  int  level;
  char *in_path_dup;

  level = 0;
  opath = out_path;

  if( ( in_path_dup = malloc( strlen( in_path ) + 1 ) ) == NULL ) {
    ERROR_MSG( "Malloc Failed*ABORT" );
    exit( 1 );
  }

  if( *in_path == FILE_SEPARATOR_CHAR ) {
    s = in_path + 1;
    *opath++ = FILE_SEPARATOR_CHAR;
  } else {
    s = in_path;
  }

  for( d=in_path_dup; *s; d++ ) {
    *d = *s++;
    while( *d == FILE_SEPARATOR_CHAR && *s == FILE_SEPARATOR_CHAR )
      s++;
  }
  *d = '\0';

  d = opath;
  s = Strtok_r( in_path_dup, FILE_SEPARATOR_STRING, &old );
  while( s ) {
    if( strcmp( s, "." ) ) {		/* skip "." */
      if( !strcmp( s, ".." ) ) {	/* optimize ".." */
        if( level > 0 ) {
          if( level == 1 ) {
	    d = out_path;
	  } else {
	    for( d -= 2; *d != FILE_SEPARATOR_CHAR; d-- )
	      ;
	    d++;
	  }
        } else {
          /* level <= 0 */
	  *d++ = '.';
	  *d++ = '.';
	  *d++ = FILE_SEPARATOR_CHAR;
        }
        level--;
      } else {				/* add component */
        strcpy( d, s );
        d += strlen( s );
        *d++ = FILE_SEPARATOR_CHAR;
        level++;
      }
    }
    s = Strtok_r( NULL, FILE_SEPARATOR_STRING, &old );
  }
  if( level != 0 )
    d--;
  *d = '\0';
  if( *out_path == '\0' )
    strcpy(out_path, "." );

  free( in_path_dup );
}



/* reentrantes strtok */
char *Strtok_r( char *str, char *delim, char **old )
{
  char *result;
  int  l, m;

  if( str == NULL ) 
    str = *old;

  if( str == NULL )
    return( NULL );

  l = strlen( str );
  if( ( result = strtok( str, delim ) ) != NULL ) {
    m = strlen( result );
    if( (m + 1) >= l)
      *old = NULL;
    else 
      *old = result + m + 1;
      
  } else 
    *old = NULL;

  return( result );
}




void GetMaxYX(WINDOW *win, int *height, int *width)
{
  if( win == dir_window )
  { 
    *height = DIR_WINDOW_HEIGHT;
    *width  = DIR_WINDOW_WIDTH;
  }
  else if( win == small_file_window )
  {
    *height = FILE_WINDOW_1_HEIGHT;
    *width  = FILE_WINDOW_1_WIDTH;
  }
  else if( win == big_file_window )
  {
    *height = FILE_WINDOW_2_HEIGHT;
    *width  = FILE_WINDOW_2_WIDTH;
  }
  else if( win == f2_window )
  {
    *height = F2_WINDOW_HEIGHT - 1; /* fake for separator line */
    *width  = F2_WINDOW_WIDTH;
  }
  else if( win == history_window )
  {
    *height = HISTORY_WINDOW_HEIGHT;
    *width  = HISTORY_WINDOW_WIDTH;
  }
  else
  {
    ERROR_MSG( "Unknown Window-ID*ABORT" );
    exit( 1 );
  }
}


int Strrcmp(char *s1, char* s2)/*compares in reverse order 2 strings*/
{
   int aux;
   int l1 = strlen(s1);
   int l2 = strlen(s2);

   for (aux = 0; aux <= l2; aux++)
   {
      if ((l1 - aux) < 0) 
	return(-1);
      if (s1[l1 - aux] > s2[l2 - aux])
         return(1);
      else if (s1[l1 - aux] < s2[l2 - aux])
         return(-1);
   }
   return(0);
}



/* NeXT does not define strdup */
char *Strdup(char *s)
{
  char *cp = NULL;

  if (s) {
    cp = malloc(strlen(s)+1);
    if (cp) strcpy(cp,s);
  }
  return(cp);
}


char *GetExtension(char *filename)
{
  char *cptr;

  cptr = strrchr(filename, '.');

  return( (cptr) ? cptr + 1 : "" );
}




void StrCp(char *dest, const char *src)
{
   static char esc_chars[] ="#*|&;()<> \t\n\r\"!$?'`~";

   while(*src)
   {
     if(strchr(esc_chars, *src))
       *dest++ = '\\';
     *dest++ = *src++;
   }
   *dest = '\0';
}

