;;; -*- Emacs-Lisp -*-
;;; Window manager for GNU Emacs.
;;; $Id: windows.el,v 2.26 1999/05/14 05:43:38 yuuji Exp $
;;; (c) 1993-1999 by HIROSE Yuuji [yuuji@gentei.org]
;;; Last modified Fri May 14 14:35:14 1999 on firestorm

;;;		Window manager for GNU Emacs
;;;
;;;[What is Windows?]
;;;
;;;	  You can divide  the screen of GNU Emacs  as many as you  like.
;;;	Since efficiency of implementation or so  depends  much  on  the
;;;	style  of  window division,  you  may have  your  own  style  of
;;;	partitioning.   But  if you  switch the  mode to  e-mail mode or
;;;	NetNews mode, they break your favorite style.
;;;	  Windows.el  enables  you  to  have  multiple  favorite  window
;;;	configurations at the  same time, and switch them.  Furthermore,
;;;	it can save all window  configurations into a  file and  restore
;;;	them correctly.
;;;
;;;  **For Emacs 19 or later**
;;;
;;;	 This package provides  the `named(numbered) frame'  that can be
;;;	selected directly with their name.   With revive.el, all frames'
;;;	displaying buffers,  window configurations and size can be saved
;;;	and restored.
;;;
;;;[Installation]
;;;
;;;	  Put windows.el into the directory load-path indicates, and put
;;;	the following expressions into your ~/.emacs.
;;;
;;;	   (require 'windows)
;;;	   (win:startup-with-window)
;;;	   (define-key ctl-x-map "C" 'see-you-again)
;;;
;;;[Key Bindings]
;;;
;;;	  The default prefix key stroke for Windows is `C-c C-w'.  If it
;;;	causes  you some  troubles, see  the  section  `Customizations'.
;;;	Here are the default key bindings.
;;;
;;;		C-c C-w 1		Switch to window 1 (Q)
;;;		C-c C-w 2		Switch to window 2 (Q)
;;;		   :
;;;		C-c C-w 9		Switch to window 9 (Q)
;;;		C-c C-w 0		Swap windows with the buffer 0 (Q)
;;;					(Select unallocated frame(Emacs 19))
;;;		C-c C-w SPC		Switch to window previously shown (Q)
;;;		C-c C-w C-n		Switch to next window
;;;		C-c C-w C-p		Switch to previous window
;;;		C-c C-w !		Delete current window (Q)
;;;		C-c C-w C-w		Window operation menu
;;;		C-c C-w C-r		Resume menu
;;;		C-c C-w C-l		Local resume menu
;;;		C-c C-w C-s		Switch task
;;;		C-c C-w =		Show window list (Q)
;;;
;;;	  The  key strokes  to  select  windows from  1    to 9 must  be
;;;	frequently used, so the alternative key strokes `C-c [Num.]' are
;;;	available  by default  (And  any  function  with (Q)mark can  be
;;;	invoked without  C-w).  To disable these  quick key strokes, set
;;;	the variable win:quick-selection to `nil' in your ~/.emacs.
;;;
;;;[Description]
;;;(for Emacs19 or later)
;;;
;;;	  Windows.el manages   maximum  10 (or   more if you  configure)
;;;	frames.  The first frame is `window#1'.  If you want to create a
;;;	new frame as  `window#2', type `C-c  C-w 2'.  You can  create or
;;;	switch  numbered frames as  many  as you  want.  Unlike standard
;;;	Emacs's frame selection (`C-x  5 o'), windows.el enables you  to
;;;	go to the desired frame directly.
;;;
;;;	  For    detailed  frame  management,   read the  section `Other
;;;	functions'.  In that section, the term `window' is used to refer
;;;	the frame.
;;;
;;;[Description]
;;;(for Emacs18 or emacs -nw)
;;;
;;;	  Windows.el has 10 window buffers,  from 0 to  9.   But you can
;;;	use the buffer from 1 to 9,  the  buffer 0 is reserved  for  the
;;;	most recently  used window  (This  is  not true  for  the  frame
;;;	environment of Emacs 19).
;;;
;;;	  If you  have  wrote `win:startup-with-window' in your  .emacs,
;;;	the initial  window configuration is memorized  in the buffer 1.
;;;	Otherwise you    have to memorize   it by   typing `C-c  C-w 1'.
;;;	Anyway, say you are editing some program in buffer 1.
;;;
;;;	  After a  while, a mail has arrived.   You may wish to assign a
;;;	mail mode configuration  to the  buffer 2.   Type `C-c C-w 2' to
;;;	create the buffer 2,  and  you  will  see  the  `window creation
;;;	menu':
;;;
;;;		C)reate D)uplicate P)reserve F)indfile B)uff X)M-x N)o:
;;;
;;;	in the  minibuffer.   Since  you don't need  the current  window
;;;	configuration  (programming  configuration) to read  mails, type
;;;	`c', stands for Create, to create the new  window configuration.
;;;	Then, after invoke the mail reader, current window configuration
;;;	will turn to mail oriented one. (Of course you can directly call
;;;	e-mail mode by typing `x' at the window creation menu.) When you
;;;	finish  to  read  your  mail,  you  can  return  to  programming
;;;	configuration with `C-c C-w 1'.
;;;
;;;	  Let's read the NetNews.  M-x gnus...  O.K.!  You've read.  You
;;;	may have typed `q' to quit gnus until yesterday.   But you don't
;;;	have to do it  from  today.   You  can go  back  to  programming
;;;	immediately by typing  `C-c C-w 1'!  Oops, you  have not created
;;;	the  new  configuration buffer  yet.  So the  window  you see is
;;;	still the window 1.  If you switch the window to another, you'll
;;;	lose the  configuration in the buffer 1.  In this case, type `p'
;;;	(stands for  Preserve) at the window creation  menu after typing
;;;	`C-c C-w  3'(%1).   Windows.el doesn't  update the  buffer 1 and
;;;	saves  the  current window configuration of the NetNews into the
;;;	buffer 3.
;;;   **On Emacs-19,  you can't preserve  the buffer contents unless you 
;;;	have saved it into the resume file described below.
;;;
;;;	  Then, type `C-c C-w 2' to read the mail, type `C-c C-w 3' when
;;;	you are  tired with    programming.   `C-c  C-w  SPC' is    very
;;;	convenient when you want to exchange two configurations.
;;;
;;;	  If you forget what windows are  allocated to the buffers, type
;;;	`C-c C-w =' to display  the configuration buffer names and their
;;;	corresponding  editing buffer names in    the menu buffer.   The
;;;	entry preceded by `*' is the selected  buffer and the entry with
;;;	`+'  is the buffer previously  selected(that is, the buffer `C-c
;;;	C-w SPC' will select).  In this buffer, you can move cursor with
;;;	`n' or `p', and select that window  with SPC.  Type `?' for more
;;;	information.
;;;
;;;	(%1)
;;;	At a point of this time, while window configuration buffer holds
;;;	the  programming environment,  the screen of GNUS  is displayed.
;;;	And,  notice  that `p'(Preserve)  at  the  window creation  menu
;;;	doesn't  work  when the  Windows uses `frame' as window unit  on
;;;	Emacs 19.
;;;
;;;[Other functions]
;;;
;;;	  Typing `C-c C-w C-w' displays the menu as follows.
;;;
;;;	N)ext P)rev R)ecent D)elete K)ill S)ave2buf L)oad-from-buf A)save-As
;;;
;;;	In this menu, `n',  `p' is for  switching window to the next  or
;;;	previous, `r' is for recovering the  window recently seen before
;;;	the window switching operation(%2), `d' is for  deleting current
;;;	window.  `k' is same as `d' except  closing all visible file(s).
;;;	And type `s' to save  the current window  configuration into the
;;;	corresponding   buffer,  `a'   to    save  the   current  window
;;;	configuration into specified buffer.  Note that `s' and `l' is
;;;	unavailable on frame environment.
;;;
;;;	(%2)
;;;	When using frame on Emacs 19, it is impossible  to store a frame
;;;	recently seen, so `r'  (win-recent-window)  selects a frame that
;;;	is not  allocated to Windows instead, if any (equivalent to `C-c
;;;	C-w 0').
;;;
;;;	  When you  create  the  new window, you see the window creation
;;;	menu which  ask you  how to  handle  the  current  configuration
;;;	buffer  and  what  configuration the  new  window must  be.  The
;;;	entries of the prompt stand for the followings.
;;;
;;;		Create		After saving the current window
;;;				configuration into the current buffer,
;;;				create a newly allocated window.
;;;		Duplicate	After saving the current window
;;;				configuration into the current buffer,
;;;				create the new window with the same
;;;				configuration as the current one.
;;;		Preserve	Without updating the current buffer,
;;;				use the current window configuration
;;;				as the new window.  This function is not
;;;				available on Emacs 19 with frame.
;;;		Findfile	Find-file on new window.
;;;		Buff		Switch to buffer on new window.
;;;		M-x		Call a command on new window.
;;;		No		Cease window creation.
;;;
;;;[Resume]
;;;
;;;	  Windows.el  can  resume  your  environment  with  a  help   of
;;;	`revive.el'.  You can see the menu by typing `C-c C-w C-r'.
;;;
;;;	     A)save-all R)estore-all S)ave-this L)oad-this N)Load# ~)read-~
;;;
;;;	Type `a' to save all window configurations into a file, and type
;;;	`r' to restore configurations saved  in that  file.  `s' to save
;;;	the  current window configuration, `l'  to  load current  window
;;;	from file, `n' to load a window specified by a  number.  And use
;;;	`~' when you type `a' instead of `r' by mistake.  And it is much
;;;	more convenient  to kill emacs with `C-x  C'.   If you  want  to
;;;	resume that  context, call  `resume-windows' (or C-c C-w  C-r r)
;;;	just after starting Emacs.
;;;
;;;[Local resume]
;;;
;;;	  If you want to have  many sets of window  configurations, type
;;;	`C-c   C-w  C-l'   to  specify  the  directory   where   another
;;;	configuration file is to resid,  and operate in the same way  as
;;;	you  do in resume menu described  above.  You can change sets of
;;;	configurations directory by directory.
;;;
;;;	  By  the  way,  most  of  tasks  are being  done  in a  certain
;;;	directory.   If you have a couple of or more jobs to do at once,
;;;	the  function  `win-switch-task' is very useful  to  switch your
;;;	tasks.  It  saves the current  set of window configurations into
;;;	current configuration file, flushes buffers, and reads  the next
;;;	set of window  configurations for  the  next task  from  another
;;;	configuration file.
;;;
;;;[Customizations]
;;;
;;;	  To change  the prefix key stroke  to  `C-c w' for example,
;;;	put the following expressions into your ~/.emacs.
;;;
;;;		(setq win:switch-prefix "\C-cw")
;;;		(define-key global-map win:switch-prefix nil)
;;;		(define-key global-map "\C-cw1" 'win-switch-to-window)
;;;
;;;	And you can also change the key stroke of window selection to
;;;	`a' to `z' other than `1' to `9'.
;;;
;;;		(setq win:switch-prefix "\C-cw")
;;;		(define-key global-map win:switch-prefix nil)
;;;		(define-key global-map "\C-cwb" 'win-switch-to-window)
;;;		(setq win:base-key ?`)		;; '`' is before 'a'
;;;		(setq win:max-configs 27)	;; '`' to 'z' are 27 chars.
;;;		(setq win:quick-selection nil)	;; Not assign `C-c LETTER'
;;;
;;;	Notice that '`' is the previous character  of 'a' in ASCII code,
;;;	and  that C-c w  ` is bound  to swap  the configuration  in  the
;;;	buffer '`' and the current buffer.
;;;
;;;	  If you don't use `frame' even on Emacs 19 with X Window.  Set
;;;	win:use-frame to nil in ~/.emacs.
;;;
;;;	  If you hate raising of  frames at win-save-all-configurations,
;;;	set win:no-raise-at-save to t.
;;;
;;;[For frame users]
;;;
;;;	  When you start to use windows.el,  you may create  a new frame
;;;	with  old  operation  `C-x  5 f'  or  so.  Frames  created  with
;;;	standard frame operation are not marked in the windows ring.  To
;;;	incorporate sucn an  orphan frame into  windows  ring, type `C-c
;;;	C-w C-w' and select `A)save-as' from the menu.   And if you want
;;;	to switch to  orphan frames, type  `C-c C-w 0',  which  switches
;;;	frame to isolated frames and rotate them.
;;;
;;;	By default, windows.el name a frame title (bar) as follows.
;;;	
;;;		Emacs[1]:*scartch*
;;;	
;;;	This causes frame  title  always representing the frame  number.
;;;	So you can switch   to any of  them with  key operation  of your
;;;	window manager, `fvwm' for example:
;;;	--- .fvwmrc ---
;;;	key 1 A C Warp "" Emacs[1]
;;;	key 2 A C Warp "" Emacs[2]
;;;	  :
;;;	key 9 A C Warp "" Emacs[9]
;;;	
;;;	If you use fvwm2
;;;	AddToFunc DeiconifyFocusAndWarp "I" Iconify -1
;;;	+				"I" FocusAndWarp $0 $1
;;;	
;;;	Key 1 A C	Next [Emacs?1?:*] DeiconifyFocusAndWarp
;;;	 :
;;;	Key 9 A C	Next [Emacs?9?:*] DeiconifyFocusAndWarp
;;;	#(fvwm2 can't escape [ and ], so cause matches with them by ?s.)
;;;
;;;	Thus C-1, C-2, ..., C-9 directly select window frame `Emacs[1]'
;;;	through `Emacs[9]'.
;;;	In this  hook, two  variables  `frame'  and `index', which  have
;;;	frame object, frame number respectively, are available.
;;;
;;;[Bugs]
;;;
;;;	  This  program  was inspired from  `screen', the window manager
;;;	for VT100  emulation  terminal, and operations are fundamentally
;;;	based on it.  But there is no compatibility.
;;;
;;;	  When  restoring  frames  of  Emacs  19,  the  order  of  frame
;;;	allocation is  not restored, that is,  its order depends on  the
;;;	frame  where  win-load-all-configurations  is called.  No  frame
;;;	positions are not recovered neither.
;;;
;;;[Copying]
;;;
;;;	  This program is distributed as a free  software. The author is
;;;	not responsible  for  any  possible   defects   caused  by  this
;;;	software.
;;;
;;;	  Comments and bug reports  are  welcome.   Don't  hesitated  to
;;;	report.  My possible e-mail address is following.
;;;
;;;							yuuji@gentei.org
;;;
;;; Japanese Document follows:
;;;
;;;		GNU Emacs $BMQJT=82hLL%^%M!<%8%c(B [windows]
;;;
;;;$B!Z$G$-$k;v![(B
;;;
;;;	  GNU Emacs $B$G$O=D2#G$0U$N?t$@$1%&%#%s%I%&$rJ,3d$7$F:n6H$r$9$k;v(B
;;;	$B$,$G$-$^$9!#%W%m%0%i%`$r3+H/$9$k;~$J$I$N%&%#%s%I%&J,3d$O8zN($KBg(B
;;;	$B$-$/1F6A$9$k$N$G!"?M$K$h$C$F9%$_$NJ,3d7ABV$r;}$C$F$$$k;v$G$7$g$&!#(B
;;;	$B$7$+$7$=$NESCf$G!"%a%$%k$d%K%e!<%9$rFI$`$H$=$NJ,3d7ABV$r2u$5$l$F(B
;;;	$B$7$^$$$^$9!#@5$7$$<j=g$G%a%$%k%j!<%@%b!<%I$r=*$o$l$PNI$$$N$G$9$,!"(B
;;;	$B$=$l$@$H$^$?%a%$%k$,Mh$?;~$K:F$S%a%$%k%j!<%@%b!<%I$r5/F0$7$J$1$l(B
;;;	$B$P$J$j$^$;$s!#(B
;;;	  windows.el $B$r%m!<%I$9$k$H!"9%$_$N%&%#%s%I%&J,3d7ABV$rJ#?t;}$A!"(B
;;;	$B$=$l$i$r@ZBX$($J$,$i(B Emacs $B$r;H$&;v$,$G$-$^$9!#$5$i$K!"$=$NJ,3d(B
;;;	$B7ABV$NA4$F$r%U%!%$%k$K%;!<%V$7!"$$$D$G$b$=$l$i$rI|85$9$k$3$H$,$G(B
;;;	$B$-$^$9!#(B
;;;
;;;	  Emacs 19(Mule2) $B0J9_$G$O!"F1MM$NA`:nBN7O$G(B frame $B$rC10L$H$7$F(B
;;;	$B%&%#%s%I%&@ZBX$(A`:n$r9T$$$^$9!#$5$i$KJ,3d7ABVI|85;~$K$O%U%l!<%`(B
;;;	$B$N%5%$%:$H0LCV$bCi<B$K:F8=$7$^$9!#%U%l!<%`$N7y$$$J?M$OJQ?t$N@_Dj(B
;;;	$B$K$h$j%U%l!<%`$r;H$o$J$$%&%#%s%I%&$N@Z$jBX$($GMxMQ$9$k$3$H$b$G$-(B
;;;	$B$^$9!#(B
;;;
;;;$B!Z=`Hw![(B
;;;
;;;	  windows.el $B$r(B load-path $B$NDL$C$?%G%#%l%/%H%j$KF~$l$F$/$@$5$$!#(B
;;;	$B$=$7$F0J2<$N9T$r(B .emacs $B$KF~$l$F$/$@$5$$!#(B
;;;
;;;	   (require 'windows)
;;;	   (define-key global-map "\C-xC" 'see-you-again)
;;;	   (win:startup-with-window)
;;;
;;;
;;;$B!Z%-!<Dj5A![(B
;;;
;;;	  $B%G%U%)%k%H$N%W%j%U%#%/%9%-!<$O(B C-c C-w $B$G$9!#$3$l$G$OITET9g$J(B
;;;	$B>l9g$O!X%-!<%+%9%?%^%$%:!Y$N9`$r;2>H$7$F$/$@$5$$!#I8=`>uBV$N%-!<(B
;;;	$B%P%$%s%I$O0J2<$N$h$&$K$J$C$F$$$^$9!#(B
;;;
;;;		C-c C-w 1	$BJ,3d>uBV(B 1 $B$X(B (Q)
;;;		C-c C-w 2	$BJ,3d>uBV(B 2 $B$X(B (Q)
;;;		   :
;;;		C-c C-w 9	$BJ,3d>uBV(B 9 $B$X(B (Q)
;;;		C-c C-w 0	$BD>A0$NJ,3d>uBV$X(B($B%P%C%U%!(B0$B$H8r49(B) (Q)
;;;		C-c C-w SPC	$BJ,3d>uBV(B1$B!A(Bn$B$N$&$A!"D>A0MQ$$$?$b$N$X(B (Q)
;;;		C-c C-w n	$B<!$NJ,3d>uBV$X(B(C-c SPC)
;;;		C-c C-w p	$BA0$NJ,3d>uBV$X(B
;;;		C-c C-w !	$B8=:_$N%&%#%s%I%&$rGK4~(B (Q)
;;;		C-c C-w C-w	$B%&%#%s%I%&A`:n%a%K%e!<(B
;;;		C-c C-w C-r	$B%j%8%e!<%`%a%K%e!<(B
;;;		C-c C-w C-l	$B%m!<%+%k%j%8%e!<%`%a%K%e!<(B
;;;		C-c C-w C-s	$B%?%9%/@ZBX$((B
;;;		C-c C-w =	$BJ,3d>uBVJ]B8%P%C%U%!0lMwI=<((B (Q)
;;;
;;;	  1 $BHV$+$i(B 9 $BHV$^$G$N%&%#%s%I%&A*Br$OHs>o$KIQHK$KMQ$$$i$l$k$N$G!"(B
;;;	$B!V(BC-c $BHV9f!W$G$b@Z$jBX$($,$G$-$k$h$&$K$J$C$F$$$^$9(B($B$=$NB>(BQ$B%^!<%/(B
;;;	$B$NIU$$$F$$$k%-!<%P%$%s%IA4$F$O(B C-w $B$rBG$?$J$/$F$b$h$$(B)$B!#$3$l$rL5(B
;;;	$B8z$K$9$k$?$a$K$O!"(B~/.emacs $B$J$I$GJQ?t(B win:quick-selection $B$r(B nil 
;;;	$B$K%;%C%H$7$F$/$@$5$$!#(B
;;;
;;;$B!Z@bL@![(B
;;;
;;;	  windows.el $B$K$O(B0$B$+$i(B9$B$^$G$N(B10$B8D$N%P%C%U%!$,MQ0U$5$l$F$$$^$9!#(B
;;;	$B$3$N$&$A%f!<%6$,9%$_$NJ,3d>uBV$rJ]B8$5$;$k$?$a$K;H$($k$N$O(B1$B!A(B9 
;;;	$B$G!"(B0$BHV$O<+F0E*$KD>A0$NJ,3d>uBV$r%;!<%V$9$k$?$a$K;H$o$l$^$9(B
;;;	(Emacs-19$B0J9_$G$O(Bwindows$B$K3d$jEv$F$i$l$F$$$J$$(Bframe$B$X$N%8%c%s%W(B)$B!#(B
;;;
;;;	  win:startup-with-window $B$r(B .emacs $B$K=q$$$F$$$k>l9g$O5/F0;~$NJT(B
;;;	$B=8>uBV$,$=$N$^$^(B1$BHV$N%P%C%U%!$K3JG<$5$l$F$$$^$9!#$=$&$G$J$$>l9g(B
;;;	$B$O2?$+(B C-c C-w 1 $B$r2!$7$F:G=i$NJT=8>uBV$r(B1$BHV$N%P%C%U%!$K5-21$5$;(B
;;;	$B$^$9!#(B
;;;
;;;	  $B$5$F!"(B1$BHV$K8=>u$rJ]B8$7$?>uBV$G!"%a%$%k$rFI$_$^$7$g$&!#%a%$%k(B
;;;	$B$O(B2$BHV$N%&%#%s%I%&$K3d$jEv$F$^$9!#(BC-c C-w 2 $B$r2!$9$H:#EY$O(B
;;;
;;;		C)reate D)uplicate P)reserve F)indfile B)uff X)M-x N)o:
;;;
;;;	$B$H=P$FMh$^$9(B($B$3$l$r%&%#%s%I%&@8@.%a%K%e!<$H8F$V$3$H$K$7$^$9(B)$B!#%a(B
;;;	$B%$%k$rFI$`$?$a$K$O8=:_$NJ,3d>uBV$OI,MW$"$j$^$;$s$+$i!"(BCreate $B$N(B 
;;;	c $B$r2!$7$F?75,%&%#%s%I%&$r:n@.$7$^$9!#$=$3$G%a%$%k%j!<%@$r5/F0$9(B
;;;	$B$k$H!"%&%#%s%I%&$NJ,3d>uBV$,%a%$%k@lMQ$K$J$j$^$9(B($B$b$A$m$s%a%K%e!<(B
;;;	$B$G(Bx$B$r2!$7$FD>@\%a%$%k%j!<%@$r5/F0$7$F$b$+$^$$$^$;$s(B)$B!#FI$_=*$o$C(B
;;;	$B$?$i(B C-c C-w 1 $B$r2!$9$H!"(B1$BHV$N%P%C%U%!$KJ]B8$5$l$F$$$k!":G=i$N%W(B
;;;	$B%m%0%i%`JT=8>uBV$K@Z$jBX$o$j$^$9!#$3$l$G%W%m%0%i%`:n@.$KD>$A$KLa(B
;;;	$B$l$^$9!#(B
;;;
;;;	  $B:#EY$O%K%e!<%9$rFI$_$^$7$g$&!#(BM-x gnus $B!&!&!&!#$O$$FI$_=*$o$j(B
;;;	$B$^$7$?!#$$$^$^$G$O(B q $B$G=*N;$7$F$$$^$7$?$,!":#F|$+$i$O0c$$$^$9!#(B 
;;;	C-c C-w 1 $B$GI|5"$G$-$k$N$G$9!#$O$$!"(BC-c C-w 1$B!#$*$C$H!"?75,%&%#(B
;;;	$B%s%I%&$r:n@.$9$k$N$rK:$l$F$$$?$N$G!"$^$@(B1$BHV$N%&%#%s%I%&$K$$$?$N(B
;;;	$B$G$7$?!#$3$N$^$^(B(%1)$B$G$O$;$C$+$/(B1$BHV$KJ]B8$7$?%W%m%0%i%`JT=8>uBV(B
;;;	$B$,>C$($F$7$^$$$^$9!#$=$s$J;~$O!"(BC-c C-w 3 $B$r2!$7$F%&%#%s%I%&@8@.(B
;;;	$B%a%K%e!<$,=P$?$H$3$m$G!"(BPreserve $B$N(B p $B$r2!$7$F$/$@$5$$!#(B1$BHV$N%P%C(B
;;;	$B%U%!$NFbMF$O99?7$;$:$K!"8=>u$N%&%#%s%I%&>uBV$r(B3$BHV$N%P%C%U%!$KJ](B
;;;	$BB8$7$^$9!#(B
;;;   **Mule2$B$G$O%j%8%e!<%`(B($B8e=R(B)$B%U%!%$%k$K8=:_$N>uBV$,%;!<%V$5$l$F$$$J(B
;;;	$B$$8B$j!"J,3d>uBV$rI|5l$9$k$3$H$,$G$-$^$;$s!#(B
;;;
;;;	  $B$"$H$O%a%$%k$,Mh$?$i(B C-c C-w 2 $B$r!"%W%m%0%i%`$KK0$-$?$i(B C-c
;;;	C-w 3 $B$r2!$7$F0lF|$r2a$4$7$^$7$g$&!#%a%$%k$H%K%e!<%9$@$1$rFI$_B3(B
;;;	$B$1$k>l9g$N$h$&$KFs$D$N>uBV$r9T$C$?$jMh$?$j$9$k>l9g$O(B C-c C-w SPC 
;;;	$B$,JXMx$G$9!#(B
;;;
;;;	  $B!V$"$l!"%a%$%k$O$$$^2?HV$N%&%#%s%I%&$@(B?$B!W$HJ,$+$i$J$/$J$C$?$i!"(B
;;;	C-c C-w = $B$r2!$7$^$7$g$&!#%_%K%P%C%U%!$KHV9f$H!"BP1~$9$k%P%C%U%!(B
;;;	$BL>$,%a%K%e!<%P%C%U%!$KI=<($5$l$^$9!#$3$N$&$A!"(B $B%P%C%U%!L>$NF,$K(B*
;;;	$B$,IU$$$F$$$k$b$N$,8=:_A*Br$7$F$$$k%P%C%U%!$G!"(B +$B$,IU$$$F$$$k$b$N(B
;;;	$B$,D>A0$KA*Br$7$F$$$?%P%C%U%!$G$9(B($B$D$^$j(B  C-c C-w SPC $B$N9T$-@h(B)$B!#(B
;;;	$B%a%K%e!<%P%C%U%!$G$O!"(B n $B$d(B p $B$r2!$7$F@ZBX$($?$$%&%#%s%I%&$N0LCV(B
;;;	$B$^$G0\$j!"(B SPC $B$G$=$N%&%#%s%I%&$K@ZBX$($k$3$H$,$G$-$^$9!#$^$?(B d,
;;;	k, s, l $B$r2!$9$H9TF,$K(B D, K,  S, L $B%^!<%/$,IU$-$^$9!#$3$3$G(B x $B$r(B
;;;	$B2!$9$H%^!<%/$rIU$1$?%P%C%U%!$KBP$7!"$=$l$>$l!V:o=|!W!"!VI=<($5$l(B
;;;	$B$F$$$k%P%C%U%!$b4^$a$F:o=|(B(kill)$B!W!"!V>uBV$r%U%!%$%k$K%;!<%V!W!"(B
;;;	$B!V>uBV$r%U%!%$%k$+$i%m!<%I!W$r9T$$$^$9!#>\$7$/$O!"%a%K%e!<%P%C%U%!(B
;;;	$B$G(B ? $B$r2!$7$F$/$@$5$$!#(B
;;;
;;;	(%1)
;;;	$B$3$N>uBV$G$O%P%C%U%!$K%W%m%0%i%`JT=8>uBV$,J]B8$5$l!"%&%#%s%I%&$K(B
;;;	GNUS$B$N2hLL$,I=<($5$l$F$$$k!#$J$*!"(BPreserve $B$O(B Emacs 19 $B$G(Bframe$B$r(B
;;;	$B@ZBX$(C10L$H$9$k>l9g$K$OMxMQ$G$-$J$$$N$GCm0U$7$F2<$5$$!#(B
;;;
;;;$B!Z$=$NB>:Y$+$$5!G=![(B
;;;
;;;	  C-c C-w C-w $B$r2!$9$H0J2<$N$h$&$J%a%K%e!<$,=P$FMh$^$9!#(B
;;;
;;;	N)ext P)rev R)ecent D)elete K)ill S)ave2buf L)oad-from-buf A)save-As
;;;
;;;	n, p $B$O$=$l$>$l0l$DA0(B/$B<!$N%P%C%U%!$NA*Br$7$^$9!#(Br $B$O%&%#%s%I%&@Z(B
;;;	$B$jBX$($9$kD>A0$KI=<($7$F$$$?2hLL$XI|5"$7$^$9(B(%2)$B!#(Bd $B$O8=:_A*Br$7(B
;;;	$B$F$$$kHV9f$N%P%C%U%!$r>C5n$7$^$9!#(Bk $B$O(B d $B$HF1$8$G$9$,!"8=:_8+$((B
;;;	$B$F$$$k%U%!%$%k$bF1;~$K%/%m!<%:$7$^$9!#(Bl $B$O4V0c$($F(B C-x 1 $B$7$F$7(B
;;;	$B$^$C$?;~$J$I$K!"%P%C%U%!$K%;!<%V$5$l$F$$$k%&%#%s%I%&>uBV$r6/@)E*(B
;;;	$B$KFI$_D>$9;~$K;H$$$^$9!#(Bs $B$O8=:_8+$F$$$k>uBV$r6/@)E*$KBP1~$9$k%P%C(B
;;;	$B%U%!$K%;!<%V$9$k0Y$K;H$$!"(Ba $B$O%;!<%V$9$k%P%C%U%!HV9f$rJLES;XDj$9(B
;;;	$B$k;~$K;H$$$^$9!#(B
;;;
;;;	(%2)
;;;	Emacs 19 $B$N(B frame $B5!G=$G%&%#%s%I%&@ZBX$($r9T$&>l9g!"D>A0$N>uBV$r(B
;;;	$BJ]B8$9$k;v$O$G$-$J$$$?$a!"(Br $B$r2!$7$?>l9g(B($B4X?t(Bwin-recent-window)
;;;	windows $BMQ$K3d$jEv$F$i$l$F$$$J$$(B frame $B$,$"$l$P$=$l$KI=<($r@ZBX(B
;;;	$B$($^$9(B(C-c C-w 0 $B$HF1$8(B)$B!#(B
;;;
;;;	  $B?75,%&%#%s%I%&:n@.;~$K!"8=:_$N%P%C%U%!FbMF$N99?7$H!"?7%&%#%s%I(B
;;;	$B%&$N>uBV$r;X<($9$k$?$a$K%&%#%s%I%&@8@.%a%K%e!<$,=P$^$9!#$3$l$i$N(B
;;;	$B0UL#$O0J2<$N$h$&$K$J$C$F$$$^$9!#(B
;;;
;;;		Create		$B8=2hLL$r8=%P%C%U%!$KJ]B88e!"?75,%&%#%s%I(B
;;;				$B%&$r@8@.(B
;;;		Duplicate	$B8=2hLL$r8=%P%C%U%!$KJ]B88e!"8=2hLL$HF1$8(B
;;;				$B%&%#%s%I%&$r@8@.(B
;;;		Preserve	$B8=%P%C%U%!$O99?7$;$:!"8=2hLL$r?75,%&%#%s(B
;;;				$B%I%&$H$7$FEPO?(B
;;;		Findfile	$B?75,%&%#%s%I%&$G(B find-file $B$r9T$J$&(B
;;;		Buff		$B?75,%&%#%s%I%&$G(B switch-to-buffer $B$r9T$J$&(B
;;;		M-x		$B?75,%&%#%s%I%&$G%3%^%s%I<B9T(B
;;;		No		$B?75,%&%#%s%I%&@8@.$rCf;_(B
;;;
;;;$B!Z%j%8%e!<%`![(B
;;;
;;;	  revive.el $B$HAH$_9g$o$;$F;H$&$3$H$K$h$j!"%j%8%e!<%`5!G=$,M-8z$G(B
;;;	$B$9!#(BC-c C-w C-r $B$r2!$9$H0J2<$N%a%K%e!<$,8=$l$^$9!#(B
;;;
;;;	     A)save-all R)estore-all S)ave-this L)oad-this N)Load# ~)read-~
;;;
;;;	$B$3$3$G(B a $B$r2!$9$H8=:_$NA4$F$N%&%#%s%I%&$N>pJs$r%U%!%$%k$K%;!<%V(B
;;;	$B$9$k$3$H$,$G$-$^$9!#(Br $B$r2!$9$H%U%!%$%k$K%;!<%V$7$?$b$N$r%m!<%I$9(B
;;;	$B$k$3$H$,$G$-$^$9!#(Bs,l $B$r2!$9$H8=:_A*Br$7$F$$$k%&%#%s%I%&>uBV$r$=(B
;;;	$B$l$>$l(B $B%;!<%V(B/$B%m!<%I(B $B$7$^$9!#(Bn $B$O%U%!%$%k$+$i?t;z$G;XDj$7$?%&%#(B
;;;	$B%s%I%&>uBV$r%m!<%I$7$^$9!#$^$?(B Emacs $B5/F0D>8e$K(B r $B$r2!$9$H$3$m$r(B
;;;	$B4V0c$($F(B a $B$r2!$7$F$7$^$C$?>l9g$J$I$O(B ~ $B$rMxMQ$7$F$/$@$5$$!#(B
;;;
;;;	  $B$3$N%a%K%e!<$+$i%;!<%V$9$k$h$j$b!V(BC-x C$B!W$G(B Emacs $B$r=*N;$7!"<!(B
;;;	$B2s(B Emacs $B$r5/F0$7$?D>8e$K(B resume-windows ($B$^$?$O(B C-c C-w C-r r)
;;;	$B$r5/F0$9$k$3$H$GD>$A$K0JA0$N>uBV$KLa$k$3$H$,$G$-$k$N$G$3$A$i$NJ}(B
;;;	$B$,JXMx$J;H$$J}$H$$$($^$7$g$&!#(B
;;;
;;;$B!Z%m!<%+%k%j%8%e!<%`![(B
;;;
;;;	  $B%j%8%e!<%`$G$OA4$F$N%&%#%s%I%&>pJs$r%U%!%$%k$K%;!<%V$7$^$9$,!"(B
;;;	$B$=$N%U%!%$%k$r$5$i$KJ#?t;}$A!"$=$l$>$l$r@Z$jBX$($F;H$&$3$H$,$G$-(B
;;;	$B$^$9!#!V(BC-c C-w C-l$B!W$r%?%$%W$7>pJs%U%!%$%k$r%;!<%V(B/$B%m!<%I$9$k%G(B
;;;	$B%#%l%/%H%j$rF~NO$7$?8e!"DL>o$N%j%8%e!<%`%a%K%e!<$NA`:n$r9T$J$$$^(B
;;;	$B$9!#(B
;;;
;;;	  $B$H$3$m$G!"B?$/$N;E;v$O$=$N;E;vFCM-$N%G%#%l%/%H%j$r%Y!<%9$K9T$o(B
;;;	$B$l$^$9!#$3$N@-<A$rMxMQ$7$F!"0lEY$KJ#?t8D$N;E;v$r$3$J$9>l9g$J$I$K!"(B
;;;	$B4X?t(B win-switch-task $B$r;H$&$H;E;v$N@ZBX$($r%9%`!<%:$K9T$&$3$H$,(B
;;;	$B$G$-$^$9!#$3$N4X?t$r8F$V$H8=:_$N4D6-$r8=:_$N>pJs%U%!%$%k$KJ]B8$9(B
;;;	$B$k$+3NG'8e!"<!$N;E;v$r9T$C$F$$$k%G%#%l%/%H%j$NF~NO$rB%$7$^$9!#(B
;;;
;;;$B!Z%+%9%?%^%$%:![(B
;;;
;;;	  $B%W%j%U%#%/%9%-!<$rNc$($P(B C-c w $B$KJQ99$9$k;~$O(B .emacs $B$K<!$N$h(B
;;;	$B$&$J5-=R$r$$$l$^$9!#(B
;;;
;;;		(setq win:switch-prefix "\C-cw")
;;;		(define-key global-map win:switch-prefix nil)
;;;		(define-key global-map "\C-cw1" 'win-switch-to-window)
;;;
;;;	  $B%&%#%s%I%&$NA*Br$r(B1$B!A(B9$B$G$O$J$/$F!"(Ba$B!A(Bz$B$K$9$k$3$H$b$G$-$^$9!#(B
;;;
;;;		(setq win:switch-prefix "\C-cw")
;;;		(define-key global-map win:switch-prefix nil)
;;;		(define-key global-map "\C-cwa" 'win-switch-to-window)
;;;		(setq win:base-key ?`)		;; ` $B$O!VD>A0$N>uBV!W(B
;;;		(setq win:max-configs 27)	;; ` $B!A(B z $B$O(B27$BJ8;z(B
;;;		(setq win:quick-selection nil)	;; C-c$B1Q;z(B $B$K3d$jEv$F$J$$(B
;;;
;;;	$B$3$3$G(B ` $B$O%"%9%-!<%3!<%I$G(B a $B$N0l$DA0$K$"$k$3$H$KCm0U$7$F$/$@$5(B
;;;	$B$$!#(BC-c C-w ` $B$OD>A0>uBVJ]B8MQ%P%C%U%!$H!"%+%l%s%H%&%#%s%I%&$NFb(B
;;;	$BMF$N8r49$K3d$jEv$F$i$l$^$9!#(B
;;;
;;;	  windows $B$NF0:n$rD4@0$9$k0J2<$NJQ?t$,$"$j$^$9!#(B
;;;
;;;	win:switch-prefix	windows.el $BA`:nMQ$N(Bprefix$B%-!<(B
;;;	win:menu-key-stroke	window$B@8@.(Bmenu$B$N%-!<(B(prefix$B%-!<$KB3$1$F(B)
;;;	win:resume-key-stroke	resume menu $B$N%-!<(B ($B!7(B)
;;;	win:resume-local-key-stroke	local resume menu $B$N%-!<(B ($B!7(B)
;;;	win:switch-task-key-stroke	switch task menu $B$N%-!<(B ($B!7(B)
;;;	win:quick-selection	C-c $B?t;z(B $B$J$I$G(Bwindow$BA*Br$G$-$k(B
;;;	win:mode-line-format	window$BHV9f$r<($9(B mode-line format
;;;	win:configuration-file	resume file $B$N%Q%9L>(B
;;;	win:make-backup-files	resume file $B$N%P%C%/%"%C%W$r<h$k$+(B
;;;	win:buffer-depth-per-win window$BKh$K(Bbuffer-list$B$N>e0L2?8D$r5-21$9$k$+(B
;;;				nil$B$N;~$O(Bbuffer-list$BM%@h=g0L$rJ]B8$7$J$$(B
;;;
;;;	-- $B0J2<(B mule2 $B0J9_$G%U%l!<%`$rMxMQ$9$k>l9g$N$_M-8z(B --
;;;	win:no-raise-at-save	$BA4(Bwindow$B$N%;!<%V;~$K%U%l!<%`$r(Braise$B$9$k$+(B
;;;	win:frame-parameters-to-save-private
;;;				frame parameter $B$N$&$A%;!<%V$7$?$$%Q%i%a!<(B
;;;				$B%?(B(win:frame-parameters-to-save-default 
;;;				$B$NCM0J30$N$b$N$r@_Dj$9$k(B)
;;;	win:auto-position	$B%U%l!<%`?75,:n@.;~$K(B
;;;				nil $B$J$i<jF0$G0LCV$r3NDj(B
;;;				'absolute $B$J$i@dBP:BI8$r7W;;$7$FG[CV(B
;;;				'relative $B$J$i8=%U%l!<%`$H$NAjBP0LCV$GG[CV(B
;;;	win:new-frame-offset-x	$B?75,%U%l!<%`<+F0G[CV;~$N(BX$B:BI8$N%*%U%;%C%H(B
;;;	win:new-frame-offset-y	$B?75,%U%l!<%`<+F0G[CV;~$N(BY$B:BI8$N%*%U%;%C%H(B
;;;	win:resumed-frame-offset-x $B%U%l!<%`%j%8%e!<%`;~$N(BX$B:BI8$N%*%U%;%C%H(B
;;;				fvwm$B$N%G%U%)%k%H$N(B BoundaryWidth $B$r;H$&(B
;;;				$B;~$O$3$NJQ?t$NCM$r(B3$B$K$7$F$*$/$HNI$$!#(B
;;;	win:resumed-frame-offset-y $B%U%l!<%`%j%8%e!<%`;~$N(BY$B:BI8$N%*%U%;%C%H(B
;;;	win:mouse-position	$B%U%l!<%`0\F0;~$N%^%&%9%+!<%=%k$N:BI8(B
;;;				'(x y) $B$H$$$&%j%9%H$G;XDj(B
;;;	win:frame-title-function $B3F%U%l!<%`$N%?%$%H%k$r7hDj$9$k4X?t(B
;;;				$B%U%l!<%`HV9f$,0z?t$H$7$FEO$5$l$k!#(B
;;;				$B$3$NCM$r(Bnil$B$K$9$k$H%?%$%H%k$O$$$8$i$J$$!#(B
;;;	win:title-with-buffer-name
;;;				$B%U%l!<%`%?%$%H%k$K%P%C%U%!L>$rIU2C$9$k$+(B
;;;
;;;$B!Z%P%0![(B
;;;
;;;	  $B%&%#%s%I%&$r@ZBX$($k$H8@$&%"%$%G%"$O(B screen $B%3%^%s%I$K4p$E$$$F(B
;;;	$B$$$^$9$,!"A`:nBN7O$O$+$J$j0c$$$^$9!#(B
;;;
;;;$B!ZDL$J;H$$J}![(B
;;;	
;;;	windows.el 2.11 $B0J9_$G$O!"(Bframe$B$K(B
;;;
;;;		mule[1]:*scratch*
;;;	
;;;	$B$N$h$&$J%?%$%H%k$rIU$1$^$9!#$3$l$rMxMQ$9$k$H!"%&%#%s%I%&%^%M!<%8%c(B
;;;	$B$+$i0l7b$GL\E*$N(Bframe$B$KHt$V$3$H$,=PMh$k$h$&$K$J$j$^$9!#(Bfvwm2$B$r;H$C(B
;;;	$B$F$$$k$H$-$O!"(B
;;;	
;;;	AddToFunc DeiconifyFocusAndWarp "I" Iconify -1
;;;	+				"I" FocusAndWarp $0 $1
;;;	
;;;	Key 1 A C	Next [mule?1?:*] DeiconifyFocusAndWarp
;;;	 :
;;;	Key 9 A C	Next [mule?9?:*] DeiconifyFocusAndWarp
;;;	
;;;	$B$N$h$&$K(B ~/.fvwm2rc $B$K=q$/$3$H$G!"(BC-1 $B!A(B C-9 $B$r2!$9$3$H$GL\E*%U(B
;;;	$B%l!<%`$KHt$V$3$H$,=PMh$k$h$&$K$J$j$^$9(B($B>\$7$/$O%&%#%s%I%&%^%M!<(B
;;;	$B%8%c$N%^%K%e%"%k$r8+$F$/$@$5$$(B)$B!#(B
;;;	
;;;$B!Z$"$H$,$-![(B
;;;
;;;	  $B;w$?$h$&$J$NB>$K$b$"$j$=$&!#(B $B$H$*$b$$$D$D(B fj.editor.emacs $B$KEj(B
;;;	$B9F$7$?$H$3$m(B screens.el $B$H$$$&$^$5$K(B screen $B%3%^%s%I8_49$N$b$N$,(B
;;;	$B$"$j$^$7$?!#(B $B$^$?(B wicos.el $B$H$$$&8e7QHG$,=P$F$$$k$h$&$G$9$,!D(B($BB?(B
;;;	$B$/$O8l$k$^$$(B)$B!D!#(Bwindows.el $B$G$O!"(B ($BA4(B)$B%&%#%s%I%&>uBV$NJ]B8(B/$BI|85(B
;;;	$B$,2DG=$J$N$G!"$?$@$A$KA02s$NJT=84D6-$r<h$jLa$9$3$H$,$G$-$^$9!#$=(B
;;;	$B$l$f$(O@J8$K%$%s%W%j%a%s%H$K$HK;$7$$;~4|$K$O7g$+$;$J$$%f!<%F%#%j(B
;;;	$B%F%#$H$J$k$G$7$g$&!#(B
;;;
;;;
;;;$B!Z<U<-![(B
;;;
;;;	  $B$3$N%W%m%0%i%`$r:n$k$-$C$+$1$HE,@Z$J%3%a%s%H$r2<$5$C$?!"(BASCII-
;;;	NET$B$N$?$j$c!<:4!9LZ$5$s!"(B Emacs-19 $B$G%_%K%P%C%U%!$rJ,N%$5$;$F$$(B
;;;	$B$k;~$N5sF0$K4X$9$k%G%P%C%0$K6(NO2<$5$C$?(Bfujixerox.co.jp$B$NW"@%M[(B
;;;	$B0l$5$s!"%a%K%e!<$K$h$k%&%#%s%I%&@Z$jBX$($rDs0F$7$F$/$@$5$C$?(B($B3t(B) 
;;;	$BEl<G$N>.NSJY$5$s!"(BXEmacs$B4X78$NF0:nJs9p$J$I$rD:$$$?CfEg44IW$5$s!"(B
;;;	$B3F%&%#%s%I%&$KL>A0$r$D$1$k5!G=$J$I$N%Q%C%A$rD:$$$?Aa0pEDBg3X$N@>(B
;;;	$BK\$5$s$K46<UCW$7$^$9!#(B
;;;
;;;$B!Z<h$j07$$![(B
;;;
;;;	  $B$3$N%W%m%0%i%`$O!"%U%j!<%=%U%H%&%'%"$H$7$FG[I[$$$?$7$^$9!#$3$N(B
;;;	$B%W%m%0%i%`$r;HMQ$7$F@8$8$?$$$+$J$k7k2L$KBP$7$F$b:n<T$O0l@Z$N@UG$(B
;;;	$B$rIi$o$J$$$b$N$H$$$?$7$^$9$,!"%3%a%s%H$d%P%0%l%]!<%H$OBg$$$K4?7^(B
;;;	$B$$$?$7$^$9!#$*5$7Z$K$4O"Mm2<$5$$!#O"Mm$O0J2<$N%"%I%l%9$^$G$*4j$$(B
;;;	$B$$$?$7$^$9(B(1999/3$B8=:_(B)$B!#(B
;;;							yuuji@gentei.org

;;;
;; Code
;;;

;; ---------- Customizable variables
(defvar win:max-configs 10
  "*Number of window configurations to hold")
(defvar win:base-key ?0
  "*Base of window buffer name")
(if (> win:max-configs 27) (error "win:max-configs too large!"))
(defvar win:switch-prefix "\C-c\C-w"
  "*Prefix key stroke to switch windows")
(defvar win:menu-key-stroke "\C-w"
  "*Key assignment of win-menu")
(defvar win:resume-key-stroke "\C-r"
  "*Key assignment of win-resume-menu")
(defvar win:resume-local-key-stroke "\C-l"
  "*Key assignment of win-resume-local-menu")
(defvar win:switch-task-key-stroke "\C-s"
  "*Key assignment of win-switch-task")
(defvar win:quick-selection t
  "*Non-nil enables a short cut for window selection;
Not only with `C-c C-w 1' but also with `C-c 1'.")
(defvar win:mode-line-format "[%c%s%s]"
  "*Format of mode line that shows the selected window number")

;;Variables for resume
(defvar win:configuration-file
  (if (eq system-type 'ms-dos) "~/_windows" "~/.windows")
  "*File to save window configurations")
(defvar win:local-config-file win:configuration-file
  "*Default local configuration file")
(defvar win:make-backup-files t
  "*Create a backup of window configuration file or not")

;;Variables for Emacs 19
(defvar win:no-raise-at-save nil
  "*Non-nil inhibits win-save-all-configurations from raising each frame.")
;(Rev.1.4)
(defvar win:frame-parameters-to-save-default
  (delq nil
	(list
	 'top 'left 'minibuffer 'vertical-scroll-bars
	 (if (string< "19.27" emacs-version) 'menu-bar-lines)
	 (if (featurep 'mule) 'line-space)
	 ;;	These parameters below should go to
	 ;;	win:frame-parameters-to-save-private
	 ;; 'cursor-type 'auto-lower 'auto-raise 'cursor-color 'mouse-color
	 ;; 'background-color 'foreground-color 'font
	 ))
  "Which frame parameters to save; Do not modify this variable.")
(defvar win:frame-parameters-to-save-private nil
  "*User defined list of frame parameters to save;
You don't have to include neither 'heght nor 'width in this list
because they are automatically saved in other method.")
(defvar win:auto-position 'absolute
  "*Non-nil automatically positions the newly created frame;
There are two methods of auto positioning,
'absolute for this variable puts the new frame by calculating its absolute
coordinates.
'relative for this variable puts the new frame relative to currently
selected frame.")
(defvar win:new-frame-offset-x 50
  "*X-Offset of new frame to currently selected frame; See win:auto-position.")
(defvar win:new-frame-offset-y 10
  "*Y-Offset of new frame to currently selected frame; See win:auto-position.")
(defvar win:allocate-frame-hook nil
  "*Hook running at allocating new frame")
(defvar win:resumed-frame-offset-x 0
  "*X-Offset of resumed frame to compensate the window manager's border")
(defvar win:resumed-frame-offset-y 0
  "*Y-Offset of resumed frame to compensate the window manager's border")
(defvar win:mouse-position '(0 -5)
  "*Mouse position list (X Y) in *pixel* at window selection")
(defvar win:title-with-buffer-name t
  "*T means naming frame title with buffer name")
(defvar win:wipe-also-frames nil
  "*T means wipe all frames but one when wipe-windows.")
(defvar win:need-uptodate-frame-title t
  "*Set this to nil to disable frequent rewriting of frame title.")
(defvar win:buffer-depth-per-win 5
  "*Default depth of buffer stack per window.
If nil, do not preserve buffer-list priority")
(defvar win:names-maxl 20 "*Title length in window list")

;;Variables for XEmacs
(defvar win:frame-title-function
  '(lambda (index)
     (format (if (featurep 'mule) "mule[%d]" "emacs[%d]") index))
  "*Window title creation function.
One argument of frame number should be taken.")

;;; ---------- Internal work variables
(defvar win:configs (make-vector win:max-configs nil)
  "Array of window configurations; 0th always has previous configuration.")
(defvar win:names (make-vector win:max-configs ""))
(defvar win:names-prefix (make-vector win:max-configs ""))
(defvar win:sizes (make-vector win:max-configs nil))
(defvar win:buflists (make-vector win:max-configs nil))
(let ((i 0))
  (while (< i win:max-configs)
    (aset win:buflists i (make-vector win:buffer-depth-per-win nil))
    (setq i (1+ i))))

(defvar win:current-config 0 "Current window buffer number")
(defvar win:last-config 0 "Buffer number for a window previously seen")

(defvar win:switch-map nil "Key map for window switcher")
(defvar win:switch-menu-map nil "Keymap used in window selection menu")

;; for XEmacs
(defvar win:xemacs-p (string-match "XEmacs" emacs-version))
(defun win:make-frame (index &optional prop)
  "Wrapper function for make-frame;
INDEX is a window number.  Optional second argument PROP is passed to
make-frame function."
  (if win:frame-title-function
      (setq prop
	    (cons (cons 'name (funcall win:frame-title-function index)) prop)))
  (if win:xemacs-p
      (make-frame (alist-to-plist prop))
    (let ((frame (make-frame prop)) (count 100))
      (if (string-match "^20\\." emacs-version)
	  (progn
	    (while (and (> count 0) (not (frame-visible-p frame)))
	      (setq count (1- count))
	      (sit-for (string-to-number "0.1")))
	    ;;Emacs 20 becomes not to support top/left for initial parameter.
	    (modify-frame-parameters frame prop)))
      frame)))

;; for Emacs-19
(defvar win:use-frame
  (and (string< "18" (substring emacs-version 0 2)) window-system)
  "*Non-nil means switch windows with frame.")
(and (fboundp 'eval-when-compile)
     (eval-when-compile (require 'revive)))

(if win:switch-map nil
  (setq win:switch-map (make-sparse-keymap)
	win:switch-menu-map (make-keymap))
  (suppress-keymap win:switch-menu-map)
  (define-key global-map win:switch-prefix nil)
  (define-key global-map win:switch-prefix win:switch-map)
  (let ((key win:base-key) (max (+ win:base-key win:max-configs)))
    (while (< key max)
      (define-key win:switch-map (char-to-string key) 'win-switch-to-window)
      (setq key (1+ key)))		;`key' increasing
    (if (and win:quick-selection (> (length win:switch-prefix) 1))
	(let ((prefix (substring win:switch-prefix 0 1)))
	  (while (>= key win:base-key)
	    (setq key (1- key))
	    (define-key global-map
	      (concat prefix (char-to-string key))
	      'win-switch-to-window))
	  (define-key global-map (concat prefix "=") 'win-switch-menu)
	  (define-key global-map (concat prefix " ") 'win-toggle-window)
	  (define-key global-map (concat prefix "!")
	    'win-delete-current-window)))
    (setq key win:base-key)
    (while (< key max)
      (define-key win:switch-menu-map (char-to-string key)
	'win-switch-menu-select-directly)
      (setq key (1+ key))))
  (define-key win:switch-map "=" 'win-switch-menu)
  (define-key win:switch-map win:menu-key-stroke 'win-menu)
  (define-key win:switch-map win:resume-key-stroke 'win-resume-menu)
  (define-key win:switch-map win:resume-local-key-stroke 'win-resume-local)
  (define-key win:switch-map win:switch-task-key-stroke 'win-switch-task)
  (define-key win:switch-map " " 'win-toggle-window)
  (define-key win:switch-map "\C-n" 'win-next-window)
  (define-key win:switch-map "n" 'win-next-window)
  (define-key win:switch-map "\C-p" 'win-prev-window)
  (define-key win:switch-map "p" 'win-prev-window)
  (define-key win:switch-map "!" 'win-delete-current-window)
  ;; Key map of window selection menu.
  (define-key win:switch-menu-map "n"		'next-line)
  (define-key win:switch-menu-map "p"		'previous-line)
  (define-key win:switch-menu-map "\C-m"	'win-switch-menu-select)
  (define-key win:switch-menu-map " "		'win-switch-menu-select)
  (define-key win:switch-menu-map "f"		'win-switch-menu-select)
  (define-key win:switch-menu-map "s"		'win-switch-menu-mark-job)
  (define-key win:switch-menu-map "l"		'win-switch-menu-mark-job)
  (define-key win:switch-menu-map "d"		'win-switch-menu-mark-job)
  (define-key win:switch-menu-map "k"		'win-switch-menu-mark-job)
  (define-key win:switch-menu-map "u"		'win-switch-menu-unmark-job)
  (define-key win:switch-menu-map "e"           'win-switch-menu-edit-name-prefix)
  (define-key win:switch-menu-map "x"		'win-switch-menu-execute-job)
  (define-key win:switch-menu-map "q"		'win-switch-menu-quit)
  (define-key win:switch-menu-map "?"		'describe-mode)
  ;;Next lines prevent accidents
  (mapcar
   (function
    (lambda (func)
      (mapcar (function (lambda (key)
			  (define-key win:switch-menu-map key "")))
	      (where-is-internal func))))
    '(switch-to-buffer other-window other-frame kill-buffer save-buffer))
  (define-key win:switch-menu-map win:switch-prefix "")
  (define-key win:switch-menu-map (substring win:switch-prefix 0 1) "")
  (run-hooks 'windows-keymap-setup-hook)
  )

;; define menu-bar
(if (or (null (fboundp 'make-frame))
	(or (not (boundp 'window-system)) (not window-system)))
    nil					;Emacs 18 or emacs -nw
  (cond
   (win:xemacs-p
    (defvar win:xemacs-resume-menu
      '("Resume menu"
	["Save all"			(win-resume-menu nil ?a)	t]
	["Resume"			(win-resume-menu nil ?r)	t]
	["Save this window"		(win-resume-menu nil ?s)	t]
	["Load this window"		(win-resume-menu nil ?l)	t]
	["Load from backup file"	(win-resume-menu nil ?~)	t]
	["Wipe"				(win-resume-menu nil ?w)	t]))
    (defvar win:xemacs-top-menu
      '("Windows"
	; :filter windows-menu-filter
	["Next window frame"		win-next-window			t]
	["Preious window frame"	win-prev-window			t]
	["Switch task"			win-switch-task			t]
	["local"			win-resume-local		t]
	["--"				nil				nil]
	["See you! (Revivable)"	see-you-again			t]
	["Revive!"			resume-windows			t]))
    (add-submenu nil win:xemacs-top-menu "Edit")
    (add-submenu '("Windows") win:xemacs-resume-menu)
    (set-menubar current-menubar)
    (set-menubar-dirty-flag) )
   (t					;GNU Emacs-19 or later
    (defvar win:menu-bar-buffer-map (make-sparse-keymap "Windows"))
    (defvar win:menu-bar-file-map (make-sparse-keymap "Windows resume menu"))
    (fset 'win:update-menu-bar
	  (function
	   (lambda ()
	     (define-key-after (lookup-key global-map [menu-bar buffer])
	       [windows] (cons "Windows" win:menu-bar-buffer-map) [frames]))))
    (define-key win:menu-bar-buffer-map [resume]
      (cons "Resume menu" (make-sparse-keymap "Resume menu")))
    (mapcar
     (function
      (lambda (bind)
	(define-key win:menu-bar-buffer-map (vector 'resume (car bind))
	  (cons (nth 1 bind)
		(list 'lambda nil '(interactive)
		      (list 'win-resume-menu nil (nth 2 bind)))))))
     (nreverse
      '((save-all	"Save all"		?a)
	(resume	"Resume"		?r)
	(save	"Save this window"	?s)
	(load	"Load this window"	?l)
	(back	"Load from backup file"	?~)
	(wipe	"Wipe"			?w))))
    (mapcar
     (function
      (lambda (bind)
	(define-key win:menu-bar-buffer-map (vector (car bind)) (cdr bind))))
     (nreverse
      '((next "Next window frame" . win-next-window)
	(prev "Previous window frame" . win-prev-window)
	(delete "Delete current window frame" . win-delete-current-window)
	;;(load "Load all configuration" . win-load-all-configurations)
	;;(save "Save all configuration" . win-save-all-configurations)
	(switch "Switch task" . win-switch-task)
					;(resume "Resume menu" . win-resume-menu)
	(local "Local resume" . win-resume-local)
	)))
    (define-key-after
      (or (lookup-key global-map [menu-bar file])
	  (lookup-key global-map [menu-bar files]))
      [see-you] (cons "See you!(revivable)" 'see-you-again)
      'kill-buffer)
    (define-key-after
      (or (lookup-key global-map [menu-bar file])
	  (lookup-key global-map [menu-bar files]))
      [revive] (cons "Revive!" 'resume-windows)
      'see-you)
    (add-hook 'menu-bar-update-hook 'win:update-menu-bar t))))

(defun win:No-of-windows ()
  (let ((i 1) (num 0))
    (while (< i win:max-configs)
      (if (aref win:configs i) (setq num (1+ num)))
      (setq i (1+ i)))
    num))

(defun win:free-window-min ()
  "Search a window which is not displayed currently nor previously."
  (let ((i 1) num)
    (catch 'free
      (while (< i win:max-configs)
	(if (and (aref win:configs i)
		 (/= i win:current-config)
		 (/= i win:last-config))
	    (throw 'free i))
	(setq i (1+ i)))
      (throw 'free win:last-config))))

(defun win:delete-window (n &optional killbufmsg force)
  "Delete Nth entry of window configuration buffer."
  (if (= n 0) (error "Can't delete window %c" win:base-key))
  (if (and (<= (win:No-of-windows) 1)    ;;if there's 1 window and it is
	   (aref win:configs n))         ;;currently selected window
      (error "Can't delete sole window"))
  (if (or force
	  (y-or-n-p (format "Erase %sconfiguration of %c{%s}?"
			    (if killbufmsg "buffer and " "")
			    (+ n win:base-key) (aref win:names n))))
      (progn
	(if win:use-frame (delete-frame (aref win:configs n)))
	(aset win:configs n nil)
	(aset win:names-prefix n "")
	(if (= n win:current-config)
	    (let ((free (win:free-window-min)))
	      (setq win:current-config win:last-config
		    win:last-config free)
	      (win:set-wc win:current-config)))
	(win:update-mode-line win:current-config)))
  (message ""))

(defun win:store-buffer-list (index)
  "(Windows internal)Store current window's buffer-list top 5"
  (let ((d 0) (bl (buffer-list)))
    (while (and (< d win:buffer-depth-per-win) bl)
      (or (eq (window-buffer (minibuffer-window)) (car bl))
          ;(string-match "\\*$" (buffer-name (car bl)))
	  (progn
	    (aset (aref win:buflists index) d (car bl)) ;buffer-list$B$N=g=xJ]B8(B
	    (setq d (1+ d))))
      (setq bl (cdr bl)))))

(defun win:restore-buffer-list (index)
  "(Windows internal)Restore current window's buffer-list previously saved."
  (save-window-excursion
    (select-window (get-largest-window))
    (let ((d win:buffer-depth-per-win) b)
      (while (> d 0)
	(setq d (1- d)
	      b (aref (aref win:buflists index) d))
	(and b
	     (get-buffer b)
	     (buffer-name b)
	     (switch-to-buffer b))))))

(defun win:switch-window (to &optional preserve nosetwc)
  "(windows internal) Switch to window TO, changing win:{last,current}-config.
Optional second arg PRESERVE non-nil inhibits updation of win:current-config.
Optional third arg NOSETWC non-nil means do not set-window-configuration TO.
"
  (win:adjust-window t)
  (if win:buffer-depth-per-win (win:store-buffer-list win:current-config))
  (cond
   (win:use-frame
    (or preserve
	(if (win:frame-window (selected-frame))
	    (win:store-config win:current-config)))
    (if (aref win:configs to) nil
      (aset win:configs to 
	    (if (win:selected-window)
		(win:allocate-frame to)
	      (selected-frame))))
    (if (win:select-frame to)		;if succeeded
	(if win:buffer-depth-per-win (win:restore-buffer-list to))
      (aset win:configs to nil)		;failed
      (error "Window frame [%c] does not exist." (+ win:base-key to))))
   (t
    (or preserve (win:store-config win:current-config))
    (if win:buffer-depth-per-win (win:restore-buffer-list to))
    (or nosetwc (win:set-wc to))
    ))
  (win:update-mode-line to)
  (if (/= to win:current-config)
      (setq win:last-config win:current-config
	    win:current-config to))
  (message "Switch to window[%c]" (+ to win:base-key)))

(defun win-delete-current-window (arg)
  "Delete selected window configuration buffer.
Non-nil for ARG kills all visible buffer."
  (interactive "P")
  (if win:use-frame
      (win:adjust-window t)
    (win:set-window-name win:current-config)) ;set window name
  (let ((cwin (selected-window)) win (cc win:current-config)
	(blist (list (current-buffer))))
    (if arg
	(progn
	  (setq win cwin)
	  (while (not (eq cwin (setq win (next-window win))))
	    (setq blist (cons (window-buffer win) blist)))))
    (win:delete-window win:current-config arg)
    (if (and arg (/= cc win:current-config))
	(progn
	  (while blist
	    (if (get-buffer (car blist))
		(kill-buffer (car blist)))
	    (setq blist (cdr blist)))))))

;;;###autoload
(defun win-switch-to-window (arg &optional window)
  "Switch window configurations to a buffer specified by keyboard.
If calling from program, optional second argument WINDOW can specify
the window number."
  (interactive "p")
  (let*((window (or window
                    (if (< last-command-char 0)
                        (- last-command-char ?\M-0)
                      (- last-command-char win:base-key))))
	(wc (aref win:configs window)))
    (cond
     ;;if ARG=0, switch to recent window.
     ((= window 0) (win-recent-window))
     ;;if ARG<0, delete specified(by invoke key) window.
     ((< arg 0)
      (win:delete-window window))
     ;;if ARG>0, update specified(by invoke key) window.
     ((> arg 1)
      (win:switch-window window t t)
      (message "Update window[%c]" (+ window win:base-key)))
     ;;if specified window is current window.
     ((= win:current-config window)
      (if (= arg 0)
	  (win:set-wc window)
	(if win:use-frame (win:switch-window window)
	  (message "This is window[%c]." (+ window win:base-key)))))
     ;;else...
     ;;switch to specified window.
     (t
      (if (aref win:configs window)
	  ;;if target window already exists.
	  (win:switch-window window)
	;;if target window does not exist.
	(let (ans)
	  (if (= (+ win:current-config win:last-config) 0)
	      (message "Create window[%c]?(y or n):" (+ window win:base-key))
	    (message
	     (concat
	      "[%c] is nil. C)reate D)uplicate "
	      (if win:use-frame "" "P)reserve ")
	      "F)indfile B)uff X)M-x N)o:")
	     (+ window win:base-key)))
	  ;;(setq ans (if (interactive-p) (read-char) ?y))
	  (setq ans (read-char))
	  (if (string-match (char-to-string ans) "cdpyfbx")
	      (let (inhibitmsg)
		(cond
		 ((equal ans ?f)
		  (let ((file (read-file-name "Find file on new window: ")))
		    (win:switch-window window nil t)
		    (delete-other-windows)
		    (switch-to-buffer (get-buffer-create "*scratch*"))
		    (sit-for 0)
		    (find-file file)))
		 ((equal ans ?b)
		  (let ((buf (read-buffer "Switch to buffer on new window: "
					  (other-buffer))))
		    (win:switch-window window nil t)
		    (delete-other-windows)
		    (switch-to-buffer buf)))
		 ((equal ans ?x)
		  (let ((cmd (read-command "M-x on new window: ")))
		    (win:switch-window window nil t)
		    (delete-other-windows)
		    (switch-to-buffer (get-buffer-create "*scratch*"))
		    (sit-for 0)
		    (setq inhibitmsg t)
		    (call-interactively cmd)))
		 ((and (string-match (char-to-string ans) "py")
		       (null win:use-frame))
		  (win:switch-window window t t))
		 ((equal ans ?d)
		  (require 'revive)
		  (let ((conf (current-window-configuration-printable)))
		    (win:switch-window window nil t)
		    (restore-window-configuration conf)))
		 ((string-match (char-to-string ans) "cy")
		  (win:switch-window window nil t)
		  (delete-other-windows)
		  (switch-to-buffer (get-buffer-create "*scratch*")))
		 (nil t))
		(or inhibitmsg
		    (message "Memorize current window configuration into %c"
			     (+ window win:base-key))))))
	)))))

(defun win-menu (arg)
  "Windows menu for operations on window configuration."
  (interactive "p")
  (message
   "N)ext P)rev R)ecent D)elete K)ill S)ave2buf L)oad-from-buf A)saveAs sW)ap")
  (let ((c (downcase (read-char))))
    (cond
     ((= c ?n) (win-next-window arg))
     ((= c ?p) (win-prev-window arg))
     ((= c ?r) (win-recent-window))
     ((= c ?d) (win-delete-current-window nil))
     ((= c ?k) (win-delete-current-window t))
     ((= c ?l) (win-load-window-buffer))
     ((= c ?s) (win-update-window-buffer))
     ((= c ?a) (win-save-as))
     ((= c ?w) (call-interactively 'win-swap-with))
     (t nil))))

;; Interactive functions.
(defun win-delete-current-window-force ()
  (interactive)
  (win-delete-current-window t))
(defun win-load-window-buffer ()
  (interactive)
  (win:set-wc win:current-config))
(defun win-update-window-buffer ()
  (interactive)
  (win:store-config win:current-config)
        (message "Update window [%d]" win:current-config))
(defun win-save-as ()
  (interactive)
  (let (c)
    (message "Save current window configuration into buffer # ?")
    (setq c (- (read-char) win:base-key))
    (if (or (< c 1) (> c win:max-configs))
	(error "Buffer number out of range"))
    (if (and win:use-frame
	     ;;(aref win:configs c)
	     ;;(frame-live-p (aref win:configs c))
	     (win:selected-window)
	     )
	(error "Window frame [%c] already used" (+ win:base-key c))
      (win:store-config c)
      (win:switch-window c))
    (message "Save current window configuration into buffer[%c]"
	     (+ win:base-key c))))

(defun win-swap-with (win)
  "Swap current window configuration with WIN-th window's."
  (interactive "cSwap with: ")
  (if (or (< win win:base-key) (> win (+ win:base-key win:max-configs)))
      (error "Window number out of range"))
  (let* ((n (- win win:base-key)) (tmp (aref win:configs n)) conf1 conf2)
    (or tmp (error "Window [%c] is null." win))
    (win:adjust-window)
    (if (= n win:current-config) (error "[%c] is current window." win))
    (cond
     (win:use-frame
      (setq conf1 (current-window-configuration-printable))
      (select-frame (aref win:configs n))
      (setq conf2 (current-window-configuration-printable))
      (restore-window-configuration conf1)
      (select-frame (aref win:configs win:current-config))
      (restore-window-configuration conf2))
     (t
      (aset win:configs n (current-window-configuration))
      (win:set-window-name win:current-config)
      (aset win:names n (aref win:names win:current-config))
      (set-window-configuration tmp))))
)

(defun win:read-config-file ()
  "Read window configuration file from minibuffer."
  (let ((dir (file-name-directory win:local-config-file)))
    (setq dir (read-file-name "Configuration file directory: " dir dir 1))
    (if (not (string-match "[\\/]$" dir))
	(setq dir (concat dir "/")))
    (if (not (file-directory-p dir)) (error "No such directory [%s]" dir))
    (setq win:local-config-file
	  (concat dir (file-name-nondirectory win:configuration-file)))))

(defun win-switch-task (force-save &optional config-file)
  "Switch to other configuration environments.
If FORCE-SAVE is non-nil, save current environment without query.
Optional second arg CONFIG-DIR specifies the configuration file to switch.
Using from program, non-interactively, don't forget to specify second arg."
  (interactive "P")
  (if (or force-save
	  (y-or-n-p (format "Save current configuration in [%s]? "
			    win:local-config-file)))
      (let ((win:configuration-file win:local-config-file))
	(win-save-all-configurations)))
  (let ((win:configuration-file (or config-file (win:read-config-file))))
    (setq win:local-config-file win:configuration-file)
    (if (file-exists-p win:local-config-file)
	(win-load-all-configurations)
      (wipe-windows t)
      (message "New task started"))))

(defun win-resume-local (arg)
  "Call resume operations with local configuration file."
  (interactive "P")
  (let (dir (win:configuration-file (win:read-config-file)))
    (win-resume-menu arg)))

(defun win-resume-menu (&optional arg key)
  "Windows menu for resume operations."
  (interactive "P")
  (message
   "A)save-all R)esume-all S)ave-this L)oad-this N)Load# ~)read-~ W)ipe")
  (let ((c (or key (downcase (read-char)))))
    (win:adjust-window)
    (cond
     ((= c ?a) (win-save-all-configurations))
     ((= c ?r) (win-load-all-configurations arg))
     ((= c ?s) (win:save-window win:current-config))
     ((= c ?l) (win:load-window win:current-config))
     ((= c ?n)
      (message "Load the window No.?")
      (win:load-window (- (read-char) win:base-key)))
     ((= c ?~)
      (let ((win:configuration-file
	     (make-backup-file-name win:configuration-file)))
	(win-load-all-configurations)))
     ((= c ?w)
      (require 'revive)
      (if (y-or-n-p "Do you wish to save this configurations? ")
	  (let ((win:configuration-file (win:read-config-file)))
	    (win-save-all-configurations)))
      (wipe-windows t))
     )))

(defun win-toggle-window ()
  "Toggle current window and most recently used one."
  (interactive)
  (if win:use-frame
      (win:adjust-window))
  (if (or (= win:last-config win:current-config)
	  (equal (aref win:configs win:last-config) nil))
      (message "No other window")
    (win:switch-window win:last-config)))

(defun win-recent-window ()
  "Switch to recently displayed window saved in temporary buffer.
If Windows uses frame, switch to frame unallocated to Windows."
  (interactive)
  ;;(let ((last-wc (aref win:configs 0))(last-sz (aref win:sizes 0)))
  ;;  (if last-wc (win:set-wc last-wc last-sz)))
  (if win:use-frame
      (let ((cf (selected-frame)) (frame (next-frame)))
	(if (catch 'found
	      (while (not (eq frame cf))
		(if (null (win:frame-window frame)) (throw 'found t))
		(setq frame (next-frame frame))))
	    (progn
	      (select-frame frame)
	      (raise-frame frame)
	      (focus-frame frame)
	      (apply 'set-mouse-pixel-position
		     (if win:xemacs-p (selected-window) frame)
		     win:mouse-position)
	      (win:update-mode-line 0))
	  (message "There are no %sunallocated frames for Windows."
		   (if (win:frame-window (selected-frame)) "" "other ")))
	frame)
    (win:set-wc 0)
    (win:update-mode-line win:current-config)))

(defun win-next-window (arg)
  "Switch to window saved in the ARG-th next configuration buffer."
  (interactive "p")
  (if (<= (win:No-of-windows) 1)
      (message "There is no other window.")
    (let ((count 0)(num win:current-config)
	  (incr (if (> arg 0) 1 (1- win:max-configs))))
      (setq arg (max arg (- arg)))
      (while (< count arg)
	(setq num (% (+ num incr) win:max-configs))
	(if (and (aref win:configs num) (/= num 0))
	    (setq count (1+ count))))
      (setq num (% num win:max-configs))
      (if (= num win:current-config)
	  (message "Next window by %d is this window." num)
	(win:switch-window num)))))

(defun win-prev-window (arg)
  "Switch to window saved in the ARG-th previous congiguration buffer."
  (interactive "p")
  (win-next-window (- arg)))

;;;###autoload
(defun win:set-wc (num)
  "(Windows low level internal) Set the NUM-th windows configuration.
If Windows uses frame(Emacs 19), Select the NUM-th window frame."
  (let*((size (aref win:sizes num))
	(oldh (nth 0 size)) (oldw (nth 1 size))
	(wc (aref win:configs num)))
    (win:store-config 0)  ;;save current configuration into array[0]
    (if win:use-frame
	(win:select-frame num)
      (set-window-configuration wc))))

(cond
 ((fboundp 'screen-height)
  (fset 'win:screen-height 'screen-height)
  (fset 'win:screen-width 'screen-width))
 ((fboundp 'frame-height)
  (fset 'win:screen-height 'frame-height)
  (fset 'win:screen-width 'frame-width))
 (t (error "I don't know how to run windows.el on this Emacs...")))

(defun win:store-config (index)
  "(Windows low level intenal)Save current configuration in INDEX-th of array."
  (aset win:configs index
	(if win:use-frame (selected-frame) (current-window-configuration)))
  (win:set-window-name index)
  (aset win:sizes index (list (win:screen-height) (win:screen-width))))

(defun win:set-window-name (index)
  "(Windows low level intenal)Set current window name to INDEX-th of array."
  (require 'revive)
  (aset win:names index
	(mapconcat (function (lambda (w) (buffer-name (window-buffer w))))
		   (revive:window-list) " / ")))

(defvar win:mode-string nil)
(defun win:update-mode-line (number)
  "Update mode line for selected window number NUMBER."
  (let ((prefix (aref win:names-prefix number)))
    (setq win:mode-string (format win:mode-line-format
                                  (+ number win:base-key)
                                  (if (string= prefix "") "" ":")
                                  prefix
                                )))
  (set-buffer-modified-p (buffer-modified-p))
  (sit-for 0))


(defun win-edit-name-prefix (index)
  "Edit win:names-prefix of INDEXth window."
  (interactive (list win:current-config))
  (aset win:names-prefix index
        (read-string "Window name: " (aref win:names-prefix index)))
  (if (= win:current-config index) (win:update-mode-line index)))
  
(defun win:recover-deleted-frames ()
  "Detect frames deleted at initialization, and allocate new one for Windows.
Do not call this function."
  (let ((i 1) newframe)
    (if (catch 'deleted
	  (while (< i win:max-configs)
	    (if (and (aref win:configs i)
		     (not (frame-live-p (aref win:configs i))))
		(throw 'deleted t))
	    (setq i (1+ i))))
	(progn
	  (aset win:configs i (setq newframe (win:allocate-frame i)))
	  (modify-frame-parameters (aref win:configs i) '((name)))
	  (select-frame newframe)
	  (let ((index i)(frame newframe))
	    (run-hooks 'win:allocate-frame-hook))
	  (win:load-window i))
      )))

;;;###autoload
(defun win:startup-with-window ()
  "Start up Emacs with window[1] selected."
  (if (aref win:configs 1) nil
    (cond
     ((and win:use-frame (not (interactive-p)))
      ;; When called from .emacs, since the base frame at that time
      ;; will be deleted by the function frame-notice-user-settings,
      ;; allocating frame here won't work.  So we set window-setup-hook to
      ;; do all the jobs after frame initialization has been done.
      (add-hook 'window-setup-hook
		'(lambda ()
		   (if (aref win:configs 1) ;Already resumed by resume-windows
		       ;; `emacs -e resume-windows' leads to this section.
		       (progn
			 (win:recover-deleted-frames)
			 (if (get 'resume-windows 'lc)
			     ;; Adjust window visiting list.
			     ;; See also the comment of resume-windows.
			     (let ((lc (get 'resume-windows 'lc)))
			       (win:switch-window (car (cdr lc)))
			       (put 'resume-windows 'lc nil)
			       (setq win:last-config (car lc))
			       (message "Startup with window[%d]"
					win:current-config))))
		     (let ((count 30))
		       (while (and (null (visible-frame-list))
				   (> count 0))
			 (message "Waiting for frames to be shown...")
			 (sit-for (string-to-number "0.1"))
			 (setq count (1- count))))
		     (select-frame
		      (car
		       (or (filtered-frame-list
			    (function
			     (lambda (f)
			       (and
				(eq (cdr (assq 'visibility
					       (frame-parameters f)))
				    t)
				(not (member f (minibuffer-frame-list)))))))
			   (visible-frame-list))))
		     (setq win:current-config 1)
		     (win:store-config 1)
		     (win:update-mode-line 1)
		     (and
		      (assq 'minibuffer default-frame-alist)
		      (null (cdr (assq 'minibuffer default-frame-alist)))
		      (boundp 'minibuffer-frame-alist)
		      minibuffer-frame-alist
		      (modify-frame-parameters
		       (car (minibuffer-frame-list))
		       minibuffer-frame-alist))
		     (message "Startup with window [1]")
		     (let ((index 1) (frame (aref win:configs 1)))
		       (run-hooks 'win:allocate-frame-hook))
		     (sit-for 1))
		   'append)))
     (t					;not frame environment
      (win:store-config 1)
      (win:update-mode-line 1)
      (setq win:current-config 1)
      (message "Startup with window[1]")))))

;;;
;; Functions for resume.
;;;
(defconst win:revision
  "$Revision: 2.26 $"
  "Revision string of windows.el")
(defvar win:revision-prefix ";win;")

(defun win:frame-parameters (&optional frame)
  "Return frame parameters of FRAME (defaults to nil) which you want to save."
  (let ((parm (frame-parameters frame))
	(tosave (append win:frame-parameters-to-save-default
			win:frame-parameters-to-save-private)))
    (delq nil
	  (mapcar
	   (function 
	    (lambda (s)
	      (if (memq (car s) tosave)
		  (if (and (eq 'minibuffer (car s))
			   (windowp (cdr s)))
		      (cons 'minibuffer t)
		    s))))
	   parm))))

(defun win:save-window (winnum)
  "Save window WINNUM into configuration file.
Configuration to be saved is a list of
 (WINNUM (current-window-configuration-printable))"
  (require 'revive)
  (let ((conf (current-window-configuration-printable))
	(make-backup-files win:make-backup-files)
	(version-control 'never)
	(hilit-auto-highlight nil)
	i)
    (set-buffer (find-file-noselect win:configuration-file))
    (widen)
    (goto-char (point-min))
    (if (re-search-forward "^([0-9]" nil t)
	(goto-char (match-beginning 0))
      (goto-char (point-max))
      (if (not (bolp)) (newline 1)))
    (if (re-search-forward (format "^(%d " winnum) nil t)
	(progn
	  (goto-char (match-beginning 0))
	  (kill-sexp 1))
      (catch 'here
	(while (re-search-forward "^(\\([0-9]+\\)" nil 1)
	  (setq i (string-to-int
		   (buffer-substring (match-beginning 1) (match-end 1))))
	  (if (> i winnum)
	      (progn (open-line 1) (throw 'here t))))))
    (if (not (bolp)) (newline 1))
    (delete-blank-lines)
    ;; Now save the current window configuration.
    (insert
     (format "%s\n"
	     (prin1-to-string
	      (list winnum conf
		    (if win:use-frame
			(win:frame-parameters (aref win:configs winnum)))
		    (aref win:names-prefix winnum) ;;2.26
		    ))))
    (basic-save-buffer)
    (kill-buffer (current-buffer))
    (message "Saved window [%d]" winnum)))

;;;###autoload
(defun win-save-all-configurations ()
  "Save all window configurations into the configuration file."
  (interactive)
  (message "Saving all window configurations")
  (require 'revive)
  (win:adjust-window)
  (win:store-config win:current-config)
  (let ((i 1) (buflist (revive:buffer-property-list))
	(bakfile (concat win:configuration-file ".~~"))
	(hilit-auto-highlight nil)
	(version-control 'never))
    (if (and win:make-backup-files
	     (file-exists-p win:configuration-file))
	(copy-file win:configuration-file bakfile t))
    (set-buffer (find-file-noselect win:configuration-file))
    (widen)
    (erase-buffer)
    (insert (format "%s%s\n\n" win:revision-prefix win:revision))
    (insert (format ";;buffer-list\n%s\n\n;;window-configurations\n"
		    (prin1-to-string
		     (list buflist win:current-config win:last-config))))
    (basic-save-buffer)
    (kill-buffer (current-buffer))
    (while (< i win:max-configs)
      (if (aref win:configs i)
	  (progn
	    (if win:use-frame
		(progn
		  (select-frame (aref win:configs i))
		  (or win:no-raise-at-save (raise-frame (aref win:configs i))))
	      (set-window-configuration (aref win:configs i)))
	    (message "Saving window [%d]..." i)
	    (win:save-window i)
	    ))
      (setq i (1+ i)))
    (if (and win:make-backup-files
	     (file-exists-p bakfile))
	(let ((bk (make-backup-file-name win:configuration-file)))
	  (rename-file bakfile bk t)))
    (message "Saved all configurations in [%s]" win:configuration-file)
    (if win:use-frame
	(win:select-frame win:current-config)
      (set-window-configuration (aref win:configs win:current-config)))))

(defun win:load-window (arg)
  "Load the ARG-th window configuration from the configuration file."
  (require 'revive)
  (if (or (< arg 0) (> arg win:max-configs))
      (error "Window number %d out of range" arg))
  (if (null (file-exists-p win:configuration-file))
      (error "Configuration file %s not found" win:configuration-file))
  (let ((curb (current-buffer)) confb config)
    (set-buffer (find-file-noselect win:configuration-file))
    (setq confb (current-buffer))
    (widen)
    (goto-char (point-min))
    (if (null (re-search-forward (format "^(%d " arg) nil t))
	(error "Window [%s] is not found in configuration file." arg))
    (goto-char (match-beginning 0))
    (setq config (read (current-buffer)))
    (kill-buffer confb)
    (switch-to-buffer curb)
    (if (/= win:current-config arg)
	(win:switch-window arg nil t))
    (win:set-frame-configuration config)
    (win:store-config win:current-config)
    (win:switch-window arg)))

;;;###autoload
(defun wipe-windows (&optional no-ask)
  "Kill all buffers.  Optional argument NO-ASK non-nil skips query."
  (interactive "P")
  (if (and (null no-ask)
	   (not (y-or-n-p "Are you sure to wipe Emacs? ")))
      (error "Aborted"))
  (save-some-buffers)
  (let ((i 2))
    (while (< i win:max-configs)
      (and win:use-frame win:wipe-also-frames (aref win:configs i)
	   (delete-frame (aref win:configs i)))
      (aset win:configs i nil)
      (setq i (1+ i))))
  (mapcar (function kill-buffer) (buffer-list))
  (switch-to-buffer (get-buffer-create "*scratch*"))
  (funcall initial-major-mode)
  (delete-other-windows)
  (win:store-config 1)
  (win:update-mode-line 1))

(defun win:numericify (obj)
  "Force to numericify object of frame position parameter."
  (cond
   ((integerp obj) obj)
   ((and (listp obj) (= (length obj) 2) (memq (car obj) '(+ -)))
    (eval obj))
   (t 100)))

(defun win:set-frame-configuration (config)
  (if win:use-frame
      (let ((conf (car (cdr config))) x y (params (nth 2 config)) frame)
	;;win:switch-window is the easiest way to resume frames.
	(win:switch-window (car config))
	(setq frame (aref win:configs (car config)))
	(set-frame-width frame (car conf))
	(set-frame-height frame (car (cdr conf)))
	(if (setq x (assq 'left params))
	    (setcdr (car (member x params))
		    (+ (win:numericify (cdr x)) win:resumed-frame-offset-x)))
	(if (setq y (assq 'top params))
	    (setcdr (car (member y params))
		    (+ (win:numericify (cdr y)) win:resumed-frame-offset-y)))
	(if win:xemacs-p		;XEmacs is unwilling to set minibuffer
	    (setq params (delq (assq 'minibuffer params) params)))
	(modify-frame-parameters frame params)
	))
  (if (nth 3 config) (aset win:names-prefix (car config) (nth 3 config)))
  (restore-window-configuration (car (cdr config))))

;;;###autoload
(defun win-load-all-configurations (&optional preserve)
  "Load all window configurations from the configuration file.
Non-nil for optional argument PRESERVE keeps all current buffers."
  (interactive "P")
  (if (null (file-exists-p win:configuration-file))
      (error "Configuration file %s not found" win:configuration-file))
  (message "Loading all window configurations")
  (require 'revive)
  (let ((i 0) buflist wconflist buf)
    (if (null preserve)
	(wipe-windows t))
    (if (aref win:configs 1) (win:switch-window 1))
    (set-buffer (find-file-noselect win:configuration-file))
    (setq buf (current-buffer))
    (widen)
    (goto-char (point-min))
    (if (null (search-forward win:revision-prefix nil t))
	(error "Configuration file collapsed"))
    (if (and (not (string= win:revision
		      (buffer-substring
		       (point)
		       (progn (end-of-line)
			      (skip-chars-backward "^$") (point)))))
	     (not (y-or-n-p
		   "Configuration file version conflicts. Continue?")))
	(error "Version of configuration file conflicts.  Please update."))
    (if (null (re-search-forward "^(" nil t))
	(error "Configuration empty"))
    (goto-char (match-beginning 0))
    (setq buflist (read (current-buffer)))
    (setq win:current-config (nth 1 buflist) win:last-config (nth 2 buflist))

    ;;read all configs
    (while (re-search-forward "^([0-9]+ " nil t)
      (goto-char (match-beginning 0))
      (setq wconflist (cons (read (current-buffer)) wconflist)))
    (setq wconflist (nreverse wconflist))
    (set-buffer-modified-p nil)
    (kill-buffer buf)

    ;;Start restore
    (revive:restore-buffers (car buflist))
    (while wconflist
      (message "Restoring window [%d]..." (car (car wconflist)))
      (let ((win:current-config win:current-config)
	    win:last-config frame)
	(win:set-frame-configuration (car wconflist)))
      (win:store-config (car (car wconflist)))
      (setq wconflist (cdr wconflist)))
    (win:set-wc win:current-config)
    (win:update-mode-line win:current-config))
  (message "Finish loading.  Resume in window [%d]" win:current-config))

(or global-mode-string (setq global-mode-string '("")))
(or (memq 'win:mode-string global-mode-string)
    (setq global-mode-string (append global-mode-string '(win:mode-string))))

;;;
;; For Emacs 19 frame feature
;;;
(defun win:select-frame (num)
  "Select the NUM-th window frame."
  (if (= (length (frame-list)) 1)
      (if (eq (selected-frame) (aref win:configs num)) (selected-frame) nil)
    (let ((goal (aref win:configs num)))
      (if (null (frame-live-p goal))
	  (aset win:configs num nil)	;returns NIL
	;(if (eq (cdr (assq 'visibility (frame-parameters goal))) 'icon)
	;    (make-frame-visible goal))	;to de-iconify(if iconified)
	;;'visibility attribute is not defined in XEmacs...
	(or (eq t (frame-visible-p goal))
	    (make-frame-visible goal))
	(while (not (frame-visible-p goal)) (sit-for 0))
	(raise-frame goal)
	(select-frame goal)
	(if (not (eq (selected-frame) goal))
	    nil
	  (apply 'set-mouse-pixel-position
		 (if win:xemacs-p (selected-window) goal)
		 win:mouse-position)
	  (or win:xemacs-p (unfocus-frame))
	  goal)))))

(defun win:selected-window ()
  "Return the window number if selected-frame is a member of window list."
  (let ((i 1) (sf (selected-frame)) found)
    (while (and (< i win:max-configs) (not found))
      (if (eq sf (aref win:configs i))
	  (setq found t))
      (setq i (1+ i)))
    (if found (1- i))))

(defun win:adjust-window (&optional noerror)
  "Adjust win:current-config to (selected-frame).
If optional argument NOERROR is non-nil, do not stop even if the selected
window is not a member of window list."
  (interactive)
  (cond
   (win:use-frame
    (catch 'escape
      (if (eq (aref win:configs win:current-config) (selected-frame))
	  nil				;selected frame is current window.
	(let ((sw (win:selected-window)))
	  (if (not sw)
	      (if noerror
		  (throw 'escape t)
		(error "This frame is not under control of windows."))
	    (setq win:last-config win:current-config
		  win:current-config sw)
	    (win:update-mode-line win:current-config))))
      (if (and win:title-with-buffer-name (not win:xemacs-p))
	  (modify-frame-parameters
	   nil
	   (list
	    (cons 'name
		  (concat (funcall
			   win:frame-title-function win:current-config)
			  ":" (aref win:names-prefix win:current-config)
			  "(" (buffer-name) ")")))))))))

(defun win:title-mode-line-updater ()
  (if (eq this-command (get 'win:title-mode-line-updater 'last))
      nil				;Continuous call(maybe) canceled
    (condition-case err
	(progn
	  (win:adjust-window t)
	  (put 'win:title-mode-line-updater 'buffer (current-buffer)))
      (error nil))))

(defun win:title-mode-line-updater2 ()
  (if (eq this-command (get 'win:title-mode-line-updater 'last))
      nil
    (put 'win:title-mode-line-updater 'last this-command)
    (or (eq (get 'win:title-mode-line-updater 'buffer) (current-buffer))
	(condition-case err
	    (progn
	      (win:adjust-window t))
	  (error nil)))))

(if (and win:use-frame win:need-uptodate-frame-title)
    (progn
      (add-hook 'pre-command-hook 'win:title-mode-line-updater)
      (add-hook 'post-command-hook 'win:title-mode-line-updater2)))


(defun win:adjust-names ()
  "Adjust window names stored in win:names (for frame environment)."
  (cond
   (win:use-frame
    (let ((i 1))
      (while (< i win:max-configs)
	(if (aref win:configs i)
	    (progn
	      (select-frame (aref win:configs i))
	      (win:set-window-name i)))
	(setq i (1+ i))))
    (select-frame (aref win:configs win:current-config)))))

(defun win:other-frame (arg)
  "Switch to other frame for windows."
  (interactive "p")
  (win:adjust-window t)
  (other-frame arg)
  (if (null (win:adjust-window t)) (win:update-mode-line 0)))
(mapcar (function
	 (lambda (s)
	   (define-key global-map s 'win:other-frame)))
	(where-is-internal 'other-frame))

(defun win:frame-window (frame)
  "If FRAME is a member of window list return that index, else return nil."
  (let ((i 1))
    (catch 'found
      (while (< i win:max-configs)
	(if (eq frame (aref win:configs i)) (throw 'found i))
	(setq i (1+ i))))))

(defun win:allocate-frame (index)
  "Allocate a new frame for buffer list of Windows.
If all frames are members of window buffer, create new frame.
If there is a frame which don't belong to window buffer, return it.
INDEX is referred to decide the frame position."
  (let ((flist (reverse (frame-list))) frame)
    (if (catch 'found
	  (while flist
	    (or (member (car flist) (minibuffer-frame-list))
		(window-dedicated-p (frame-selected-window (car flist)))
		(if (null (win:frame-window (car flist)))
		    (throw 'found (setq frame (car flist)))))
	    (setq flist (cdr flist))))
	frame
      (setq
       frame
       (win:make-frame
	index
	(if (and win:auto-position (numberp index)
		 (memq 'top (append win:frame-parameters-to-save-default
				    win:frame-parameters-to-save-private)))
	    (let (frame (minn 1) minl mint left top)
	      (cond
	       ((eq win:auto-position 'absolute)
		(or (catch 'found	;search minimumly numbered window
		      (while (< minn win:max-configs)
			(if (aref win:configs minn) (throw 'found t))
			(setq minn (1+ minn))))
		    (setq minn 1 minl 0 mint 0)) ;not found
		(setq frame (aref win:configs minn)
		      minl (cdr (assq 'left (frame-parameters frame)))
		      minl (- (win:numericify minl)
			      (* win:new-frame-offset-x (1- minn)))
		      mint (cdr (assq 'top (frame-parameters frame)))
		      mint (- (win:numericify mint)
			      (* win:new-frame-offset-y (1- minn)))
		      left (+ (* win:new-frame-offset-x index) minl)
		      top  (+ (* win:new-frame-offset-y index) mint)))
	       (t			;not absolutely
		(setq
		 left (cdr (assq 'left (frame-parameters (selected-frame))))
		 left (+ (win:numericify left)
			 win:new-frame-offset-x)
		 top (cdr (assq 'top (frame-parameters (selected-frame))))
		 top (+ (win:numericify top)
			win:new-frame-offset-y))))
	      (list (cons 'left left) (cons 'top top)))))))
    (run-hooks 'win:allocate-frame-hook)
    frame))

;;;
;; For Utility
;;;
;;;###autoload
(defun see-you-again ()
  "Save all of the window configurations and kill-emacs."
  (interactive)
  (if win:current-config
      (progn (win-save-all-configurations)
	     (message "See you again!")
	     (sit-for 1)
	     (save-buffers-kill-emacs))))

;;;###autoload
(defun resume-windows (&optional preserve)
  "Restore all window configurations reading configurations from a file.
Non-nil for optional argument PRESERVE keeps current buffers."
  (interactive "P")
  (win:store-config 0)
  (win-load-all-configurations preserve)
  ;; This section depends highly on the version of `frame.el'.
  ;; It might be better to check boundp of variables frame-*.
  ;; But I think the case that those variables is not defined makes
  ;; confusion.  So we refer them without checking boundp.
  (if (and win:use-frame (aref win:configs 1)
	   frame-initial-frame (boundp 'frame-initial-geometry-arguments))
      ;;Modify initial-frame-alist so that the alternative frame
      ;;which will be created by frame-notice-user-settings
      ;;has the same geometry as that of the resumed first frame.
      (let ((frame (aref win:configs 1)))
	(setq frame-initial-geometry-arguments
	      (append (list (assq 'height (frame-parameters frame))
			    (assq 'width (frame-parameters frame))
			    (assq 'top (frame-parameters frame))
			    (assq 'left (frame-parameters frame)))
		      frame-initial-geometry-arguments))
	;; The new frame created in frame-notice-user-settings is to
	;; have the same buffer as that of selected frame at that time.
	;; So we temporarily select the window#1 for the new frame,
	;; and save the current window visiting list into the property
	;; of the symbol 'resume-windows.
	(put 'resume-windows 'lc (list win:last-config win:current-config))
	(win:switch-window 1))))

;;;
;; Window selection menu
;;;
(defvar win:switch-menu-buffer " * window list *")
(defvar win:switch-menu-saved-config (make-vector 2 nil)
  "(windows internal variable) vector of [NUM CONF];
where NUM is the selected window number when window selection is invoked,
CONF is the window configuration at the time.")

(defun win-switch-menu-edit-name-prefix ()
  "Edit win:names-prefix in win-switch-menu."
  (interactive)
  (let* ((goal (progn
                 (beginning-of-line)
                 (re-search-forward "(\\([A-Za-z0-9:-@]\\))" nil t)
                 (- (char-after (match-beginning 1)) win:base-key))) 
         (prefix (read-string "Window name: " (aref win:names-prefix goal))))
    (if (> (length prefix) win:names-maxl) ;$BF|K\8lCN$i$J$$!D(B
	(setq prefix (substring prefix 0 win:names-maxl)))
    (aset win:names-prefix goal prefix)
    (win:switch-menu-prepare-menu)
    (goto-char (point-min))
    (search-forward (concat "(" (format "%d" goal) ")"))
    (beginning-of-line)
  ))

(defun win-switch-menu-select (kill)
  "Select the window of cursor position in *window list*.
If interactive argument KILL is non-nil, kill menu buffer and no select."
  (interactive "P")
  (beginning-of-line)
  (if (and (eq (get-buffer win:switch-menu-buffer) (current-buffer))
	   (looking-at "[ A-Z]*(\\([A-Za-z0-9:-@]\\))"))
      (let ((goal (buffer-substring (match-beginning 1) (match-end 1))))
	(setq goal (- (string-to-char goal) win:base-key))
	(if win:use-frame (win:adjust-window))
	(if (eq win:current-config (aref win:switch-menu-saved-config 0))
	    (set-window-configuration (aref win:switch-menu-saved-config 1)))
	(or kill (win-switch-to-window 1 goal)))))

(defun win-switch-menu-select-directly ()
  "Select the window directly from the keyboard in window selection menu."
  (interactive)
  (let ((num (- last-command-char win:base-key)))
    (and
     (eq (get-buffer win:switch-menu-buffer) (current-buffer))
     (< num win:max-configs)
     (> num 0)
     (goto-char (point-min))
     (progn
       (if win:use-frame (win:adjust-window))
       (if (eq win:current-config (aref win:switch-menu-saved-config 0))
	   (set-window-configuration (aref win:switch-menu-saved-config 1)))
       (win-switch-to-window 1 num)))))

(defun win-switch-menu-mark-job (unmark)
  "Put job symbol in window selection menu buffer."
  (interactive "P")
  (and
   (eq (get-buffer win:switch-menu-buffer) (current-buffer))
   (progn (beginning-of-line) (looking-at "[ A-Z]+(.)"))
   (let (buffer-read-only)		;bound to nil
     (delete-char 1)
     (insert (if unmark " " (char-to-string (upcase last-command-char))))
     (forward-line 1)
     (and (eobp) (forward-line -1)))))

(defun win-switch-menu-unmark-job ()
  "Remove job symbol in window selection menu buffer."
  (interactive)
  (win-switch-menu-mark-job t))

(defun win-switch-menu-execute-job ()
  "Do real jobs in window selection menu buffer."
  (interactive)
  (let*((current win:current-config) job num (name (aref win:names current))
	(buf (get-buffer win:switch-menu-buffer)) (mes "Doing marked jobs..."))
    (save-excursion
      (goto-char (point-min))
      (message mes)
      (while (re-search-forward "^[A-Z]" nil t)
	(setq job (char-after (match-beginning 0)))
	(re-search-forward "(\\([A-Za-z0-9:-@]\\))" nil t)
	(setq num (- (char-after (match-beginning 1)) win:base-key))
	(cond
	 ((= job ?D)
	  (if (aref win:configs num)
	      (if (or (/= current num)
		      (y-or-n-p "Are you sure to kill this window?"))
		  (win:delete-window num nil t)))) ;without query(3rd arg t)
	 ((= job ?S) (and (aref win:configs num) (win:save-window num)))
	 ((= job ?L)
	  (let ((win:last-config win:last-config))
	    (win:load-window num)
	    (if (= num current)		;override previous configuration.
		(aset win:switch-menu-saved-config 1
		      (current-window-configuration)))))
	 ((= job ?K)
	  (if (aref win:configs num)
	      (let ((win:last-config win:last-config))
		(win:switch-window num)
		(win-delete-current-window t)))) ;with query
	 (t nil))
	(and (aref win:configs num) (/= num current)
	     (progn (win:switch-window current)	;back to menu buffer
		    (win:set-window-name current))) ;preserve window name
	(set-buffer buf)))		;might be killed by `D'
    (message "%sDone." mes)
    (if (= current win:current-config) ;menu is still alive
	(win:switch-menu-prepare-menu))))

(defun win-switch-menu-quit ()
  "Quit from window menu buffer."
  (interactive)
  (win-switch-menu-select t))

(defun win:switch-menu-prepare-menu ()
  (switch-to-buffer win:switch-menu-buffer)
  (setq buffer-read-only nil)
  (erase-buffer)
  (let ((i 1) (this (make-marker))
	(form (format " (%%c)%%s %%-%ds [%%s]\n" (+ win:names-maxl 2))))
    (while (< i win:max-configs)
      (if (= win:current-config i) (set-marker this (point)))
      (insert (format form
		      (+ win:base-key i)
		      (cond ((= i win:current-config) "*")
			    ((= i win:last-config) "+")
			    (t " "))
		      (if (aref win:configs i) 
			  (format "\"%s\"" (aref win:names-prefix i))
			"")
		      (if (aref win:configs i) (aref win:names i)
			"")
		      ))
      (setq i (1+ i)))
    (use-local-map win:switch-menu-map)
    (goto-char this))
  (win:switch-menu-mode)
  (setq buffer-read-only t))

(defun win-switch-menu ()
  "Show the menu of all windows and select one of them."
  (interactive)
  (if (string= (buffer-name (current-buffer)) win:switch-menu-buffer) () 
    (if (= (+ win:current-config win:last-config) 0)
        (error "No windows allocated"))
    (win:adjust-window)
    (win:store-config win:current-config)		;save current state
    (win:adjust-names)
    (or win:use-frame (win:store-config win:current-config)) ;save current state
    (aset win:switch-menu-saved-config 0 win:current-config)
    (aset win:switch-menu-saved-config 1 (current-window-configuration))
    (if (< (window-height) (1+ win:max-configs))
        (enlarge-window (- win:max-configs (window-height)))))
  (win:switch-menu-prepare-menu)
  (message
   "N)ext P)rev SPC)select S)ave L)oad D)elete K)ill E)dit-name e(X)ec NUM Q)uit ?)help"))

(defun win:switch-menu-mode ()
  "===== Window selection buffer for windows.el =====

	n	next-line
	p	previous-line
	\\[win-switch-menu-select]	select this window
	\\[win-switch-menu-quit]	quit from window selection menu
	NUMBER	select NUMBER-th window directly
	s	mark this window to be saved into configuration file
	l	mark this window to be loaded from configuration file
	d	mark this window to be deleted
	k	mark this window to be killed (kill also displayed buffers)
        e       edit window configuration name
	\\[win-switch-menu-execute-job]	do jobs on each marked window
"
  (setq major-mode 'win:switch-menu-mode
	mode-name "window selection"))

;;;
;; Final setup.
;;;
(provide 'windows)
(run-hooks 'win-load-hook)

;; $Log: windows.el,v $
;; Revision 2.26  1999/05/14 05:43:38  yuuji
;; Fix the case as below;
;; Start Emacs with win:startup-with-window,
;; and C-c 2 f SomeFile,
;; and immediately delete window by C-c !. it complain that
;; there is only one window.
;;
;; Revision 2.25  1999/01/16 06:19:25  yuuji
;; bug in win:store-buffer-list, fixed
;;
;; Revision 2.24  1999/01/16 05:13:20  yuuji
;; win:buffer-depth-per-win
;; 	preserves buffer-list priority per window
;;
;; Revision 2.23  1998/11/12 13:42:01  yuuji
;; Now runs correctly on Emacs without screen-height/screen-width.
;;
;; Revision 2.22  1998/10/26 13:25:02  yuuji
;; For Emacs20, avoid infinite loop at selecting iconified frame.
;;
;; Revision 2.21  1998/09/22 15:16:08  yuuji
;; Now win:auto-position works correctly on Emacs20.
;;
;; Revision 2.20  1998/09/22 14:46:29  yuuji
;; *** empty log message ***
;;
;; Revision 2.19  1998/04/01 03:52:24  yuuji
;; FSF's address fixed
;;
;; Revision 2.18  1997/12/22 02:34:04  yuuji
;; win:wipe-also-frames works correctly
;;
;; Revision 2.17  1997/12/15 02:52:55  yuuji
;; Free variable `frame' in win:set-frame-configuration localized
;;
;; Revision 2.16  1997/12/08 06:51:52  yuuji
;; Small fix
;;
;; Revision 2.15  1997/12/08 06:43:15  yuuji
;; Try to keep frame title up to date.
;; win:need-uptodate-frame-title
;;
;; Revision 2.14  1997/12/04 03:30:27  yuuji
;; win:wipe-also-frames
;; Set win:current-config to 1 at win:startup-with-window.
;;
;; Revision 2.13  1997/12/01 19:36:53  yuuji
;; Fix document of the part which says about combination with window
;; manager.
;;
;; Revision 2.12  1997/12/01 01:51:28  yuuji
;; Switch to selected frame at loading.
;; Don't pass 'minibufffer property at frame creation on XEmacs.
;;
;; Revision 2.11  1997/11/29 13:19:42  yuuji
;; XEmacs support
;;
;; Revision 2.10  1997/10/23 13:53:52  yuuji
;; Support Emacs20
;;
;; Revision 1.94  1997/01/27 03:50:31  yuuji
;; split-window-safe fixed
;; mew support fixed again
;;
;; Revision 1.93  1997/01/17 03:10:38  yuuji
;; Support mew(revive.el)
;;
; Revision 1.92  1996/08/16  16:23:18  yuuji
; Adjust window at win-resume-menu and win-swap-with.
;
; Revision 1.91  1996/05/05  16:48:50  yuuji
; small fix for emacs 19.30
;
; Revision 1.9  1995/09/07  02:27:16  yuuji
; Revise document.
;
; Revision 1.8  1995/07/13  01:33:19  yuuji
; Fix typos and setq of frame-initial-geometry-arguments.
;
; Revision 1.7  1995/02/02  17:37:05  yuuji
; New variables for customization, win:resumed-frame-offset-x,
; win:resumed-frame-offset-y and win:mouse-position added.
;
; Revision 1.6  1995/01/12  14:55:37  yuuji
; Enhanced window selection menu
;
; Revision 1.5  1994/11/19  17:50:30  yuuji
; Resume window number correctly when splitting minibuffer.
;
; Revision 1.4  1994/09/26  17:16:09  yuuji
; Full support for Emacs-19.
;
; Revision 1.3  1994/06/06  07:51:52  yuuji
; Window #0 no longer shows up in window-list.
;
; Revision 1.2  1994/05/06  21:38:33  yuuji
; Omit window#0 on win-{next,prev}-window.
; Disable deleting sole window.
; win:last-config has no longer #0.
;
; Revision 1.1  1994/04/18  02:41:22  yuuji
; Fix the bug on `Preserve' of window creation menu.
;
; Revision 1.0  1994/03/07  07:39:01  yuuji
; Support `frame environment' of Emacs 19.
;
; Revision 0.9  1994/02/17  08:48:41  yuuji
; Make win-startup-with-window smart.
; Local resume.
;
; Revision 0.8  1994/02/09  10:57:20  yuuji
; Update the document.
; Fix win:startup-with-window.
;
; Revision 0.7  1994/02/07  12:41:05  yuuji
; win-resume-menu
;
; Revision 0.6  1994/02/05  07:56:37  yuuji
; Add the functions to resume Emacs.
;
; Revision 0.5  1994/02/03  10:08:03  yuuji
; Allow resize of Emacs's window.
;
;; Revision 0.2  93/10/12  02:43:15  yuuji
;; Change prefix key to `C-c C-w'.
;; 

; Local variables:
; fill-prefix: ";;;	"
; paragraph-start: "^$\\|\\|;;;$"
; paragraph-separate: "^$\\|\\|;;;$"
; End:
