/*
 *
 * (c) Vladi Belperchinov-Shabanski "Cade" <cade@biscom.net> 1996-1999
 *
 * SEE `README',`LICENSE' OR `COPYING' FILE FOR LICENSE AND OTHER DETAILS!
 *
 */

#include "vfu.h"
#include "vfufiles.h"
#include "vfuview.h"
#include "vfuopt.h"
#include "vfuuti.h"
#include "vfusys.h"

#define TAGMARK TAGMARKS[opt.TagMark]

int SelMarkPos   = 1; // this is set by ReDraw
int TagMarkPos   = 1; // this is set by ReDraw

void ShowPos( int curr, int all )
{
  char tmp[64];
  sprintf( tmp, "%5d of %5d ", curr, all );
  ConOut( ConMaxX() - 14, 3, tmp, cHEADER );
}

void UpdatePos()
{
 if ( FLI < 0 ) FLI = 0;
 if ( FLI > FilesCount - 1) FGO(FilesCount - 1);
}

void ClearPointer()
{
if(opt.VFStyle)
  {
  DrawItem(FLI, 0);
  }
else
  ConOut(TagMarkPos,FLI-FLP+4, "  ", chWHITE);
}

void DrawPointer()
{
if(opt.VFStyle)
  {
  DrawItem(FLI, 1);
  if (Files[FLI]->sel != 0)
    ConOut(TagMarkPos, FLI-FLP+4, TAGMARK, CONCOLOR(cBLACK, cWHITE) );
  else
    ConOut(TagMarkPos, FLI-FLP+4, TAGMARK, chWHITE );
  }
else
  ConOut(TagMarkPos, FLI-FLP+4, TAGMARK, chWHITE);
}

/////////////////////////////////////////////
//
// refresh private views
//
void RefreshAllViews()
{
int z = 0;
if ( FilesCount > 1024 ) say1( "Refreshing views..." );
for( z = 0; z < FilesCount; z++ ) RefreshView( z );
if ( FilesCount > 1024 ) say1( "" );
}

void RefreshView( int n )
{
    TF *fi = Files[n];

    char stmode[16]  = ""; // 10 + 1sep
    char stowner[16] = "";
    char stgroup[16] = "";
    char sttime[16]  = "";
    char stsize[16]  = "";
    char sttype[4]   = "";
    char seltag[4]   = "   ";

    if (opt.fTime && !opt.LongNameView)
      {
      /*
      time_t timenow = time( NULL );
      time_t _ctime = 0;
      if (opt.fTimeType == 0) _ctime   = fi->st.st_ctime; else
      if (opt.fTimeType == 1) _ctime   = fi->st.st_mtime; else
      if (opt.fTimeType == 2) _ctime   = fi->st.st_atime; else
      ASSERT(!"Bad fTime state");
      strcpy(stctime, ctime(&_ctime));
      if (timenow > _ctime + 6L * 30L * 24L * 60L * 60L // Old.
          ||
          timenow < _ctime - 60L * 60L) // In the future.
          strcpy (stctime + 11, stctime + 19);
      stctime[16] = 0;
      strcpy(stctime, stctime+4);
//      strcpy(stctime+3, stctime+4);
      sprintf( sttime, "%11s ", stctime );
      if (sttime[4] == ' ') sttime[4] = '0';
      */
      if (opt.fTimeType == 0) TimeStr(fi->st.st_ctime,sttime); else
      if (opt.fTimeType == 1) TimeStr(fi->st.st_mtime,sttime); else
      if (opt.fTimeType == 2) TimeStr(fi->st.st_atime,sttime); else
      ASSERT(!"Bad fTime state");
      strcat( sttime, " " );
      }

    /*
    time_t *tt;
    tt = &(fi->st.st_ctime);
    strcpy(stctime, ctime(tt));
    stctime[11] = 0;
    */

    if (opt.fAttr && !opt.LongNameView)
      {
      strcpy( stmode, Files[n]->stmode );
      strcat( stmode, " " );
      }

    if (opt.fType || opt.LongNameView)
      {
      strcpy( fi->sttype, FileStatType( fi->st.st_mode, fi->is_link ) );
      strcpy( sttype, fi->sttype );
      // type nqma separator zashtoto vednaga sled nego idva pointera TAGMARK
      }

    if (opt.fOwner && !opt.LongNameView)
      {
      char file_owner[32];
      struct passwd* _pwd = getpwuid(fi->st.st_uid);
      if (_pwd)
        strcpy(file_owner,_pwd->pw_name);
      else
        sprintf(file_owner,"%d",fi->st.st_uid);
      sprintf( stowner, "%8s ", file_owner );
      }

    if (opt.fGroup && !opt.LongNameView)
      {
      char file_group[32];
      struct group*  _grp = getgrgid(fi->st.st_gid);
      if (_grp)
        strcpy(file_group,_grp->gr_name);
      else
        sprintf(file_group,"%d",fi->st.st_gid);
      sprintf( stgroup, "%8s ", file_group );
      }

    if (opt.fSize && !opt.LongNameView)
      {
      String str;
      if (fi->size == -1)
        {
        str = "[DIR]";
        }
      else
        {
        str.setfi(fi->size);
        StrComma(str);
        }
      sprintf( stsize, "%14s ", (const char*)(str) );
      }

    char outname[MAX_PATH];
    outname[0] = 0;
    strcpy(outname, fi->name);
    #ifdef _TARGET_GO32_
    if (opt.VFFilenames)
      {
      if (fi->is_dir)
        UpString( outname );
      else
        LowString( outname );
      }
    #endif
    if (fi->is_link && opt.ShowLinks)
      {
      #ifdef _TARGET_UNIX_
      strcat(outname, "  -> ");
      char tmp[MAX_PATH];
      // ExpandPath(fi->name, tmp); // !!! tova trqbva da stava s `readlink()'
      int lnum = readlink( fi->name, tmp, MAX_PATH-1 );
      if (lnum != -1) tmp[lnum] = 0;
      strcat(outname, tmp);
      #endif
      }

    char out[512] = "";
    strcat( out, stmode );
    strcat( out, stowner );
    strcat( out, stgroup );
    strcat( out, sttime );
    strcat( out, stsize );
    strcat( out, sttype );
    strcat( out, seltag );
    strcat( out, outname );
//    strcat( out, "                                                      " );
    if (strlen(out) > (size_t)(MAXX-1)) out[(MAXX-1)] = 0;
    strcpy( fi->view, out );

    fi->color = GetColor( fi );
/*
    if (opt.LongNameView == 1)
          sp(fi->view,
          "%10s %8s %8s %11ld %2s   %s ",
          stmode,
          file_owner,
          file_group,
          fi->size,
          sttype,
          outname
          );
    else
          sp(fi->view,
          "%10s %8s %8s %11s %11ld %2s   %s",
          stmode,
          file_owner,
          file_group,
          stctime,
          fi->size,
          sttype,
          outname
          );
*/
}

/////////////////////////////////////////////
//
// navigation & screen draws
//
int GetColor( TF *fi )
{
  if (!opt.FileColors)
    {
    if (fi->is_dir) return cCYAN; // dirs are cCYAN by default
    return cNORMAL;
    }

  int z;
  char _ext[128] = ".";
  char _stype[8] = "."; // stat type

//  if (fi->sel && opt.VFStyle) return CONCOLOR(cBLACK,cWHITE);

  if (fi->fname[0] == '.')
    strcpy( _ext, ".dotfiles" );
  else
    FileExt( fi->fname, _ext+1 );
  strcat( _ext, "." );
  strcpy( _stype+1, fi->sttype ); strcat( _stype, "." );

  #ifdef _TARGET_GO32_
  LowString( _ext );
  #endif

  for ( z = cBLACK; z <= chWHITE; z++ ) if (strstr( ExtColors[z], _stype )) return z;
  for ( z = cBLACK; z <= chWHITE; z++ ) if (strstr( ExtColors[z], _ext   )) return z;
  if  (fi->is_dir) return cCYAN; // if no color given for dirs -- cCYAN
  return cNORMAL;
}

void DrawItem( int n, int hilite )
{
  if ( n >= FilesCount || n < 0 ) return;
  if ( n < FLP || n > FLP + PS ) return;
  TF *fi = Files[n];
  DrawItem( ( n - FLP ) + 4, 0, fi, hilite );
}

void DrawItem(int y, int x, TF *fi, int hilite)
{
    x = 1;

    int fi_color = fi->color; // GetColor( fi );

    strcpy(sss, fi->view);

    if (opt.VFStyle)
      {
      if ( COLORFG(fi_color) > cBOLD ) fi_color -= cBOLD;
      if(fi->sel)
        {
        sss[SelMarkPos-1] = '#';
        fi_color = CONCOLOR(cBLACK,cWHITE);
        }
      ConOut(1, y, sss, fi_color + hilite*cBOLD); ConCE(fi_color + hilite*cBOLD);
      if(hilite)
        {
        if (fi->sel != 0)
           ConOut( TagMarkPos, y, TAGMARK, CONCOLOR(cBLACK, cWHITE) );
        else
          ConOut( TagMarkPos, y, TAGMARK, chWHITE );
        }
      }
    else
      {
      ConOut(1, y, sss, fi_color); ConCE(fi_color);
      if (fi->sel)
        ConOut( SelMarkPos, y, "#", chWHITE );
      }
}

extern char *FTIMETYPE[];
void ReDraw()
{
  String str;
  ConOut(1,1,HEADER,chYELLOW);
//  sprintf( str,"%s%s %s", CPath, AName, (WorkMode == wmInArchive)?"[ IN ARCHIVE MODE ]":FMASK);
  str = CPath;
  if ( WorkMode == wmInArchive )
    { str += AName; str += " [ IN ARCHIVE MODE ]"; }
  if ( WorkMode == wmNormal )
    { str += " "; str += FMASK; }
  
  ConOut(1,2,str,chYELLOW);ConCE(chYELLOW);

  str = "";
  sss[0] = 0;
  char *spos = sss;
  if (opt.SortOrder == 'D') opt.SortOrder = 'T'; // hack anyway
  if (!opt.LongNameView)
    {
    // sort order char +/-
    #define SOCH(c) ((opt.SortOrder == (c))?(opt.Reversed == 'A'?'+':'-' ):' ')
    if (opt.fAttr  ) spos += sprintf( spos, "%10s%c", ATTR_STRING,  SOCH('A') );
    if (opt.fOwner ) spos += sprintf( spos, "  %cOWNER ", SOCH('O') );
    if (opt.fGroup ) spos += sprintf( spos, "  %cGROUP ", SOCH('G') );
    if (opt.fTime  ) spos += sprintf( spos, "%s %cTiME ", FTIMETYPE[opt.fTimeType], SOCH('T') );
    if (opt.fSize  ) spos += sprintf( spos, "         %cSiZE ", SOCH('S') );
    };
  if (opt.fType || opt.LongNameView) spos += sprintf( spos, "TP%c", SOCH('Y') );
  TagMarkPos = strlen( sss );
  SelMarkPos = TagMarkPos + 2;

  spos += sprintf( spos, " #NAME%c",  ((opt.SortOrder == 'M') || (opt.SortOrder == 'N')) ? (opt.Reversed == 'A'?'+':'-') : ' ' );

  str = sss;
  StrPad( str, -(ConMaxX()) );
  StrTrimR( str, 13 ); // do not overlap `xxx of yyy' place + `[NA] '
/*
  char tmp[8];
  tmp[0] = '[';
  tmp[1] = opt.SortOrder;
  tmp[2] = opt.Reversed;
  tmp[3] = ']';
  tmp[4] = ' ';
  tmp[5] = 0;
  str += tmp;
*/
  ConOut(1,3, str, cHEADER );

  int z;

  for (z = 0; z < PS; z++)
    {
    if (FLP+z >= FilesCount)
      { ConOut(1,z+4,"~",cNORMAL); ConCE( cNORMAL ); }
    else
      DrawItem(FLP+z, FLP+z == FLI);
    }
  if(FilesCount > 0)
    {
    DrawPointer();
    }
  else
    {
    ConOut(30, 10, "No files found...", chRED);
    }
  ShowPos( FLI+1, FilesCount );
}

void ReDrawSta()
{
  String s1;
  String s2;
  String tmp;
  s1  = "Select :";
  tmp = SelCount;
  StrComma(tmp);
  StrPad(tmp,13);
  s1 += tmp;

  s1 += "   Free :";
  sprintf( 64, tmp,"%0.3f MB", FSFree/1024.0/1024.0 );
  StrComma(tmp); StrPad(tmp,13); s1 += tmp;
  if (FSTotal == 0)
    tmp = "  n/a%";
  else
    sprintf( 64, tmp, "%4.1f%%", (double)100 * ((double)FSFree / (double)FSTotal));
  s1 += "  " + tmp + "   FSize:";
  tmp = AllSize;
  StrComma(tmp);
  StrPad(tmp,13);
  s1 += tmp;
  if (FSTotal == 0)
    tmp = "  n/a%";
  else
    sprintf(tmp,"%4.1f%%", (double)100 * ((double)AllSize / (double)FSTotal));
  s1 += " " + tmp + "  ";

  s2  = "SelSize:";
  tmp = SelSize;
  StrComma(tmp); StrPad(tmp,13); s2 += tmp;
  s2 += "   Total:";
  sprintf( 64, tmp,"%0.3f MB", FSTotal/1024.0/1024.0 );
  StrComma(tmp); StrPad(tmp,13); s2 += tmp;
  tmp = FSBSize; StrPad( tmp,5 ); s2 += " [" + tmp + "]";
  // sprintf( tmp,"  UID/GID: %8s/%8s ", UIDstr, GIDstr ); s2 += tmp;
  sprintf( tmp,"  U: %s.%s@%s ", UIDstr, GIDstr, HOSTstr ); s2 += tmp;

  StrPad( s1, - MAXX );
  StrPad( s2, - MAXX );

  ConOut( 1, STATLINE1, s1, cINFO );
  ConOut( 1, STATLINE2, s2, cINFO );
}


void __Up()
{
if (FilesCount == 0) return;
if (FLI == 0) return;

ClearPointer();

int OldFLP = FLP;
FINDEX.up();
if (OldFLP != FLP) draw = 1;
/*
FLI--;
if (FLI < FLP)
  {
  FLP -= PS;
  draw = 1;
  }
*/
if (opt.VFStyle)
  {
  DrawItem(FLI+1, 0);
  DrawItem(FLI, 1);
  }
else
  DrawPointer();

}

void __Dn()
{
if (FilesCount == 0) return;
if (FLI == FilesCount - 1) return;

ClearPointer();

int OldFLP = FLP;
FINDEX.down();
if (OldFLP != FLP) draw = 1;
/*
FLI++;
if (FLI >= FLP+PS )
  {
  FLP += PS;
  draw = 1;
  }
*/
if (opt.VFStyle)
  {
  DrawItem(FLI-1, 0);
  DrawItem(FLI, 1);
  }
else
  DrawPointer();

}

void __PU()
{
if (FilesCount == 0) return;
if (FLP == 0 && FLI == 0) return;

ClearPointer();

int OldFLP = FLP;
FINDEX.pageup();
if (OldFLP != FLP) draw = 1;
/*
if (FLP != 0)
  {
  if (FLI != FLP)
    {
    FLI = FLP;
    }
  else
    {
    FLP -= PS;
    FLI -= PS;
    }
  draw = 1;
  }
else
  {
  FLI = 0;
  }
*/
DrawPointer();

}

void __PD()
{
if (FilesCount == 0) return;
if (FLP >= FilesCount - PS && FLI == FilesCount - 1) return;

ClearPointer();

int OldFLP = FLP;
FINDEX.pagedown();
if (OldFLP != FLP) draw = 1;

/*
if (FLP < FilesCount - PS)
  {
  if (FLI != FLP + PS - 1)
    {
    FLI = FLP + PS - 1;
    }
  else
    {
    FLP += PS;
    FLI += PS;
    if (FLI > FilesCount - 1) FLI = FilesCount - 1;
    }
  draw = 1;
  }
else
  {
  FLI = FilesCount - 1;
  }
*/
DrawPointer();

}

void __Home()
{
if (FilesCount == 0) return;
if (FLI == 0) return;

ClearPointer();

int OldFLP = FLP;

FGO(0); // FLI = 0;
UpdatePos();

if (OldFLP != FLP) draw = 1;

DrawPointer();
}

void __End()
{
if (FilesCount == 0) return;
if (FLI >= FilesCount - 1) return;

ClearPointer();

int OldFLP = FLP;

// FLI = FilesCount - 1;
FGO(FilesCount - 1);
UpdatePos();

if (OldFLP != FLP) draw = 1;

DrawPointer();

}

void __Select()
{
if (FilesCount == 0) return;
TF *fi = Files[FLI];

fi->sel = -(fi->sel - 1);
fsize_t dsize = fi->size;
if (dsize < 0) dsize = 0; // dirs?
if (fi->sel == 0)
  {
  SelCount --;
  SelSize -= dsize;
  ClearSel;
  }
else
  {
  SelCount ++;
  SelSize += dsize;
  DrawSel;
  }

DrawPointer();

if (FLI < FilesCount - 1) __Dn();
ReDrawSta();
}

