/*
 *
 * (c) Vladi Belperchinov-Shabanski "Cade" <cade@biscom.net> 1996-1999
 *
 * SEE `README',`LICENSE' OR `COPYING' FILE FOR LICENSE AND OTHER DETAILS!
 *
 */
      
#include "vfu.h"
#include "vfusys.h"
#include "vfuuti.h"
#include "vfumenu.h"

#ifdef _TARGET_GO32_
  #include <io.h>
#endif

// ############################################# MISC OS UTILS ##########

#ifdef _TARGET_UNIX_

//  these attributes/mode functions are a bit messy...
//  however it's clean (hope so) now and works ok. :)

void fgetattr_s( const mode_t tm, char *stmode )
{
  strcpy(stmode, "----------");
  if (S_ISDIR(tm) ) stmode[0] = 'd';else
  if (S_ISLNK(tm) ) stmode[0] = 'l';else
  if (S_ISBLK(tm) ) stmode[0] = 'b';else
  if (S_ISCHR(tm) ) stmode[0] = 'c';else
  if (S_ISFIFO(tm)) stmode[0] = 'f';else
  if (S_ISSOCK(tm)) stmode[0] = 's';

  if ((tm & S_IRUSR) != 0) stmode[1] = 'r';
  if ((tm & S_IWUSR) != 0) stmode[2] = 'w';
  if ((tm & S_IXUSR) != 0) stmode[3] = 'x';
  if ((tm & S_IRGRP) != 0) stmode[4] = 'r';
  if ((tm & S_IWGRP) != 0) stmode[5] = 'w';
  if ((tm & S_IXGRP) != 0) stmode[6] = 'x';
  if ((tm & S_IROTH) != 0) stmode[7] = 'r';
  if ((tm & S_IWOTH) != 0) stmode[8] = 'w';
  if ((tm & S_IXOTH) != 0) stmode[9] = 'x';

  if ((tm & S_ISUID) != 0) stmode[3] = ((tm & S_IXUSR) != 0) ? 's' : 'S';
  if ((tm & S_ISGID) != 0) stmode[6] = ((tm & S_IXGRP) != 0) ? 's' : 'S';
  if ((tm & S_ISVTX) != 0) stmode[9] = ((tm & S_IXOTH) != 0) ? 't' : 'T';
  #ifdef _TARGET_GO32_
  stmode[4]=stmode[5]=stmode[6]=stmode[7]=stmode[8]=stmode[9]='-';
  #endif
}

int fgetattr_s( const char *filename, char *target )
{
strcpy(target, "----------");
struct stat st;
if (stat(filename, &st)) return 1;
fgetattr_s(st.st_mode, target);
return 0;
}

int fsetattr_s( const char *filename, const char *attrs )
{
char oldattrs[12];
char newattrs[12];
mode_t newmode = 0;
strcpy(newattrs, attrs);
if (strchr( newattrs, '?' ))
  {
  if (fgetattr_s(filename, oldattrs)) return 1;
  
  if (newattrs[1] == '?') newattrs[1] = oldattrs[1];
  if (newattrs[2] == '?') newattrs[2] = oldattrs[2];
  if (newattrs[3] == '?') newattrs[3] = oldattrs[3];
  if (newattrs[4] == '?') newattrs[4] = oldattrs[4];
  if (newattrs[5] == '?') newattrs[5] = oldattrs[5];
  if (newattrs[6] == '?') newattrs[6] = oldattrs[6];
  if (newattrs[7] == '?') newattrs[7] = oldattrs[7];
  if (newattrs[8] == '?') newattrs[8] = oldattrs[8];
  if (newattrs[9] == '?') newattrs[9] = oldattrs[9];
  }
  
if (newattrs[1] == 'r') newmode |= S_IRUSR;
if (newattrs[2] == 'w') newmode |= S_IWUSR;
if (newattrs[3] == 'x') newmode |= S_IXUSR;
if (newattrs[4] == 'r') newmode |= S_IRGRP;
if (newattrs[5] == 'w') newmode |= S_IWGRP;
if (newattrs[6] == 'x') newmode |= S_IXGRP;
if (newattrs[7] == 'r') newmode |= S_IROTH;
if (newattrs[8] == 'w') newmode |= S_IWOTH;
if (newattrs[9] == 'x') newmode |= S_IXOTH;

if (newattrs[3] == 's') { newmode |= S_ISUID; newmode |= S_IXUSR; }
if (newattrs[3] == 'S') newmode |= S_ISUID;
if (newattrs[6] == 's') { newmode |= S_ISGID; newmode |= S_IXGRP; }
if (newattrs[6] == 'S') newmode |= S_ISGID;
if (newattrs[9] == 't') { newmode |= S_ISVTX; newmode |= S_IXOTH; }
if (newattrs[9] == 'T') newmode |= S_ISVTX;

return (chmod( filename, newmode ) != 0);
}

/*
void rollattr( const int n, char *attrs, int allow_masking )
{
char templ[11];
strcpy(templ, "-rwxrwxrwx");

switch(attrs[n])
  {
  case '?'      : attrs[n] = templ[n]; break;
  case 's'      : attrs[n] = '-';break;
  case '-'      : attrs[n] = allow_masking? '?' : templ[n] ; break;
  default       : if(n == 3 || n == 6)
                    attrs[n] = 's';
                  else
                    attrs[n] = '-';
                  break;
  }
}
*/

int EditAttr( char *attrs, int allow_masking )
{
  int atti[16];
  if (allow_masking == 0)
    { // "-rwxrwxrwx"
    for ( int z = 0; z < 16; z++ ) atti[z] = 1;
    atti[ 1] = (attrs[1] != 'r');
    atti[ 2] = (attrs[2] != 'w');
    atti[ 3] = (attrs[3] != 'x');
    atti[ 4] = (attrs[4] != 'r');
    atti[ 5] = (attrs[5] != 'w');
    atti[ 6] = (attrs[6] != 'x');
    atti[ 7] = (attrs[7] != 'r');
    atti[ 8] = (attrs[8] != 'w');
    atti[ 9] = (attrs[9] != 'x');
    
    atti[10] = !((attrs[3] == 's') || (attrs[3] == 'S'));
    atti[11] = !((attrs[6] == 's') || (attrs[6] == 'S'));
    atti[12] = !((attrs[9] == 't') || (attrs[9] == 'T'));
    if (atti[3]) atti[ 3] = !(attrs[3] == 's');
    if (atti[6]) atti[ 6] = !(attrs[6] == 's');
    if (atti[9]) atti[ 9] = !(attrs[9] == 't');
    }
  else
    {
    for ( int z = 0; z < 16; z++ ) atti[z] = 2;
    }

  char* AONOFF1[] = { "YES", " - ", " ? ", NULL };
  char* AONOFF2[] = { "YES", " - ", NULL };
  #define AONOFF  (allow_masking?AONOFF1:AONOFF2)
  ToggleEntry attr_togs[] =
  {
  { ' ', "USR Read  ", &atti[ 1], AONOFF },
  { ' ', "USR Write ", &atti[ 2], AONOFF },
  { ' ', "USR Exec  ", &atti[ 3], AONOFF },
  { ' ', "GRP Read  ", &atti[ 4], AONOFF },
  { ' ', "GRP Write ", &atti[ 5], AONOFF },
  { ' ', "GRP Exec  ", &atti[ 6], AONOFF },
  { ' ', "OTH Read  ", &atti[ 7], AONOFF },
  { ' ', "OTH Write ", &atti[ 8], AONOFF },
  { ' ', "OTH Exec  ", &atti[ 9], AONOFF },
  { ' ', "Set UID   ", &atti[10], AONOFF },
  { ' ', "Set GID   ", &atti[11], AONOFF },
  { ' ', "Sticky    ", &atti[12], AONOFF },
  { -1, "---", NULL, NULL },
  };

  if ( !ToggleBox( 50, 5, "Attributes/Mode", attr_togs ) ) return 0;

  if (atti[ 1] < 2) attrs[1] = atti[ 1] == 0 ? 'r' : '-';
  if (atti[ 2] < 2) attrs[2] = atti[ 2] == 0 ? 'w' : '-';
  if (atti[ 3] < 2) attrs[3] = atti[ 3] == 0 ? 'x' : '-';
  if (atti[ 4] < 2) attrs[4] = atti[ 4] == 0 ? 'r' : '-';
  if (atti[ 5] < 2) attrs[5] = atti[ 5] == 0 ? 'w' : '-';
  if (atti[ 6] < 2) attrs[6] = atti[ 6] == 0 ? 'x' : '-';
  if (atti[ 7] < 2) attrs[7] = atti[ 7] == 0 ? 'r' : '-';
  if (atti[ 8] < 2) attrs[8] = atti[ 8] == 0 ? 'w' : '-';
  if (atti[ 9] < 2) attrs[9] = atti[ 9] == 0 ? 'x' : '-';

  if (atti[10] < 2) if (atti[10] == 0) attrs[3] = (atti[ 3] == 0) ? 's' : 'S';
  if (atti[11] < 2) if (atti[11] == 0) attrs[6] = (atti[ 6] == 0) ? 's' : 'S';
  if (atti[12] < 2) if (atti[12] == 0) attrs[9] = (atti[ 9] == 0) ? 't' : 'T';

  return 1;
}

#endif // _TARGET_UNIX_

#ifdef _TARGET_GO32_
void fgetattr_s( const mode_t tm, char *stmode )
{
  strcpy(stmode, "----------");
  if (tm == -1) return; // _chmod(..0) failed

  if ((tm & ATTR_DIR) != 0) stmode[0] = 'D';
  if ((tm & ATTR_VOL) != 0) stmode[1] = 'V';
                            stmode[2] = '-';
                            stmode[3] = '-';
                            stmode[4] = '-';
                            stmode[5] = '-';
  if ((tm & ATTR_RO ) != 0) stmode[6] = 'R';
  if ((tm & ATTR_HID) != 0) stmode[7] = 'H';
  if ((tm & ATTR_SYS) != 0) stmode[8] = 'S';
  if ((tm & ATTR_ARC) != 0) stmode[9] = 'A';
};

int fgetattr_s( const char *filename, char *target )
{
  strcpy(target, "----------");
  mode_t mode = 0;
  mode = _chmod( filename, 0, 0 );
  if (mode == -1) return 1;
  fgetattr_s(mode, target);
  return 0;
};

int  fsetattr_s( const char *filename, const char *attrs )
{
char oldattrs[12];
char newattrs[12];
mode_t newmode = 0;
if (fgetattr_s(filename, oldattrs)) return 1;

strcpy(newattrs, attrs);

if (newattrs[1] == '?') newattrs[1] = oldattrs[1];
if (newattrs[2] == '?') newattrs[2] = oldattrs[2];
if (newattrs[3] == '?') newattrs[3] = oldattrs[3];
if (newattrs[4] == '?') newattrs[4] = oldattrs[4];
if (newattrs[5] == '?') newattrs[5] = oldattrs[5];
if (newattrs[6] == '?') newattrs[6] = oldattrs[6];
if (newattrs[7] == '?') newattrs[7] = oldattrs[7];
if (newattrs[8] == '?') newattrs[8] = oldattrs[8];
if (newattrs[9] == '?') newattrs[9] = oldattrs[9];

                        newattrs[0] = '-'; // ATTR_DIR -- must be off!
                        newattrs[1] = '-'; // ATTR_VOL -- must be off!

// if (newattrs[1] == 'D') newmode |= ATTR_DIR; // forbidden!
// if (newattrs[2] == 'V') newmode |= ATTR_DIR; // forbidden!
if (newattrs[6] == 'R') newmode |= ATTR_RO ;
if (newattrs[7] == 'H') newmode |= ATTR_HID;
if (newattrs[8] == 'S') newmode |= ATTR_SYS;
if (newattrs[9] == 'A') newmode |= ATTR_ARC;

return ( _chmod( filename, 1, newmode ) == -1);
};

int EditAttr( char *attrs, int allow_masking )
{
  int atti[16];
  if (!allow_masking)
    {
    atti[6] = (attrs[6] != 'R');
    atti[7] = (attrs[7] != 'H');
    atti[8] = (attrs[8] != 'S');
    atti[9] = (attrs[9] != 'A');
    }
  else
    {
    atti[6] = 2;
    atti[7] = 2;
    atti[8] = 2;
    atti[9] = 2;
    }

  char* AONOFF1[] = { "YES", " - ", " ? ", NULL };
  char* AONOFF2[] = { "YES", " - ", NULL };
  #define AONOFF  (allow_masking?AONOFF1:AONOFF2)
  ToggleEntry attr_togs[] =
  {
  { 'R', "Read-only", &atti[6], AONOFF },
  { 'H', "Hidden   ", &atti[7], AONOFF },
  { 'S', "System   ", &atti[8], AONOFF },
  { 'A', "Archive  ", &atti[9], AONOFF },
  { -1, "---", NULL, NULL },
  };

  if ( !ToggleBox( 50, 5, "Attributes/Mode", attr_togs ) ) return 0;

  if (atti[6] < 2) attrs[6] = atti[6] == 0 ? 'R' : '-';
  if (atti[7] < 2) attrs[7] = atti[7] == 0 ? 'H' : '-';
  if (atti[8] < 2) attrs[8] = atti[8] == 0 ? 'S' : '-';
  if (atti[9] < 2) attrs[9] = atti[9] == 0 ? 'A' : '-';

  return 1;
}
#endif // _TARGET_GO32_



#ifdef _TARGET_GO32_
#include <dpmi.h>
#include <go32.h>

int get_sfn( const char *in, char *out )
{
  char src[MAX_PATH+32]; // jtbs
  char dst[MAX_PATH+32]; // jtbs

  strcpy( src, in );

  __dpmi_regs r;
  dosmemput(src, strlen (src)+1, __tb);
  r.x.ax = 0x7160;		/* Truename */
  r.x.cx = 1;			/* Get short name */
  r.x.ds = r.x.es = __tb / 16;
  r.x.si = r.x.di = __tb & 15;
  __dpmi_int(0x21, &r);
  if (r.x.flags & 1 || r.x.ax == 0x7100)
    {
    strcpy( out, in );
    return -1;
    }
  dosmemget (__tb, MAX_PATH, dst);
  strcpy( out, dst );
  return 0;
}

int get_lfn( const char *in, char *out )
{
  char src[MAX_PATH+32]; // jtbs
  char dst[MAX_PATH+32]; // jtbs

  strcpy( src, in );

  __dpmi_regs r;
  dosmemput(src, strlen (src)+1, __tb);
  r.x.ax = 0x7160;		/* Truename */
  r.x.cx = 2;			/* Get long name */
  r.x.ds = r.x.es = __tb / 16;
  r.x.si = r.x.di = __tb & 15;
  __dpmi_int(0x21, &r);
  if (r.x.flags & 1 || r.x.ax == 0x7100)
    {
    strcpy( out, in );
    return -1;
    }
  dosmemget (__tb, MAX_PATH, dst);
  strcpy( out, dst );
  return 0;
}

#endif // _TARGET_GO32_


 // eof vfusys.cpp
