;;; tc-util.el --- utilities for T-Code

;; Copyright (C) 1996, 97, 1998 KITAJIMA Akira

;; Author: KITAJIMA Akira <kitajima@ics.es.osaka-u.ac.jp>
;; Created: 7 May 1996
;; Version: $Id: tc-util.el,v 1.7 1999/09/27 15:06:17 akira Exp $
;; Keywords: wp

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.

;;; Code:

(require 'tc)

(defgroup tcode-utility nil
  "T-Code ǽ"
  :group 'tcode)

;;;; 

;;;###autoload
(defun set-tcode-mode-key (key func &optional type)
  "T-Code ⡼ɤΥꤹ롣
ϼΤȤꡣ

KEY  ... ꤹ륭stringcharvector Τ줫
FUNC ... TYPE ޥɤξδؿ̾ TYPE  'command ޤ -3 ʳ
         ϰ̣ʤ(nil ˤƤФ褤)
TYPE ... ǽμࡣ(ѿ `tcode-keymap-table' )
         άϡFUNC  nil ΤȤ 'literal ǡǤʤȤ
         'command
         ʲΥܥȤ롣

         literal      ʸ
         lowercase    бѾʸ
         command      tcode-mode-map ˤäޥɡ"
  (interactive (list (progn
		       (message "T-Code ⡼ɤԤ? ")
		       (setq key (read-char)))
		     (read-command (format "%cפ˳Ƥ륳ޥɤ? "
					   key))
		     prefix-arg))
  ;; type
  (cond ((null type)
	 (setq type (if (if (interactive-p) (commandp func) func)
			-3 -1)))
	((integerp type))
	((eq type 'literal)
	 (setq type -1))
	((eq type 'lowercase)
	 (setq type -2))
	((eq type 'command)
	 (setq type -3))
	(t
	 (error "TYPE ")))
  ;; key
  (cond ((char-or-string-p key)
	 (or (stringp key)
	     (setq key (char-to-string key))))
	((vectorp key)
	 (setq key (char-to-string (aref key 0))))
	(t
	 (error "KEY ")))
  ;; set keymap address
  (let ((addr (string-to-char key)))
    (if (and (>= addr ? )
	     (<= addr ?~))
	(aset tcode-keymap-table (- addr ? ) type)
      (error "%sפˤϳƤޤ" key)))
  ;; set key binding
  (define-key tcode-mode-map key (and (= type -3)
				      func)))

;;;; ο

(when (or (tcode-mule-2-p)
	  (tcode-mule-3-p)
	  (tcode-mule-4-p)
	  (tcode-xemacs-p))
  (or (fboundp 'set-cursor-color)
      ;; for XEmacs
      (defun set-cursor-color (color)
	(set-frame-property (selected-frame) 'cursor-color color)))

  (defcustom tcode-mode-off-cursor-color
    (and window-system
	 (or (cdr (assq 'cursor-color (frame-parameters (selected-frame))))
	     (face-property (get-face 'default) 'foreground))) ; XEmacs
    "* T-Code ⡼ɤǤʤȤΥο"
    :type 'string :group 'tcode-utility)
  (defcustom tcode-mode-on-cursor-color "GreenYellow"
    "* T-Code ⡼ɤΤȤΥο"
    :type 'string :group 'tcode-utility)
  (defcustom tcode-katakana-mode-cursor-color "Green"
    "* T-Code ⡼ɤǥʥ⡼ɤΤȤΥο"
    :type 'string :group 'tcode-utility)

  (defun tcode-change-cursor-color ()
    (set-cursor-color
     (if tcode-mode
	 (if tcode-katakana-mode
	     tcode-katakana-mode-cursor-color
	   tcode-mode-on-cursor-color)
       tcode-mode-off-cursor-color)))

  (defun tcode-enable-cursor-to-change-color (&optional arg)
    "ʤСο⡼ɤˤѤ褦ˤ롣
nil ǤʤСο⡼ɤˤѤʤ褦ˤ롣"
    (interactive "P")
    (if (null arg)
	(progn
	  (add-hook 'post-command-hook 'tcode-change-cursor-color)
	  (add-hook 'minibuffer-setup-hook 'tcode-change-cursor-color))
      (remove-hook 'post-command-hook 'tcode-change-cursor-color)
      (remove-hook 'minibuffer-setup-hook 'tcode-change-cursor-color))))

;;;; 򤼽񤭼񤫤ܤ

(defvar tcode-mazegaki-delete-log-buffer "*Mazegaki Delete Log*"
  "* ΰɽХåե̾")

(autoload 'tcode-mazegaki-switch-to-dictionary "tc-mazegaki" nil t)

(defun tcode-mazegaki-write-to-delete-log (str)
  (save-excursion
    (set-buffer tcode-mazegaki-delete-log-buffer)
    (goto-char (point-max))
    (insert str)))

(defun tcode-mazegaki-make-entry-list (kanji)
  "ޤܤΰ롣
Τ `tcode-mazegaki-delete-kanji-from-dictionary' 
ܤ"
  (and (string= kanji "")
       (error "Quit"))
  (let ((nod 0)
	(yomi-pattern (concat "[^ ]*" kanji))
	str)
    (save-excursion
      (get-buffer-create tcode-mazegaki-delete-log-buffer)
      (tcode-mazegaki-switch-to-dictionary)
      (goto-char (point-min))
      (message "(%s)..." kanji)
      (while (search-forward kanji nil t)
	(beginning-of-line)
	(if (looking-at yomi-pattern)
	    (next-line 1)
	  (setq str (buffer-substring (point) (progn (next-line 1) (point))))
	  (tcode-mazegaki-write-to-delete-log str)
	  (setq nod (1+ nod))))
      (if (> nod 0)
	  (tcode-mazegaki-write-to-delete-log
	   (format "\n\t%s  %s\n" kanji (format "%d " nod)))
	(message "ʤ"))
      (> nod 0))))

;;;###autoload
(defun tcode-mazegaki-delete-kanji-from-dictionary (kanji)
  "ޤܤ롣
ΤɤߤˤδޤޤƤʤܤ"
  (interactive
   (let ((minibuffer-setup-hook
	  (unless (or (tcode-nemacs-p)
		      (tcode-mule-1-p))
	    (cons 'tcode-activate minibuffer-setup-hook))))
     (list (read-from-minibuffer " "))))
  (and (or (string= kanji "")
	   (string= kanji "/"))
       (error "Quit"))
  (and (tcode-mazegaki-make-entry-list kanji)
       (if (save-excursion
	     (pop-to-buffer tcode-mazegaki-delete-log-buffer)
	     (goto-char (point-max))
	     (y-or-n-p "ޤ"))
	   (let ((nod 0)
		 (yomi-pattern (concat "[^ ]*" kanji))
		 (pattern (concat "/[^/\n]*" kanji "[^/\n]*/")))
	     (save-excursion
	       (tcode-mazegaki-switch-to-dictionary)
	       (goto-char (point-min))
	       (message "(%s)..." kanji)
	       (while (search-forward kanji nil t)
		 (beginning-of-line)
		 (if (looking-at yomi-pattern)
		     (next-line 1)
		   (narrow-to-region (point)
				     (save-excursion (next-line 1) (point)))
		   (while (re-search-forward pattern nil t)
		     (replace-match "/")
		     (backward-char)
		     (setq nod (1+ nod)))
		   (widen)
		   (if (and (= (preceding-char) ? )
			    (= (char-after (1+ (point))) ?\n))
		       (progn
			 (beginning-of-line)
			 (kill-line 1))
		     (end-of-line)
		     (forward-char))))
	       (message "(%s)...λ (%s)" kanji
			(format "%d" nod))
	       (tcode-mazegaki-write-to-delete-log
		(format "%d\n\f\n" nod))))
	 (tcode-mazegaki-write-to-delete-log "\n\f\n"))))

;;;; 򤼽񤭼κĹɤߤĸĤ

;;;###autoload
(defun tcode-mazegaki-get-yomi-max ()
  "ιܤɤߤĹΤ(ӤĹ)ĸĤ롣
Ĺ֤"
  (interactive)
  (let ((max 0)	n
	line (l 0)
	maxstr str)
    (tcode-mazegaki-switch-to-dictionary)
    (goto-char (point-min))
    (while (not (eobp))
      (setq n (if (= (tcode-char-width (tcode-char-after (point))) 1)
		  1			; alphabet
		(length
		 (tcode-string-to-char-list
		  (setq str (buffer-substring
			     (point)
			     (prog2
				 (looking-at "^\\([^/]+\\) /")
				 (match-end 1))))))))
      (and (> n max)
	   (setq max n
		 line l
		 maxstr str))
      (forward-line 1)
      (setq l (1+ l)))
    (and (interactive-p)
	 (message "%dʸ (%s) %d" max maxstr line))
    max))

;;;; ȥ륭ȼʤ T-Code ⡼ɤڤؤ

(defvar tcode-electric-switching-command-list
  '(tcode-self-insert-command-maybe
    egg-self-insert-command
    tcode-mazegaki-kakutei
    delete-backward-char
    backward-delete-char
    backward-delete-char-untabify
    tcode-insert-ya-outset
    tcode-transpose-strokes-or-chars)
  "* ľ `tcode-electric-space' ǥ⡼ɤڤؤ륳ޥɤΥꥹȡ
T-Code ⡼ɤΤȤˡΥꥹȤΥޥɤƤФ줿
`tcode-electric-space' ¹Ԥ T-Code ⡼ɤڤؤ롣")

(defvar tcode-electric-switching-chars '(?,)
  "* `tcode-electric-space' ľ˥⡼ɤڤؤʸΥꥹȡ
줿ʸ̾Υե٥åϥ⡼ɤ
`tcode-electric-space' ľϤ T-Code ⡼ɤڤؤ롣")

(defvar tcode-space-chars-list '(?  ?\n ?\t)
  "* ȤưʸΥꥹ")

(defvar tcode-electric-deleting-and-switching-chars '(?\t)
  "* `tcode-electric-space' ľ˥⡼ɤڤؤʸΥꥹȡ
`tcode-electric-switching-chars' Ȱۤʤꡢ
ľ `tcode-electric-space' ʸä")

(defvar tcode-electric-space-without-inserting nil
  "* nil ʤڤؤȤʸ()Ϥ롣")

(defvar tcode-no-following-space-chars "({[ơȡʡ̡ΡСҡԡ֡ءڡ"
  "ʸΤɤʸθˤľ˶ʤ")

;;; 򤼽ѴѰդƤʤϡself-insert Ԥʤ
(or (boundp 'tcode-self-insert-or-henkan)
    (defun tcode-self-insert-or-henkan (arg)
      (interactive "*p")
      (self-insert-command arg)))

;;;###autoload
(defun tcode-electric-space (arg)
  "Ϥ뤳Ȥˤ T-Code ⡼ɤڤؤ롣
`tcode-electric-switching-command-list' ˤ륳ޥɤƤФ줿ľ
ΥޥɤƤФȡT-Code ⡼ɤڤؤ롣
ǤʤȤϡñ˶롣"
  (interactive "p")
  (cond (buffer-read-only
	 (toggle-input-method))
	(tcode-mode
	 (or (tcode-self-insert-or-henkan arg)
	     (if (memq last-command tcode-electric-switching-command-list)
		 ;; 򤽤Τޤޤˤڤؤ
		 (progn
		   (delete-backward-char 1)
		   (toggle-input-method)
		   (or tcode-electric-space-without-inserting
		       (and (not (bobp))
			    (let ((prev-char (char-to-string
					      (tcode-char-before (point)))))
			      (string-match (regexp-quote prev-char)
					    tcode-no-following-space-chars)))
		       (tcode-redo-command last-command-char)))
	       (condition-case nil
		   (let* ((echo-keystrokes 0)
			  (ch (read-char)))
		     (if (memq ch tcode-electric-deleting-and-switching-chars)
			 ;; ľζäڤؤ
			 (progn
			   (delete-backward-char 1)
			   (toggle-input-method))
		       ;; ڤؤʤ
		       (tcode-redo-command ch)))
		 (t
		  (setq unread-command-events
			(nconc unread-command-events
			       (list last-input-event))))))))
	(t
	 ;; OFF  ON ؤڤؤ
	 (self-insert-command arg)
	 (condition-case nil
	     (let* ((echo-keystrokes 0)
		    (ch (read-char)))
	       (cond ((memq ch tcode-electric-switching-chars)
		      (and tcode-electric-space-without-inserting
			   (delete-backward-char 1))
		      (toggle-input-method))
		     ((memq ch tcode-electric-deleting-and-switching-chars)
		      (delete-backward-char 1)
		      (toggle-input-method))
		     (t
		      (tcode-redo-command ch))))
	   (t
	    (setq unread-command-events (nconc unread-command-events
					       (list last-input-event))))))))

;;;###autoload
(defun tcode-electric-comma (arg)
  "ʤɤθǡ,פϤ뤳ȤˤꡢT-Code ⡼ɤڤؤ롣
ڤؤΤϡ T-Code ⡼ɤǡ `tcode-space-chars-list' 
줫ʸľǡ,פϤȤΤߡ"
  (interactive "p")
  (if (and (not tcode-mode)
	   (or (bolp)
	       (memq (tcode-char-before (point)) tcode-space-chars-list)))
      (toggle-input-method)
    (self-insert-command arg)))

(or (assq 'tcode-electric-comma tcode-self-inserting-commands)
    (setq tcode-self-inserting-commands
	  (cons '(tcode-electric-comma . "p")
		tcode-self-inserting-commands)))

;;;; ⤦Ĥγ

(defvar tcode-ya-outset-map-list
  '(["" "" "" ""  ""     ""  "" "" "" ""

     "" "" "" ""  ""     ""  "" "" "" ""
     "" "" "" ""  ""     ""  "" "" "" ""
     "" "" "" ""  ""     ""  "" "" "" ""]

    ["" "" "" ""  ""     ""  "" "" "" ""

     "" "" "" ""  ""     ""  "" "" "" ""
     "" "" "" ""  ""     ""  "" "" "" ""
     "" "" "" ""  ""     ""  "" "" "" ""]

    ["" "" "" ""  ""     ""  "" "" "" ""

     "" "" "" ""  ""     ""  "" "" "" ""
     "" "" "" ""  ""     ""  "" "" "" ""
     "" "" "" ""  ""     ""  "" "" "" ""])
  "* ΥޥåפΥꥹ")

;;;###autoload
(defun tcode-insert-ya-outset (level)
  "ʸɤ߹ߡ `tcode-ya-outset-map-list' ɽ˴Ťʸ롣
LEVEL ܤɽоݤȤʤ롣"
  (interactive "*p")
  (tcode-cancel-undo-boundary)
  (let* ((map-num (length tcode-ya-outset-map-list))
	 (map-index (1- (let ((i level))
			  (while (> i map-num)
			    (setq i (- i map-num)))
			  i)))
	 (outset-map (nth map-index tcode-ya-outset-map-list))
	 (show-table (sit-for 1)))
    (and show-table
	 (tcode-display-help-buffer
	  (tcode-draw-table outset-map (1+ map-index) map-num) t))
    (unwind-protect
	(let* ((ch (read-char))
	       (addr (tcode-get-key-address ch))
	       (elm (and (> addr 0)
			 (< addr 40)
			 (aref outset-map addr))))
	  (cond (elm
		 (tcode-insert elm))
		((= ch last-command-char)
		 (tcode-insert-ya-outset (1+ level)))
		((= ch ? )
		 (self-insert-command level))
		(t
		 (self-insert-command level)
		 (setq prefix-arg level)
		 (tcode-redo-command ch))))
      (and show-table
	   (tcode-auto-remove-help t)))))

;;;; ʸޤϥȥؤ

(defvar tcode-transpose-strokes-enable-commands
  '(tcode-self-insert-command-maybe
    tcode-self-insert-command
    egg-self-insert-command
    self-insert-command
    tcode-transpose-strokes-or-chars)
  "*ưǥȥؤ뤳ȤǤ륳ޥɤΥꥹȡ
ѿǻꤵ줿ޥɤ¹Ԥľ
`tcode-transpose-strokes-or-chars' ¹Ԥȡ
ȥؤ롣")

;;;###autoload
(defun tcode-transpose-strokes-or-chars (&optional arg)
  "T-Code ⡼ɤΤȤˤϡݥȤΥȥؤ롣"
  (interactive "*P")
  (if (and (not (bobp))
	   (memq last-command tcode-transpose-strokes-enable-commands)
	   (= (tcode-char-width (tcode-char-before (point))) 2))
      (progn
	;; ȥؤ
	(or (eolp)
	    (tcode-backward-char 1))
	(tcode-transpose-strokes arg))
    ;; ʸؤ
    (if (memq last-command tcode-transpose-strokes-enable-commands)
	(progn
	  (backward-char 1))
      (setq this-command 'transpose-chars)
      (and (eolp)
	   (backward-char 1)))
    (transpose-chars arg)))

;;;; Ф򤼽񤭼񤫤ɤߤɽ

;;;###autoload
(defun tcode-mazegaki-show-yomi-region (begin end &optional prefix)
  "꡼ǻꤵ줿ʸɤߤ򤼽񤭼񤫤õɽ롣
PREFIX  nil ǤʤХ꡼ʸǻϤޤʸõ"
  (interactive "r\nP")
  (let* ((kanji (buffer-substring begin end))
	 (pattern (concat "/" kanji (if prefix "" "/")))
	 list)
    (save-excursion
      (tcode-mazegaki-switch-to-dictionary)
      (goto-char (point-min))
      (while (search-forward pattern nil t)
	(beginning-of-line)
	(looking-at "^\\([^/]+\\) /")
	(setq list (nconc list
			  (list (tcode-get-yomi-in-dictionary
				 (buffer-substring (match-beginning 1)
						   (match-end 1))))))
	(forward-line 1))
      (if list
	  (message (mapconcat 'identity list ", "))
	(error "%sפɤߤϸĤޤǤ" kanji)))))

;;;; Ҥ餬ʤ饫ʤؤѴ

;;; Mule 2.3  egg.el ˤΤ NEmacs Ѥѹ
;;; ޤ kanji-hiragana  "[-]" ѹ(XEmacs )
(or (fboundp 'katakana-region)
    (defun katakana-region (start end)
      "꡼ΤҤ餬ʤ򥫥ʤˤ롣"
      (interactive "r")
      (let (tmp)
	(if (> start end)
	    (setq tmp end
		  end start
		  start tmp))
	(goto-char start)
	(while (re-search-forward "[-]" end end)
	  (if (tcode-nemacs-p)
	      (let ((ch (preceding-char)))
		(delete-char -1)
		(insert ?\245 ch))
	    (let ((ch (char-component (preceding-char) 2)))
	      (delete-char -1)
	      (insert (make-character lc-jp ?\245 ch))))))))

;;;###autoload
(defun tcode-katakana-previous-char (n)
  "ݥȤ n ʸޤǤΤҤ餬ʤ򥫥ʤˤ롣"
  (interactive "*p")
  (let ((prev-char (tcode-char-before (point))))
    (katakana-region (save-excursion (tcode-backward-char n) (point))
		     (point))
    (and tcode-auto-help
	 (/= prev-char (tcode-char-before (point)))
	 (= n 1)
	 (tcode-display-direct-stroke
	  (char-to-string (tcode-char-before (point))))
	 (tcode-auto-remove-help-char))))

;;;; JIS ɤˤ

;;;###autoload
(defun tcode-insert-kanji-by-kuten-code (code)
  " CODE δ롣"
  (interactive "*s(10ʿ4)? ")
  (let* ((declist (mapcar
		   (function (lambda (n)
			       (if (and (>= n ?0)
					(<= n ?9))
				   (- n ?0)
				 0)))
		   (tcode-string-to-char-list code)))
	 (kuten (cons (+ (* (car declist) 10)
			 (car (setq declist (cdr declist))))
		      (+ (* (car (setq declist (cdr declist))) 10)
			 (car (cdr declist))))))
    (and (or (> (cdr kuten) 94)
	     (= (cdr kuten) 0)
	     (memq (car kuten) '(0 14 15)))
	 (error "(%s)ְäƤޤ" code))
    (tcode-insert-kanji-by-jis-code (format "%x%x"
					    (+ (car kuten) 32)
					    (+ (cdr kuten) 32)))))

;;;###autoload
(defun tcode-insert-kanji-by-jis-code (code)
  "JIS CODE δ롣"
  (interactive "*sJIS (16ʿ)? ")
  (let ((hexlist (mapcar
		  (function (lambda (n)
			      (cond ((and (>= n ?0)
					  (<= n ?9))
				     (- n ?0))
				    ((and (>= (setq n (downcase n)) ?a)
					  (<= n ?f))
				     (+ (- n ?a) 10))
				    (t
				     0))))
		  (tcode-string-to-char-list code)))
	bytelist)
    (while hexlist
      (setq bytelist (nconc bytelist
			    (list (+ (* (car hexlist) 16)
				     (car (cdr hexlist)))))
	    hexlist (nthcdr 2 hexlist)))
    (let ((kanji (make-character lc-jp
				 (+ (car bytelist) 128)
				 (+ (car (cdr bytelist)) 128))))
      (tcode-insert kanji)
      (and tcode-auto-help
	   (tcode-display-direct-stroke (char-to-string kanji))
	   (tcode-auto-remove-help-char)))))

;;;; ХåեƤ˱ưڤؤ

(defvar tcode-kutouten-regexp-alist
  (list '("[]" . 1)
	(if (tcode-nemacs-p)
	    '("\\z[,.]" . 2)
	  '("\\cj[,.]" . 2)))
  "* Ƚꤹ뤿ɽ alist
ꥹȤγǤϡ
ζȤƤ뤳ȤȽꤹ뤿ɽȡ
˥ޥåФ `tcode-switch-table-list' Ȥ
ֹ(ܤȤ)")

(defvar tcode-auto-identify-kutouten-mode-list '(text-mode)
  "* μưȽԤ⡼ɤΥꥹȡ")

(defun tcode-identify-kutouten-type ()
  "ХåեƤѤƤȽ̤롣
`tcode-kutouten-regexp-alist' ɽõޥå
ֹ֤ɤˤ⤢ƤϤޤʤ 0 ֤"
  (catch 'found
    (let* ((list tcode-kutouten-regexp-alist)
	   regexp)
      (while list
	(setq regexp (car (car list)))
	(save-excursion
	  (goto-char (point-min))
	  (and (re-search-forward regexp nil t)
	       (throw 'found (cdr (car list)))))
	(setq list (cdr list)))
      0)))

;;;###autoload
(defun tcode-auto-switch-kutouten (&optional force)
  "ХåեƤ鼫ưŪ˶ڤؤ롣
FORCE  nil ξϡ
`tcode-auto-identify-kutouten-mode-list' Υ⡼ɤǡ
ĤΥХåե read-only ǤʤˤΤư롣
ϴؿ `tcode-identify-kutouten-type' ǹԤ"
  (interactive)
  (and (or force
	   (and (memq major-mode tcode-auto-identify-kutouten-mode-list)
		(not buffer-read-only)))
       (tcode-switch-variable (tcode-identify-kutouten-type))))

;;;; ľʸ˥ʤѴ

(or (fboundp 'hiragana-region)
    (defun hiragana-region (start end)
      "꡼ΥʤҤ餬ʤˤ롣"
      (interactive "r")
      (let (tmp)
	(if (> start end)
	    (setq tmp end
		  end start
		  start tmp))
	(goto-char start)
	(while (re-search-forward "[-]" end end)
	  (if (tcode-nemacs-p)
	      (let ((ch (preceding-char)))
		(delete-char -1)
		(insert ?\244 ch))
	    (let ((ch (char-component (preceding-char) 2)))
	      (delete-char -1)
	      (insert (make-character lc-jp ?\244 ch))))))))

(defun tcode-katakana-preceding-chars (arg)
  "ľʸ˥ʤѴ롣
ޥɤΥ򲿲󤫲ȡβľΤҤ餬ʤʤˤʤ롣
Backspace ǺǸ˥ʤˤʤäʸҤ餬ʤ᤹
RET ǽλ
¾ΥϤΥưԤ"
  (interactive "*p")
  (let ((point (point)))
    (cond ((> arg 0)
	   (tcode-forward-char (- arg))
	   (katakana-region (point) point))
	  ((< arg 0)
	   (tcode-forward-char arg)
	   (hiragana-region (point) (progn (tcode-forward-char 1)
					   (point)))
	   (setq arg (1- (- arg)))
	   (goto-char point)))
    (unwind-protect
	(let* ((ch (read-char)))
	  (cond ((= ch last-command-char)
		 (tcode-katakana-preceding-chars (1+ arg)))
		((= ch ?\C-?)
		 (tcode-katakana-preceding-chars (- arg)))
		((= ch ?\C-m))
		(t
		 (tcode-redo-command ch))))
      (goto-char point))))

(provide 'tc-util)

;;; tc-util.el ends here
