/*
 * Hardware tuning for the VIA 82C598_0 PCI-to-PCI/AGP bridge
 */

#define PCI_DEVICE_ID_VIA_598_1 0x8598
 
static Tweaks_t VIA_82C598_1_Tweaks[] = {
	{ "AGP_POST_WRITE_ENABLE",	0x40,	1<<7,	1<<7,	"AGP posted write"},
	{ "AGP_DYNAMIC_BURST_ENABLE",	0x40,	1<<6,	1<<6,	"AGP dynamic burst"},
	{ "AGP_ONE_WS_BURST_WRITE_ENABLE",	0x40,	1<<5,	1<<5,	"AGP 1 WS write burst"},
	{ "AGP_TO_DRAM_PREFETCH_ENABLE",	0x40,	1<<4,	1<<4,	"AGP to DRAM prefetch"},
	{ "AGP_MASTER_GRANT_BEFORE_FLUSH",	0x40,	1<<3,	1<<3,	"AGP dynamic burst"},
	{ "AGP_MASTER_READ_CACHE",	0x40,	1<<1,	1<<1,	"AGP Master read cache"},
	{ "AGP_DELAY_TRANSACTION",	0x40,	1<<0,	1<<0,	"AGP Delay trasaction"},
	{ "AGP_RETRY_COUNT_4",		0x41,	1<<4,	1<<4,	"AGP retry 4 times and backoff CPU"},
	{ "AGP_CPU_BACKOFF_TIMEOUT",	0x41,	1<<2,	1<<2,	"AGP Backoff CPU on read retry failure"},
	{ "CPU_TO_AGP_POST_WRITE_IO",	0x41,	1<<1,	1<<1,	"CPU to AGP I/O posted write"},
	{ "AGP_PREFETCH_ONLY_ENHANCE",	0x42,	1<<7,	1<<7,	"AGP Prefetch only if enhance command"},
	{ "AGP_MASTER_1WS_WRITE",	0x42,	1<<6,	1<<6,	"AGP Master 1 WS write"},
	{ "AGP_MASTER_1WS_READ",	0x42,	1<<5,	1<<5,	"AGP Master 1 WS read"},
	{ "AGP_EFFICENT_DUMMY_CYCLES",	0x42,	1<<4,	1<<4,	"AGP Eficent handling of dummy cycles"},
	{ "AGP_WRITE_TIMEOUT_STOP",	0x42,	1<<3,	1<<3,	"AGP Write timeout asserts #STOP"},
	{ "AGP_READ_TIMEOUT_STOP",	0x42,	1<<2,	1<<2,	"AGP Read timeout asserts #STOP"},
	{ 0, 0, 0, 0, 0 }
};
