/*
 * Copyright (c) 2000 Dave Jones <dave@powertweak.com>
 *
 * Can be freely distributed and used under the terms of the GNU GPL.
 */

void CloseDialog (GtkWidget *widget, gpointer data)
{
	gtk_widget_destroy (GTK_WIDGET (data));
}


void ClosingDialog (GtkWidget *widget, gpointer data)
{
	gtk_grab_remove (GTK_WIDGET (widget));
}


void show_popup(char *title, char *message)
{
	static GtkWidget	*label;
	GtkWidget			*dialog;
	GtkWidget			*button;

	dialog = gtk_dialog_new();

	gtk_signal_connect (GTK_OBJECT (dialog), "destroy",
		GTK_SIGNAL_FUNC (ClosingDialog),
		&dialog);

	gtk_window_set_title (GTK_WINDOW (dialog), title);
	gtk_container_border_width (GTK_CONTAINER (dialog), 5);

	label = gtk_label_new (message);

	gtk_misc_set_padding (GTK_MISC (label), 10, 10 );
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), label, TRUE, TRUE, 0);
	gtk_widget_show (label);

	button = gtk_button_new_with_label ("Ok");
	gtk_signal_connect (GTK_OBJECT (button), "clicked",
		GTK_SIGNAL_FUNC (CloseDialog),
		dialog);

	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);

	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		button, TRUE, TRUE, 0);
	gtk_widget_grab_default (button);
	gtk_widget_show (button);
	gtk_widget_show (dialog);
	gtk_grab_add (dialog);
}
