/*
 * Copyright (c) 2000 Dave Jones <dave@powertweak.com>
 *
 * Can be freely distributed and used under the terms of the GNU GPL.
 */

#define MAX_POSSIBLE_PAGES 5

GtkWidget *notebook;
GtkWidget *current_pages[MAX_POSSIBLE_PAGES];
gint current_max_page=0;


GtkText *CreateText (char *buffer)
{
	GtkWidget *Text;

	Text = gtk_text_new (NULL, NULL);
	gtk_text_set_editable (GTK_TEXT (Text), FALSE);

	gtk_text_insert (GTK_TEXT(Text), NULL, NULL, NULL,
		buffer, strlen (buffer));
	gtk_widget_show (Text);

	return GTK_TEXT(Text);
}


/*
 * PageSwitch
 *
 * Event that occurs when a different page is now
 * the focus.
 */
void PageSwitch (GtkWidget *widget, GtkNotebookPage *page, gint page_num)
{
}



/*
 * AddPage
 *
 * Add a page to the notebook 
 *
 * notebook - existing notebook
 * pagename - name to give to the new page
 */
void AddPage (GtkNotebook *notebook, char *pagename)
{
	GtkWidget *label;
	GtkWidget *frame;

	/* --- Create a label from the name. --- */
	label = gtk_label_new (pagename);
	gtk_widget_show (label);

	/* --- Create a frame for the page --- */
	frame = gtk_frame_new (NULL);
	gtk_frame_set_shadow_type(GTK_FRAME (frame), GTK_SHADOW_NONE);
	gtk_widget_show (frame);

	/* --- Add a page with the frame and label --- */
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame, label);

	current_pages[current_max_page++]=frame;
}


void remove_all_pages(GtkWidget *notebook)
{
	int i;

	if (current_max_page!=0) {

		for (i=MAX_POSSIBLE_PAGES;i>=0;i--) {
			if (current_pages[i]!=NULL) {
				gtk_notebook_remove_page (GTK_NOTEBOOK (notebook), i);
				current_pages[i]=NULL;
			}
		}
		gtk_widget_draw (GTK_WIDGET(notebook), NULL);
		current_max_page=0;
	}
}


/*
 * CreateNotebookWindow
 *
 * Create a window to display the notebook.
 */
GtkWidget *CreateNotebook (GtkPositionType pos)
{
	notebook = gtk_notebook_new ();	/* Create the notebook*/
	gtk_signal_connect (GTK_OBJECT (notebook), "switch_page",
			GTK_SIGNAL_FUNC (PageSwitch), NULL);

	gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), pos);

	gtk_container_border_width (GTK_CONTAINER (notebook), 10);
	return notebook;
}
