/*
 * Copyright (c) 2000 Dave Jones <dave@powertweak.com>
 *
 * Can be freely distributed and used under the terms of the GNU GPL.
 */

#include "PCI/known_PCI.h"

void select_PCI_item(struct pci_dev *current_pci_dev)
{
	char namebuf[256];
	char TextBuffer[2048];
	char *TextPtr;
	unsigned short pci_word;
	unsigned char pci_byte;
	unsigned int num_widgets;
	struct devinfo *current_devinfo;

	GtkText *InfoTextPtr;
	GtkWidget *tweak_frame;
	GtkWidget *scrolled_win;
	GtkWidget *table;
	GtkWidget *vbox;
	
	TextPtr=TextBuffer;

	remove_all_pages(notebook);

	TextPtr+=sprintf(TextPtr, "Vendor: %x (%s)\nDevice: %x (%s)\nClass: %s\n",
		current_pci_dev->vendor_id,
		pci_lookup_name(pacc, namebuf, sizeof(namebuf),
			PCI_LOOKUP_VENDOR,
			current_pci_dev->vendor_id, 0, 0, 0),
		current_pci_dev->device_id,
		pci_lookup_name(pacc, namebuf, sizeof(namebuf),
			PCI_LOOKUP_DEVICE,
			current_pci_dev->vendor_id,
			current_pci_dev->device_id, 0, 0),
		pci_lookup_name(pacc, namebuf, sizeof(namebuf),
			PCI_LOOKUP_CLASS,
			(pci_read_word (current_pci_dev, PCI_CLASS_DEVICE)),
			0,0,0));

	pci_byte = pci_read_byte (current_pci_dev, PCI_CLASS_REVISION);
	TextPtr+=sprintf(TextPtr, "Revision: %02x\n", pci_byte);

	pci_byte = pci_read_byte (current_pci_dev, PCI_LATENCY_TIMER);
	TextPtr+=sprintf(TextPtr, "Current latency:%d\n", pci_byte);

//FIXME:
// This is __horrid__. Please clean this mess up, using a struct. -- DJ
	pci_word = pci_read_word (current_pci_dev, PCI_COMMAND);
	TextPtr+=sprintf(TextPtr, "Command: %x\n", pci_word);
	if (pci_word & PCI_COMMAND_IO)
		TextPtr+=sprintf(TextPtr, "\tI/O space access\n");
	if (pci_word & PCI_COMMAND_MEMORY)
		TextPtr+=sprintf(TextPtr, "\tMemory space access\n");
	if (pci_word & PCI_COMMAND_MASTER)
		TextPtr+=sprintf(TextPtr, "\tBus mastering\n");
	if (pci_word & PCI_COMMAND_SPECIAL)
		TextPtr+=sprintf(TextPtr, "\tResponse to special Cycles\n");
	if (pci_word & PCI_COMMAND_INVALIDATE)
		TextPtr+=sprintf(TextPtr, "\tUse memory write and invalidate\n");
	if (pci_word & PCI_COMMAND_VGA_PALETTE)
		TextPtr+=sprintf(TextPtr, "\tVGA palette snooping\n");
	if (pci_word & PCI_COMMAND_PARITY)
		TextPtr+=sprintf(TextPtr, "\tParity checking\n");
	if (pci_word & PCI_COMMAND_WAIT)
		TextPtr+=sprintf(TextPtr, "\tAddress/data stepping\n");
	if (pci_word & PCI_COMMAND_SERR)
		TextPtr+=sprintf(TextPtr, "\tSERR\n");
	if (pci_word & PCI_COMMAND_FAST_BACK)
		TextPtr+=sprintf(TextPtr, "\tSupports back to back writes.\n");


	pci_word = pci_read_word (current_pci_dev, PCI_STATUS);
	TextPtr+=sprintf(TextPtr, "Status: %x\n", pci_word);
	if (pci_word & PCI_STATUS_CAP_LIST)
		TextPtr+=sprintf(TextPtr, "\tHas capabilities list.\n");
	if (pci_word & PCI_STATUS_66MHZ)
		TextPtr+=sprintf(TextPtr, "\tSupports 66Mhz PCI 2.1 bus.\n");
	if (pci_word & PCI_STATUS_UDF)
		TextPtr+=sprintf(TextPtr, "\tUser defined features [Obsolete]\n");
	if (pci_word & PCI_STATUS_FAST_BACK)
		TextPtr+=sprintf(TextPtr, "\tUsing Fast back to back tranfers.\n");
	if (pci_word & PCI_STATUS_PARITY)
		TextPtr+=sprintf(TextPtr, "\tParity error detected!\n");
	TextPtr+=sprintf(TextPtr, "\tDEVSEL timing=%s\n",
		((pci_word & PCI_STATUS_DEVSEL_MASK)==PCI_STATUS_DEVSEL_SLOW) ? "Slow" :
		((pci_word & PCI_STATUS_DEVSEL_MASK)==PCI_STATUS_DEVSEL_MEDIUM) ? "Medium" :
		((pci_word & PCI_STATUS_DEVSEL_MASK)==PCI_STATUS_DEVSEL_FAST) ? "Fast" :
		"???");
	if (pci_word & PCI_STATUS_SIG_TARGET_ABORT)
		TextPtr+=sprintf(TextPtr, "\t>TAbort\n");
	if (pci_word & PCI_STATUS_REC_TARGET_ABORT)
		TextPtr+=sprintf(TextPtr, "\t<TAbort\n");
	if (pci_word & PCI_STATUS_REC_MASTER_ABORT)
		TextPtr+=sprintf(TextPtr, "\t<MAbort\n");
	if (pci_word & PCI_STATUS_SIG_SYSTEM_ERROR)
		TextPtr+=sprintf(TextPtr, "\t>SERR\n");
	if (pci_word & PCI_STATUS_DETECTED_PARITY)
		TextPtr+=sprintf(TextPtr, "\tParity error detected!\n");

	AddPage (GTK_NOTEBOOK(notebook), "Information");
	InfoTextPtr = CreateText(TextBuffer);
	gtk_container_add (GTK_CONTAINER (current_pages[current_max_page-1]), GTK_WIDGET(InfoTextPtr));


	/* If we know any tweaks for this device, we add an extra tab. */

	current_devinfo = known_devlist;

	while (current_devinfo->vendor) {

		/* Do we know anything about this device ? */
		if ((current_devinfo->vendor == current_pci_dev->vendor_id) &&
			(current_devinfo->device == current_pci_dev->device_id)) {

			if (current_devinfo->extended_info != NULL)
				current_devinfo->extended_info (notebook, current_pci_dev);

			if (!current_devinfo->gadget_counter)
				goto createtweaks_out; /* Untweakable device. */

			num_widgets = current_devinfo->gadget_counter(current_pci_dev);

			scrolled_win = gtk_scrolled_window_new (NULL, NULL);
			gtk_widget_set_usize (scrolled_win, (WindowWidth/3)*2, 260);
			gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW (scrolled_win),
											GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

			table = gtk_table_new (num_widgets, 1, TRUE);
			current_devinfo->gadget_adder(table, current_pci_dev, num_widgets);

			gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled_win), table);

			gtk_widget_show (table);
			gtk_widget_show (scrolled_win);

			AddPage (GTK_NOTEBOOK(notebook), "Tweaks");
			TweakInfoTextPtr = CreateText("");

			vbox = gtk_vbox_new (FALSE, 0);
			gtk_box_pack_start (GTK_BOX (vbox), scrolled_win, TRUE, TRUE, 0);
			gtk_box_pack_start (GTK_BOX (vbox), GTK_WIDGET(TweakInfoTextPtr), TRUE, TRUE, 0);
			gtk_widget_show (vbox);
			gtk_container_add (GTK_CONTAINER (current_pages[current_max_page-1]), vbox);
			goto createtweaks_out;			/* Done tweaking. */
		}
		current_devinfo++;
	}
createtweaks_out:
}
