/*
 * Hardware tuning for the VIA 82C598_1 PCI->PCI/>AGP bridge
 */

#include "82C598_1.h"

#define VIA_598_1_TWEAKSIZE (sizeof(VIA_82C598_1_Tweaks)/sizeof(Tweaks_t))-1

unsigned int getnumtweaks_VIA_598_1(struct pci_dev *current_dev)
{
	return VIA_598_1_TWEAKSIZE; 
}

void init_VIA_598_1(struct pci_dev *current_dev)
{
	init_tweaks(VIA_598_1_TWEAKSIZE, VIA_82C598_1_Tweaks, current_dev);
}

void tune_VIA_598_1(GtkWidget *table, struct pci_dev *current_dev, unsigned int numbuttons)
{
	Tweaks_t *Tweaks;

	unsigned int index;
	int column=0;

	Tweaks = VIA_82C598_1_Tweaks;

	for (index=0;index<numbuttons;index++) {
		CreateButton(table,	Tweaks, current_dev, column);
		column++;
		Tweaks++;
	}
}

void save_VIA_598_1(FILE *savehandle, struct pci_dev *current_dev)
{
	write_tweaks(savehandle, VIA_598_1_TWEAKSIZE, VIA_82C598_1_Tweaks, current_dev);
}
