/*
 * Hardware tuning for the VIA 82C586_1 IDE interface
 */

#define PCI_DEVICE_ID_VIA_586_1 0x0571

static Tweaks_t VIA_82C586_1_Tweaks[] = {
	{ "IDE0_PREFETCH",
		0x41,
		1<<7,
		1<<7,
		"IDE0 Prefetch",
		"Enables read prefetch on primary IDE bus",
		0, 0 },

	{ "IDE0_POST_WRITE",
		0x41,
		1<<6,
		1<<6,
		"IDE0 Posted write",
		"Enables delayed writes on primary IDE bus",
		0, 0 },

	{ "IDE1_PREFETCH",
		0x41,
		1<<5,
		1<<5,
		"IDE1 Prefetch",
		"Enables read prefetch on secondary IDE bus",
		0, 0 },

	{ "IDE1_POST_WRITE",
		0x41,
		1<<4,
		1<<4,
		"IDE1 Posted write",
		"Enables delayed writes on secondary IDE bus",
		0, 0 },

	{ 0, 0, 0, 0, 0, 0, 0, 0 }
};
